﻿#ifndef	AJCFILEDIR_H_
#define	AJCFILEDIR_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcCopyFolderStruct				AjcCopyFolderStructW
	#define	AjcCopyFolderStructEx			AjcCopyFolderStructExW
	#define	AjcCopyFiles					AjcCopyFilesW
	#define	AjcCopyFilesEx					AjcCopyFilesExW
	#define	AjcRemoveFolder					AjcRemoveFolderW
	#define	AjcCleanFolder					AjcCleanFolderW
	#define	AjcEnumFilesMatchingList		AjcEnumFilesMatchingListW
	#define	AjcGetParentDirectory			AjcGetParentDirectoryW
	#define	AjcCreateDirectory				AjcCreateDirectoryW
	#define	AjcCreateDirectoryEx			AjcCreateDirectoryExW
	#define	AjcCreateDirectoryStruct		AjcCreateDirectoryStructW
	#define	AjcCreateDirectoryStructEx		AjcCreateDirectoryStructExW
	#define	AjcCopyFile						AjcCopyFileW
	#define	AjcCopyFileEx					AjcCopyFileExW
	#define	AjcPathMatchSpec				AjcPathMatchSpecW
	#define	AjcPathMatchStr					AjcPathMatchStrW
	#define	AjcIsPathBackslash				AjcIsPathBackslashW
	#define	AjcIsPathBackslashEx			AjcIsPathBackslashExW
	#define	AjcPathCat						AjcPathCatW
	#define	AjcPathCmp						AjcPathCmpW
	#define	AjcChangeFNameToCorrect			AjcChangeFNameToCorrectW
	#define	AjcPathExists					AjcPathExistsW
	#define	AjcPathIsDirectory				AjcPathIsDirectoryW
	#define	AjcPathIsEmptyDirectory			AjcPathIsEmptyDirectoryW
	#define	AjcPathIsFile					AjcPathIsFileW
	#define	AjcGetFileSize					AjcGetFileSizeW
	#define	AjcGetFileTime1970				AjcGetFileTime1970W
	#define	AjcFileCompare					AjcFileCompareW
	#define	AjcGetFileTime					AjcGetFileTimeW
	#define	AjcSetFileTime					AjcSetFileTimeW
	#define	AjcSetFileTimeBySysTime			AjcSetFileTimeBySysTimeW
	#define	AjcIsSamePath					AjcIsSamePathW
	#define	AjcIsUnderPath					AjcIsUnderPathW

	#define	AJCFMLITEM						AJCFMLITEMW
	#define	PAJCFMLITEM						PAJCFMLITEMW
	#define	PCAJCFMLITEM					PCAJCFMLITEMW
#else
	#define	AjcCopyFolderStruct				AjcCopyFolderStructA
	#define	AjcCopyFolderStructEx			AjcCopyFolderStructExA
	#define	AjcCopyFiles					AjcCopyFilesA
	#define	AjcCopyFilesEx					AjcCopyFilesExA
	#define	AjcRemoveFolder					AjcRemoveFolderA
	#define	AjcCleanFolder					AjcCleanFolderA
	#define	AjcEnumFilesMatchingList		AjcEnumFilesMatchingListA
	#define	AjcGetParentDirectory			AjcGetParentDirectoryA
	#define	AjcCreateDirectory				AjcCreateDirectoryA
	#define	AjcCreateDirectoryEx			AjcCreateDirectoryExA
	#define	AjcCreateDirectoryStruct		AjcCreateDirectoryStructA
	#define	AjcCreateDirectoryStructEx		AjcCreateDirectoryStructExA
	#define	AjcCopyFile						AjcCopyFileA
	#define	AjcCopyFileEx					AjcCopyFileExA
	#define	AjcPathMatchSpec				AjcPathMatchSpecA
	#define	AjcPathMatchStr					AjcPathMatchStrA
	#define	AjcIsPathBackslash				AjcIsPathBackslashA
	#define	AjcIsPathBackslashEx			AjcIsPathBackslashExA
	#define	AjcPathCat						AjcPathCatA
	#define	AjcPathCmp						AjcPathCmpA
	#define	AjcChangeFNameToCorrect			AjcChangeFNameToCorrectA
	#define	AjcPathExists					AjcPathExistsA
	#define	AjcPathIsDirectory				AjcPathIsDirectoryA
	#define	AjcPathIsEmptyDirectory			AjcPathIsEmptyDirectoryA
	#define	AjcPathIsFile					AjcPathIsFileA
	#define	AjcGetFileSize					AjcGetFileSizeA
	#define	AjcGetFileTime1970				AjcGetFileTime1970A
	#define	AjcFileCompare					AjcFileCompareA
	#define	AjcGetFileTime					AjcGetFileTimeA
	#define	AjcSetFileTime					AjcSetFileTimeA
	#define	AjcSetFileTimeBySysTime			AjcSetFileTimeBySysTimeA
	#define	AjcIsSamePath					AjcIsSamePathA
	#define	AjcIsUnderPath					AjcIsUnderPathA

	#define	AJCFMLITEM						AJCFMLITEMA
	#define	PAJCFMLITEM						PAJCFMLITEMA
	#define	PCAJCFMLITEM					PCAJCFMLITEMA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	AjcCopyFolderStruct()/AjcCopyFiles()の通知コード															//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCCFS_SUCCESS		= 0	,		//	ディレクトリ作成 成功
	AJCCFS_FAILURE			,		//	ディレクトリ作成 失敗
	AJCCFS_EXIST			,		//	既に同一パスが存在する
} EAJCCFS, *PEAJCCFS;

//--------------------------------------------------------------------------------------------------------------//
//	ファイルタイム	（1601年世界協定時刻 (UTC) の 12:00 AM から経過した 100 ナノ秒間隔の数を表す 64 ビット値）	//
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	FILETIME  	ft;
	ULL			v;
} AJCUFT, *PAJCUFT;
typedef const AJCUFT *PCAJCUFT;

//	ファイルタイム群（通算時刻）
typedef struct {
	AJCUFT	mk;				//	作成日時
	AJCUFT	ac;				//	アクセス日時
	AJCUFT	up;				//	更新日時
} AJCFTIMES, *PAJCFTIMES;
typedef const AJCFTIMES *PCAJCFTIMES;

//	ファイルタイム群（システムタイム形式）
typedef struct {
	SYSTEMTIME	mk;			//	作成日時
	SYSTEMTIME	ac;			//	アクセス日時
	SYSTEMTIME	up;			//	更新日時
} AJCSTIMES, *PAJCSTIMES;
typedef const AJCSTIMES *PCAJCSTIMES;

//	フォルダ構造コピー(AjcCopyFolderStruct[Ex])時のオプション
#define	AJCFSC_NONE			0				//	オプション無し
#define	AJCFSC_SAMETIME		0x01			//	新規作成フォルダのタイムスタンプをコピー元と同じにする
#define	AJCFSC_FORCETIME	0x02			//	新規作成フォルダと既存フォルダのタイムスタンプをコピー元と同じにする

#define	AJCFSC_SAMEATTR		0x04			//	新規作成フォルダの属性をコピー元と同じにする
#define	AJCFSC_FORCEATTR	0x08			//	新規作成フォルダと既存フォルダの属性をコピー元と同じにする

#define	AJCFSC_MAKETOP		0x10			//	転送元末尾フォルダ名をの転送先の先頭フォルダとして作成する
#define	AJCFSC_ALLOWEXIST	0x20			//	同一フォルダが存在してもエラーとしない

#define	AJCFSC_SAME			(AJCFSC_SAMETIME  | AJCFSC_SAMEATTR)
#define	AJCFSC_FORCE		(AJCFSC_FORCETIME | AJCFSC_FORCEATTR)
#define	AJCFSC_STD			(AJCFSC_SAME | AJCFSC_MAKETOP | AJCFSC_ALLOWEXIST)

//	フォルダ内ファイルコピー(AjcCopyFiles[Ex])のオプション
#define	AJCCPF_NONE				0			//	オプション無し
#define	AJCCPF_CREATEALWAYS		0x0001		//	既にファイルが存在する場合、上書きする
#define	AJCCPF_WILDEXC			0x0002		//	ワイルドカードに一致するファイルを除外する

#define	AJCCPF_INP_SHARE_READ	0x0010		//	入力ファイルで読み出し共有
#define	AJCCPF_INP_SHARE_WRITE	0x0020		//	入力ファイルで書き込み共有
#define	AJCCPF_INP_SHARE_BOTH	(AJCCPF_INP_SHARE_READ | AJCCPF_INP_SHARE_WRITE)

#define	AJCCPF_OUT_SHARE_READ	0x0100		//	出力ファイルで読み出し共有
#define	AJCCPF_OUT_SHARE_WRITE	0x0200		//	出力ファイルで書き込み共有
#define	AJCCPF_OUT_SHARE_BOTH	(AJCCPF_OUT_SHARE_READ | AJCCPF_OUT_SHARE_WRITE)

#define	AJCCPF_ALL_SHARE_READ	(AJCCPF_INP_SHARE_READ	| AJCCPF_OUT_SHARE_READ)
#define	AJCCPF_ALL_SHARE_WRITE	(AJCCPF_INP_SHARE_WRITE | AJCCPF_OUT_SHARE_WRITE)
#define	AJCCPF_ALL_SHARE		(AJCCPF_INP_SHARE_BOTH	| AJCCPF_OUT_SHARE_BOTH )

//	フォルダ削除(AjcRemoveFolderEx)時の通知コード
#define	AJCRMV_FILE			0x00			//	ファイルの削除
#define	AJCRMV_DIR			0x01			//	フォルダの削除
#define	AJCRMV_ERR			0x80			//	エラーフラグ

#define	AJCRMV_FILE_OK		(AJCRMV_FILE)
#define	AJCRMV_FILE_ERR		(AJCRMV_FILE | AJCRMV_ERR)
#define	AJCRMV_DIR_OK		(AJCRMV_DIR )
#define	AJCRMV_DIR_ERR		(AJCRMV_DIR  | AJCRMV_ERR)

//--------------------------------------------------------------------------------------------------------------//
//	ファイル突合せリストリスト 																					//
//--------------------------------------------------------------------------------------------------------------//
//	エラーコード
#define	AJCFMLERR_OK			0			//	正常
#define	AJCFMLERR_NULL			-1			//	パス１，２が NULL
#define	AJCFMLERR_PATH1			-2			//	パス１が存在しない
#define	AJCFMLERR_PATH2			-3			//	パス２が存在しない
#define	AJCFMLERR_SYSAPI		-4			//	システムＡＰＩエラー
#define	AJCFMLERR_MEM			-5			//	メモリエラー
#define	AJCFMLERR_STOP_BY_USER	-9			//	コールバックから中止指示

//	opt（オプション）
#define	AJCFML_BOTH				0x03		//	ファイルとディレクトリのマッチングリストを列挙
#define	AJCFML_FILE				0x02		//	ファイルのマッチングリストを列挙
#define	AJCFML_DIR				0x01		//	ディレクトリのマッチングリストを列挙
#define	AJCFML_NOFILE			AJCFML_DIR	//	マッチングリストにファイルを含めない
#define	AJCFML_NODIR			AJCFML_FILE	//	マッチングリストにディレクトリを含めない

//	ヘッダ情報
typedef	struct {
	UI		utc;							//	ファイル・タイムスタンプ（ＵＴＣ）
	UI		att;							//	ファイル属性
	ULL		size;							//	ファイルサイズ
} AJCFMLHD, *PAJCFMLHD;

//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	列挙情報
typedef struct {
	BOOL		fValid;						//	有効フラグ
	AJCFMLHD	hd;							//	共通ヘッダ
	BC			path[MAX_PATH];				//	ファイル／ディレクトリパス名
	BC			name[MAX_PATH];				//	ファイル名と拡張子（ディレクトリの場合は、末尾パス項目）
	BC			tail[MAX_PATH];				//	パス名の後部（指定した pPath1/pPath2 の後続部分）
} AJCFMLITEMA, *PAJCFMLITEMA;
typedef const AJCFMLITEMA *PCAJCFMLITEMA;

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	列挙情報
typedef struct {
	BOOL		fValid;						//	有効フラグ
	AJCFMLHD	hd;							//	共通ヘッダ
	WC			path[MAX_PATH];				//	ファイルパス名
	WC			name[MAX_PATH];				//	ファイル名と拡張子（ディレクトリの場合は、末尾パス項目）
	WC			tail[MAX_PATH];				//	パス名の後部（指定した pPath1/pPath2 の後続部分）
} AJCFMLITEMW, *PAJCFMLITEMW;
typedef const AJCFMLITEMW *PCAJCFMLITEMW;

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL	WINAPI AjcCopyFolderStructA(C_BCP pPathFrom, C_BCP pPathTo, UI opt);
AJCEXPORT	BOOL	WINAPI AjcCopyFolderStructW(C_WCP pPathFrom, C_WCP pPathTo, UI opt);


AJCEXPORT	BOOL	WINAPI	AjcCopyFolderStructExA(C_BCP pPathFrom, C_BCP pPathTo, UI opt, UX cbp, 
													BOOL (CALLBACK *cbNotify)(C_BCP pPathFrom , C_BCP pPathTo, EAJCCFS ntc, UX cbp),
													BCP  (CALLBACK *cbQuery )(C_BCP pPathFront,   BCP pNewDir,				UX cbp));
AJCEXPORT	BOOL	WINAPI	AjcCopyFolderStructExW(C_WCP pPathFrom, C_WCP pPathTo, UI opt, UX cbp, 
													BOOL (CALLBACK *cbNotify)(C_WCP pPathFrom , C_WCP pPathTo, EAJCCFS ntc, UX cbp),
													WCP  (CALLBACK *cbQuery )(C_WCP pPathFront,   WCP pNewDir,				UX cbp));


AJCEXPORT	BOOL	WINAPI AjcCopyFilesA(C_BCP pPathFrom, C_BCP pPathTo, C_BCP pWildCard, UI opt);
AJCEXPORT	BOOL	WINAPI AjcCopyFilesW(C_WCP pPathFrom, C_WCP pPathTo, C_WCP pWildCard, UI opt);

AJCEXPORT	BOOL	WINAPI AjcCopyFilesExA(C_BCP pPathFrom, C_BCP pPathTo, C_BCP pWildCard, UI opt, UX cbp,
											BOOL (CALLBACK *cbNotify  )(C_BCP pFileFrom, C_BCP pFileTo, EAJCCFS ntc, UX cbp),
											BCP  (CALLBACK *cbQuery   )(C_BCP pFileFrom, C_BCP pFileTo, BCP pFileName, UIP pAtt, UX cbp),
											BOOL (CALLBACK *cbProgress)(ULL FileSize, ULL Copied, UX cbp));
AJCEXPORT	BOOL	WINAPI AjcCopyFilesExW(C_WCP pPathFrom, C_WCP pPathTo, C_WCP pWildCard, UI opt, UX cbp,
											BOOL (CALLBACK *cbNotify  )(C_WCP pFileFrom, C_WCP pFileTo, EAJCCFS ntc , UX cbp),
											WCP  (CALLBACK *cbQuery   )(C_WCP pFileFrom, C_WCP pFileTo, WCP pFileName, UIP pAtt, UX cbp),
											BOOL (CALLBACK *cbProgress)(ULL FileSize, ULL Copied, UX cbp));

AJCEXPORT	BOOL	WINAPI	AjcCopyFileA(C_BCP pFrom, C_BCP pTo, UI opt, UX cbp, BOOL (CALLBACK *cbProgress)(ULL FileSize, ULL Copied, UX cbp));
AJCEXPORT	BOOL	WINAPI	AjcCopyFileW(C_WCP pFrom, C_WCP pTo, UI opt, UX cbp, BOOL (CALLBACK *cbProgress)(ULL FileSize, ULL Copied, UX cbp));

AJCEXPORT	BOOL	WINAPI	AjcCopyFileExA(C_BCP pFrom, C_BCP pTo, UI opt, BOOL *pfCancel, UX cbp, BOOL (CALLBACK *cbProgress)(ULL FileSize, ULL Copied, UX cbp));
AJCEXPORT	BOOL	WINAPI	AjcCopyFileExW(C_WCP pFrom, C_WCP pTo, UI opt, BOOL *pfCancel, UX cbp, BOOL (CALLBACK *cbProgress)(ULL FileSize, ULL Copied, UX cbp));

AJCEXPORT	BOOL	WINAPI AjcRemoveFolderA(C_BCP pPath, UX cbp, BOOL (CALLBACK *cbNotify)(C_BCP pPathRemoved, UI ntc, UX cbp));
AJCEXPORT	BOOL	WINAPI AjcRemoveFolderW(C_WCP pPath, UX cbp, BOOL (CALLBACK *cbNotify)(C_WCP pPathRemoved, UI ntc, UX cbp));

AJCEXPORT	BOOL	WINAPI AjcCleanFolderA(C_BCP pPath, UX cbp, BOOL (CALLBACK *cbNotify)(C_BCP pPathRemoved, UI ntc, UX cbp));
AJCEXPORT	BOOL	WINAPI AjcCleanFolderW(C_WCP pPath, UX cbp, BOOL (CALLBACK *cbNotify)(C_WCP pPathRemoved, UI ntc, UX cbp));

AJCEXPORT	int		WINAPI AjcEnumFilesMatchingListA(C_BCP pPath1, C_BCP pPath2, UI opt, UX cbp, BOOL (CALLBACK *cbQuery)(UI id, C_BCP pPath, UI att, BOOL *pfDiscard, UX cbp),
																						 		 BOOL (CALLBACK *cbEnum )(AJCFMLITEMA item[2], UX cbp));
AJCEXPORT	int		WINAPI AjcEnumFilesMatchingListW(C_WCP pPath1, C_WCP pPath2, UI opt, UX cbp, BOOL (CALLBACK *cbQuery)(UI id, C_WCP pPath, UI att, BOOL *pfDiscard, UX cbp),
																						 		 BOOL (CALLBACK *cbEnum )(AJCFMLITEMW item[2], UX cbp));

AJCEXPORT	BOOL	WINAPI AjcGetParentDirectoryA(C_BCP pPath, BCP pBuf, UI lBuf, BOOL *pfRoot);
AJCEXPORT	BOOL	WINAPI AjcGetParentDirectoryW(C_WCP pPath, WCP pBuf, UI lBuf, BOOL *pfRoot);

AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryA(C_BCP pPath, BOOL fSaveParentDirTime);
AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryW(C_WCP pPath, BOOL fSaveParentDirTime);

AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryExA(C_BCP lpTemplateDirectory, C_BCP lpNewDirectory, LPSECURITY_ATTRIBUTES lpSecurityAttributes, BOOL fSaveParentDirTime);
AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryExW(C_WCP lpTemplateDirectory, C_WCP lpNewDirectory, LPSECURITY_ATTRIBUTES lpSecurityAttributes, BOOL fSaveParentDirTime);

AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryStructA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryStructW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryExA(C_BCP lpTemplateDirectory, C_BCP lpNewDirectory, LPSECURITY_ATTRIBUTES lpSecurityAttributes, BOOL fSaveParentDirTime);
AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryExW(C_WCP lpTemplateDirectory, C_WCP lpNewDirectory, LPSECURITY_ATTRIBUTES lpSecurityAttributes, BOOL fSaveParentDirTime);

AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryStructExA(C_BCP pPath, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
AJCEXPORT	BOOL	WINAPI AjcCreateDirectoryStructExW(C_WCP pPath, LPSECURITY_ATTRIBUTES lpSecurityAttributes);

AJCEXPORT	BOOL	WINAPI	AjcPathMatchSpecA(C_BCP pPath, C_BCP pWild);
AJCEXPORT	BOOL	WINAPI	AjcPathMatchSpecW(C_WCP pPath, C_WCP pWild);

AJCEXPORT	BOOL	WINAPI	AjcPathMatchStrA(C_BCP pPath, C_BCP pStr);
AJCEXPORT	BOOL	WINAPI	AjcPathMatchStrW(C_WCP pPath, C_WCP pStr);

AJCEXPORT	BOOL	WINAPI	AjcIsPathBackslashA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcIsPathBackslashW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcIsPathBackslashExA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcIsPathBackslashExW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcPathCatA(BCP pTop, C_BCP pTail, int lBuf);
AJCEXPORT	BOOL	WINAPI	AjcPathCatW(WCP pTop, C_WCP pTail, int lBuf);

AJCEXPORT	int		WINAPI	AjcPathCmpA(C_BCP pPath1, C_BCP pPath2);
AJCEXPORT	int		WINAPI	AjcPathCmpW(C_WCP pPath1, C_WCP pPath2);

AJCEXPORT	int		WINAPI	AjcChangeFNameToCorrectA(BCP pPath, BC c);
AJCEXPORT	int		WINAPI	AjcChangeFNameToCorrectW(WCP pPath, WC c);

AJCEXPORT	BOOL	WINAPI	AjcPathExistsA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcPathExistsW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcPathIsDirectoryA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcPathIsDirectoryW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcPathIsEmptyDirectoryA(C_BCP pPath, UX cbp, BOOL (CALLBACK *cbQuery)(C_BCP pPath, UI att, BOOL *pfDiscard, UX cbp));
AJCEXPORT	BOOL	WINAPI	AjcPathIsEmptyDirectoryW(C_WCP pPath, UX cbp, BOOL (CALLBACK *cbQuery)(C_WCP pPath, UI att, BOOL *pfDiscard, UX cbp));

AJCEXPORT	BOOL	WINAPI	AjcPathIsFileA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcPathIsFileW(C_WCP pPath);

AJCEXPORT	ULL		WINAPI	AjcGetFileSizeA(C_BCP pPath);
AJCEXPORT	ULL		WINAPI	AjcGetFileSizeW(C_WCP pPath);

AJCEXPORT	UI		WINAPI	AjcGetFileTime1970A(C_BCP pPath);
AJCEXPORT	UI		WINAPI	AjcGetFileTime1970W(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcFileCompareA(C_BCP pFile1, C_BCP pFile2);
AJCEXPORT	BOOL	WINAPI	AjcFileCompareW(C_WCP pFile1, C_WCP pFile2);

AJCEXPORT	BOOL	WINAPI	AjcGetFileTimeA(C_BCP pPath, PAJCFTIMES pFTimes, PAJCSTIMES pSTimes, BOOL fLocalTime);
AJCEXPORT	BOOL	WINAPI	AjcGetFileTimeW(C_WCP pPath, PAJCFTIMES pFTimes, PAJCSTIMES pSTimes, BOOL fLocalTime);

AJCEXPORT	BOOL	WINAPI	AjcSetFileTimeA(C_BCP pPath, PCAJCFTIMES pFTimes, BOOL fLocalTime);
AJCEXPORT	BOOL	WINAPI	AjcSetFileTimeW(C_WCP pPath, PCAJCFTIMES pFTimes, BOOL fLocalTime);

AJCEXPORT	BOOL	WINAPI	AjcSetFileTimeBySysTimeA(C_BCP pPath, LPSYSTEMTIME pSTimes, BOOL fLocalTime);
AJCEXPORT	BOOL	WINAPI	AjcSetFileTimeBySysTimeW(C_WCP pPath, LPSYSTEMTIME pSTimes, BOOL fLocalTime);

AJCEXPORT	C_BCP	WINAPI	AjcIsSamePathA(C_BCP pBase, C_BCP pPath1, C_BCP pPath2);
AJCEXPORT	C_WCP	WINAPI	AjcIsSamePathW(C_WCP pBase, C_WCP pPath1, C_WCP pPath2);

AJCEXPORT	BOOL	WINAPI	AjcIsUnderPathA(C_BCP pBase, C_BCP pUpperPath, C_BCP pUnderPath);
AJCEXPORT	BOOL	WINAPI	AjcIsUnderPathW(C_WCP pBase, C_WCP pUpperPath, C_WCP pUnderPath);

//----- ＭＳＩＬ用サポートコード -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcEnumFileMatchingListMsil(C_WCP pPath1, C_WCP pPath2, UI opt, UX cbp, 
					BOOL (CALLBACK *cbQuery)(UI id, C_WCP pPath, UI att, BOOL *fDiscard, UX cbp),
					BOOL (CALLBACK *cbEnum )(BOOL fValid1, UI utc1, UI att1, ULL size1, C_WCP pPath1, C_WCP pName1, C_WCP pTail1,
											 BOOL fValid2, UI utc2, UI att2, ULL size2, C_WCP pPath2, C_WCP pName2, C_WCP pTail2, UX cbp));

/****************************************************************************************************************/
#endif
