﻿#ifndef	AJCMAIN_H_
#define	AJCMAIN_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	言語種別																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCLID_ENG	= 0	,
	AJCLID_JPN	= 0x411
} AJCLANGID;

#define		AJCLNGSEL(JPN, ENG)	((AjcGetLangId() == AJCLID_JPN) ? JPN : ENG)

//--------------------------------------------------------------------------------------------------------------//
//	バージョン表示時のリソース種別																				//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCVER_BMAP		= 1	,		//	ビットマップ
	AJCVER_ICON		= 2	,		//	アイコン
} AJCVER_RESKND;

//--------------------------------------------------------------------------------------------------------------//
//	MAjcInit()の戻り値																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCINIT_OK		= 0	,		//	初期化成功
	AJCINIT_FAILURE		,		//	初期化失敗（リソースが不足）
} AJCINIT_RESULT;

//--------------------------------------------------------------------------------------------------------------//
//	ツールチップ文字列の最大長																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCMAX_TIPSIZE		128

//--------------------------------------------------------------------------------------------------------------//
//	試行日数																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTRIAL_DAYS	64

//--------------------------------------------------------------------------------------------------------------//
//	汎用マクロ																									//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCTSIZE(_TEXT_)	(sizeof _TEXT_ / sizeof _TEXT_[0])		//	テキストバイト数／文字数
#define		AJCSZARR(_ARR_)		(sizeof _ARR_  / sizeof _ARR_[0] )		//	配列エントリサイズ

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcSetAppName				AjcSetAppNameW

	#define		AjcTAlloc					AjcTAllocW
	#define		AjcGetVerStr				AjcGetVerStrW
	#define		AjcGetVersion				AjcGetVersionW
	#define		AjcGetVerInRes				AjcGetVerInResW

	#define		AjcGetMyPath				AjcGetMyPathW
	#define		AjcAdjustSemiCollon			AjcAdjustSemiCollonW
	#define		AjcAjrAppVersionDialog		AjcAjrAppVersionDialogW
	#define		AjcAjrAppVersionDialogEx	AjcAjrAppVersionDialogExW
	//	トレース
	#define		AjcTrace					AjcTraceW

#else

	#define		AjcSetAppName				AjcSetAppNameA

	#define		AjcTAlloc					AjcTAllocA
	#define		AjcGetVerStr				AjcGetVerStrA
	#define		AjcGetVersion				AjcGetVersionA
	#define		AjcGetVerInRes				AjcGetVerInResA
	#define		AjcGetMyPath				AjcGetMyPathA
	#define		AjcAdjustSemiCollon			AjcAdjustSemiCollonA
	#define		AjcAjrAppVersionDialog		AjcAjrAppVersionDialogA
	#define		AjcAjrAppVersionDialogEx	AjcAjrAppVersionDialogExA
	//	トレース
	#define		AjcTrace					AjcTraceA

#endif
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HFONT		WINAPI	AjcGetDefFontFix(int FontHeight);
AJCEXPORT	HFONT		WINAPI	AjcGetDefFontVar(int FontHeight);


AJCEXPORT	HINSTANCE	WINAPI	AjcGetDllInstance(void);

AJCEXPORT	AJCINIT_RESULT	WINAPI	AjcInit(UL dmy1, UL dmy2);
AJCEXPORT	VO				WINAPI	AjcSetCmdWithHdl(BOOL fWithHandle);

AJCEXPORT	VO			WINAPI	AjcSetAppNameA(C_BCP pName);
AJCEXPORT	VO			WINAPI	AjcSetAppNameW(C_WCP pName);

AJCEXPORT	VO			WINAPI	AjcSetAppIcon(HICON hIcon);

AJCEXPORT	VO			WINAPI	AjcChangeIconToMsil(VO);

AJCEXPORT	VO			WINAPI	AjcSetLangId	 (AJCLANGID Lid);
AJCEXPORT	AJCLANGID	WINAPI	AjcGetLangId	 (VO);

typedef	VO (CALLBACK *CBCLEANUP)(VOP pHandle);
AJCEXPORT	VOP			WINAPI	AjcAllocInstance(int size, CBCLEANUP cbCleanup);
AJCEXPORT	VO			WINAPI	AjcReleaseInstance(VOP pHandle);


//----- テキスト・メモリ割り当て -------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcTAllocA(UI TextLength);
AJCEXPORT	WCP		WINAPI	AjcTAllocW(UI TextLength);
AJCEXPORT	VO		WINAPI	AjcTFree(VOP pTxt);

//----- バージョン文字列取得 -----------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcGetVerStrA(VO);
AJCEXPORT	WCP		WINAPI	AjcGetVerStrW(VO);

AJCEXPORT	VO		WINAPI	AjcGetVersionA(BCP pBuf, int lBuf);
AJCEXPORT	VO		WINAPI	AjcGetVersionW(WCP pBuf, int lBuf);

AJCEXPORT	UI	WINAPI	AjcGetVerInResA(HINSTANCE hInst, BCP pVerBuf, int lVerBuf);
AJCEXPORT	UI	WINAPI	AjcGetVerInResW(HINSTANCE hInst, WCP pVerBuf, int lVerBuf);

//----- 自ＢＩＮパス，ＩＮＣパス取得 ---------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetMyPathA(BCP pBinPath, int lBinPath, BCP pIncPath, int lIncPath);
AJCEXPORT	VO		WINAPI	AjcGetMyPathW(WCP pBinPath, int lBinPath, WCP pIncPath, int lIncPath);

//----- 先頭と末尾のセミコロンを削除し、中間の連続したセミコロンを１つにまとめる -------------------------------//
AJCEXPORT	VO	WINAPI	AjcAdjustSemiCollonA(BCP pStr);
AJCEXPORT	VO	WINAPI	AjcAdjustSemiCollonW(WCP pStr);

//----- メモリアクセス（PEEK) ----------------------------------------------------------------------------------//
AJCEXPORT	UB		WINAPI	AjcMemPeekUB (C_UBP  pMem);
AJCEXPORT	UW		WINAPI	AjcMemPeekUW (C_UWP  pMem);
AJCEXPORT	UI		WINAPI	AjcMemPeekUL (C_UIP  pMem);
AJCEXPORT	ULL		WINAPI	AjcMemPeekULL(C_ULLP pMem);

AJCEXPORT	SB		WINAPI	AjcMemPeekSB (C_UBP  pMem);
AJCEXPORT	SW		WINAPI	AjcMemPeekSW (C_UWP  pMem);
AJCEXPORT	SI		WINAPI	AjcMemPeekSL (C_UIP  pMem);
AJCEXPORT	SLL		WINAPI	AjcMemPeekSLL(C_ULLP pMem);

//----- メモリコピー -------------------------------------------------------------------------------------------//
AJCEXPORT	VOP		WINAPI	AjcMemCopy(VOP pDest, C_VOP pSrc, int len);

//----- ワイド文字列長 -----------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcWStrLen(C_WCP pStr);

//----- ワイド文字列コピー -------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcWStrCopy(WCP pDest, C_WCP pSrc, int lDest);

//----- バイト文字→ワイド文字変換 -----------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcByteCharToWideChar(C_BCP pSrc, WCP pDest, int lDest);

//----- ワイド文字→バイト文字変換 -----------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcWideCharToByteChar(C_WCP pSrc, BCP pDest, int lDest);

//----- レンジ分割のステップ値を算出（非公開）------------------------------------------------------------------//
AJCEXPORT	double	WINAPI	AjcCalcRangeStep(double RangWidth, double MinDiv, double MaxDiv, UIP pDigit, UIP pPrec);

//----- バージョン表示ダイアログ -------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogA  (HWND hOwner, C_BCP pVerStr, HBITMAP hBmp , int SrtYY, C_BCP pWndTtl, C_BCP pSubTtl, C_BCP pCpyRgt);
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogW  (HWND hOwner, C_WCP pVerStr, HBITMAP hBmp , int SrtYY, C_WCP pWndTtl, C_WCP pSubTtl, C_WCP pCpyRgt);

AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogExA(HWND hOwner, C_BCP pVerStr, UX hBmpOrIcon, int SrtYY, C_BCP pWndTtl, C_BCP pSubTtl, C_BCP pCpyRgt, AJCVER_RESKND knd);
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogExW(HWND hOwner, C_WCP pVerStr, UX hBmpOrIcon, int SrtYY, C_WCP pWndTtl, C_WCP pSubTtl, C_WCP pCpyRgt, AJCVER_RESKND knd);

//----- トレース（IDEの出力ウインドへ書式出力）-----------------------------------------------------------------//
AJCEXPORT	VO		WINAPI AjcTraceA(C_BCP pFmt, ...);
AJCEXPORT	VO		WINAPI AjcTraceW(C_WCP pFmt, ...);





//----- ＭＳＩＬ用サポートコード -------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcMsilEncDblBrktW(C_WCP pFmt, WCP pBuf);
AJCEXPORT	VO		WINAPI	AjcMsilEncBrktW(C_WCP pStr, WCP pBuf);
AJCEXPORT	VO		WINAPI	AjcMsilRcvBrktW(C_WCP pStr, WCP pBuf);
AJCEXPORT	int		WINAPI	AjcMsilGetFormatItemW(C_WCP pFmt, WCP pBuf);
AJCEXPORT	VO		WINAPI	AjcMsilFormatIxToZeroW(C_WCP pFmt, WCP pBuf);
AJCEXPORT	VO		WINAPI	AjcPtrToStringW(C_WCP pStr, WCP pBuf, UI len);
AJCEXPORT	int		WINAPI	AjcPtrToStrLenW(C_WCP pStr);



/****************************************************************************************************************/
#endif
