﻿#ifndef	AJCSOCKSERV_H_
#define	AJCSOCKSERV_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcSsvStart				AjcSsvStartW
	#define	AjcSsvSendChar			AjcSsvSendCharW
	#define	AjcSsvSendText			AjcSsvSendTextW
	#define	AjcSsvSendTextF			AjcSsvSendTextFW
	#define	AjcSsvGetIpAddrStr		AjcSsvGetIpAddrStrW
#else
	#define	AjcSsvStart				AjcSsvStartA
	#define	AjcSsvSendChar			AjcSsvSendCharA
	#define	AjcSsvSendText			AjcSsvSendTextA
	#define	AjcSsvSendTextF			AjcSsvSendTextFA
	#define	AjcSsvGetIpAddrStr		AjcSsvGetIpAddrStrA
#endif


//	イベントコード
#define	AJCSSV_EV_RXTEXT		AJCSSEP_EV_TXT				//	テキストデータ通知		0x01
#define	AJCSSV_EV_RXESC			AJCSSEP_EV_ESC				//	ＥＳＣコードデータ通知	0x02
#define	AJCSSV_EV_RXPKT			AJCSSEP_EV_PKT				//	パケットデータ通知		0x04
#define	AJCSSV_EV_RXCTRL		AJCSSEP_EV_CTRL				//	制御コード通知			0x08
#define	AJCSSV_EV_RXNOPKT		AJCSSEP_EV_NOPKT			//	パケット外テキスト		0x10

#define	AJCSSV_EV_RXCHUNK		0x00000100					//	チャンクデータ受信通知
#define	AJCSSV_EV_INVCHUNK		0x00000200					//	不正チャンクテキスト受信通知
#define	AJCSSV_EV_TXEMPTY		0x00000400					//	送信完了通知
#define	AJCSSV_EV_CONNECT		0x00000800					//	接続通知
#define	AJCSSV_EV_DISCONNECT	0x00001000					//	切断通知
#define	AJCSSV_EV_START			0x00002000					//	サーバ開始通知
#define	AJCSSV_EV_STOP			0x00004000					//	サーバ停止通知

#define	AJCSSV_EV_RXERR			0x00010000					//	受信エラー通知
#define	AJCSSV_EV_TXERR			0x00020000					//	送信エラー通知
#define	AJCSSV_EV_OVERR			0x00040000					//	クライアント接続数オーバー
#define	AJCSSV_EV_ERR			0x08000000					//	その他のエラー通知

#define	AJCSSV_EV_SSEP			(AJCSSV_EV_RXTEXT  | AJCSSV_EV_RXESC	  | AJCSSV_EV_RXCTRL  | AJCSSV_EV_RXPKT | AJCSSV_EV_RXNOPKT)
#define	AJCSSV_EV_COMM			(AJCSSV_EV_RXCHUNK | AJCSSV_EV_INVCHUNK   | AJCSSV_EV_TXEMPTY					)
#define	AJCSSV_EV_GENERAL		(AJCSSV_EV_CONNECT | AJCSSV_EV_DISCONNECT | AJCSSV_EV_START   | AJCSSV_EV_STOP	)
#define	AJCSSV_EV_ERRS			(AJCSSV_EV_RXERR   | AJCSSV_EV_TXERR	  | AJCSSV_EV_ERR						)
#define	AJCSSV_EV_CLIENT		(AJCSSV_EV_SSEP    | AJCSSV_EV_COMM 	  | AJCSSV_EV_CONNECT | AJCSSV_EV_DISCONNECT | AJCSSV_EV_RXERR | AJCSSV_EV_TXERR)
#define	AJCSSV_EV_ALL			(AJCSSV_EV_SSEP    | AJCSSV_EV_COMM 	  | AJCSSV_EV_GENERAL | AJCSSV_EV_ERRS)

//	エラーコード
#define	AJCSSV_ERR_CREEVT			 10						//	終了通知用イベントオブジェクト生成失敗
#define	AJCSSV_ERR_SOCKET			 20						//	接続要求待機用ソケット生成失敗(socket)
#define	AJCSSV_ERR_BIND				 30						//	バインド失敗（bindt）
#define	AJCSSV_ERR_LISTEN			 40						//	LISTEN失敗(listen)
#define	AJCSSV_ERR_ACCEPT			 50						//	ACCEPT失敗（accept）
#define	AJCSSV_ERR_ADDRINFO			 60						//	アドレス情報取得失敗（getaddrinfo）
#define	AJCSSV_ERR_SOCKOPT			 70						//	ソケットオプション設定失敗(setsockopt)
#define	AJCSSV_ERR_THREADPOWCTRL	 80						//	電源制御スレッド開始失敗
#define	AJCSSV_ERR_THREADLISTEN		 90						//	接続待機スレッド開始失敗
#define	AJCSSV_ERR_THREADCLIENT		100						//	クライアント通信スレッド開始失敗
#define	AJCSSV_ERR_CRESSEP			110						//	ストリーム分離インスタンス生成失敗
#define	AJCSSV_ERR_CREMBXTXD		120						//	送信データ用メールボックス生成失敗
#define	AJCSSV_ERR_TIMEOUT			130						//	サーバ終了タイムアウト
#define	AJCSSV_ERR_CRETHREADWORK	140						//	クライアントスレッド用ワーク確保失敗
#define	AJCSSV_ERR_CONNOVER			150						//	クライアント接続数オーバー
#define	AJCSSV_ERR_CREIXMAP			160						//	インデクス割り当て用マップテーブル生成失敗

//	テキスト・コード
typedef enum {
	AJCSSV_TXT_SJIS		=	AJCMBC_SJIS	,					//	シフトＪＩＳ(=1)
	AJCSSV_TXT_EUC		=	AJCMBC_EUC	,					//	ＥＵＣ　　　(=2)
	AJCSSV_TXT_UTF8		=	AJCMBC_UTF8	,					//	ＵＴＦ－８　(=3)
	AJCSSV_TXT_AUTO		=	9	,							//	自動判別　　
} AJCSSV_TEXTCODE;

//	送受信バッファサイズ
#define	AJCSSVMAX_RXBUF	1024
#define	AJCSSVMAX_TXBUF	1024

//	チャンク・データ・モード
typedef enum {
	AJCSSV_CM_BIN	=	0x01	,				//	バイナリチャンク
	AJCSSV_CM_TEXT	=	0x02	,				//	テキストチャンク
	AJCSSV_CM_BOTH	=	0x03	,				//	両方
} AJCSSV_CHUNKMODE;

//	アドレス情報ストレージ
typedef union {
	struct sockaddr_in		sain;
	struct sockaddr_in6		sain6;
	struct sockaddr_storage storage;
} AJCSSVSAIN, *PAJCSSVSAIN;
typedef const AJCSSVSAIN *PCAJCSSVSAIN;

//	サーバ起動オプション
typedef enum {
	AJCSSV_SOP_NOOPT			= 0   ,		//	オプション無し
	AJCSSV_SOP_SUP_SLEEP		= 0x01,		//	スリープ抑止
	AJCSSV_SOP_SUP_DISPOFF		= 0x02,		//	ディスプレィOFF抑止
	AJCSSV_SOP_SUP_ALL			= 0x03,		//	スリープ＆ディスプレィOFF抑止
} AJCSSV_SERVOPT, *PAJCSSV_SERVOPT;

#define		AJCSSV_SERVOPT_MASK		0x03

//	インスタンスワーク
typedef struct {
	UI					InstID;								//	インスタンス識別ＩＤ
	BOOL				fStarted;							//	サーバ開始済フラグ
	BOOL				fEnding;							//	AjcSsvStop()/AjcSsvDelete()による終了中フラグ
	UI					CliSeqNo;							//	クライアント接続順序番号

	//	インスタンス生成時ワーク
	UI					EvtMask;							//	通知イベントマスク
	AJCSSV_CHUNKMODE	ChunkMode;							//	チャンク通知モード
	AJCSSV_TEXTCODE		RxTxtCode;							//	受信テキストコード
	AJCSSV_TEXTCODE		TxTxtCode;							//	送信テキストコード
	UI					PktTimeout;							//	パケット受信タイムアウト[ms]
	UB					stx, etx, dle;						//	パケットを認識するための制御コード
	UB					dummy;
	HAJCFMBX			hFMbxNtc;							//	ユーザＡＰへのイベント通知用メールボックスハンドル
	HAJCAVL				hAvlCli;							//	クライアントインスタンス登録用ＡＶＬ

	//	サーバ開始時ワーク
	BOOL				fUnicode;							//	UNICODEフラグ
	UI					MaxClients;							//	クライアント最大接続数
	AJCSSV_SERVOPT		opt;								//	サーバ起動オプション
	HWND				hWndNtc;							//	イベント通知用ウインドハンドル
	UI					MsgNtc;								//	イベント通知メッセージコード
	SOCKET				hSockListen;						//	TCP/IPストリームソケット
	HANDLE				hEvtExit;							//	サーバ終了イベント
	HANDLE				hEvtNoClients;						//	全クライアント終了イベント
	HANDLE				hThreadPowCtrl;						//	電源制御スレッドハンドル
	UL					idThreadPowCtrl;					//	電源制御スレッドＩＤ
	HANDLE				hThreadListen;						//	接続待機スレッドハンドル
	UL					idThreadListen;						//	接続待機スレッドＩＤ
	UIP					pIxMap;								//	インデクス割り当て用マップテーブル

	CRITICAL_SECTION	csClients;							//	接続数カウンタ増減の排他制御用
	int					ClientCount;						//	接続クライアント数


	//----- MSILサポート用 ----------------------------------------------------//
	HWND	hWndForMsil;						//	MSIL用ダミーウインドハンドル

} AJCSSV, *HAJCSSV;
typedef const AJCSSV *PCAJCSSV;

//	クライアントスレッド ワーク
typedef struct {
	UI			InstID;				//	インスタンス識別ＩＤ
	UI			SeqNo;				//	クライアント接続順序番号
	UI			ix;					//	クライアントのインデクス
	BOOL		fExit;				//	クライアント終了フラグ
	HAJCSSV		pW;					//	インスタンスワークへのポインタ
	SOCKET		hSockClient;		//	クライアントソケットハンドル
	AJCSSVSAIN	SockAddr;			//	ソケットアドレス情報
	UI			ThreadId;			//	スレッドＩＤ
	UX			UserData;			//	ユーザデータ
	HAJCSSEP	hSsep;				//	ストリーム分離インスタンス
	HANDLE		hThreadClient;		//	クライアントスレッドハンドル
	UI			idThreadClient;		//	クライアントスレッド識別子
	HAJCVMBX	hVMbxTxD;			//	送信データ・メールボックスハンドル
	BOOL		fTxBusy;			//	送信完了検出用フラグ
	BC			SvSndA, dmy1;		//	テキスト送信時の全角１バイト目退避バッファ
	WC			SvSndW;				//	テキスト送信時のサロゲート１文字目退避バッファ
	UI			ixRxb;							//	受信バッファ空部分のインデクス（＝前部の半端マルチバイト数）
	UB			RxBuf[AJCSSVMAX_RXBUF + 8];		//	テキスト受信データバッファ（データ＋中途マルチバイト(1～5)）＋終端(0x00)）
	UB			RxBin[AJCSSVMAX_RXBUF];			//	バイナリ受信データバッファ
	UI			ixNpk;							//	パケット外バッファ空部分のインデクス（＝前部の半端マルチバイト数）
	BC			NpBuf[AJCSSVMAX_RXBUF + 8];		//	パケット外バッファ（データ＋中途マルチバイト(1～5)）＋終端(0x00)）
} AJCSSVCLI, *HAJCSSVCLI;
typedef const AJCSSVCLI *PCAJCSSVCLI;

//	プロトタイプ
AJCEXPORT	HAJCSSV	 		WINAPI	AjcSsvCreate		 (VO);
AJCEXPORT	BOOL			WINAPI	AjcSsvDelete		 (HAJCSSV hSsv);

AJCEXPORT	BOOL			WINAPI	AjcSsvSetOpt		 (HAJCSSV hSsv, AJCSSV_SERVOPT opt);
AJCEXPORT	AJCSSV_SERVOPT	WINAPI	AjcSsvGetOpt		 (HAJCSSV hSsv);

AJCEXPORT	BOOL			WINAPI	AjcSsvStartA(HAJCSSV hSsv, C_BCP pPort, int AddressFamily, UI MaxClients, HWND hWndNtc, UI WndMsgNtc);
AJCEXPORT	BOOL			WINAPI	AjcSsvStartW(HAJCSSV hSsv, C_WCP pPort, int AddressFamily, UI MaxClients, HWND hWndNtc, UI WndMsgNtc);
AJCEXPORT	BOOL			WINAPI	AjcSsvStop			 (HAJCSSV hSsv, UI msTimeout);

AJCEXPORT	BOOL			 WINAPI	AjcSsvSetChunkMode	 (HAJCSSV hSsv, AJCSSV_CHUNKMODE ChunkMode);
AJCEXPORT	AJCSSV_CHUNKMODE WINAPI	AjcSsvGetChunkMode	 (HAJCSSV hSsv);
AJCEXPORT	BOOL			WINAPI	AjcSsvSetEvtMask	 (HAJCSSV hSsv, UI EvtMsk);
AJCEXPORT	UI		 		WINAPI	AjcSsvGetEvtMask	 (HAJCSSV hSsv);
AJCEXPORT	BOOL			WINAPI	AjcSsvSetRxTextCode	 (HAJCSSV hSsv, AJCSSV_TEXTCODE code);
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetRxTextCode	 (HAJCSSV hSsv);
AJCEXPORT	BOOL			WINAPI	AjcSsvSetTxTextCode	 (HAJCSSV hSsv, AJCSSV_TEXTCODE code);
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetTxTextCode	 (HAJCSSV hSsv);
AJCEXPORT	BOOL			WINAPI	AjcSsvWaitEvent		 (HAJCSSV hSsv, WPARAM *pwParam, LPARAM *plParam, UI msTime);
AJCEXPORT	BOOL			WINAPI	AjcSsvGetEventData	 (HAJCSSV hSsv, LPARAM lParam, VOP *ppDat, UIP plDat, UIP pParam);
AJCEXPORT	UI				WINAPI	AjcSsvGetClient		 (HAJCSSV hSsv, LPARAM lParam, HAJCSSVCLI *hClient);
AJCEXPORT	BOOL			WINAPI	AjcSsvRelEventData	 (HAJCSSV hSsv, LPARAM lParam);
AJCEXPORT	BOOL			WINAPI	AjcSsvSetPktCtrlCode (HAJCSSV hSsv, UI stx, UI etx, UI dle);
AJCEXPORT	BOOL			WINAPI	AjcSsvGetPktCtrlCode (HAJCSSV hSsv, UIP pStx, UIP pEtx, UIP pDle);
AJCEXPORT	BOOL			WINAPI	AjcSsvSetPktTimeout	 (HAJCSSV hSsv, UI msTime);
AJCEXPORT	BOOL			WINAPI	AjcSsvGetPktTimeout	 (HAJCSSV hSsv, UIP pMsTime);
AJCEXPORT	BOOL			WINAPI	AjcSsvIsStarted		 (HAJCSSV pW);
AJCEXPORT	UI				WINAPI	AjcSsvGetClientCount (HAJCSSV hSsv);
AJCEXPORT	UI				WINAPI	AjcSsvGetConnectCount(HAJCSSV hSsv);
AJCEXPORT	UI				WINAPI	AjcSsvEnumClients	 (HAJCSSV hSsv, UX cbp, BOOL (CALLBACK *cbNtcClients)(HAJCSSVCLI hClient, UX cbp));



AJCEXPORT	BOOL			WINAPI	AjcSsvDisconnect	(HAJCSSVCLI hClient);

AJCEXPORT	BOOL			WINAPI	AjcSsvSendCharA		(HAJCSSVCLI hClient, BC code);
AJCEXPORT	BOOL			WINAPI	AjcSsvSendCharW		(HAJCSSVCLI hClient, WC code);

AJCEXPORT	BOOL			WINAPI	AjcSsvSendTextA		(HAJCSSVCLI hClient, C_BCP pTxt, UI lTxt);
AJCEXPORT	BOOL			WINAPI	AjcSsvSendTextW		(HAJCSSVCLI hClient, C_WCP pTxt, UI lTxt);

AJCEXPORT	BOOL			WINAPI	AjcSsvSendTextFA	(HAJCSSVCLI hClient, C_BCP pFmt, ...);
AJCEXPORT	BOOL			WINAPI	AjcSsvSendTextFW	(HAJCSSVCLI hClient, C_WCP pFmt, ...);

AJCEXPORT	BOOL			WINAPI	AjcSsvSendBinData	(HAJCSSVCLI hClient, C_VOP pDat, UI lDat);
AJCEXPORT	UI				WINAPI	AjcSsvSendPacket	(HAJCSSVCLI hClient, C_VOP pPkt, UI lPkt);

AJCEXPORT	BOOL			WINAPI	AjcSsvPurgeRecvData	(HAJCSSVCLI hClient);
AJCEXPORT	BOOL			WINAPI	AjcSsvPurgeSendData	(HAJCSSVCLI hClient);
AJCEXPORT	BOOL			WINAPI	AjcSsvPurgeAllData	(HAJCSSVCLI hClient);

AJCEXPORT	BOOL			WINAPI	AjcSsvSetClientData	(HAJCSSVCLI hClient, UX   data);
AJCEXPORT	BOOL			WINAPI	AjcSsvGetClientData	(HAJCSSVCLI hClient, UXP pData);

AJCEXPORT	UI				WINAPI	AjcSsvGetSeqNo		(HAJCSSVCLI hClient);
AJCEXPORT	UI				WINAPI	AjcSsvGetIndex		(HAJCSSVCLI hClient);

AJCEXPORT	C_BCP			WINAPI	AjcSsvGetIpAddrStrA	(HAJCSSVCLI hClient, BCP pBuf, UI lBuf);
AJCEXPORT	C_WCP			WINAPI	AjcSsvGetIpAddrStrW	(HAJCSSVCLI hClient, WCP pBuf, UI lBuf);

AJCEXPORT	UI				WINAPI	AjcSsvGetThreadId	(HAJCSSVCLI hClient);
AJCEXPORT	SOCKET			WINAPI	AjcSsvGetSocket		(HAJCSSVCLI hClient);

AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetActualRxTextCode(HAJCSSVCLI hClient);
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetActualTxTextCode(HAJCSSVCLI hClient);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- コントロールウインド生成 -------------------------------------------------------------------------------//
AJCEXPORT HAJCSSV WINAPI AjcSsvCreateForMSIL(	VO	 (CALLBACK *cbRxText		)(HAJCSSVCLI hClient, C_WCP text),
												VO	 (CALLBACK *cbRxEsc			)(HAJCSSVCLI hClient, C_WCP text),
												VO	 (CALLBACK *cbRxCtrl		)(HAJCSSVCLI hClient, int	ctrl),
												VO	 (CALLBACK *cbRxPacket		)(HAJCSSVCLI hClient, C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxNoPkt		)(HAJCSSVCLI hClient, C_WCP text),
												VO	 (CALLBACK *cbTxEmpty		)(HAJCSSVCLI hClient),
												VO	 (CALLBACK *cbRxChunkTxt	)(HAJCSSVCLI hClient, C_WCP text),
												VO	 (CALLBACK *cbRxChunkBin	)(HAJCSSVCLI hClient, C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxInvChunk	)(HAJCSSVCLI hClient, C_VOP pData, int lData),
												VO	 (CALLBACK *cbConnect		)(HAJCSSVCLI hClient),
												VO	 (CALLBACK *cbDisconnect	)(HAJCSSVCLI hClient),
												VO	 (CALLBACK *cbRecvError		)(HAJCSSVCLI hClient, BOOL fOverlapped),
												VO	 (CALLBACK *cbSendError		)(HAJCSSVCLI hClient, BOOL fOverlapped),
												VO	 (CALLBACK *cbStart			)(VO),
												VO	 (CALLBACK *cbStop			)(VO),
												VO	 (CALLBACK *cbGeneralError	)(UI ErrCode),
												BOOL (CALLBACK *cbEnumClients	)(HAJCSSVCLI pC, UX cbp));
//----- サーバ開始 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcSsvStartForMSIL(HAJCSSV hSsv, C_WCP pPort, int AddressFamily, UI MaxClients, BOOL fOnEvent);
//----- クライアント列挙 ---------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcSsvEnumClientsForMSIL(HAJCSSV hSsv, UX cbp);
//----- 終了処理 -----------------------------------------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcSsvDeleteForMSIL(HAJCSSV hSsv);



/****************************************************************************************************************/
#endif
