﻿#ifndef	AJCSTRING_H_
#define	AJCSTRING_H_
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	マルチバイト文字コード種別																					//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCMBC_SJIS		= 1	,
	AJCMBC_EUC		= 2	,
	AJCMBC_UTF8		= 3	,
} AJCMBCKIND;

//--------------------------------------------------------------------------------------------------------------//
//	マルチバイト文字コードチェック・インスタンス																//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCMIN_MBCBUF		16
#define		AJCMAX_MBCBUF		1024
typedef struct {
	AJCMBCKIND	MbcDef;							//	デフォルト文字コード
	AJCMBCKIND	MbcKind;						//	判別した文字コード
	UI			BufSize;						//	有効文字バッファサイズ
	UI			MbcIx;							//	バッファインデクス
	BC			MbcBuf[AJCMAX_MBCBUF + 1];		//	マルチバイト文字バッファ
} AJCMBC, *HAJCMBC;
//--------------------------------------------------------------------------------------------------------------//
//	マルチバイト文字情報																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int		len;				//	マルチバイト文字の総バイト数
	int		ix;					//	マルチバイト文字における当該バイトの位置（０～）
} AJCMBCINFO, *PAJCMBCINFO;
typedef const AJCMBCINFO *PCAJCMBCINFO;

//--------------------------------------------------------------------------------------------------------------//
//	AjcStrFind - 部分文字列検索の／オプション，戻り情報															//
//--------------------------------------------------------------------------------------------------------------//
//	オプション
#define	AJCSFO_HIGHPOS	0x01	//	複数の文字列が見つかった場合は、高位アドレスの文字列を選択する
#define	AJCSFO_SHORT	0x02	//	同じ位置で複数の文字列が見つかった場合は、短い方の文字列を選択する

//	戻り情報
typedef struct {
	int		ix;					//	見つかった文字列のインデクス（０～，何番目の文字列が見つかったかを示す）
	int		pos;				//	見つかった文字列の先頭桁位置（０～）
	int		len;				//	見つかった文字列の長さ
} AJCSTRFIND, *PAJCSTRFIND;
typedef const AJCSTRFIND *PCAJCSTRFIND;

//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcStrCmpEx				AjcStrCmpExW
	#define	AjcStrStrEx				AjcStrStrExW
	#define	AjcStrIStr 				AjcStrIStrW
	#define	AjcMbsStrEx				AjcMbsStrExW
	#define	AjcMbsIStr 				AjcMbsIStrW
	#define	AjcStrFind				AjcStrFindW
	#define	AjcStrIFind				AjcStrIFindW
	#define	AjcStrFindEx			AjcStrFindExW
	#define	AjcStrIFindEx			AjcStrIFindExW
	#define	AjcStrTok				AjcStrTokW
	#define	AjcStrTokS				AjcStrTokSW
	#define	AjcMbsTok				AjcMbsTokW
	#define	AjcMbsTokS				AjcMbsTokSW
	#define	AjcStrTokEx				AjcStrTokExW
	#define	AjcStrTokSEx			AjcStrTokSExW
	#define	AjcStrTokREx			AjcStrTokRExW
	#define	AjcStrEnclose			AjcStrEncloseW
	#define	AjcStrStripEnclose		AjcStrStripEncloseW
	#define	AjcSnPrintF				AjcSnPrintFW
	#define	AjcVSnPrintF			AjcVSnPrintFW
	#define	AjcSnPrtSep				AjcSnPrtSepW
	#define	AjcStrSepDecimal		AjcStrSepDecimalW
	#define	AjcStrAnySepDecimal		AjcStrAnySepDecimalW
	#define	AjcStrRmvSepChar		AjcStrRmvSepCharW
	#define	AjcStrAnyRmvSepChar		AjcStrAnyRmvSepCharW
	#define	AjcMStrMakeArray		AjcMStrMakeArrayW
	#define	AjcMStrCount			AjcMStrCountW
	#define	AjcMStrTotalSize		AjcMStrTotalSizeW
	#define	AjcMStrNextPtr			AjcMStrNextPtrW
	#define	AjcRepPartStr			AjcRepPartStrW
	#define	AjcStrCpy				AjcStrCpyW
	#define	AjcStrNCpy				AjcStrNCpyW
	#define	AjcStrCat				AjcStrCatW
	#define	AjcStrLTrim				AjcStrLTrimW
	#define	AjcStrRTrim				AjcStrRTrimW
	#define	AjcStrTrim				AjcStrTrimW
	#define	AjcStrLTrimEx			AjcStrLTrimExW
	#define	AjcStrRTrimEx			AjcStrRTrimExW
	#define	AjcStrTrimEx			AjcStrTrimExW
	#define	AjcStrShaping			AjcStrShapingW
	#define	AjcStrAdjustLen			AjcStrAdjustLenW
	#define	AjcRemoveEscInStr		AjcRemoveEscInStrW
	#define	AjcStrCnvRevPath		AjcStrCnvRevPathW
	#define	AjcStrRetRevPath		AjcStrRetRevPathW
	#define	AjcStrSameAsAllChar		AjcStrSameAsAllCharW
	#define	AjcDecToUI				AjcDecToUIW
	#define	AjcDecToULL				AjcDecToULLW
	#define	AjcHexToUI				AjcHexToUIW
	#define	AjcHexToULL				AjcHexToULLW
	#define	AjcOctToUI				AjcOctToUIW
	#define	AjcOctToULL				AjcOctToULLW
	#define	AjcAscToInt				AjcAscToIntW
	#define	AjcAscToLInt			AjcAscToLIntW
	#define	AjcAscToReal			AjcAscToRealW
	#define	AjcGetSepNumbers		AjcGetSepNumbersW
	#define	AjcGetAfterPrefix		AjcGetAfterPrefixW
	#define	AjcHexStrToUB			AjcHexStrToUBW
	#define	AjcHexStrToUW			AjcHexStrToUWW
	#define	AjcHexStrToUI			AjcHexStrToUIW
	#define	AjcHexStrToULL			AjcHexStrToULLW
	#define	AjcExtractCompletedText	AjcExtractCompletedTextW
	#define	AjcCLangStrToBin		AjcCLangStrToBinW
	#define	AjcBinToCLangStr		AjcBinToCLangStrW
	#define	AjcTextLen				AjcTextLenW
	#define	AjcIsBigChar			AjcIsBigCharW
	#define	AjcTextToCodePoint		AjcTextToCodePointW
	#define	AjcCodePointToText		AjcCodePointToTextW
	#define	AjcLogFontToText		AjcLogFontToTextW
	#define	AjcTextToLogFont		AjcTextToLogFontW
#else
	#define	AjcStrCmpEx				AjcStrCmpExA
	#define	AjcStrStrEx				AjcStrStrExA
	#define	AjcStrIStr 				AjcStrIStrA
	#define	AjcMbsStrEx				AjcMbsStrExA
	#define	AjcMbsIStr 				AjcMbsIStrA
	#define	AjcStrFind				AjcStrFindA
	#define	AjcStrIFind				AjcStrIFindA
	#define	AjcStrFindEx			AjcStrFindExA
	#define	AjcStrIFindEx			AjcStrIFindExA
	#define	AjcStrTok				AjcStrTokA
	#define	AjcStrTokS				AjcStrTokSA
	#define	AjcMbsTok				AjcMbsTokA
	#define	AjcMbsTokS				AjcMbsTokSA
	#define	AjcStrTokEx				AjcStrTokExA
	#define	AjcStrTokSEx			AjcStrTokSExA
	#define	AjcStrTokREx			AjcStrTokRExA
	#define	AjcStrEnclose			AjcStrEncloseA
	#define	AjcStrStripEnclose		AjcStrStripEncloseA
	#define	AjcSnPrintF				AjcSnPrintFA
	#define	AjcVSnPrintF			AjcVSnPrintFA
	#define	AjcSnPrtSep				AjcSnPrtSepA
	#define	AjcStrSepDecimal		AjcStrSepDecimalA
	#define	AjcStrAnySepDecimal		AjcStrAnySepDecimalA
	#define	AjcStrRmvSepChar		AjcStrRmvSepCharA
	#define	AjcStrAnyRmvSepChar		AjcStrAnyRmvSepCharA
	#define	AjcMStrMakeArray		AjcMStrMakeArrayA
	#define	AjcMStrCount			AjcMStrCountA
	#define	AjcMStrTotalSize		AjcMStrTotalSizeA
	#define	AjcMStrNextPtr			AjcMStrNextPtrA
	#define	AjcRepPartStr			AjcRepPartStrA
	#define	AjcStrCpy				AjcStrCpyA
	#define	AjcStrNCpy				AjcStrNCpyA
	#define	AjcStrCat				AjcStrCatA
	#define	AjcStrLTrim				AjcStrLTrimA
	#define	AjcStrRTrim				AjcStrRTrimA
	#define	AjcStrTrim				AjcStrTrimA
	#define	AjcStrLTrimEx			AjcStrLTrimExA
	#define	AjcStrRTrimEx			AjcStrRTrimExA
	#define	AjcStrTrimEx			AjcStrTrimExA
	#define	AjcStrShaping			AjcStrShapingA
	#define	AjcStrAdjustLen			AjcStrAdjustLenA
	#define	AjcRemoveEscInStr		AjcRemoveEscInStrA
	#define	AjcStrCnvRevPath		AjcStrCnvRevPathA
	#define	AjcStrRetRevPath		AjcStrRetRevPathA
	#define	AjcStrSameAsAllChar		AjcStrSameAsAllCharA
	#define	AjcDecToUI				AjcDecToUIA
	#define	AjcDecToULL				AjcDecToULLA
	#define	AjcHexToUI				AjcHexToUIA
	#define	AjcHexToULL				AjcHexToULLA
	#define	AjcOctToUI				AjcOctToUIA
	#define	AjcOctToULL				AjcOctToULLA
	#define	AjcAscToInt				AjcAscToIntA
	#define	AjcAscToLInt			AjcAscToLIntA
	#define	AjcAscToReal			AjcAscToRealA
	#define	AjcGetSepNumbers		AjcGetSepNumbersA
	#define	AjcGetAfterPrefix		AjcGetAfterPrefixA
	#define	AjcHexStrToUB			AjcHexStrToUBA
	#define	AjcHexStrToUW			AjcHexStrToUWA
	#define	AjcHexStrToUI			AjcHexStrToUIA
	#define	AjcHexStrToULL			AjcHexStrToULLA
	#define	AjcExtractCompletedText	AjcExtractCompletedTextA
	#define	AjcCLangStrToBin		AjcCLangStrToBinA
	#define	AjcBinToCLangStr		AjcBinToCLangStrA
	#define	AjcTextLen				AjcTextLenA
	#define	AjcIsBigChar			AjcIsBigCharA
	#define	AjcTextToCodePoint		AjcTextToCodePointA
	#define	AjcCodePointToText		AjcCodePointToTextA
	#define	AjcLogFontToText		AjcLogFontToTextA
	#define	AjcTextToLogFont		AjcTextToLogFontA
#endif


//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcStrCmpExA(C_BCP pStr1, C_BCP pStr2, EAJCCMPMODE CmpMode);
AJCEXPORT	int		WINAPI	AjcStrCmpExW(C_WCP pStr1, C_WCP pStr2, EAJCCMPMODE CmpMode);


AJCEXPORT	BCP		WINAPI	AjcStrStrExA(C_BCP pStr, C_BCP pPart, BOOL fIgnoreWidth);
AJCEXPORT	WCP		WINAPI	AjcStrStrExW(C_WCP pStr, C_WCP pPart, BOOL fIgnoreWidth);

AJCEXPORT	BCP		WINAPI	AjcStrIStrA(C_BCP pStr, C_BCP pPart);
AJCEXPORT	WCP		WINAPI	AjcStrIStrW(C_WCP pStr, C_WCP pPart);

AJCEXPORT	BCP		WINAPI	AjcMbsStrExA(C_BCP pStr, C_BCP pPart, BOOL fIgnoreWidth);
AJCEXPORT	WCP		WINAPI	AjcMbsStrExW(C_WCP pStr, C_WCP pPart, BOOL fIgnoreWidth);

AJCEXPORT	BCP		WINAPI	AjcMbsIStrA(C_BCP pStr, C_BCP pPart);
AJCEXPORT	WCP		WINAPI	AjcMbsIStrW(C_WCP pStr, C_WCP pPart);

AJCEXPORT	int		WINAPI	AjcStrFindA(C_BCP pSrc, C_BCP pStr, PAJCSTRFIND pInfo);
AJCEXPORT	int		WINAPI	AjcStrFindW(C_WCP pSrc, C_WCP pStr, PAJCSTRFIND pInfo);

AJCEXPORT	int		WINAPI	AjcStrIFindA(C_BCP pSrc, C_BCP pStr, PAJCSTRFIND pInfo);
AJCEXPORT	int		WINAPI	AjcStrIFindW(C_WCP pSrc, C_WCP pStr, PAJCSTRFIND pInfo);

AJCEXPORT	int		WINAPI	AjcStrFindExA(C_BCP pSrc, C_BCP pStr, C_BCP pDlm, C_BCP pAny, C_BCP pEnc, BOOL fTrim, UI opt, PAJCSTRFIND pInfo);
AJCEXPORT	int		WINAPI	AjcStrFindExW(C_WCP pSrc, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, UI opt, PAJCSTRFIND pInfo);

AJCEXPORT	int		WINAPI	AjcStrIFindExA(C_BCP pSrc, C_BCP pStr, C_BCP pDlm, C_BCP pAny, C_BCP pEnc, BOOL fTrim, UI opt, PAJCSTRFIND pInfo);
AJCEXPORT	int		WINAPI	AjcStrIFindExW(C_WCP pSrc, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, UI opt, PAJCSTRFIND pInfo);

AJCEXPORT	BCP		WINAPI	AjcStrTokA(BCP pStr, C_BCP pDlm);
AJCEXPORT	WCP		WINAPI	AjcStrTokW(WCP pStr, C_WCP pDlm);

AJCEXPORT	BCP		WINAPI	AjcStrTokSA(BCP pStr, C_BCP pDlm, BCP *ppContext);
AJCEXPORT	WCP		WINAPI	AjcStrTokSW(WCP pStr, C_WCP pDlm, WCP *ppContext);

AJCEXPORT	BCP		WINAPI	AjcMbsTokA(BCP pMbc, C_BCP pDlm);
AJCEXPORT	WCP		WINAPI	AjcMbsTokW(WCP pMbc, C_WCP pDlm);

AJCEXPORT	BCP		WINAPI	AjcMbsTokSA(BCP pMbc, C_BCP pDlm, BCP *ppContext);
AJCEXPORT	WCP		WINAPI	AjcMbsTokSW(WCP pMbc, C_WCP pDlm, WCP *ppContext);

AJCEXPORT	BCP		WINAPI	AjcStrTokExA(BCP pSTr, C_BCP pDlm, C_BCP pEnc);
AJCEXPORT	WCP		WINAPI	AjcStrTokExW(WCP pSTr, C_WCP pDlm, C_WCP pEnc);

AJCEXPORT	BCP		WINAPI	AjcStrTokSExA(BCP pSTr, C_BCP pDlm, C_BCP pEnc, BCP *ppContext);
AJCEXPORT	WCP		WINAPI	AjcStrTokSExW(WCP pSTr, C_WCP pDlm, C_WCP pEnc, WCP *ppContext);

AJCEXPORT	BCP		WINAPI	AjcStrTokRExA(BCP pSTr, C_BCP pDlm, C_BCP pEnc, BCP *ppContext);
AJCEXPORT	WCP		WINAPI	AjcStrTokRExW(WCP pSTr, C_WCP pDlm, C_WCP pEnc, WCP *ppContext);

AJCEXPORT	UI		WINAPI	AjcStrEncloseA(C_BCP pTop, BCP pBuf, UI lBuf, UI c);
AJCEXPORT	UI		WINAPI	AjcStrEncloseW(C_WCP pTop, WCP pBuf, UI lBuf, UI c);

AJCEXPORT	BCP		WINAPI	AjcStrStripEncloseA(BCP pStr);
AJCEXPORT	WCP		WINAPI	AjcStrStripEncloseW(WCP pStr);

AJCEXPORT	BOOL	WINAPI	AjcSnPrintFA(BCP pBuf, UI lBuf, C_BCP pFmt, ...);
AJCEXPORT	BOOL	WINAPI	AjcSnPrintFW(WCP pBuf, UI lBuf, C_WCP pFmt, ...);

AJCEXPORT	BOOL	WINAPI	AjcVSnPrintFA(BCP pBuf, UI lBuf, C_BCP pFmt, va_list vls);
AJCEXPORT	BOOL	WINAPI	AjcVSnPrintFW(WCP pBuf, UI lBuf, C_WCP pFmt, va_list vls);

AJCEXPORT	BOOL	WINAPI	AjcSnPrtSepA(BCP pBuf, UI lBuf, C_BCP pFmt, ...);
AJCEXPORT	BOOL	WINAPI	AjcSnPrtSepW(WCP pBuf, UI lBuf, C_WCP pFmt, ...);

AJCEXPORT	BOOL	WINAPI	AjcStrSepDecimalA(BCP pStr, UI lBuf);
AJCEXPORT	BOOL	WINAPI	AjcStrSepDecimalW(WCP pStr, UI lBuf);

AJCEXPORT	BOOL	WINAPI	AjcStrAnySepDecimalA(BCP pStr, UI lBuf, UI cSep, UI nSep);
AJCEXPORT	BOOL	WINAPI	AjcStrAnySepDecimalW(WCP pStr, UI lBuf, UI cSep, UI nSep);

AJCEXPORT	VO		WINAPI	AjcStrRmvSepCharA(BCP pStr);
AJCEXPORT	VO		WINAPI	AjcStrRmvSepCharW(WCP pStr);

AJCEXPORT	VO		WINAPI	AjcStrAnyRmvSepCharA(BCP pStr, UI cSep);
AJCEXPORT	VO		WINAPI	AjcStrAnyRmvSepCharW(WCP pStr, UI cSep);

AJCEXPORT	BCP	*	WINAPI	AjcMStrMakeArrayA(BCP pStr, UIP pnArr);
AJCEXPORT	WCP	*	WINAPI	AjcMStrMakeArrayW(WCP pStr, UIP pnArr);

AJCEXPORT	VO		WINAPI	AjcMStrReleaseArray(VOP pArr);

AJCEXPORT	UI		WINAPI	AjcMStrCountA(C_BCP pStr);
AJCEXPORT	UI		WINAPI	AjcMStrCountW(C_WCP pStr);

AJCEXPORT	UI		WINAPI	AjcMStrTotalSizeA(C_BCP pStr);
AJCEXPORT	UI		WINAPI	AjcMStrTotalSizeW(C_WCP pStr);

AJCEXPORT	BCP		WINAPI	AjcMStrNextPtrA(BCP pStr);
AJCEXPORT	WCP		WINAPI	AjcMStrNextPtrW(WCP pStr);

AJCEXPORT	BCP		WINAPI	AjcRepPartStrA(BCP pStr1, UI lBuf, UI loc, UI len, C_BCP pStr2, UI lStr2);
AJCEXPORT	WCP		WINAPI	AjcRepPartStrW(WCP pStr1, UI lBuf, UI loc, UI len, C_WCP pStr2, UI lStr2);

AJCEXPORT	BCP		WINAPI	AjcStrCatA(BCP pStr1, UI lBuf, C_BCP pStr2);
AJCEXPORT	WCP		WINAPI	AjcStrCatW(WCP pStr1, UI lBuf, C_WCP pStr2);

AJCEXPORT	BCP		WINAPI	AjcStrCpyA(BCP pBuf, UI lBuf, C_BCP pStr);
AJCEXPORT	WCP		WINAPI	AjcStrCpyW(WCP pBuf, UI lBuf, C_WCP pStr);

AJCEXPORT	BCP		WINAPI	AjcStrNCpyA(BCP pBuf, UI lBuf, C_BCP pStr, UI n);
AJCEXPORT	WCP		WINAPI	AjcStrNCpyW(WCP pBuf, UI lBuf, C_WCP pStr, UI n);

AJCEXPORT	BCP		WINAPI	AjcStrCatA(BCP pStr1, UI lBuf, C_BCP pStr2);
AJCEXPORT	WCP		WINAPI	AjcStrCatW(WCP pStr1, UI lBuf, C_WCP pStr2);

AJCEXPORT	BCP		WINAPI	AjcStrLTrimA(BCP pStr, BCP pBuf, UI lBuf);
AJCEXPORT	WCP		WINAPI	AjcStrLTrimW(WCP pStr, WCP pBuf, UI lBuf);

AJCEXPORT	BCP		WINAPI	AjcStrRTrimA(BCP pStr, BCP pBuf, UI lBuf);
AJCEXPORT	WCP		WINAPI	AjcStrRTrimW(WCP pStr, WCP pBuf, UI lBuf);

AJCEXPORT	BCP		WINAPI	AjcStrTrimA (BCP pStr, BCP pBuf, UI lBuf);
AJCEXPORT	WCP		WINAPI	AjcStrTrimW (WCP pStr, WCP pBuf, UI lBuf);

AJCEXPORT	BCP		WINAPI	AjcStrLTrimExA(BCP pStr, BCP pBuf, UI lBuf, C_BCP pChars);
AJCEXPORT	WCP		WINAPI	AjcStrLTrimExW(WCP pStr, WCP pBuf, UI lBuf, C_WCP pChars);

AJCEXPORT	BCP		WINAPI	AjcStrRTrimExA(BCP pStr, BCP pBuf, UI lBuf, C_BCP pChars);
AJCEXPORT	WCP		WINAPI	AjcStrRTrimExW(WCP pStr, WCP pBuf, UI lBuf, C_WCP pChars);

AJCEXPORT	BCP		WINAPI	AjcStrTrimExA (BCP pStr, BCP pBuf, UI lBuf, C_BCP pChars);
AJCEXPORT	WCP		WINAPI	AjcStrTrimExW (WCP pStr, WCP pBuf, UI lBuf, C_WCP pChars);

AJCEXPORT	BCP		WINAPI	AjcStrShapingA(BCP pStr, BCP pBuf, UI lBuf, C_BCP pChars, C_BCP pRepStr);
AJCEXPORT	WCP		WINAPI	AjcStrShapingW(WCP pStr, WCP pBuf, UI lBuf, C_WCP pChars, C_WCP pRepStr);

AJCEXPORT	BCP		WINAPI	AjcRemoveEscInStrA(C_BCP pStr, BCP pBuf, UI lBuf);
AJCEXPORT	WCP		WINAPI	AjcRemoveEscInStrW(C_WCP pStr, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI	AjcStrChkMbcPart (C_BCP pTop, UI ix, PAJCMBCINFO pBuf);
AJCEXPORT	BOOL	WINAPI	AjcStrChkEucPart (C_BCP pTop, UI ix, PAJCMBCINFO pBuf);
AJCEXPORT	BOOL	WINAPI	AjcStrChkUtf8Part(C_BCP pTop, UI ix, PAJCMBCINFO pBuf);

AJCEXPORT	int		WINAPI	AjcUtf8ToMbc(C_BCP pUtf8, BCP pMbc , UI lMbc );
AJCEXPORT	int		WINAPI	AjcMbcToUtf8(C_BCP pMbc , BCP pUtf8, UI lUtf8);

AJCEXPORT	int		WINAPI	AjcEucToSJis(C_BCP pEuc , BCP pSJis, UI lSJis);
AJCEXPORT	int		WINAPI	AjcSJisToEuc(C_BCP pSJis, BCP pEuc , UI lEuc );

AJCEXPORT	int		WINAPI	AjcUtf8ToMbcEx(C_BCP pUtf8, UI lUtf8, BCP pMbc , UI lMbc);
AJCEXPORT	int		WINAPI	AjcMbcToUtf8Ex(C_BCP pMbc , UI lMbc , BCP pUtf8, UI lUtf8);

AJCEXPORT	int		WINAPI	AjcEucToSJisEx(C_BCP pEuc , UI lEuc , BCP pSJis, UI lSJis);
AJCEXPORT	int		WINAPI	AjcSJisToEucEx(C_BCP pSJis, UI lSJis, BCP pEuc , UI lEuc );

AJCEXPORT	AJCMBCKIND	WINAPI	AjcStrChkCode(C_BCP pStr);
AJCEXPORT	EAJCTEC		WINAPI	AjcStrChkCodeEx(C_BCP pStr, UI lStr);
AJCEXPORT	int			WINAPI	AjcStrIsJis (C_BCP pStr);

AJCEXPORT	int			WINAPI	AjcStrIsSJis(C_BCP pStr);
AJCEXPORT	int			WINAPI	AjcStrIsEuc (C_BCP pStr);
AJCEXPORT	int			WINAPI	AjcStrIsUtf8(C_BCP pStr);

AJCEXPORT	int			WINAPI	AjcStrIsSJisEx(C_BCP pStr, UI lStr);
AJCEXPORT	int			WINAPI	AjcStrIsEucEx (C_BCP pStr, UI lStr);
AJCEXPORT	int			WINAPI	AjcStrIsUtf8Ex(C_BCP pStr, UI lStr);

AJCEXPORT	UI			WINAPI	AjcStrChkMbcLen	 (C_BCP pTop, UI len);
AJCEXPORT	UI			WINAPI	AjcStrChkUtf8Len (C_BCP pTop, UI len);
AJCEXPORT	UI			WINAPI	AjcStrChkEucLen	 (C_BCP pTop, UI len);
AJCEXPORT	UI			WINAPI	AjcStrChkU16LeLen(C_WCP pTop, UI len);
AJCEXPORT	UI			WINAPI	AjcStrChkU16BeLen(C_WCP pTop, UI len);

AJCEXPORT	UI			WINAPI	AjcStrAdjustLenA(C_BCP pTxt, UI len);
AJCEXPORT	UI			WINAPI	AjcStrAdjustLenW(C_WCP pTxt, UI len);

AJCEXPORT	HAJCMBC		WINAPI	AjcMbcCreate (UI BufSize, AJCMBCKIND DefCode);
AJCEXPORT	BOOL		WINAPI	AjcMbcReset  (HAJCMBC hMbc);
AJCEXPORT	BOOL		WINAPI	AjcMbcPutData(HAJCMBC hMbc, C_BCP pStr);
AJCEXPORT	AJCMBCKIND	WINAPI	AjcMbcCheck  (HAJCMBC hMbc);
AJCEXPORT	VO			WINAPI	AjcMbcDelete (HAJCMBC hMbc);


AJCEXPORT	BOOL		WINAPI	AjcStrCnvRevPathA(BCP pPath, BCP pBuf, int lBuf);
AJCEXPORT	BOOL		WINAPI	AjcStrCnvRevPathW(WCP pPath, WCP pBuf, int lBuf);

AJCEXPORT	BOOL		WINAPI	AjcStrRetRevPathA(BCP pRev, BCP pBuf, int lBuf);
AJCEXPORT	BOOL		WINAPI	AjcStrRetRevPathW(WCP pRev, WCP pBuf, int lBuf);

AJCEXPORT	BOOL		WINAPI	AjcStrSameAsAllCharA(C_BCP pStr, BC c);
AJCEXPORT	BOOL		WINAPI	AjcStrSameAsAllCharW(C_WCP pStr, WC c);

AJCEXPORT	UI		WINAPI	AjcDecToUIA(C_BCP pStr);
AJCEXPORT	UI		WINAPI	AjcDecToUIW(C_WCP pStr);

AJCEXPORT	ULL		WINAPI	AjcDecToULLA(C_BCP pStr);
AJCEXPORT	ULL		WINAPI	AjcDecToULLW(C_WCP pStr);

AJCEXPORT	UI		WINAPI	AjcHexToUIA(C_BCP pStr);
AJCEXPORT	UI		WINAPI	AjcHexToUIW(C_WCP pStr);

AJCEXPORT	ULL		WINAPI	AjcHexToULLA(C_BCP pStr);
AJCEXPORT	ULL		WINAPI	AjcHexToULLW(C_WCP pStr);

AJCEXPORT	UI		WINAPI	AjcOctToUIA(C_BCP pStr);
AJCEXPORT	UI		WINAPI	AjcOctToUIW(C_WCP pStr);

AJCEXPORT	ULL		WINAPI	AjcOctToULLA(C_BCP pStr);
AJCEXPORT	ULL		WINAPI	AjcOctToULLW(C_WCP pStr);

AJCEXPORT	SI		WINAPI	AjcAscToIntA (C_BCP pStr);
AJCEXPORT	SI		WINAPI	AjcAscToIntW (C_WCP pStr);

AJCEXPORT	SLL		WINAPI	AjcAscToLIntA(C_BCP pStr);
AJCEXPORT	SLL		WINAPI	AjcAscToLIntW(C_WCP pStr);

AJCEXPORT	double	WINAPI	AjcAscToRealA(C_BCP pStr);
AJCEXPORT	double	WINAPI	AjcAscToRealW(C_WCP pStr);

AJCEXPORT	UI		WINAPI	AjcGetSepNumbersA(C_BCP pStr, BC sep, C_BCP pTyp, ...);
AJCEXPORT	UI		WINAPI	AjcGetSepNumbersW(C_WCP pStr, WC sep, C_WCP pTyp, ...);

AJCEXPORT	BOOL	WINAPI	AjcGetAfterPrefixA(C_BCP pParam, C_BCP pPrefix, UIP pVal, BCP pBuf, UI lBuf);
AJCEXPORT	BOOL	WINAPI	AjcGetAfterPrefixW(C_WCP pParam, C_WCP pPrefix, UIP pVal, WCP pBuf, UI lBuf);


AJCEXPORT	BOOL	WINAPI	AjcHexStrToUBA (C_BCP pStr, UI lStr, UB  *pVal);
AJCEXPORT	BOOL	WINAPI	AjcHexStrToUBW (C_WCP pStr, UI lStr, UB  *pVal);

AJCEXPORT	BOOL	WINAPI	AjcHexStrToUWA (C_BCP pStr, UI lStr, UW  *pVal);
AJCEXPORT	BOOL	WINAPI	AjcHexStrToUWW (C_WCP pStr, UI lStr, UW  *pVal);

AJCEXPORT	BOOL	WINAPI	AjcHexStrToUIA (C_BCP pStr, UI lStr, UI  *pVal);
AJCEXPORT	BOOL	WINAPI	AjcHexStrToUIW (C_WCP pStr, UI lStr, UI  *pVal);

AJCEXPORT	BOOL	WINAPI	AjcHexStrToULLA(C_BCP pStr, UI lStr, ULL *pVal);
AJCEXPORT	BOOL	WINAPI	AjcHexStrToULLW(C_WCP pStr, UI lStr, ULL *pVal);

AJCEXPORT	BCP		WINAPI	AjcExtractCompletedTextA(BCP pBuf, UI lBuf, UIP pIx, AJCMBCKIND mbk);
AJCEXPORT	WCP		WINAPI	AjcExtractCompletedTextW(BCP pBuf, UI lBuf, UIP pIx, AJCMBCKIND mbk);

AJCEXPORT	UI		WINAPI	AjcCLangStrToBinA(C_BCP pTxt, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcCLangStrToBinW(C_WCP pTxt, WCP pBuf, UI lBuf);

AJCEXPORT	UI		WINAPI	AjcBinToCLangStrA(C_BCP pTxt, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcBinToCLangStrW(C_WCP pTxt, WCP pBuf, UI lBuf);

AJCEXPORT	UI		WINAPI	AjcTextLenA(C_BCP pText);
AJCEXPORT	UI		WINAPI	AjcTextLenW(C_WCP pText);

AJCEXPORT	BOOL	WINAPI	AjcIsBigCharA(const BC txt[2]);
AJCEXPORT	BOOL	WINAPI	AjcIsBigCharW(const WC txt[2]);

AJCEXPORT	UI		WINAPI	AjcTextToCodePointA(const BC txt[2]);
AJCEXPORT	UI		WINAPI	AjcTextToCodePointW(const WC txt[2]);

AJCEXPORT	UI		WINAPI	AjcCodePointToTextA(UI cp, BC txt[2]);
AJCEXPORT	UI		WINAPI	AjcCodePointToTextW(UI cp, WC txt[2]);

AJCEXPORT	UI		WINAPI	AjcLogFontToTextA(const LOGFONTA *pLogFont, BCP pTxt, UI lTxt, BOOL fKey);
AJCEXPORT	UI		WINAPI	AjcLogFontToTextW(const LOGFONTW *pLogFont, WCP pTxt, UI lTxt, BOOL fKey);

AJCEXPORT	BOOL	WINAPI	AjcTextToLogFontA(C_BCP pTxt, LPLOGFONTA pLogFont);
AJCEXPORT	BOOL	WINAPI	AjcTextToLogFontW(C_WCP pTxt, LPLOGFONTW pLogFont);

//----- 互換維持のための名称 -----------------------------------------------------------------------------------//
#define		AjcUtf8ToSJis		AjcUtf8ToMbc
#define		AjcSJisToUtf8		AjcMbcToUtf8

#define		AjcUtf8ToSJisEx		AjcUtf8ToMbcEx
#define		AjcSJisToUtf8Ex		AjcMbcToUtf8Ex


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	MAjcVSnPrintF マクロ																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	MAjcVSnPrintF	MAjcVSnPrintFW
#else
	#define	MAjcVSnPrintF	MAjcVSnPrintFA
#endif

#define	MAjcVSnPrintFA(BUF, LEN, FMT) {va_list vls; va_start(vls, FMT); AjcVSnPrintFA(BUF, LEN, FMT, vls); va_end(vls);}
#define	MAjcVSnPrintFW(BUF, LEN, FMT) {va_list vls; va_start(vls, FMT); AjcVSnPrintFW(BUF, LEN, FMT, vls); va_end(vls);}


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	マルチバイト文字列ファンクションのインライン化																//
//																												//
//		※	マルチバイト文字列の引数を「BCP」とすることにより、キャスト（BCP -> UBP）不要とする					//
//		※	関数名は先頭のアンダバー（_）を削除した名称とする													//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	マルチバイト特有のファンクション（マルチバイト文字タイプ取得）
__inline	int		mbsbtype (C_BCP P, size_t L)			{return 	 _mbsbtype	((C_UBP)P, (size_t)L);}				/*	指定バイト位置のマルチバイト種別					*/
__inline	BCP		mbschr	 (C_BCP P , int C)				{return (BCP)_mbschr	((C_UBP)P , (int)C);}				/*	マルチバイト文字有無チェック						*/
__inline	int		mbscmp	 (C_BCP P1, C_BCP P2)			{return 	 _mbscmp	((C_UBP)P1, (C_UBP)P2);}			/*	マルチバイト文字列比較（英大小区別あり）			*/
__inline	int		mbsncmp  (C_BCP P1, C_BCP P2, size_t L)	{return 	 _mbsncmp	((C_UBP)P1, (C_UBP)P2, (size_t)L);}	/*	指定文字数のマルチバイト文字列比較（英大小区別あり）*/
__inline	int		mbsicmp  (C_BCP P1, C_BCP P2)			{return 	 _mbsicmp	((C_UBP)P1, (C_UBP)P2);}			/*	マルチバイト文字列比較（英大小区別なし）			*/
__inline	int		mbsnicmp (C_BCP P1, C_BCP P2, size_t L)	{return 	 _mbsnicmp	((C_UBP)P1, (C_UBP)P2, (size_t)L);}	/*	指定文字数のマルチバイト文字列比較（英大小区別なし）*/
__inline	BCP		mbsstr	 (C_BCP P1, C_BCP P2)			{return (BCP)_mbsstr	((C_UBP)P1, (C_UBP)P2);}			/*	マルチバイト文字列中の文字列検索（英大小区別あり）	*/
__inline	size_t	mbslen	 (C_BCP P)						{return 	 _mbslen	((C_UBP)P);}			 			/*	マルチバイト文字数（全角は１文字として計算）		*/
__inline	BCP		mbsistr  (C_BCP P1, C_BCP P2)			{return (BCP)AjcMbsIStrA(		P1, 	   P2);}			/*	マルチバイト文字列中の文字列検索（英大小区別なし）	*/
__inline	BCP		mbstok	 (	BCP P1, C_BCP P2)			{return (BCP)AjcMbsTokA (		P1, 	   P2);}			/*	マルチバイトトークン分離							*/



//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ワイド文字列ファンクション（標準関数に無い「wcsistr」を追加）												//
//																												//
//--------------------------------------------------------------------------------------------------------------//
__inline	WCP	wcsistr(C_WCP P1, C_WCP P2)	{return AjcStrIStrW(P1, P2);}	/*	ワイド文字列中の文字列検索（英大小区別なし）*/


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	文字列操作マクロ																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	MAjcStrChr			MAjcStrChrW
	#define	MAjcStrCmp			MAjcStrCmpW
	#define	MAjcStrNCmp			MAjcStrNCmpW
	#define	MAjcStrICmp			MAjcStrICmpW
	#define	MAjcStrNICmp		MAjcStrNICmpW
	#define	MAjcStrStr			MAjcStrStrW
	#define	MAjcStrIStr			MAjcStrIStrW
	#define	MAjcStrTok			MAjcStrTokW

	#define	MAjcStrLen			MAjcStrLenW
	#define	MAjcStrCpy			MAjcStrCpyW
	#define	MAjcStrNCpy			MAjcStrNCpyW
	#define	MAjcStrCat			MAjcStrCatW

	#define	MAjcStrBytes		MAjcStrBytesW

	#define	MAjcMbsBType		MAjcMbsBTypeW
	#define	MAjcMbsChr			MAjcMbsChrW
	#define	MAjcMbsCmp			MAjcMbsCmpW
	#define	MAjcMbsNCmp			MAjcMbsNCmpW
	#define	MAjcMbsICmp			MAjcMbsICmpW
	#define	MAjcMbsNICmp		MAjcMbsNICmpW
	#define	MAjcMbsStr			MAjcMbsStrW
	#define	MAjcMbsLen			MAjcMbsLenW
	#define	MAjcMbsIStr			MAjcMbsIStrW
	#define	MAjcMbsTok			MAjcMbsTokW

	#define	MAjcMakePath		MAjcMakePathW
	#define	MAjcSplitPath		MAjcSplitPathW

#else

	#define	MAjcStrChr			MAjcStrChrA
	#define	MAjcStrCmp			MAjcStrCmpA
	#define	MAjcStrNCmp			MAjcStrNCmpA
	#define	MAjcStrICmp			MAjcStrICmpA
	#define	MAjcStrNICmp		MAjcStrNICmpA
	#define	MAjcStrStr			MAjcStrStrA
	#define	MAjcStrIStr			MAjcStrIStrA
	#define	MAjcStrTok			MAjcStrTokA

	#define	MAjcStrLen			MAjcStrLenA
	#define	MAjcStrCpy			MAjcStrCpyA
	#define	MAjcStrNCpy			MAjcStrNCpyA
	#define	MAjcStrCat			MAjcStrCatA

	#define	MAjcStrBytes		MAjcStrBytesA

	#define	MAjcMbsBType		MAjcMbsBTypeA
	#define	MAjcMbsChr			MAjcMbsChrA
	#define	MAjcMbsCmp			MAjcMbsCmpA
	#define	MAjcMbsNCmp			MAjcMbsNCmpA
	#define	MAjcMbsICmp			MAjcMbsICmpA
	#define	MAjcMbsNICmp		MAjcMbsNICmpA
	#define	MAjcMbsStr			MAjcMbsStrA
	#define	MAjcMbsLen			MAjcMbsLenA
	#define	MAjcMbsIStr			MAjcMbsIStrA
	#define	MAjcMbsTok			MAjcMbsTokA

	#define	MAjcMakePath		MAjcMakePathA
	#define	MAjcSplitPath		MAjcSplitPathA

#endif

//----- バイト文字列操作ファンクション -----------------------------------------------------------------------------------------//
#define	MAjcStrChrA(P, C)			strchr	((P) , (C))					/*	バイト文字有無チェック								*/
#define	MAjcStrCmpA(P1, P2)			strcmp	((P1), (P2))				/*	バイト文字列比較（英大小区別あり）					*/
#define	MAjcStrNCmpA(P1, P2, L)		strncmp ((P1), (P2), (L))			/*	バイト文字列比較（英大小区別あり, バイト数指定	）	*/
#define	MAjcStrICmpA(P1, P2)		_stricmp ((P1), (P2))				/*	バイト文字列比較（英大小区別なし）					*/
#define	MAjcStrNICmpA(P1, P2, L)	_strnicmp((P1), (P2), (L))			/*	バイト文字列比較（英大小区別なし, バイト数指定	）	*/
#define	MAjcStrStrA(P1, P2)			strstr	((P1), (P2))				/*	バイト文字列中の文字列検索（英大小区別あり）		*/
#define	MAjcStrIStrA(P1, P2)		AjcStrIStrA((P1), (P2))				/*	バイト文字列中の文字列検索（英大小区別なし）		*/
#define	MAjcStrTokA(P1, P2)			AjcStrTokA((P1), (P2))				/*	バイトトークン分離									*/

#define	MAjcStrLenA(P)				strlen((P))							/*	バイト文字列のバイト数								*/
#define	MAjcStrCpyA(P1, L, P2)		strncpy_s((P1), (L), (P2), (L)-1)	/*	バイト文字列コピー									*/
#define	MAjcStrNCpyA(P1, L, P2, N)	strncpy_s((P1), (L), (P2), (N))		/*	バイト文字列コピー（指定文字数まで）				*/
#define	MAjcStrCatA(P1, L, P2)		strcat_s ((P1), (L), (P2))			/*	バイト文字列連結									*/

#define	MAjcStrBytesA(P)			(strlen(P) + 1)						/*	バイト文字列のバイト数（終端'\0'を含む）			*/

#define	MAjcMbsBTypeA(P, L)			mbsbtype   ((P),  (L))				/*	指定バイト位置のマルチバイト種別を取得				*/
#define	MAjcMbsChrA(P, C)		 	mbschr	   ((P) , (UI)(C))			/*	マルチバイト文字有無チェック						*/
#define	MAjcMbsCmpA(P1, P2)			mbscmp	   ((P1), (P2))				/*	マルチバイト文字列比較（英大小区別あり）			*/
#define	MAjcMbsNCmpA(P1, P2, L)		mbsncmp    ((P1), (P2), (L))		/*	マルチバイト文字列比較（英大小区別あり, 文字数制限）*/
#define	MAjcMbsICmpA(P1, P2)		mbsicmp    ((P1), (P2))				/*	マルチバイト文字列比較（英大小区別なし）			*/
#define	MAjcMbsNICmpA(P1, P2, L)	mbsnicmp   ((P1), (P2), (L))		/*	マルチバイト文字列比較（英大小区別なし, 文字数制限）*/
#define	MAjcMbsStrA(P1, P2)		 	mbsstr	   ((P1), (P2))				/*	マルチバイト文字列中の文字列検索（英大小区別あり）	*/
#define	MAjcMbsLenA(P)				mbslen	   ((P))					/*	マルチバイト文字列の文字数							*/
#define	MAjcMbsIStrA(P1, P2)	 	AjcMbsIStrA((P1), (P2))				/*	マルチバイト文字列中の文字列検索（英大小区別なし）	*/
#define	MAjcMbsTokA(P1, P2)			AjcMbsTokA ((P1), (P2))				/*	マルチバイトトークン分離							*/

//	splitpath_s, makepath_s のバッファサイズを内部で生成し、splitpath, makepath と同様に扱えるようにする
#define	MAjcMakePathA(PATH, DRV, DIR, FNAME, FEXT)	_makepath_s (PATH, sizeof(PATH), DRV, DIR, FNAME, FEXT)
#define	MAjcSplitPathA(PATH, DRV, DIR, FNAME, FEXT)	_splitpath_s(PATH, DRV,									\
																	   DRV	 == NULL ? 0 : sizeof(DRV	),	\
																	   DIR,									\
																	   DIR	 == NULL ? 0 : sizeof(DIR	),	\
																	   FNAME,								\
																	   FNAME == NULL ? 0 : sizeof(FNAME),	\
																	   FEXT,								\
																	   FEXT  == NULL ? 0 : sizeof(FEXT ))

//----- ワイド文字列操作ファンクション -----------------------------------------------------------------------------------------//
#define	MAjcStrChrW(P, C)			wcschr	   ((P), (UI)(C))			/*	ワイド文字有無チェック								*/
#define	MAjcStrCmpW(P1, P2)			wcscmp	   ((P1), (P2))				/*	ワイド文字列比較（英大小区別あり）					*/
#define	MAjcStrNCmpW(P1, P2, L)		wcsncmp	   ((P1), (P2), (L))		/*	ワイド文字列比較（英大小区別あり，長さ指定）		*/
#define	MAjcStrICmpW(P1, P2)		_wcsicmp	((P1), (P2))			/*	ワイド文字列比較（英大小区別なし）					*/
#define	MAjcStrNICmpW(P1, P2, L)	_wcsnicmp	((P1), (P2), (L))		/*	ワイド文字列比較（英大小区別なし，長さ指定）		*/
#define	MAjcStrStrW(P1, P2)			wcsstr	   ((P1), (P2))				/*	ワイド文字列中の文字列検索（英大小区別あり）		*/
#define	MAjcStrIStrW(P1, P2)		AjcStrIStrW((P1), (P2))				/*	ワイド文字列中の文字列検索（英大小区別なし）		*/
#define	MAjcStrTokW(P1, P2)			AjcStrTokW ((P1), (P2))				/*	ワイド文字列トークン分離							*/

#define	MAjcStrLenW(P)				wcslen ((P))						/*	ワイド文字列のワード数								*/
#define	MAjcStrCpyW(P1, L, P2)		wcsncpy_s((P1), (L), (P2), (L)-1)	/*	ワイド文字列コピー									*/
#define	MAjcStrNCpyW(P1, L, P2, N)	wcsncpy_s((P1), (L), (P2), (N))		/*	ワイド文字列コピー（指定文字数まで）				*/
#define	MAjcStrCatW(P1, L, P2)		wcscat_s ((P1), (L), (P2))			/*	ワイド文字列連結									*/

#define	MAjcStrBytesW(P)			((wcslen(P) + 1) * 2)				/*	ワイド文字列のバイト数（終端'\0'を含む）			*/

#define	MAjcMbsBTypeW(P, L)			(_MBC_SINGLE )						/*	指定バイト位置のマルチバイト種別を取得				*/
#define	MAjcMbsChrW(P, C)			wcschr		((P), (UI)(C))			/*	ワイド文字有無チェック								*/
#define	MAjcMbsCmpW(P1, P2)			wcscmp		((P1), (P2))			/*	ワイド文字列比較（英大小区別あり）					*/
#define	MAjcMbsNCmpW(P1, P2, L)		wcsncmp	((P1), (P2), (L))			/*	ワイド文字列比較（英大小区別あり, 文字数指定）		*/
#define	MAjcMbsICmpW(P1, P2)		_wcsicmp	((P1), (P2))			/*	ワイド文字列比較（英大小区別なし）					*/
#define	MAjcMbsNICmpW(P1, P2, L)	_wcsnicmp	((P1), (P2), (L))		/*	ワイド文字列比較（英大小区別なし, 文字数指定）		*/
#define	MAjcMbsStrW(P1, P2)			wcsstr		((P1), (P2))			/*	ワイド文字列中の文字列検索（英大小区別あり）		*/
#define	MAjcMbsLenW(P)				wcslen ((P))						/*	ワイド文字列の文字数								*/
#define	MAjcMbsIStrW(P1, P2)		AjcMbsIStrW((P1), (P2))				/*	ワイド文字列中の文字列検索（英大小区別なし）		*/
#define	MAjcMbsTokW(P1, P2)			AjcMbsTokW ((P1), (P2))				/*	ワイド文字列トークン分離							*/

//	_wsplitpath_s, _wmakepath_s のバッファサイズを内部で生成し、_wsplitpath, _wmakepath と同様に扱えるようにする
#define	MAjcMakePathW(PATH, DRV, DIR, FNAME, FEXT)	_wmakepath_s (PATH, sizeof(PATH)/2, DRV, DIR, FNAME, FEXT)
#define	MAjcSplitPathW(PATH, DRV, DIR, FNAME, FEXT)	_wsplitpath_s(PATH, DRV,									\
																		DRV	  == NULL ? 0 : sizeof(DRV	) / 2,	\
																		DIR,									\
																		DIR	  == NULL ? 0 : sizeof(DIR	) / 2,	\
																		FNAME,									\
																		FNAME == NULL ? 0 : sizeof(FNAME) / 2,	\
																		FEXT,									\
																		FEXT  == NULL ? 0 : sizeof(FEXT ) / 2)


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	文字種別チェックマクロ																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define		MAjcIsLead		MAjcIsLeadW
	#define		MAjcIsTrail		MAjcIsTrailW

	#define		MAjcIsAlpha		MAjcIsAlphaW
	#define		MAjcIsAlNum		MAjcIsAlNumW
	#define		MAjcIsDigit		MAjcIsDigitW
	#define 	MAjcIsXDigit	MAjcIsXDigitW
	#define		MAjcIsUpper		MAjcIsUpperW
	#define		MAjcIsLower		MAjcIsLowerW
	#define		MAjcIsSpace		MAjcIsSpaceW
	#define		MAjcIsCntrl		MAjcIsCntrlW
	#define		MAjcIsPrint		MAjcIsPrintW
	#define		MAjcIsBlank		MAjcIsBlankW

	#define		MAjcAscIsAlpha	MAjcAscIsAlphaW
	#define		MAjcAscIsAlNum	MAjcAscIsAlNumW
	#define		MAjcAscIsDigit	MAjcAscIsDigitW
	#define 	MAjcAscIsXDigit	MAjcAscIsXDigitW
	#define		MAjcAscIsPrint	MAjcAscIsPrintW

	#define		MAjcMbcIsAlpha	MAjcMbcIsAlphaW
	#define		MAjcMbcIsAlNum	MAjcMbcIsAlNumW
	#define		MAjcMbcIsDigit	MAjcMbcIsDigitW
	#define		MAjcMbcIsXDigit	MAjcMbcIsXDigiW
	#define		MAjcMbcIsUpper	MAjcMbcIsUpperW
	#define		MAjcMbcIsLower	MAjcMbcIsLowerW
	#define		MAjcMbcIsSpace	MAjcMbcIsSpaceW
	#define		MAjcMbcIsBlank	MAjcMbcIsBlankW

	#define		MAjcIsBigChar	MAjcIsBigCharW
#else
	#define		MAjcIsLead		MAjcIsLeadA
	#define		MAjcIsTrail		MAjcIsTrailA

	#define		MAjcIsAlpha		MAjcIsAlphaA
	#define		MAjcIsAlNum		MAjcIsAlNumA
	#define		MAjcIsDigit		MAjcIsDigitA
	#define 	MAjcIsXDigit	MAjcIsXDigitA
	#define		MAjcIsUpper		MAjcIsUpperA
	#define		MAjcIsLower		MAjcIsLowerA
	#define		MAjcIsSpace		MAjcIsSpaceA
	#define		MAjcIsCntrl		MAjcIsCntrlA
	#define		MAjcIsPrint		MAjcIsPrintA
	#define		MAjcIsBlank		MAjcIsBlankA

	#define		MAjcAscIsAlpha	MAjcAscIsAlphaA
	#define		MAjcAscIsAlNum	MAjcAscIsAlNumA
	#define		MAjcAscIsDigit	MAjcAscIsDigitA
	#define 	MAjcAscIsXDigit	MAjcAscIsXDigitA
	#define		MAjcAscIsPrint	MAjcAscIsPrintA

	#define		MAjcMbcIsAlpha	MAjcMbcIsAlphaA
	#define		MAjcMbcIsAlNum	MAjcMbcIsAlNumA
	#define		MAjcMbcIsDigit	MAjcMbcIsDigitA
	#define		MAjcMbcIsXDigit	MAjcMbcIsXDigiA
	#define		MAjcMbcIsUpper	MAjcMbcIsUpperA
	#define		MAjcMbcIsLower	MAjcMbcIsLowerA
	#define		MAjcMbcIsSpace	MAjcMbcIsSpaceA
	#define		MAjcMbcIsBlank	MAjcMbcIsBlankA

	#define		MAjcIsBigChar	MAjcIsBigCharA
#endif


//----- バイト文字チェック -----------------------------------------------------//
//	マルチバイト順
#define		MAjcIsLeadA(C)		(_ismbblead(C)	!= 0)
#define		MAjcIsTrailA(C)		(_ismbbtrail(C) != 0)

//	バイト文字コードチェック
#define		MAjcIsAlphaA(C)		(((C) >= 0 && (C) <= 255) ? (isalpha (C) != 0) : 0)
#define		MAjcIsAlNumA(C)		(((C) >= 0 && (C) <= 255) ? (isalnum (C) != 0) : 0)
#define		MAjcIsDigitA(C)		(((C) >= 0 && (C) <= 255) ? (isdigit (C) != 0) : 0)
#define 	MAjcIsXDigitA(C)	(((C) >= 0 && (C) <= 255) ? (isxdigit(C) != 0) : 0)
#define		MAjcIsUpperA(C)		(((C) >= 0 && (C) <= 255) ? (isupper (C) != 0) : 0)
#define		MAjcIsLowerA(C)		(((C) >= 0 && (C) <= 255) ? (islower (C) != 0) : 0)
#define		MAjcIsSpaceA(C)		(((C) >= 0 && (C) <= 255) ? (isspace (C) != 0) : 0)
#define		MAjcIsCntrlA(C)		(((C) >= 0 && (C) <= 255) ? (iscntrl (C) != 0) : 0)
#define		MAjcIsPrintA(C)		(((C) >= 0 && (C) <= 255) ? (isprint (C) != 0) : 0)
#define		MAjcIsBlankA(C)		((C) == ' ' || (C) == '\t')

//	ASCII文字コードチェック
#define		MAjcAscIsAlphaA(C)	(((C) >= 0 && (C) <= 255) ? (isalpha (C) != 0) : 0)
#define		MAjcAscIsAlNumA(C)	(((C) >= 0 && (C) <= 255) ? (isalnum (C) != 0) : 0)
#define		MAjcAscIsDigitA(C)	(((C) >= 0 && (C) <= 255) ? (isdigit (C) != 0) : 0)
#define 	MAjcAscIsXDigitA(C)	(((C) >= 0 && (C) <= 255) ? (isxdigit(C) != 0) : 0)
#define		MAjcAscIsPrintA(C)	(((C) >= 0 && (C) <= 255) ? (isprint (C) != 0) : 0)

//	マルチバイト文字コードチェック
#define		MAjcMbcIsAlphaA(C)	(_ismbcalpha(C) != 0)
#define		MAjcMbcIsAlNumA(C)	(_ismbcalnum(C) != 0)
#define		MAjcMbcIsDigitA(C)	(_ismbcdigit(C) != 0)
#define 	MAjcMbcIsXDigitA(C)	(((C) >= '0'  && (C) <= '9' ) || ((C) >= 'A'  && (C) <= 'F' ) || ((C) >= 'a'  && (C) <= 'f' ) || \
								 ((C) >= '０' && (C) <= '９') || ((C) >= 'Ａ' && (C) <= 'Ｆ') || ((C) >= 'ａ' && (C) <= 'ｆ'))
#define		MAjcMbcIsUpperA(C)	(_ismbcupper(C) != 0)
#define		MAjcMbcIsLowerA(C)	(_ismbclower(C) != 0)
#define		MAjcMbcIsSpaceA(C)	(_ismbcspace(C) != 0)
#define		MAjcMbcIsBlankA(C)	((C) == ' ' || (C) == '　' || (C) == '\t')

//	全角文字チェック（全角１バイト目）
#define		MAjcIsBigCharA(C)	(AjcIsBigCharA(C))

//----- ワイド文字チェック -----------------------------------------------------//
//	マルチバイト順（ワイド文字にバイト順の概念は無い為、FALSE）
#define		MAjcIsLeadW(C)		((C) >= 0xD800 && (C) <= 0xDBFF)
#define		MAjcIsTrailW(C)		((C) >= 0xDC00 && (C) <= 0xDFFF)

//	ワイド文字コードチェック
#define		MAjcIsAlphaW(C)		(iswalpha(C) != 0)
#define		MAjcIsAlNumW(C)		(iswalnum(C) != 0)
#define		MAjcIsDigitW(C)		(iswdigit(C) != 0)
#define 	MAjcIsXDigitW(C)	(iswxdigit(C)!= 0)
#define		MAjcIsUpperW(C)		(iswupper(C) != 0)
#define		MAjcIsLowerW(C)		(iswlower(C) != 0)
#define		MAjcIsSpaceW(C)		(iswspace(C) != 0)
#define		MAjcIsCntrlW(C)		(iswcntrl(C) != 0)
#define		MAjcIsPrintW(C)		(iswprint(C) != 0)
#define		MAjcIsBlankW(C)		((C) == L' ' || (C) == L'\t')

//	ASCII文字コードチェック
#define		MAjcAscIsAlphaW(C)	(iswascii(C) != 0 && iswalpha (C) != 0)
#define		MAjcAscIsAlNumW(C)	(iswascii(C) != 0 && iswalnum (C) != 0)
#define		MAjcAscIsDigitW(C)	(iswascii(C) != 0 && iswdigit (C) != 0)
#define 	MAjcAscIsXDigitW(C)	(iswascii(C) != 0 && iswxdigit(C) != 0)
#define		MAjcAscIsPrintW(C)	(iswascii(C) != 0 && iswprint (C) != 0)

//	マルチバイト文字コードチェックに対応するワイド文字版
#define		MAjcMbcIsAlphaW(C)	(iswalpha(C) != 0)
#define		MAjcMbcIsAlNumW(C)	(iswalnum(C) != 0)
#define		MAjcMbcIsDigitW(C)	(iswdigit(C) != 0)
#define 	MAjcMbcIsXDigitW(C)	(iswxdigit(C)!= 0)
#define		MAjcMbcIsUpperW(C)	(iswupper(C) != 0)
#define		MAjcMbcIsLowerW(C)	(iswlower(C) != 0)
#define		MAjcMbcIsSpaceW(C)	(iswspace(C) != 0)
#define		MAjcMbcIsBlankW(C)	((C) == L' ' || (C) == L'　' || (C) == L'\t')

//	全角文字チェック
#define		MAjcIsBigCharW(C1, C2)	(AjcIsBigCharW(C1, C2))

//**************************************************************************************************************//
#endif
