﻿#ifndef	AJCTIPTXT_H_
#define	AJCTIPTXT_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcTipTextShow			AjcTipTextShowW
	#define	AjcTipTextShowEx		AjcTipTextShowExW
	#define	AjcTipTextShowCenter	AjcTipTextShowCenterW
	#define	AjcTipTextShowCenterEx	AjcTipTextShowCenterExW
	#define	AjcTipTextGetSize		AjcTipTextGetSizeW
#else
	#define	AjcTipTextShow			AjcTipTextShowA
	#define	AjcTipTextShowEx		AjcTipTextShowExA
	#define	AjcTipTextShowCenter	AjcTipTextShowCenterA
	#define	AjcTipTextShowCenterEx	AjcTipTextShowCenterExA
	#define	AjcTipTextGetSize		AjcTipTextGetSizeA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	カーソル移動モード																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCTIP_CM_CENT		= 0	,	//	中心へ移動
	AJCTIP_CM_LU			,	//	左上へ移動
	AJCTIP_CM_RU			,	//	右上へ移動
	AJCTIP_CM_LD			,	//	左下へ移動
	AJCTIP_CM_RD			,	//	右下へ移動
}	AJCTIP_CURMOVE, *PAJCTIP_CURMOVE;
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT HWND	 	WINAPI AjcTipTextCreate(VO);
AJCEXPORT VO	 	WINAPI AjcTipTextDelete(VO);

AJCEXPORT VO		WINAPI AjcTipTextDeleteForConApp(VO);

AJCEXPORT BOOL	 	WINAPI AjcTipTextShowA(int x, int y, C_BCP pTxt, int msTime, HFONT hFont);
AJCEXPORT BOOL	 	WINAPI AjcTipTextShowW(int x, int y, C_WCP pTxt, int msTime, HFONT hFont);

AJCEXPORT BOOL	 	WINAPI AjcTipTextShowExA(int x, int y, int minWidth, int height, C_BCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor);
AJCEXPORT BOOL	 	WINAPI AjcTipTextShowExW(int x, int y, int minWidth, int height, C_WCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor);

AJCEXPORT BOOL	 	WINAPI AjcTipTextShowCenterA(HWND hwnd, C_BCP pTxt, int msTime, HFONT hFont);
AJCEXPORT BOOL	 	WINAPI AjcTipTextShowCenterW(HWND hwnd, C_WCP pTxt, int msTime, HFONT hFont);

AJCEXPORT BOOL	 	WINAPI AjcTipTextShowCenterExA(HWND hwnd, int minWidth, int height, C_BCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor);
AJCEXPORT BOOL	 	WINAPI AjcTipTextShowCenterExW(HWND hwnd, int minWidth, int height, C_WCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor);

AJCEXPORT VO	 	WINAPI AjcTipTextShowCloseMark(BOOL fMark);

AJCEXPORT BOOL	 	WINAPI AjcTipTextGetSizeA(C_BCP pTxt, HFONT hFont, BOOL fBorder, LPSIZE pBuf);
AJCEXPORT BOOL	 	WINAPI AjcTipTextGetSizeW(C_WCP pTxt, HFONT hFont, BOOL fBorder, LPSIZE pBuf);

AJCEXPORT VO	 	WINAPI AjcTipTextMove(int x, int y);
AJCEXPORT VO	 	WINAPI AjcTipTextMoveCursor(AJCTIP_CURMOVE cm);


AJCEXPORT VO	 	WINAPI AjcTipTextHide(VO);
AJCEXPORT VO	 	WINAPI AjcTipTextHideEx(BOOL fDelay);

AJCEXPORT BOOL	 	WINAPI AjcTipTextGetRect(LPRECT pRect);

AJCEXPORT BOOL	 	WINAPI AjcTipTextSetPalette(int ix, COLORREF color);
AJCEXPORT COLORREF	WINAPI AjcTipTextGetPalette(int ix);

AJCEXPORT VO	 	WINAPI AjcTipTextSetDefTextColor  (COLORREF color);
AJCEXPORT COLORREF	WINAPI AjcTipTextGetDefTextColor  (VO);

AJCEXPORT VO	 	WINAPI AjcTipTextSetDefBorderColor(COLORREF color);
AJCEXPORT COLORREF	WINAPI AjcTipTextGetDefBorderColor(VO);

AJCEXPORT VO	 	WINAPI AjcTipTextSetDefBkColor	  (COLORREF color);
AJCEXPORT COLORREF	WINAPI AjcTipTextGetDefBkColor	  (VO);

AJCEXPORT VO	 	WINAPI AjcTipTextSetDefFont		  (HFONT hFont);
AJCEXPORT HFONT	 	WINAPI AjcTipTextGetDefFont		  (VO);

AJCEXPORT VO	 	WINAPI AjcTipTextSetDefMsShow	  (int msShow);
AJCEXPORT int	 	WINAPI AjcTipTextGetDefMsShow	  (VO);

AJCEXPORT BOOL		WINAPI AjcTipTextRegistBitmap	(HBITMAP hBmp , UI id, int x, int y, int cx, int cy);
AJCEXPORT BOOL		WINAPI AjcTipTextRegistIcon		(HICON   hIcon, UI id, int x, int y, int cx, int cy);
AJCEXPORT BOOL		WINAPI AjcTipTextUnregistImage	(UI id);

/****************************************************************************************************************/
#endif
