﻿#ifndef	AJCWATCH_H_
#define	AJCWATCH_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcWatCreate		AjcWatCreateW
	#define	AjcWatShow			AjcWatShowW
#else
	#define	AjcWatCreate		AjcWatCreateA
	#define	AjcWatShow			AjcWatShowA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	表示状態情報																								//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCWATSS_DISLCLK		0x0800		//	左クリック禁止
#define		AJCWATSS_DISRCLK		0x0400		//	右クリック禁止

#define		AJCWATSS_TOPMOST		0x0040		//	最前面
#define		AJCWATSS_TRANSPARENT	0x0020		//	透明
#define		AJCWATSS_SECHAND		0x0010		//	秒針表示

#define		AJCWATSS_SHOW			0x0080		//	現在商事中を示すフラグ（AjcWatGetShowState()の戻り値でのみ有効）

#define		AJCWATSS_MASK			0x00FF

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HANDLE	WINAPI	AjcWatCreateA		(HWND hOwner, UI dummy, C_BCP pSect);
AJCEXPORT	HANDLE	WINAPI	AjcWatCreateW		(HWND hOwner, UI dummy, C_WCP pSect);

AJCEXPORT	BOOL	WINAPI	AjcWatDelete		(HANDLE hWat);

AJCEXPORT	BOOL	WINAPI	AjcWatShowA			(HANDLE hWat, UI id, UI state, C_BCP pSect);
AJCEXPORT	BOOL	WINAPI	AjcWatShowW			(HANDLE hWat, UI id, UI state, C_WCP pSect);

AJCEXPORT	BOOL	WINAPI	AjcWatHide			(HANDLE hWat);
AJCEXPORT	BOOL	WINAPI	AjcWatHideByID		(HANDLE hWat, UI id);
AJCEXPORT	BOOL	WINAPI	AjcWatHideAll		(HANDLE hWat);
AJCEXPORT	UI		WINAPI	AjcWatSetShowState	(HANDLE hWat, UI id, UI state);
AJCEXPORT	UI		WINAPI	AjcWatGetShowState	(HANDLE hWat, UI id);
AJCEXPORT	HWND	WINAPI	AjcWatGetHWnd		(HANDLE hWat);

AJCEXPORT	VO	 	WINAPI	AjcWatAdvance		(SL sec);

/****************************************************************************************************************/
#endif
