﻿#ifndef		AJCXYMODEM_H_
#define		AJCXYMODEM_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcXymCreate		AjcXymCreateW
	#define	AJCXYMFILEINFO		AJCXYMFILEINFOW
	#define	PAJCXYMFILEINFO		PAJCXYMFILEINFOW
	#define	PCAJCXYMFILEINFO	PCAJCXYMFILEINFOW
#else
	#define	AjcXymCreate		AjcXymCreateA
	#define	AJCXYMFILEINFO		AJCXYMFILEINFOA
	#define	PAJCXYMFILEINFO		PAJCXYMFILEINFOA
	#define	PCAJCXYMFILEINFO	PCAJCXYMFILEINFOA
#endif
/*--------------------------------------------------------------------------------------------------------------*/
/*	インスタンスワーク																							*/
/*--------------------------------------------------------------------------------------------------------------*/
/*----- ファイル情報（バイト文字）------------------------------------------------------------------------------*/
typedef  struct  {
	BCP		pFName;					/*	ファイル名へのポインタ（但し、ファイル終了の場合はＮＵＬＬ）			*/
	ULL		size;					/*	ファイルサイズ															*/
	UL		time;					/*	ファイルタイム（1970-01-01 00:00:00 からの通算秒数 (UTC) ）				*/
} AJCXYMFILEINFOA, *PAJCXYMFILEINFOA;
typedef const AJCXYMFILEINFOA *PCAJCXYMFILEINFOA;

/*----- ファイル情報（ワイド文字）------------------------------------------------------------------------------*/
typedef  struct  {
	WCP		pFName;					/*	ファイル名へのポインタ（但し、ファイル終了の場合はＮＵＬＬ）			*/
	ULL		size;					/*	ファイルサイズ															*/
	UL		time;					/*	ファイルタイム（1970-01-01 00:00:00 からの通算秒数 (UTC) ）				*/
} AJCXYMFILEINFOW, *PAJCXYMFILEINFOW;
typedef const AJCXYMFILEINFOW *PCAJCXYMFILEINFOW;

/*----- ファイル情報（バイト文字／ワイド文字 共通）-------------------------------------------------------------*/
typedef  struct  {
	VOP		pFName;					/*	ファイル名へのポインタ（但し、ファイル終了の場合はＮＵＬＬ）			*/
	ULL		size;					/*	ファイルサイズ															*/
	UL		time;					/*	ファイルタイム（1970-01-01 00:00:00 からの通算秒数 (UTC) ）				*/
} AJCXYMFILEINFOV, *PAJCXYMFILEINFOV;
typedef const AJCXYMFILEINFOV *PCAJCXYMFILEINFOV;

/*----- コールバックタイプ（ファイル情報取得）------------------------------------------------------------------*/
typedef	VO (CALLBACK *AJCXYMCB_GETFILEA)	(PAJCXYMFILEINFOA pBuf, UX cbp);
typedef	VO (CALLBACK *AJCXYMCB_GETFILEW)	(PAJCXYMFILEINFOW pBuf, UX cbp);
typedef	VO (CALLBACK *AJCXYMCB_GETFILEV)	(PAJCXYMFILEINFOV pBuf, UX cbp);

/*--------------------------------------------------------------------------------------------------------------*/
typedef  struct  _AJCXYM {
	UI		InstID;					/*	インスタンスＩＤ														*/
	BOOL	fUnicode;				/*	ワイド文字フラグ														*/
	HAJCSTC	hStc;					/*	状態遷移制御インスタンスハンドル										*/
	UI		knd;					/*	プロトコル種別															*/

	UI		RecL;					/*	送信時：直前に送信したレコードのバイト数（132/133/1029）				*/
									/*	受信時：受信中のレコード長（132/133/1029）								*/

	UI		MaxL;					/*	最大データ長（128 / 1024）												*/
	UI		DatL;					/*	データ長（128 / 1024）													*/
	UI		ChkL;					/*	チェックバイト長（1:SUM, 2:CRC）										*/

	UI		tx_t0, tx_t1;			/*	送信時タイマ															*/
	UI		tx_r0, tx_r1;			/*	送信時リトライ															*/

	UI		rx_t0, rx_t1;			/*	受信時タイマ															*/
	UI		rx_r0, rx_r1;			/*	受信時リトライ															*/

	UI		tim0;					/*	送信時：受信要求待ち時間	受信時：受信要求(NAK/C/G)送信インタバル[ms]	*/
	UI		tim1;					/*	送信時：ACK受信待ち[ms]		受信時：レコード／EOT受信待ち[ms]			*/

	UI		rty0, RtyCnt0;			/*	送信時：未使用				受信時：未使用								*/
	UI		rty1, RtyCnt1;			/*	送信時：ACK受信リトライ		受信時：レコード／EOT受信リトライ			*/

	UB		rno;					/*	レコード番号															*/
	UI		bix;					/*	バッファインデクス														*/
	UB		buf[1024 + 5];			/*	送受信バッファ															*/

	UX		cbp;					/*	コールバックパラメタ													*/
	VO	(CALLBACK *cbNotice )(UI knd, UX Param				, UX cbp);
	VO	(CALLBACK *cbGetFile)(PAJCXYMFILEINFOV pBuf 		, UX cbp);
	VO	(CALLBACK *cbGetData)(VOP pBuf, UI len, UIP pBytes	, UX cbp);
	VO	(CALLBACK *cbSend	)(C_VOP pTxD, UI len 			, UX cbp);

} AJCXYM, *HAJCXYM;

/*--------------------------------------------------------------------------------------------------------------*/
/*	通知コード																									*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		AJCXYN_RXFILEINFO		0x0010				/*	受信ファイル情報通知								*/
#define		AJCXYN_TXREC			0x0020				/*	１レコード送信完了									*/
#define		AJCXYN_RXREC_128		0x0021				/*	１レコード受信（１２８バイトレコード）				*/
#define		AJCXYN_RXREC_1K			0x0022				/*	１レコード受信（１ＫＢレコード）					*/
#define		AJCXYN_RETRY			0x0030				/*	再送発生											*/
#define		AJCXYN_EOF				0x0040				/*	ＥＯＦ通知											*/
#define		AJCXYN_PROTOCOL			0x0050				/*	通信プロトコル変更通知								*/

#define		AJCXYN_USER				0x7000				/*	ユーザ定義用（0x7000～0x7FFF）						*/

#define		AJCXYN_END				0x8000
#define		AJCXYN_COMPLETE			(AJCXYN_END + 0)	/*	ファイル転送完了									*/
#define		AJCXYN_RX_CAN			(AJCXYN_END + 1)	/*	ファイル転送中止（ＣＡＮ受信					）	*/
#define		AJCXYN_USERSTOP			(AJCXYN_END + 2)	/*	　〃　　　　　　（ユーザからの中止要求			）	*/
#define		AJCXYN_TIMEOUT			(AJCXYN_END + 3)	/*	　〃　　　　　　（タイムアウト					）	*/
#define		AJCXYN_ABORT			(AJCXYN_END + 4)	/*	　〃　　　　　　（その他						）	*/

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトコル種別																								*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		AJCXYP_XMODEM		0x10
#define		AJCXYP_YMODEM		0x20

typedef enum {
	AJCXYP_XMODEM_SUM	=	(AJCXYP_XMODEM + 1)	,
	AJCXYP_XMODEM_CRC	=	(AJCXYP_XMODEM + 2)	,
	AJCXYP_XMODEM_1K	=	(AJCXYP_XMODEM + 3)	,

	AJCXYP_YMODEM_STD	=	(AJCXYP_YMODEM + 1)	,
	AJCXYP_YMODEM_G		=	(AJCXYP_YMODEM + 2)	,
} AJCXYMPROTOCOL;
/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT HAJCXYM	WINAPI	AjcXymCreateA(UX cbp,
										  VO (CALLBACK *cbNotice )(UI knd, UX Param					, UX cbp),
										  VO (CALLBACK *cbGetFile)(PAJCXYMFILEINFOA pBuf			, UX cbp),
										  VO (CALLBACK *cbGetData)(  VOP pBuf, UI lBuf, UIP pBytes	, UX cbp),
										  VO (CALLBACK *cbSend	 )(C_VOP pTxD, UI lTxD				, UX cbp));

AJCEXPORT HAJCXYM	WINAPI	AjcXymCreateW(UX cbp,
										  VO (CALLBACK *cbNotice )(UI knd, UX Param					, UX cbp),
										  VO (CALLBACK *cbGetFile)(PAJCXYMFILEINFOW pBuf			, UX cbp),
										  VO (CALLBACK *cbGetData)(  VOP pBuf, UI lBuf, UIP pBytes	, UX cbp),
										  VO (CALLBACK *cbSend	 )(C_VOP pTxD, UI lTxD				, UX cbp));

AJCEXPORT VO	WINAPI	AjcXymDelete(HAJCXYM hAjcXym);

AJCEXPORT BOOL	WINAPI		AjcXymTxStart		(HAJCXYM hXym, AJCXYMPROTOCOL Protocol);
AJCEXPORT BOOL	WINAPI		AjcXymRxStart		(HAJCXYM hXym, AJCXYMPROTOCOL Protocol);
AJCEXPORT VO	WINAPI		AjcXymSetTxTimeInfo	(HAJCXYM hXym, UI  t0, UI  r0, UI  t1, UI  r1);
AJCEXPORT VO	WINAPI		AjcXymGetTxTimeInfo	(HAJCXYM hXym, UIP t0, UIP r0, UIP t1, UIP r1);
AJCEXPORT VO	WINAPI		AjcXymSetRxTimeInfo	(HAJCXYM hXym, UI  t0, UI  r0, UI  t1, UI  r1);
AJCEXPORT VO	WINAPI		AjcXymGetRxTimeInfo	(HAJCXYM hXym, UIP t0, UIP r0, UIP t1, UIP r1);
AJCEXPORT VO	WINAPI		AjcXymStop			(HAJCXYM hXym);
AJCEXPORT VO	WINAPI		AjcXymPutRxChar 	(HAJCXYM hXym, UI rxd);
AJCEXPORT VO	WINAPI		AjcXymTxEnd 		(HAJCXYM hXym);
AJCEXPORT UI	WINAPI		AjcXymGetState		(HAJCXYM hXym);

/****************************************************************************************************************/
#endif
