﻿#ifndef	AJXAVL_H_
#define	AJXAVL_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	平衡２分木																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxAvl {
	public:
		HAJCAVL		m_hAvl;				//	ＡＶＬインスタンスドハンドル
		BOOL		m_fDestruct;		//	デストラクト中を示すフラグ

		CAjxAvl();						//	コンストラクタ
		~CAjxAvl();						//	デストラクタ

		BOOL	EnableMultiThread	(BOOL fEnable);								//	マルチスレッドの許可／禁止

		//----- ノードアクセス ---------------------------------------------------------------------------------//
		BOOL	InsNode				(UX key, C_VOP pNodeData, UI len);			//	ノード挿入
		int		GetNode				(UX key, VOP   pBuf,	  UI lBuf);			//	ノード取得
		VOP		GetNodePtr			(UX	key, UIP pLen);							//	ノードアドレス取得
		VOP		GetNodePtr			(UX	key);									//	ノードアドレス取得
		BOOL	RepNode				(UX key, C_VOP pNodeData, UI len);			//	ノード置換
		BOOL	InsOrRepNode		(UX key, C_VOP pNodeData, UI len);			//	ノード挿入／置換
		BOOL	DelNode				(UX key);									//	ノード削除
		BOOL	DelAllNodes			();											//	全ノードを削除

		//----- 文字列ノードアクセス ---------------------------------------------------------------------------//
		UX		InsStrNode			(C_BCP pStr);								//	文字列ノード挿入(ASCII)
		UX		InsStrNode			(C_WCP pStr);								//	文字列ノード挿入(UNICODE)

		UX		GetStrNode			(C_BCP pStr);								//	文字列ノード取得(ASCII)
		UX		GetStrNode			(C_WCP pStr);								//	文字列ノード取得(UNICODE)

		UX		InsOrGetStrNode		(C_BCP pStr);								//	文字列ノード挿入／取得(ASCII)
		UX		InsOrGetStrNode		(C_WCP pStr);								//	文字列ノード挿入／取得(UNICODE)

		UX		DelStrNode			(C_BCP pStr);								//	文字列ノード削除(ASCII)
		UX		DelStrNode			(C_WCP pStr);								//	文字列ノード削除(UNICODE)

		//----- その他 -----------------------------------------------------------------------------------------//
		UI		GetCount			();											//	ノード数取得

		UI		EnumNodes			(BOOL fDownSeq = FALSE);					//	全ノードのシーケンシャルな読み出し

		PCAJCAVLPTR	CreatePtrArr	(UIP pNum = NULL, BOOL fDownSeq = FALSE);	//	全ノードへのポインタ配列生成

		BOOL		ReleasePtrArr	(PCAJCAVLPTR pArr);							//	全ノードへのポインタ配列解放

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual int  OnKeyComp		(UX key1, UX key2);							//	キーの比較
		virtual VO	 OnNtcRemove	(UX key, VOP pNodeData, UI len, UI nest);	//	ノード削除通知
		virtual BOOL OnNtcNode		(UX key, VOP pNodeData, UI len, UI nest);	//	ノード読み出し通知
	};
}
/****************************************************************************************************************/
#endif
