﻿#ifndef	AJXBAR_H_
#define	AJXBAR_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	棒グラフ／折れ線グラフ コントロール																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxBar {
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル

		CAjxBar();						//	コンストラクタ
		~CAjxBar();						//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		BOOL	PutData				(double dat[]					, C_BCP pBarTtl);	//	データ投与(実数，ASCII)
		BOOL	PutData				(double d0						, C_BCP pBarTtl);
		BOOL	PutData				(double d0, double d1			, C_BCP pBarTtl);
		BOOL	PutData				(double d0, double d1, double d2, C_BCP pBarTtl);

		BOOL	PutData				(int dat[]						, C_BCP pBarTtl);	//	データ投与(整数，ASCII)
		BOOL	PutData				(int d0							, C_BCP pBarTtl);
		BOOL	PutData				(int d0, int d1					, C_BCP pBarTtl);
		BOOL	PutData				(int d0, int d1, int d2			, C_BCP pBarTtl);


		BOOL	PutData				(double dat[]					, C_WCP pBarTtl);	//	データ投与(実数，UNICODE)
		BOOL	PutData				(double d0						, C_WCP pBarTtl);
		BOOL	PutData				(double d0, double d1			, C_WCP pBarTtl);
		BOOL	PutData				(double d0, double d1, double d2, C_WCP pBarTtl);

		BOOL	PutData				(int dat[]						, C_WCP pBarTtl);	//	データ投与(整数，UNICODE)
		BOOL	PutData				(int d0							, C_WCP pBarTtl);
		BOOL	PutData				(int d0, int d1					, C_WCP pBarTtl);
		BOOL	PutData				(int d0, int d1, int d2			, C_WCP pBarTtl);

		BOOL	SetBarTtl			(C_BCP pTtl);										//	棒タイトル名設定(ASCII)
		BOOL	SetBarTtl			(C_WCP pTtl);										//	棒タイトル名設定(UNICODE)

		BOOL	SetVUnit			(C_BCP pUnit);										//	縦軸単位名設定(ASCII)
		BOOL	SetVUnit			(C_WCP pUnit);										//	縦軸単位名設定(UNICODE)

		BOOL	Purge				();													//	データクリアー

		BOOL	ShowBorder			(BOOL fShow, COLORREF rgb);							//	外枠表示／非表示
		BOOL	ShowFilter			(BOOL fShow);										//	フィルタ表示／非表示

		BOOL	GetProp				(PAJCBARPROP	 pBuf);								//	プロパティ取得
		BOOL	SetProp				(PCAJCBARPROP pProp);								//	プロパティ設定

		BOOL	GetRange			(double *pLow, double *pHigh);						//	レンジ取得
		BOOL	GetRange			(int	*pLow, int	  *pHigh);						//	
		BOOL	SetRange			(double	 low, double   high);						//	レンジ設定
		BOOL	SetRange			(int	 low, int	   high);						//	

		BOOL	GetBase				(double *base);										//	ベース値取得
		BOOL	GetBase				(int	*base);										//	
		BOOL	SetBase				(double  base);										//	ベース値設定
		BOOL	SetBase				(int	 base);										//	

		BOOL	SetBufSize			(int n);											//	バッファサイズ設定
		BOOL	SetItemNumber		(int n);											//	データ項目数設定
		BOOL	SetScaleWidth		(int width);										//	スケール値表示域の幅設定
		BOOL	SetBarWidth			(int width);										//	棒の幅設定
		BOOL	SetItemWidth		(int width);										//	棒表示域の幅設定
		BOOL	SetTtlLines			(int lines);										//	棒タイトルの最大行数設定

		HBITMAP	GetBitmap			();													//	ビットマップデータ取得

		BOOL	LoadProp			(C_BCP pProfileSect =  "BarProp", PCAJCBARPROP pDefProp = NULL);	//	プロファイルからプロパティ読出し(ASCII)
		BOOL	LoadProp			(C_WCP pProfileSect = L"BarProp", PCAJCBARPROP pDefProp = NULL);	//	プロファイルからプロパティ読出し(UNICODE)

		BOOL	SaveProp			(C_BCP pProfileSect =  "BarProp");									//	プロファイルへプロパティ書き込み(ASCII)
		BOOL	SaveProp			(C_WCP pProfileSect = L"BarProp");									//	プロファイルへプロパティ書き込み(UNICODE)

		BOOL	LoadPropEx			(C_BCP pProfileSect =  "BarProp", PCAJCBARPROP pDefProp = NULL);	//	プロファイルからプロパティ読出し(拡張，ASCII)
		BOOL	LoadPropEx			(C_WCP pProfileSect = L"BarProp", PCAJCBARPROP pDefProp = NULL);	//	プロファイルからプロパティ読出し(拡張，UNICODE)

		BOOL	SavePropEx			(C_BCP pProfileSect =  "BarProp");									//	プロファイルへプロパティ書き込み(拡張，ASCII)
		BOOL	SavePropEx			(C_WCP pProfileSect = L"BarProp");									//	プロファイルへプロパティ書き込み(拡張，UNICODE)

		BOOL	EnablePopupMenu		(BOOL fEnable);										//	右クリックによるポップアップメニュー許可／禁止
		BOOL	SetNtcRClk	 		(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);			//	右クリック通知設定

		BOOL	SetTipText	 		(C_BCP pTxt);										//	ツールチップの設定(ASCII)
		BOOL	SetTipText 			(C_WCP pTxt);										//	ツールチップの設定(UNICODE)

		UI		GetTipText	 		(BCP pBuf, UI lBuf);								//	ツールチップの取得(ASCII)
		UI		GetTipText 			(WCP pBuf, UI lBuf);								//	ツールチップの取得(UNICODE)

		BOOL	SetTipShowAlways	(BOOL fShowAlways);									//	ツールチップ表示条件の設定
		BOOL	GetTipShowAlways	();													//	ツールチップ表示条件の取得

		BOOL	SetChkBoxTipText	(UI n, C_BCP pTxt);									//	フィィルタチェックボックス・ツールチップの設定(ASCII)
		BOOL	SetChkBoxTipText	(UI n, C_WCP pTxt);									//	フィィルタチェックボックス・ツールチップの設定(UNICODE)

		UI		GetChkBoxTipText	(UI n, BCP pBuf, UI lBuf);							//	フィィルタチェックボックス・ツールチップの取得(ASCII)
		UI		GetChkBoxTipText	(UI n, WCP pBuf, UI lBuf);							//	フィィルタチェックボックス・ツールチップの取得(UNICODE)

		BOOL	SetChkBoxTipShowAlway(UI n, BOOL fShowAlways = FALSE);					//	フィルタ・チェックボックス・ツールチップ表示条件の設定
		BOOL	GetChkBoxTipShowAlway(UI n);											//	フィルタ・チェックボックス・ツールチップ表示条件の取得

		BOOL	SetTipShowAlwaysAll	(BOOL fShowAlways = FALSE);							//	全ツールチップ表示条件の設定

		int		GetScrollPos		();													//	スクロール位置の取得
		BOOL	SetScrollPos		(int pos);											//	スクロール位置の設定

		BOOL	SetFilter			(UI n, BOOL state);									//	フィルタの設定
		BOOL	GetFilter			(UI n);												//	フィルタの取得

		BOOL	SetHLineAtt			(UI id, COLORREF color, int width = 1, int style = AJCBAR_DASH);	//	横線の属性設定
		BOOL	SetHLinePos			(UI id, double pos);								//	横線の描画位置設定
		BOOL	EnableHLine			(UI id, BOOL fEnable);								//	横線描画の許可／禁止

		BOOL	GetCharSize			(LPSIZE pSize);										//	文字サイズの取得

		BOOL	GetDroppedFile		(BC buf[MAX_PATH]);									//	ドロップされたファイル名取得(ASCII)
		BOOL	GetDroppedFile		(WC buf[MAX_PATH]);									//	ドロップされたファイル名取得(UNICODE)

		BOOL	GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);	//	ドロップされたディレクトリ名取得(ASCII)
		BOOL	GetDroppedDir		(WC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);	//	ドロップされたディレクトリ名取得(UNICODE)

		BOOL	SetTitleText		(C_BCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(ASCII)
		BOOL	SetTitleText		(C_WCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(UNICODE)

		HFONT	SetTextFont				(HFONT hFont);									//	テキスト描画フォント設定

		UI		TextOut					(int x, int y, C_BCP pTxt);						//	テキスト描画（ピクセル位置指定）(ASCII)
		UI		TextOut					(int x, int y, C_WCP pTxt);						//	テキスト描画（ピクセル位置指定）(UNICODE)

		UI		PrintF					(int x, int y, C_BCP pFmt, ...);				//	書式テキスト描画（ピクセル位置指定）(ASCII)	
		UI		PrintF					(int x, int y, C_WCP pFmt, ...);				//	書式テキスト描画（ピクセル位置指定）(UNICODE)

		UI		GetText					(UI key, BCP pBuf, UI lBuf);					//	描画テキスト取得(ASCII)	
		UI		GetText					(UI key, WCP pBuf, UI lBuf);					//	描画テキスト取得(UNICODE)

		BOOL	ClearText				(UI key);										//	描画テキスト削除
		BOOL	ClearText				();												//	全ての描画テキスト削除

		BOOL	Clear					();												//	全てのデータと描画テキスト削除

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO		Attach		(HWND hWnd);										//	ハンドルを関連付け

		virtual	VO	OnNtcRange		(PCAJCBAR_NTC_RANGE pRange);						//	レンジ変化通知
		virtual	VO	OnNtcScrPos		(UI 				ScrPos);						//	スクロール位置変化通知
		virtual	VO	OnNtcDblClk		();													//	ダブルクリック通知
		virtual	VO	OnNtcDropFile	(UI 				nFiles);						//	ファイルドロップ通知
		virtual	VO	OnNtcDropDir	(UI 				nDirs );						//	ディレクトリドロップ通知
		virtual	VO	OnNtcRClick		(PCAJCBARRCLK		pRClk );						//	右クリック通知

	};
}
/****************************************************************************************************************/
#endif

