﻿#ifndef	AJXCON_H_
#define	AJXCON_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンソール スタティック コントロール																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT SAjxCon {
	public:
		static BOOL		SetStdMode			(EAJCTEC tec = AJCTEC_MBC, BOOL fBom = FALSE);			//	標準出力／標準エラー のモード設定

		static int		PutS				(C_BCP pStr);											//	文字列をコンソール(標準出力)へ出力(ASCII)
		static int		PutS				(C_WCP pStr);											//	文字列をコンソール(標準出力)へ出力(UNICODE)

		static int		PrintF				(C_BCP pFmt, ...);										//	書式文字列をコンソール(標準出力)へ出力(ASCII)
		static int		PrintF				(C_WCP pFmt, ...);										//	書式文字列をコンソール(標準出力)へ出力(UNICODE)

		static int	 	ErrPrintF			(C_BCP pFmt, ...);										//	書式文字列をコンソール(標準エラー)へ出力(ASCII)
		static int	 	ErrPrintF			(C_WCP pFmt, ...);										//	書式文字列をコンソール(標準エラー)へ出力(UNICODE)

		static BOOL		GetScreenBufferInfo	(LPSIZE pBufSize, LPRECT pRcWnd = NULL, LPSIZE pMaxWndSize = NULL);	//	コンソール情報取得
		static BOOL		GetMaxWndSize		(int *pCx  , int *pCy);									//	ウインド最大サイズ取得

		static BOOL		SetBufSize			(int cx, int cy);										//	バッファサイズ設定
		static BOOL		GetBufSize 			(int *pCx  , int *pCy);									//	バッファサイズ取得

		static BOOL		SetWndRect			(int left  , int top  , int right  , int bottom  );		//	コンソールウインド矩形設定
		static BOOL		GetWndRect			(int *pLeft, int *pTop, int *pRight, int *pBottom);		//	コンソールウインド矩形取得

		static BOOL		SetColor			(COLORREF	 ForeColor,   COLORREF	BackColor = (COLORREF)-1);	//	表示色設定
		static BOOL		GetColor			(LPCOLORREF pForeColor, LPCOLORREF pBackColor = NULL);			//	表示色取得

		static BOOL		SelPalette			(UI ForePalette, UI BackPalette);						//	表示色パレット選択
		static COLORREF GetForeColor		();														//	文字色パレット値の取得
		static COLORREF GetBackColor		();														//	背景色パレット値の取得

		static BOOL		SetPalette			(const COLORREF Palette[16]);							//	表示パレット設定（全パレット）
		static BOOL	 	SetPalByIx			(UI ix, COLORREF color);								//	表示パレット設定（単一パレット）

		static UI		GetPalette			(COLORREF Palette[16]);									//	表示パレット取得（全パレット）
		static COLORREF GetPalByIx			(UI ix);												//	表示パレット取得（単一パレット）

		static BOOL		SetCursor			(int x, int y);											//	カーソル位置設定
		static BOOL		GetCursor			(int *pX, int *pY);										//	カーソル位置取得
	};
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンソール入力 																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxCon {
	public:

		CAjxCon();									//	コンストラクタ
		~CAjxCon();									//	デストラクタ

		//----- ASCII ------------------------------------------------------------------------------------------//
		//	１行入力（入力バッファ指定を内部で生成）
		BOOL	 Input (C_BCP pHelpText, UI lInpField = 80, UI lBuf = 256, UI fOpt = 0, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1);

		//	１行入力（入力バッファ指定）
		BOOL	 Input (UI lInpField,
						BCP pBuf		  , UI lBuf,
						C_BCP pHelpText = NULL, UI fOpt = 0, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1);

		//	１行入力（初期テキスト指定）
		BOOL	 Input (C_BCP pInitialText, UI lInpField,
						BCP pBuf		  , UI lBuf,
						C_BCP pHelpText = NULL, UI fOpt = 0, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1);



		//----- UNICODE ----------------------------------------------------------------------------------------//
		//	１行入力（入力バッファ指定を内部で生成）
		BOOL	 Input (C_WCP pHelpText, UI lInpField = 80, UI lBuf = 256, UI fOpt = 0, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1);

		//	１行入力（入力バッファ指定）
		BOOL	 Input (UI lInpField,
						WCP pBuf		  , UI lBuf,
						C_WCP pHelpText = NULL, UI fOpt = 0, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1);

		//	１行入力（初期テキスト指定）
		BOOL	 Input (C_WCP pInitialText, UI lInpField,
						WCP pBuf		  , UI lBuf,
						C_WCP pHelpText = NULL, UI fOpt = 0, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1);

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual VO OnNtcStr(int argc, BC *argv[], C_BCP pTxt);			//	入力テキスト通知(ASCII)
		virtual VO OnNtcStr(int argc, WC *argv[], C_WCP pTxt);			//	入力テキスト通知(UNICODE)

	};
}
/****************************************************************************************************************/
#endif
