﻿#ifndef	AJXCTK_H_
#define	AJXCTK_H_
/****************************************************************************************************************/

#define		CAJX_CTKMAX_STACK	64		//	読み出し位置退避の最大ネスト数

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	Ｃ言語の字句分解																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxCtk {
		BOOL	m_fUnicode;						//	UNICODE / ASCII 識別フラグ
		int		m_Ix;							//	PUSH/POP インデクス
		HAJCTK	m_hCtk[CAJX_CTKMAX_STACK];		//	ＡＶＬインスタンスドハンドル

	public:
		#ifdef UNICODE
			CAjxCtk(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxCtk(BOOL fUnicode = FALSE);		//	コンストラクタ(ASCII)
		#endif
		~CAjxCtk();								//	デストラクタ

		BOOL	Reset			();								//	リセット

		BOOL	SetFlag			(UI flag);						//	機能フラグの設定
		UI		GetFlag			();								//	機能フラグの取得

		BOOL	GetToken		(BCP pStrBuf, UI lStrBuf);		//	字句読み出し(ASCII)
		BOOL	GetToken		(WCP pStrBuf, UI lStrBuf);		//	字句読み出し(UNICODE)

		BOOL	PeekToken		(BCP pStrBuf, UI lStrBuf);		//	現在の字句取得(ASCII)
		BOOL	PeekToken		(WCP pStrBuf, UI lStrBuf);		//	現在の字句取得(UNICODE)

		BOOL	Push			();								//	読み出し位置の退避
		BOOL	Pop				();								//	読み出し位置の回復

		C_BCP	GetTokenString	(EAJCTKCODE tkn);				//	トークンコードに対応する文字列の取得

		//----- トークン情報取得 -------------------------------------------------------------------------------//
		UI			Error		();								//	エラーコード取得
		EAJCTKCODE	Token		();								//	トークンコード取得
		EAJCTKSUF	Suffix		();								//	数値定数のサフィックスコード取得
		UI			Flag		();								//	フラグ情報取得
		UI			Line		();								//	当該字句が存在する、ソースプログラム上の行番号取得
		UI			Loc			();								//	当該字句が存在する、ライン上の桁位置を返します（タブも１文字として計算）
		UI			Pos			(UI TabStep);					//	当該字句が存在する、タブ文字(0x09)を考慮したライン上の桁位置を返します（TabStepはタブステップ幅）

		//----- トークンチェック -------------------------------------------------------------------------------//
		BOOL		IsUsrSym	(EAJCTKCODE tkn);				//	トークンチェック（ユーザシンボル）
		BOOL		IsRsvSym	(EAJCTKCODE tkn);				//	トークンチェック（予約名）
		BOOL		IsValue		(EAJCTKCODE tkn);				//	トークンチェック（数値）
		BOOL		IsString	(EAJCTKCODE tkn);				//	トークンチェック（文字列）
		BOOL		IsPathName	(EAJCTKCODE tkn);				//	トークンチェック（パス名）
		BOOL		IsDelimit	(EAJCTKCODE tkn);				//	トークンチェック（デリミタ）
		BOOL		IsSymbol	(EAJCTKCODE tkn);				//	トークンチェック（シンボル）
		BOOL		IsValSym	(EAJCTKCODE tkn);				//	トークンチェック（シンボル／数値）
		BOOL		IsSpace		(EAJCTKCODE tkn);				//	トークンチェック（空白）

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual BOOL  OnGetLine	(BCP pBuf, UI lBuf);			//	１行読み出し要求(ASCII)
		virtual BOOL  OnGetLine	(WCP pBuf, UI lBuf);			//	１行読み出し要求(UNICODE)
	};
}

/****************************************************************************************************************/
#endif
