﻿#ifndef	AJXDLG_H_
#define	AJXDLG_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ダイアログボックス	（ダイアログ項目のアクセス）															//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxDlg {
		BOOL	m_fUnicode;				//	UNICODEモード識別
	public:
		HWND	m_hDlg;					//	ダイアログハンドル

		#ifdef UNICODE
			CAjxDlg(BOOL fUnicode = TRUE);	//	コンストラクタ(UNICODE)
		#else
			CAjxDlg(BOOL fUnicode = FALSE);	//	コンストラクタ(ASCII)
		#endif
		~CAjxDlg();							//	デストラクタ

		//----- ハンドル割り当て -------------------------------------------------------------------------------//
		virtual	VO		Attach(HWND hDlg);

		//----- ダイアログ項目アクセス -------------------------------------------------------------------------//
		UI		GetDlgItemUInt					(int id);										//	ダイアログ項目の取得（符号なし整数）
		SI		GetDlgItemSInt					(int id);										//	ダイアログ項目の取得（符号付き整数）
		UI		GetDlgItemHex					(int id);										//	ダイアログ項目の取得（１６進整数）
		double	GetDlgItemReal					(int id);										//	ダイアログ項目の取得（実数）
		ULL		GetDlgItemUI64					(int id);										//	ダイアログ項目の取得（符号なし長整数）
		SLL		GetDlgItemSI64					(int id);										//	ダイアログ項目の取得（符号付き長整数）
		ULL		GetDlgItemH64					(int id);										//	ダイアログ項目の取得（１６進長整数）
		UI		GetDlgItemChk					(int id);										//	ダイアログ項目の取得（チェックボックス）
		UI		GetDlgItemStr					(int id, BCP   pBuf, UI lBuf);					//	ダイアログ項目の取得（文字列, ASCII）
		UI		GetDlgItemStr					(int id, WCP   pBuf, UI lBuf);					//	ダイアログ項目の取得（文字列,UNICODE）
		UI		GetDlgItemStrLen				(int id);										//	ダイアログ項目の取得（文字列長）
		int	 	GetDlgItemSldPos				(int id);										//	ダイアログ項目の取得（スライダの位置）
		UI		GetDlgItemCboIx					(int id);										//	ダイアログ項目の取得（コンボボックス・インデクス）
		UI		GetDlgItemCboCount				(int id);										//	ダイアログ項目の取得（コンボボックス・項目数）
		UI		GetDlgItemCboLen				(int id, UI ix);								//	ダイアログ項目の取得（コンボボックス・文字長, ASCII）
		UI		GetDlgItemCboItem				(int id, UI ix, BCP pBuf, UI lBuf);				//	ダイアログ項目の取得（コンボボックス・項目の文字列）
		UI		GetDlgItemCboItem				(int id, UI ix, WCP pBuf, UI lBuf);				//	ダイアログ項目の取得（コンボボックス・項目の文字列, UNICODE）
		SX		GetDlgItemCboData				(int id, UI ix);								//	ダイアログ項目の取得（コンボボックス・データ値）
		UI		GetDlgItemCboFind				(int id, UI ix, C_BCP pStr, UI flag);			//	ダイアログ項目の取得（コンボボックス・文字列検索, ASCII）
		UI		GetDlgItemCboFind				(int id, UI ix, C_WCP pStr, UI flag);			//	ダイアログ項目の取得（コンボボックス・文字列検索, UNICODE）
		UI		GetDlgItemCboMaxLen				(int id);										//	ダイアログ項目の取得（コンボボックス・項目群のの最大文字列長）

		BOOL	SetDlgItemUInt					(int id, UI 	value);							//	ダイアログ項目の設定（符号なし整数）
		BOOL 	SetDlgItemSInt					(int id, SI 	value);							//	ダイアログ項目の設定（符号付き整数）
		BOOL 	SetDlgItemHex					(int id, UI 	value);							//	ダイアログ項目の設定（１６進整数）
		BOOL 	SetDlgItemReal					(int id, double value, int prec);				//	ダイアログ項目の設定（実数）
		BOOL 	SetDlgItemUI64					(int id, ULL	value);							//	ダイアログ項目の設定（符号なし長整数）
		BOOL 	SetDlgItemSI64					(int id, SLL	value);							//	ダイアログ項目の設定（符号付き長整数）
		BOOL 	SetDlgItemH64					(int id, ULL	value);							//	ダイアログ項目の設定（１６進長整数）
		BOOL 	SepDlgItemUInt					(int id, UI 	value);							//	ダイアログ項目の設定（符号なし整数，  ３桁区切り）
		BOOL 	SepDlgItemSInt					(int id, SI 	value);							//	ダイアログ項目の設定（符号付き整数，  ３桁区切り）
		BOOL 	SepDlgItemHex					(int id, UI 	value, int col );				//	ダイアログ項目の設定（１６進整数  ，  桁数指定）
		BOOL 	SepDlgItemReal					(int id, double value, int prec);				//	ダイアログ項目の設定（実数，		  ３桁区切り）
		BOOL 	SepDlgItemUI64					(int id, ULL	value);							//	ダイアログ項目の設定（符号なし長整数，３桁区切り）
		BOOL 	SepDlgItemSI64					(int id, SLL	value);							//	ダイアログ項目の設定（符号付き長整数，３桁区切り）
		BOOL 	SepDlgItemH64					(int id, ULL	value, int col);				//	ダイアログ項目の設定（１６進長整数	，桁数指定）
		BOOL	SetDlgItemChk					(int id, UI state);								//	ダイアログ項目の設定（チェックボックス）
		BOOL	SetDlgItemRbt					(int id, int idFirst, int idLast);				//	ダイアログ項目の設定（ラジオボタン）
		BOOL	SetDlgItemStr					(int id, C_BCP pStr);							//	ダイアログ項目の設定（文字列, ASCII）
		BOOL	SetDlgItemStr					(int id, C_WCP pStr);							//	ダイアログ項目の設定（文字列, UNICODE）
		BOOL	SetDlgItemFStr					(int id, C_BCP pFmt, ...);						//	ダイアログ項目の設定（書式文字列, ASCII）
		BOOL	SetDlgItemFStr					(int id, C_WCP pFmt, ...);						//	ダイアログ項目の設定（書式文字列, ASCII）
		BOOL	SetDlgItemEdtLimit				(int id, UI limit);								//	ダイアログ項目の設定（エディットコントロールの桁数）
		BOOL	SetDlgItemCboIx					(int id, UI ix);								//	ダイアログ項目の設定（コンボボックス・インデクス）
		UI		SetDlgItemCboAdd				(int id, UI ix, C_BCP pItem, UI flag = AJCCBF_ALL);	//	ダイアログ項目の設定（コンボボックス・項目の文字列, ASCII）
		UI		SetDlgItemCboAdd				(int id, UI ix, C_WCP pItem, UI flag = AJCCBF_ALL);	//	ダイアログ項目の設定（コンボボックス・項目の文字列, UNICODE）
		UI		SetDlgItemCboIns				(int id, UI ix, C_BCP pItem, UI flag = AJCCBF_ALL);	//	ダイアログ項目の設定（コンボボックス・項目挿入, ASCII）
		UI		SetDlgItemCboIns				(int id, UI ix, C_WCP pItem, UI flag = AJCCBF_ALL);	//	ダイアログ項目の設定（コンボボックス・項目挿入, UNICODE）
		BOOL	SetDlgItemCboDel				(int id, UI ix);								//	ダイアログ項目の設定（コンボボックス・項目削除）
		BOOL	SetDlgItemCboData				(int id, UI ix, SX data);						//	ダイアログ項目の設定（コンボボックス・データ値）
		BOOL	SetDlgItemCboList				(int id, C_BCP pList);							//	ダイアログ項目の設定（コンボボックス・項目リスト, ASCII）
		BOOL	SetDlgItemCboList				(int id, C_WCP pList);							//	ダイアログ項目の設定（コンボボックス・項目リスト, UNICODE）
		BOOL	SetDlgItemCboLimit				(int id, UI limit);								//	ダイアログ項目の設定（コンボボックス・入力可能文字数）
		BOOL	SetDlgItemCboReset				(int id);										//	ダイアログ項目の設定（コンボボックス・リセット）
		BOOL	SetDlgItemPgsRange				(int id, int low, int high);					//	ダイアログ項目の設定（プログレスバーのレンジ）
		BOOL	SetDlgItemPgsPos				(int id, int pos);								//	ダイアログ項目の設定（プログレスバーの位置）
		BOOL	SetDlgItemSldRange				(int id, int low, int high, int page);			//	ダイアログ項目の設定（スライダのレンジ）
		BOOL	SetDlgItemSldPos				(int id, int pos);								//	ダイアログ項目の設定（スライダの位置）
		BOOL	SetDlgItemSpnInfo 				(int id, int low, int high, int idBuddy);		//	ダイアログ項目の設定（スピンボタンのレンジとバディウインド
		BOOL	SetDlgItemSpnRange				(int id, int low, int high);					//	ダイアログ項目の設定（スピンボタンのレンジ
		BOOL	SetDlgItemSpnBuddy				(int id, int idBuddy);							//	ダイアログ項目の設定（スピンボタンのバディウインド

		HWND	SetDlgItemTopMostInSiblings		(int id);										//	コントロールを兄弟ウインド中で再前面に設定する
		HWND	SetDlgItemlBackMostInSiblings	(int id);										//	コントロールを兄弟ウインド中で再背面に設定する
		BOOL	EnableDlgItemToDrop				(int id, UI optDrop = AJCDROP_DIR_AND_FILE);	//	EDITコントロールにフォルダ／ファイルをドロップ可能にする

		//----- コントロールのグレィ設定／表示／移動 -----------------------------------------------------------//
		BOOL	EnableDlgItem					(int id	, BOOL fEnable);						//	ダイアログ項目の有効化／無効化
		BOOL	EnableDlgGroup					(int idGrp, BOOL fEnaGrpBox, BOOL fEnaCtrls);	//	グループボックス内の全コントロール有効化／無効化
		BOOL	ShowDlgGroup					(int idGrp, BOOL fShow);						//	グループボックスとグループボックス内の全コントロール表示／非表示
		BOOL	ShowDlgGroup					(int idGrp, BOOL fShowGrpBox, BOOL fShowCtrls);	//	グループボックスやグループボックス内の全コントロール表示／非表示（拡張）
		BOOL	MoveDlgGroupToLoc				(int idGrp, int x, int y);						//	グループボックスとグループボックス内の全コントロールを指定位置へ移動
		BOOL	MoveDlgGroupToCtl				(int idGrp, int idCtl);							//	グループボックスとグループボックス内の全コントロールを指定コントロールのへ移動
		BOOL	MoveDlgGroupToOrg				(int idGrp);									//	グループボックスとグループボックス内の全コントロールを移動前の位置に戻す

		//----- ダイアログ項目の永続化 -------------------------------------------------------------------------//
		BOOL	DelAllCtrlPermAtt				();														//	全コントロールの永続化属性解除
		BOOL	LoadAllControlSettings			(C_BCP pSect, UI act = AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);	//	全コントロールの設定内容の読み出し(ASCII)
		BOOL	LoadAllControlSettings			(C_WCP pSect, UI act = AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);	//	全コントロールの設定内容の読み出し(UNICODE)
		BOOL	SaveAllControlSettings			();														//	全コントロールの設定内容の書き込み

		BOOL	DlgItemSetPermAtt				(UI id, UI att);										//	各コントロールの永続化属性の設定
		BOOL	DlgItemLoadTextBox				(UI id, C_BCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの読み出し(読出専用の動作を指定, ASCII)
		BOOL	DlgItemLoadTextBox				(UI id, C_WCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの読み出し(読出専用の動作を指定, UNICODE)
		BOOL	DlgItemSaveTextBox				(UI id, C_BCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの書き込み(読出専用の動作を指定, ASCII)
		BOOL	DlgItemSaveTextBox				(UI id, C_WCP pSect, BOOL fExcRdOnly = TRUE);			//	テキストボックスの書き込み(読出専用の動作を指定, UNICODE)
		BOOL	DlgItemLoadChkBox				(UI id, C_BCP pSect, BOOL fNtc = FALSE);				//	チェックボックス／ラジオボタンの読み出し(ASCII)
		BOOL	DlgItemLoadChkBox				(UI id, C_WCP pSect, BOOL fNtc = FALSE);				//	チェックボックス／ラジオボタンの読み出し(UNICODE)
		BOOL	DlgItemSaveChkBox				(UI id, C_BCP pSect);									//	チェックボックス／ラジオボタンの書き込み(ASCII)
		BOOL	DlgItemSaveChkBox				(UI id, C_WCP pSect);									//	チェックボックス／ラジオボタンの書き込み(UNICODE)
		BOOL	DlgItemLoadComboBox				(UI id, C_BCP pSect, UI sel = 0, BOOL fNtc = FALSE);	//	コンボボックスの読み出し(ASCII)
		BOOL	DlgItemLoadComboBox				(UI id, C_WCP pSect, UI sel = 0, BOOL fNtc = FALSE);	//	コンボボックスの読み出し(UNICODE)
		BOOL	DlgItemSaveComboBox				(UI id, C_BCP pSect, UI sel = 0);						//	コンボボックスの書き込み(ASCII)
		BOOL	DlgItemSaveComboBox				(UI id, C_WCP pSect, UI sel = 0);						//	コンボボックスの書き込み(UNICODE)
		BOOL	DlgItemLoadListBox				(UI id, C_BCP pSect, UI sel = 0);						//	リストボックスの読み出し(ASCII)
		BOOL	DlgItemLoadListBox				(UI id, C_WCP pSect, UI sel = 0);						//	リストボックスの読み出し(UNICODE)
		BOOL	DlgItemSaveListBox				(UI id, C_BCP pSect, UI sel = 0);						//	リストボックスの書き込み(ASCII)
		BOOL	DlgItemSaveListBox				(UI id, C_WCP pSect, UI sel = 0);						//	リストボックスの書き込み(UNICODE)
	};
}
/****************************************************************************************************************/
#endif
