﻿#ifndef	AJXLBX_H_
#define	AJXLBX_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	拡張リストボックス コントロール																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxLbx {
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル
		BOOL	m_fUnicode;				//	UNICODEフラグ

		#ifdef UNICODE
			CAjxLbx(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxLbx(BOOL fUnicode = FALSE);		//	コンストラクタ(ASCII)
		#endif
		~CAjxLbx();								//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		UI				GetAllItems		(PAJCLBXITEMA *pArr);						//	全リストボックス項目データの配列取得(ASCII)
		UI				GetAllItems		(PAJCLBXITEMW *pArr);						//	全リストボックス項目データの配列取得(UNICODE)

		VO				RelAllItems		(VOP pAllItemBuf);							//	取得した全リストボックス項目の配列解放

		UI				GetSelectedItems(PAJCLBXITEMA *pArr);						//	全選択項目の配列取得(ASCII)
		UI				GetSelectedItems(PAJCLBXITEMW *pArr);						//	全選択項目の配列取得(UNICODE)

		VO				RelSelectedItems(VOP pSelectedItemBuf);						//	取得した選択項目の配列解放

		BOOL			LoadItems		(C_BCP pSect, C_BCP pKeyPrefix =  "Lbx");	//	プロファイルから全リストボックス項目の読出し(ASCII)
		BOOL			LoadItems		(C_WCP pSect, C_WCP pKeyPrefix = L"Lbx");	//	プロファイルから全リストボックス項目の読出し(UNICODE)

		BOOL			SaveItems		(C_BCP pSect, C_BCP pKeyPrefix =  "Lbx");	//	プロファイルへ全リストボックス項目の書込み(ASCII)
		BOOL			SaveItems		(C_WCP pSect, C_WCP pKeyPrefix = L"Lbx");	//	プロファイルへ全リストボックス項目の書込み(UNICODE)

		BOOL			SetTipText		(C_BCP pTxt);								//	ツールチップの設定(ASCII)
		BOOL			SetTipText		(C_WCP pTxt);								//	ツールチップの設定(UNICODE)

		BOOL			GetTipText		(BCP pBuf, UI lBuf);						//	ツールチップの取得(ASCII)
		BOOL			GetTipText		(WCP pBuf, UI lBuf);						//	ツールチップの取得(UNICODE)

		BOOL			SetTipShowAlways(BOOL fShowAlways);							//	ツールチップ表示条件の設定
		BOOL			GetTipShowAlways();											//	ツールチップ表示条件の取得



		int				AddString		(C_BCP pStr);								//	リストボックス項目の追加(ASCII)
		int				AddString		(C_WCP pStr);								//	リストボックス項目の追加(UNICODE)

		int				InsertString	(UI ix, C_BCP pStr);						//	リストボックス項目の挿入(ASCII)
		int				InsertString	(UI ix, C_WCP pStr);						//	リストボックス項目の挿入(UNICODE)

		int				DeleteString	(UI ix);									//	リストボックス項目の削除

		int				FindString		(UI ix, C_BCP pStr);						//	リストボックス項目の検索(ASCII)
		int				FindString		(UI ix, C_WCP pStr);						//	リストボックス項目の検索(UNICODE)

		int	 			GetCount		();											//	リストボックス項目の項目数取得

		int				GetCurSel		();											//	選択されているリストボックス項目のインデクス取得
		BOOL			GetSel			(UI ix);									//	リストボックス項目の選択状態取得
		int				GetSelCount		();											//	選択されているリストボックス項目の個数取得

		BOOL			GetText			(UI ix, BCP pBuf, UI lBuf);					//	リストボックス項目の取得(ASCII)
		BOOL			GetText			(UI ix, WCP pBuf, UI lBuf);					//	リストボックス項目の取得(UNICODE)

		int				GetTextLen		(UI ix);									//	リストボックス項目の文字列長取得

		BOOL			ResetContent	();											//	全リストボックス項目の消去

		int				SelectString	(UI ix, C_BCP pStr);						//	リストボックス項目の選択(ASCII)
		int				SelectString	(UI ix, C_WCP pStr);						//	リストボックス項目の選択(UNICODE)

		BOOL			SetCount		(UI count);									//	リストボックス項目数の設定
		BOOL			SetCurSel		(UI ix);									//	リストボックス項目の選択
		BOOL			SetSel			(UI ix, BOOL fSelect);						//	リストボックス項目の選択／非選択状態設定

		BOOL			SetItemData		(UI ix, UX data);							//	リストボックス項目に関連付けられた数値の設定
		UX				GetItemData		(UI ix);									//	リストボックス項目に関連付けられた数値の取得

		BOOL			SetBasePath		(C_BCP pBasePath);							//	相対アドレス変換時のベースディレクトリパス設定(ASCII)
		BOOL			SetBasePath		(C_WCP pBasePath);							//	相対アドレス変換時のベースディレクトリパス設定(UNICODE)

		BOOL			SetNtcRClk		(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);	//	右クリック通知設定

		BOOL			SetFileFilter	(C_BCP pFilter, C_BCP pDefExt);				//	ファイル選択時のフィルタ，デフォルト拡張子の設定(ASCII)
		BOOL			SetFileFilter	(C_WCP pFilter, C_WCP pDefExt);				//	ファイル選択時のフィルタ，デフォルト拡張子の設定(UBICODE)

		BOOL			GetDroppedFile	(BC buf[MAX_PATH]);							//	ドロップされたファイルのパス名を取得(ASCII)
		BOOL			GetDroppedFile	(WC buf[MAX_PATH]);							//	ドロップされたファイルのパス名を取得(UNICODE)

		BOOL			GetDroppedDir	(BC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);	//	ドロップされたディレクトリのパス名を取得(ASCII)
		BOOL			GetDroppedDir	(WC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);	//	ドロップされたディレクトリのパス名を取得(UNICODE)

		BOOL			GetRemovedItem	(BCP pBuf, UI lBuf);						//	削除された項目の文字列を取得(ASCII)
		BOOL			GetRemovedItem	(WCP pBuf, UI lBuf);						//	削除された項目の文字列を取得(UNICODE)

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO		Attach					(HWND hWnd);				//	ハンドルを関連付け
		virtual	VO		OnNtcDblClk				();							//	ダブルクリック通知
		virtual	VO		OnNtcSelCancel			();							//	選択キャンセル通知
		virtual	VO		OnNtcSelChange			();							//	選択変更通知
		virtual	VO		OnNtcSetFocus			();							//	フォーカス取得通知
		virtual	VO		OnNtcKillFocus			();							//	フォーカス喪失通知
		virtual	VO		OnNtcRClick				(PAJCLBXRCLK pRClk);		//	右クリック通知
		virtual	VO		OnNtcRemoved			(UI n);						//	項目削除通知
		virtual	VO		OnNtcDropDir			(UI n);						//	ディレクトリドロップ通知
		virtual	VO		OnNtcDropFile			(UI n);						//	ファイルロップ通知
		virtual	VO		OnNtcErrSpace			();							//	メモリ不足通知
	};
}
/****************************************************************************************************************/
#endif
