﻿#ifndef	AJXSCP_H_
#define	AJXSCP_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	シリアル通信																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxScp {
		ATOM	m_Atom;					//	イベント通知用クラスハンドル
		HWND	m_hWndEvt;				//	イベント通知用ウインド

	public:
		HAJCSCP	m_hScp;					//	ＳＣＰインスタンスドハンドル
		BOOL	m_fUnicode;				//	UNICODEフラグ

		CAjxScp();						//	コンストラクタ
		~CAjxScp();						//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		//	初期設定
		#ifdef _CONSOLE
			BOOL	Init	(C_BCP pSect, AJCSCP_CHUNKMODE ChunkMode = AJCSCP_CM_BIN, BOOL fUseWaitEvent = TRUE , BOOL fCreateMySlot = TRUE, C_BCP pMySlot =  "MySlot", C_BCP pRmtHost =  "", C_BCP pRmtSlot =	"RmtSlot");	//	(ASCII)
			BOOL	Init	(C_WCP pSect, AJCSCP_CHUNKMODE ChunkMode = AJCSCP_CM_BIN, BOOL fUseWaitEvent = TRUE , BOOL fCreateMySlot = TRUE, C_WCP pMySlot = L"MySlot", C_WCP pRmtHost = L"", C_WCP pRmtSlot = L"RmtSlot");	//	(UNICODE)
		#else
			BOOL	Init	(C_BCP pSect, AJCSCP_CHUNKMODE ChunkMode = AJCSCP_CM_BIN, BOOL fUseWaitEvent = FALSE, BOOL fCreateMySlot = TRUE, C_BCP pMySlot =  "MySlot", C_BCP pRmtHost =  "", C_BCP pRmtSlot =	"RmtSlot");	//	(ASCII)
			BOOL	Init	(C_WCP pSect, AJCSCP_CHUNKMODE ChunkMode = AJCSCP_CM_BIN, BOOL fUseWaitEvent = FALSE, BOOL fCreateMySlot = TRUE, C_WCP pMySlot = L"MySlot", C_WCP pRmtHost = L"", C_WCP pRmtSlot = L"RmtSlot");	//	(UNICODE)
		#endif

		BOOL				Open					(UI Port, UI Rate = 115200, UI DataBits = 8, UI Parity = 'N', UI StopBit = 1);	//	ポートオープン（ＣＯＭポート）
		BOOL				Open					(UI Port, LPDCB pDcb, LPCOMMTIMEOUTS pTmo = NULL);						//	ポートオープン（ＣＯＭポート，DCB, TIMEOUT指定）

		BOOL				Open					(C_BCP pRmtHost, C_BCP pRmtSlot);										//	ポートオープン（メールスロット，ASCII）
		BOOL				Open					(C_WCP pRmtHost, C_WCP pRmtSlot);										//	ポートオープン（メールスロット，UNICODE）

		BOOL				Open					(C_BCP pServ, UI PortNo);												//	ポートオープン（ソケット，ASCII）
		BOOL				Open					(C_WCP pServ, UI PortNo);												//	ポートオープン（ソケット，UNICODE）

		BOOL				Open					();																		//	ポートオープン（選択済通信リソース）
		BOOL				Open					(AJCSCP_PORTSEL sel);													//	ポートオープン（初回通信リソース選択）

		BOOL				Close					();																		//	ポートクローズ
		UI					GetSelectedPort			();																		//	設定されている通信ポート種別取得
		UI					IsOpened				();																		//	ポートオープン状態取得

		BOOL				SendChar				(BC code);																//	１文字送信(ASCII)
		BOOL				SendChar				(WC code);																//	１文字送信(UNICODE)

		BOOL				SendWord14LF			(UI data);																//	バイトペアによるワード（14Bit）データ送信 (Low byte first)
		BOOL				SendWord14HF			(UI data);																//	バイトペアによるワード（14Bit）データ送信 (High byte first)

		BOOL				SetByteSeqRxWord14		(BOOL fLowByteFirst);													//	１４ビットワードデータ（バイトペア）受信時のバイト順設定
		BOOL				GetByteSeqRxWord14		();																		//	１４ビットワードデータ（バイトペア）受信時のバイト順取得

		BOOL				SendText				(C_BCP pTxt, UI lTxt = -1);												//	テキストデータ送信(ASCII)
		BOOL				SendText				(C_WCP pTxt, UI lTxt = -1);												//	テキストデータ送信(UNICODE)

		BOOL				SendTextF				(C_BCP pFmt, ...);														//	書式テキストデータ送信(ASCII)
		BOOL				SendTextF				(C_WCP pFmt, ...);														//	書式テキストデータ送信(UNICODE)

		BOOL				SendBinData				(C_VOP pDat, UI lDat);													//	バイナリデータ送信
		UI					SendPacket				(C_VOP pPkt, UI lPkt);													//	パケットデータ送信
		BOOL				SendBreak				(BOOL fBreak);															//	ブレーク信号送出／停止
		BOOL				SetEvtMask				(UI Mask);																//	イベントマスク設定
		UI					GetEvtMask				();																		//	イベントマスク取得
		BOOL				SetDTR					(BOOL fActive);															//	ＤＴＲ信号設定
		BOOL				SetRTS					(BOOL fActive);															//	ＲＴＳ信号設定
		UI					GetSigState				();																		//	信号状態取得
		ULL					GetTxBytes				();																		//	送信待ちデータバイト数取得
		BOOL				PurgeRecvData			();																		//	全受信済データ破棄
		BOOL				PurgeSendData			();																		//	全送信待ちデータ破棄
		BOOL				PurgeAllData			();																		//	全送受信データ破棄
		BOOL				SetParam				(const DCB *pDcb = NULL, const COMMTIMEOUTS *pTmo = NULL);				//	ＤＣＢ情報とタイムアウト情報設定
		UI					GetParam				(LPDCB pDcb = NULL, LPCOMMTIMEOUTS pTmo = NULL);						//	ＤＣＢ情報とタイムアウト情報取得
		BOOL				WaitEvent				(UI msTime);							//	イベント発生待ち
		BOOL				SetPktCtrlCode			(UI stx = 0, UI etx = 0, UI dle = 0);									//	パケットフレームを認識する為の制御コード設定
		BOOL				GetPktCtrlCode			(UIP pStx = NULL, UIP pEtx = NULL, UIP pDle = NULL);					//	パケットフレームを認識する為の制御コード取得
		BOOL				SetPktTimeout			(UI msTime);															//	パケットフレーム受信タイムアウト値設定
		BOOL				GetPktTimeout			(UIP pMsTime);															//	パケットフレーム受信タイムアウト値取得
		BOOL				EnableComPortSelection	(BOOL fEnableComPort);													//	通信パラメタ設定ダイアログによるＣＯＭポート の選択許可／禁止
		BOOL				EnableMailslotSelection	(BOOL fEnableMailSlot);													//	通信パラメタ設定ダイアログによるメールスロットの選択許可／禁止
		BOOL				EnableSocketSelection	(BOOL fEnableSocket);													//	通信パラメタ設定ダイアログによるソケット通信 の選択許可／禁止
		BOOL				EnablePortSelection		(BOOL fEnableComPort, BOOL fEnableMailSlot, BOOL fEnableSocket);		//	ＣＯＭポート、メールスロット，およびソケット通信の選択許可／禁止
		UI					DlgParamEasy			(HWND hWndOwner);														//	ダイアログによる通信パラメタ設定
		UI					DlgParamEasy			(HWND hWndOwner, int x, int y);											//	ダイアログによる通信パラメタ設定（ウインド位置指定）
		UI					DlgParamDetail			(HWND hWndOwner);														//	ダイアログによるＣＯＭポート通信パラメタ詳細設定
		UI					DlgParamDetailEx		(HWND hWndOwner, int x, int y);											//	ダイアログによるＣＯＭポート通信パラメタ詳細設定（ウインド位置指定）

		VO					GetPortPathName			(BCP *pPathName);														//	ポートパス名称取得(ASCII)
		VO					GetPortPathName			(WCP *pPathName);														//	ポートパス名称取得(UNICODE)

		VO					GetPortName				(BCP *pName);															//	ポート名称取得(ASCII)
		VO					GetPortName				(WCP *pName);															//	ポート名称取得(UNICODE)

		BOOL				SetChunkMode			(AJCSCP_CHUNKMODE ChunkMode);											//	チャンクデータの通知モード設定
		AJCSCP_CHUNKMODE	GetChunkMode			();																		//	チャンクデータの通知モード取得

		BOOL				SetRxTextCode			(AJCSCP_TEXTCODE code);													//	受信テキストの文字コード種別設定
		AJCSCP_TEXTCODE		GetRxTextCode			();																		//	受信テキストの文字コード種別取得

		BOOL				SetTxTextCode			(AJCSCP_TEXTCODE code);													//	送信テキストの文字コード種別設定
		AJCSCP_TEXTCODE		GetTxTextCode			();																		//	送信テキストの文字コード種別取得

		AJCSCP_TEXTCODE		GetActualRxTextCode		();																		//	実際の受信テキストの文字コード種別取得
		AJCSCP_TEXTCODE		GetActualTxTextCode		();																		//	実際の送信テキストの文字コード種別取得

		BOOL				CreateMySlot			();																		//	自メールスロット生成
		BOOL				DeleteMySlot			();																		//	自メールスロット消去
		BOOL				MySlotIsCreated			();																		//	自メールスロット生成状態取得

		VO					GetMySlotPathName		(BCP *pPathName);														//	自メールスロットのパス名取得(ASCII)
		VO					GetMySlotPathName		(WCP *pPathName);														//	自メールスロットのパス名取得(UNICODE)

		BOOL				GetMyComputerName		(BC pBuf[AJCMAX_HOSTNAME_LENGTH]);										//	自コンピュータ名取得(ASCII)
		BOOL				GetMyComputerName		(WC pBuf[AJCMAX_HOSTNAME_LENGTH]);										//	自コンピュータ名取得(UNICODE)

		BOOL				SetMailSlotNames		(C_BCP pMySlot, C_BCP pRmyHost, C_BCP pRmtSlot);						//	メールスロット名情報設定(ASCII)
		BOOL				SetMailSlotNames		(C_WCP pMySlot, C_WCP pRmyHost, C_WCP pRmtSlot);						//	メールスロット名情報設定(UNICODE)

		BOOL				GetMailSlotNames		(BC pMySlot[64], BC pRmyHost[AJCMAX_HOSTNAME_LENGTH], BC pRmtSlot[64]);	//	メールスロット名情報取得(ASCII)
		BOOL				GetMailSlotNames		(WC pMySlot[64], WC pRmyHost[AJCMAX_HOSTNAME_LENGTH], WC pRmtSlot[64]);	//	メールスロット名情報取得(UNICODE)

		BOOL				SetTxSpeedLimit			(BOOL flag, UI bps);													//	メールスロット送信制限速度の設定
		BOOL				GetTxSpeedLimit			(UIP pBps);																//	メールスロット送信制限速度の取得

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual VO	OnNtcPortState	(C_BCP pPortName, UI Param);				//	ポート状態通知(ASCII)
		virtual VO	OnNtcPortState	(C_WCP pPortName, UI Param);				//	ポート状態通知(UNICODE)

		virtual VO	OnNtcRxTextChunk(C_BCP pText);								//	テキストチャンク受信通知(ASCII)
		virtual VO	OnNtcRxTextChunk(C_WCP pText);								//	テキストチャンク受信通知(UNICODE)

		virtual VO	OnNtcRxBinChunk	(C_VOP pData, UI Bytes);					//	バイナリチャンク受信通知

		virtual VO	OnNtcRxText		(C_BCP pText);								//	テキスト受信通知(ASCII)
		virtual VO	OnNtcRxText		(C_WCP pText);								//	テキスト受信通知(UNICODE)

		virtual VO	OnNtcRxEsc		(C_BCP pData);								//	ＥＳＣシーケンス受信通知(ASCII)
		virtual VO	OnNtcRxEsc		(C_WCP pData);								//	ＥＳＣシーケンス受信通知(UNICODE)

		virtual VO	OnNtcRxCtrl		(UI Ctrl);									//	制御コード受信通知
		virtual VO	OnNtcRxPkt		(C_VOP pData, UI Bytes);					//	パケット受信通知
		virtual VO	OnNtcTxEmpty	();											//	送信完了通知

		virtual VO	OnNtcRxNoPkt	(C_BCP pText);								//	パケット外データ受信通知
		virtual VO	OnNtcRxNoPkt	(C_WCP pText);								//	パケット外データ受信通知

		virtual VO	OnNtcInvChunk	(C_VOP pData, UI lData);					//	不正テキストチャンク受信通知

		virtual VO	OnNtcErr		(UI param);									//	通信エラー発生通知
		virtual VO	OnNtcBreak		();											//	BREAK検出通知
		virtual VO	OnNtcRing		(UI param);									//	RING変化通知
		virtual VO	OnNtcRlsd		(UI param);									//	RLSD変化通知
		virtual VO	OnNtcDsr		(UI param);									//	DSR 変化通知
		virtual VO	OnNtcCts		(UI param);									//	CTS 変化通知

		virtual VO	OnNtcRxWord14	(UW data);									//	バイトペアによるワード(14Bit)受信通知

		//----- スタティック関数 -------------------------------------------------------------------------------//
		static UI			EnumSerialPorts			(UBP pMap, UI lMap, UI CurrentPort);	//	ＣＯＭポートの列挙
		static int			GetPortDevName			(C_BCP pPortName, BCP pBuf, UI lBuf);	//	ＣＯＭポートのデバイス名取得(ASCII)
		static int			GetPortDevName			(C_WCP pPortName, WCP pBuf, UI lBuf);	//	ＣＯＭポートのデバイス名取得(UNICODE)


	};
}
/****************************************************************************************************************/
#endif
