﻿#ifndef	AJXSCT_H_
#define	AJXSCT_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ソケット通信（クライアント側）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxSct {
		ATOM	m_Atom;					//	イベント通知用クラスハンドル
		HWND	m_hWndEvt;				//	イベント通知用ウインド

	public:
		HAJCSCT	m_hSct;					//	ＳＣＴインスタンスドハンドル
		BOOL	m_fUnicode;				//	UNICODEフラグ

		CAjxSct();						//	コンストラクタ
		~CAjxSct();						//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		//	回線接続
		#ifdef _CONSOLE		//	コンソールアプリ
			BOOL	Connect	(C_BCP pServ, C_BCP pPort, int AddressFamily = AF_INET, BOOL fUseWaitEvent = TRUE );	//	(ASCII)
			BOOL	Connect	(C_WCP pServ, C_WCP pPort, int AddressFamily = AF_INET, BOOL fUseWaitEvent = TRUE );	//	(UNICODE)
		#else				//	Windowsアプリ
			BOOL	Connect	(C_BCP pServ, C_BCP pPort, int AddressFamily = AF_INET, BOOL fUseWaitEvent = FALSE);	//	(ASCII)
			BOOL	Connect	(C_WCP pServ, C_WCP pPort, int AddressFamily = AF_INET, BOOL fUseWaitEvent = FALSE);	//	(UNICODE)
		#endif

		BOOL				Disconnect		(UI msTimeout = 10000);									//	回線切断

		AJCSCT_STATE		GetState		();														//	回線状態取得

		BOOL				SetChunkMode	(AJCSCT_CHUNKMODE ChunkMode);							//	チャンクデータの受信モード設定
		AJCSCT_CHUNKMODE	GetChunkMode	();														//	チャンクデータの受信モード取得

		BOOL				SetEvtMask		(UI EvtMsk);											//	イベントマスク設定
		UI		 			GetEvtMask		();														//	イベントマスク取得

		BOOL				SetRxTextCode	(AJCSCT_TEXTCODE code);									//	受信テキストの文字コード設定
		AJCSCT_TEXTCODE		GetRxTextCode	();														//	受信テキストの文字コード取得

		BOOL				SetTxTextCode	(AJCSCT_TEXTCODE code);									//	送信テキストの文字コード設定
		AJCSCT_TEXTCODE		GetTxTextCode	();														//	送信テキストの文字コード取得

		AJCSCT_TEXTCODE		GetActualRxTextCode	();													//	実際の受信テキストの文字コード取得
		AJCSCT_TEXTCODE		GetActualTxTextCode	();													//	実際の送信テキストの文字コード取得

		BOOL				WaitEvent		(UI msTime);											//	イベント発生待ち

		BOOL				SetPktCtrlCode	(UI stx = 0x02, UI etx = 0x02, UI dle = 0x10);			//	パケットフレームを認識する為の制御コード設定
		BOOL				GetPktCtrlCode	(UIP pStx = NULL, UIP pEtx = NULL, UIP pDle = NULL);	//	パケットフレームを認識する為の制御コード取得

		BOOL				SetPktTimeout	(UI msTime);											//	パケットフレーム受信タイムアウト値設定
		BOOL				GetPktTimeout	(UIP pMsTime);											//	パケットフレーム受信タイムアウト値取得

		BOOL				SendChar		(BC code);												//	１文字送信(ASCII)
		BOOL				SendChar		(WC code);												//	１文字送信(UNICODE)

		BOOL				SendText		(C_BCP pTxt, UI lTxt = -1);								//	テキストデータ送信(ASCII)
		BOOL				SendText		(C_WCP pTxt, UI lTxt = -1);								//	テキストデータ送信(UNICODE)

		BOOL				SendTextF		(C_BCP pFmt, ...);										//	書式テキスト送信(ASCII)
		BOOL				SendTextF		(C_WCP pFmt, ...);										//	書式テキスト送信(UNICODE)

		BOOL				SendBinData		(C_VOP pDat, UI lDat);									//	バイナリデータ送信
		UI					SendPacket		(C_VOP pPkt, UI lPkt);									//	パケットデータ送信

		BOOL				PurgeRecvData	();														//	全受信済データ破棄
		BOOL				PurgeSendData	();														//	全送信待ちデータ破棄
		BOOL				PurgeAllData	();														//	全送受信データ破棄

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO	OnNtcConnect	();											//	接続通知
		virtual	VO	OnNtcDisconnect	();											//	切断通知

		virtual VO	OnNtcRxTextChunk(C_BCP pText);								//	テキストチャンク受信通知(ASCII)
		virtual VO	OnNtcRxTextChunk(C_WCP pText);								//	テキストチャンク受信通知(UNICODE)

		virtual VO	OnNtcRxBinChunk	(C_VOP pData, UI Bytes);					//	バイナリチャンク受信通知

		virtual VO	OnNtcRxText		(C_BCP pText);								//	テキスト受信通知(ASCII)
		virtual VO	OnNtcRxText		(C_WCP pText);								//	テキスト受信通知(UNICODE)

		virtual VO	OnNtcRxEsc		(C_BCP pData);								//	ＥＳＣシーケンス受信通知(ASCII)
		virtual VO	OnNtcRxEsc		(C_WCP pData);								//	ＥＳＣシーケンス受信通知(UNICODE)

		virtual VO	OnNtcRxCtrl		(UI Ctrl);									//	制御コード受信通知
		virtual VO	OnNtcRxPkt		(C_VOP pData, UI Bytes);					//	パケット受信通知
		virtual VO	OnNtcTxEmpty	();											//	送信完了通知

		virtual VO	OnNtcRxNoPkt	(C_BCP pText);								//	パケット外データ受信通知(ASCII)
		virtual VO	OnNtcRxNoPkt	(C_WCP pText);								//	パケット外データ受信通知(UNICODE)

		virtual VO	OnNtcInvChunk	(C_VOP pData, UI lData);					//	不正テキストチャンク受信通知

		virtual	VO	OnNtcCnErr		(UI param);									//	接続失敗通知
		virtual VO	OnNtcRxErr		(UI param);									//	受信エラー発生通知
		virtual VO	OnNtcTxErr		(UI param);									//	送信エラー発生通知
		virtual VO	OnNtcErr		(UI param);									//	エラー発生通知

	};
}
/****************************************************************************************************************/
#endif
