﻿#ifndef	AJXSPL_H_
#define	AJXSPL_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	文字列プール																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//

namespace  AjxControl {
	class  AJXEXPORT CAjxSpl {
		BOOL	m_fUnicode;						//	UNICODE / ASCII 識別フラグ
		HAJCSPL	m_hSpl;							//	ＡＶＬインスタンスドハンドル

	public:
		#ifdef	UNICODE
			CAjxSpl(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxSpl(BOOL fUnicode = FALSE);		//	コンストラクタ(ASCII)
		#endif
		~CAjxSpl();								//	デストラクタ

		BOOL		SetCompMode		(EAJCCMPMODE CmpMode);						//	比較モード設定
		EAJCCMPMODE	GetCompMode		();											//	比較モード取得

		C_BCP			Regist		(C_BCP pStr);								//	文字列プールへ文字列登録(ASCII)
		C_WCP			Regist		(C_WCP pStr);								//	文字列プールへ文字列登録(UNICODE)

		C_BCP			Find		(C_BCP pStr);								//	文字列プールから文字列を検索(ASCII)
		C_WCP			Find		(C_WCP pStr);								//	文字列プールから文字列を検索(UNICODE)

		//	部分文字列一致検索（文字列プールから指定部分文字列が一致するノード検索）(ASCII)
		C_BCP			PartStrInPool(C_BCP pPartStr, AJCSPL_INSTROPT opt = AJCSPL_ISP_MATCHFIRST);
		//	部分文字列一致検索（文字列プールから指定部分文字列が一致するノード検索）(UNICODE)
		C_WCP			PartStrInPool(C_WCP pPartStr, AJCSPL_INSTROPT opt = AJCSPL_ISP_MATCHFIRST);

		//	部分文字列一致検索（指定文字列が文字列プール中の部分文字列と一致するかチェック）(ASCII)
		C_BCP			PoolStrInStr (C_BCP pStr	  , AJCSPL_INSTROPT opt = AJCSPL_ISP_MATCHFIRST);
		//	部分文字列一致検索（指定文字列が文字列プール中の部分文字列と一致するかチェック）(UNICODE)
		C_WCP			PoolStrInStr (C_WCP pStr	, AJCSPL_INSTROPT opt = AJCSPL_ISP_MATCHFIRST);

		BOOL			Remove		(C_BCP pStr);								//	文字列プールから文字列を削除(ASCII)
		BOOL			Remove		(C_WCP pStr);								//	文字列プールから文字列を削除(UNICODE)

		UI				GetCount	();											//	登録済文字列数取得
		BOOL			Reset  		();											//	文字列プールをリセット
		UI				EnumStr		(BOOL fDownSeq = FALSE);					//	登録済み全文字列の取得(列挙)
		HAJCAVL			GetAvlHandle();											//	ＡＶＬ２分木のハンドルを取得

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual BOOL	 OnNtcStr	(C_BCP pStr);								//	列挙文字列通知(ASCII)
		virtual BOOL	 OnNtcStr	(C_WCP pStr);								//	列挙文字列通知(UNICODE)
	};
}
/****************************************************************************************************************/
#endif
