﻿#ifndef	AJXVTH_H_
#define	AJXVTH_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＶＴ１００エミュレーション コントロール																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxVth {
		BOOL	m_fUnicode;				//	UNICODEモード識別（現状は未使用）
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル

		#ifdef UNICODE
			CAjxVth(BOOL fUnicode = TRUE);	//	コンストラクタ(UNICODE)
		#else
			CAjxVth(BOOL fUnicode = FALSE);	//	コンストラクタ(ASCII)
		#endif
		~CAjxVth();							//	デストラクタ

		BOOL		SetProp 			(PCAJCVTHPROP pProp);									//	プロパティ設定
		BOOL		GetProp 			(PAJCVTHPROP  pBuf );									//	プロパティ取得
		BOOL		GetVramFitSize		(UIP pWidth, UIP pHeight);								//	ＶＲＡＭにフィットしたウインドサイズ取得

		BOOL		PutChar				(BC c);													//	１文字描画(ASCII)
		BOOL		PutChar				(WC c);													//	１文字描画(UNICODE)

		BOOL		PutTextAuto			(C_BCP pTxt, UI lTxt = -1);								//	マルチバイト文字コードを自動判別してテキスト描画(ASCII)
		BOOL		PutTextEUC			(C_BCP pTxt, UI lTxt = -1);								//	日本語ＥＵＣコードテキスト描画					(ASCII)
		BOOL		PutTextUTF8			(C_BCP pTxt, UI lTxt = -1);								//	ＵＴＦ－８コードテキスト描画					(ASCII)

		BOOL		PutText				(C_BCP pTxt, UI lTxt = -1);								//	テキスト描画(ASCII)
		BOOL		PutText				(C_WCP pTxt, UI lTxt = -1);								//	テキスト描画(UNICODE)

		BOOL		PrintF 				(C_BCP pFmt, ...);										//	書式テキスト描画(ASCII)
		BOOL		PrintF 				(C_WCP pFmt, ...);										//	書式テキスト描画(UNICODE)

		BOOL		TimeStamp			();														//	タイムスタンプ描画
		BOOL		HexDump 			(C_VOP pDat, UI lDat);									//	バイナリデータの１６進ダンプ描画

		BOOL		Locate				(UI line, UI col);										//	カーソル位置設定
		BOOL		SetColor			(UI PaletteNo);											//	テキスト描画用パレット設定
		BOOL		SetBkColor			(UI PaletteNo);											//	文字背景描画用パレット設定
		BOOL		SetPalette			(UI PaletteNo, COLORREF rgb);							//	パレットの色コード設定

		UI			GetCursorPos		(UIP pLine, UIP pCol);									//	カーソル位置取得
		UI			GetColor			();														//	テキスト描画用パレット番号取得
		UI			GetBkColor			();														//	文字背景描画用パレット番号取得
		COLORREF	GetPalette			(UI PaletteNo);											//	パレットの色コード取得

		BOOL		Select				(UI slp, UI scp, UI elp, UI ecp);						//	部分テキストを選択
		BOOL		SelectAll			();														//	全てのテキストを選択
		BOOL		CopyText			();														//	選択テキストをクリップボードへコピー
		BOOL		SetFont 			();														//	ダイアログによるフォントの設定
		BOOL		ShowCaret			(BOOL fShow);											//	キャレット表示／非表示
		BOOL		Clear				();														//	全テキストクリアー
		BOOL		ClearAllText		();														//	〃

		BOOL		GetDroppedFile		(BC buf[MAX_PATH]);										//	ドロップされたファイル名取得(ASCII)
		BOOL 		GetDroppedFile		(WC buf[MAX_PATH]);										//	ドロップされたファイル名取得(UNICODE)

		BOOL		GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);		//	ドロップされたディレクトリ名取得(ASCII)
		BOOL		GetDroppedDir		(WC buf[MAX_PATH], BOOL fTailIsDelimiter = TRUE);		//	ドロップされたディレクトリ名取得(UNICODE)

		BOOL		LoadProp			(C_BCP pProfileSect =  "VthProp", PCAJCVTHPROPA pDefProp = NULL);	//	プロファイルからプロパティ値読出し(ASCII)
		BOOL		LoadProp			(C_WCP pProfileSect = L"VthProp", PCAJCVTHPROPW pDefProp = NULL);	//	プロファイルからプロパティ値読出し(UNICODE)

		BOOL		SaveProp			(C_BCP pProfileSect =  "VthProp");									//	プロファイルへプロパティ書き込み(ASCII)
		BOOL		SaveProp			(C_WCP pProfileSect = L"VthProp");									//	プロファイルへプロパティ書き込み(UNICODE)

		BOOL		LoadPermInfo		(C_BCP pProfileSect =  "VthPerm_*", C_BCP pKeyPrefix =	"Vth", UI PermItem = AJCVTH_PERM_FONT);	//	設定情報の読み出し(ASCII)
		BOOL		LoadPermInfo		(C_WCP pProfileSect = L"VthPerm_*", C_WCP pKeyPrefix = L"Vth", UI PermItem = AJCVTH_PERM_FONT);	//	設定情報の読み出し(UNICODE)

		BOOL		SavePermInfo		();														//	設定情報の書き込み

		BOOL		EnablePopupMenu		(BOOL fEnable);											//	右クリックによるポップアップメニューの許可／禁止
		BOOL		SetNtcRClk	   		(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);				//	右クリック通知設定

		UI			GetText				(BCP pBuf, UI lBuf);									//	テキストの取得(ASCII)
		UI			GetText				(WCP pBuf, UI lBuf);									//	テキストの取得(UNICODE)

		UI			GetSelectedText		(BCP pBuf, UI lBuf);									//	選択されているテキストの取得(ASCII)
		UI			GetSelectedText		(WCP pBuf, UI lBuf);									//	選択されているテキストの取得(UNICODE)

		UI			GetDblClickedLine	(BCP pBuf, UI lBuf);									//	ダブルクリックした行位置のテキスト取得(ASCII)
		UI			GetDblClickedLine	(WCP pBuf, UI lBuf);									//	ダブルクリックした行位置のテキスト取得(UNICODE)

		UI			GetDblClickedLine	(BCP pBuf, UI lBuf, UIP pLine, UIP pCol);				//	ダブルクリックした行位置のテキスト取得(ASCII)
		UI			GetDblClickedLine	(WCP pBuf, UI lBuf, UIP pLine, UIP pCol);				//	ダブルクリックした行位置のテキスト取得(UNICODE)

		BOOL		SetTipText			(C_BCP pTxt);											//	ツールチップの設定(ASCII)
		BOOL		SetTipText			(C_WCP pTxt);											//	ツールチップの設定(UNICODE)

		BOOL		GetTipText			(BCP pBuf, UI lBuf);									//	ツールチップの取得(ASCII)
		BOOL		GetTipText			(WCP pBuf, UI lBuf);									//	ツールチップの取得(UNICODE)

		BOOL		SetTipShowAlways	(BOOL fShowAlways);										//	ツールチップ表示条件の設定
		BOOL		GetTipShowAlways	();														//	ツールチップ表示条件の取得

		BOOL		SetFontInfo			(const LOGFONTA *pLogFont);								//	フォント情報の設定(ASCII)
		BOOL		SetFontInfo			(const LOGFONTA *pLogFont, UI LSpace);					//	フォント情報の設定(ASCII，行間スペース)

		BOOL		SetFontInfo			(const LOGFONTW *pLogFont);								//	フォント情報の設定(UNICODE)
		BOOL		SetFontInfo			(const LOGFONTW *pLogFont, UI LSpace);					//	フォント情報の設定(UNICODE，行間スペース)

		UI			GetFontInfo			(LPLOGFONTA *pBuf);										//	フォント情報の取得(ASCII)
		UI			GetFontInfo			(LPLOGFONTW *pBuf);										//	フォント情報の取得(UNICODE)

		BOOL		GetCharInfo 		(UIP pCx, UIP pCy, UIP pLy);							//	文字サイズ／行の高さ取得
		UI			GetLinesPerWindow	();														//	ウインドに表示可能な行数の取得
		UI			GetValidLines		();														//	バッファに格納されている有効な行数の取得
		UI			GetIxOfWndTopLine	();														//	ウインド先頭行の位置取得（０～）

		BOOL		SetTitleText		(C_BCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(ASCII)
		BOOL		SetTitleText		(C_WCP pTitleText, COLORREF TextColor = (COLORREF)-1, COLORREF BackColor = (COLORREF)-1, HFONT hFont = NULL);	//	タイトル文字列の設定(UNICODE)

		BOOL		SaveTextToFile		(C_BCP pPath, BOOL fAllText = TRUE, EAJCTEC tec = AJCTEC_MBC, BOOL fBom = FALSE);	//	テキストをファイルへ書き込み(ASCII)
		BOOL		SaveTextToFile		(C_WCP pPath, BOOL fAllText = TRUE, EAJCTEC tec = AJCTEC_MBC, BOOL fBom = FALSE);	//	テキストをファイルへ書き込み(UNICODE)

		BOOL		SaveHtmlToFile		(C_BCP pPath, BOOL fAllText = FALSE, UI FontSize = 3);	//	テキストをＨＴＭＬファイルへ書き込み(ASCII)
		BOOL		SaveHtmlToFile		(C_WCP pPath, BOOL fAllText = FALSE, UI FontSize = 3);	//	テキストをＨＴＭＬファイルへ書き込み(UNICODE)

		BOOL		SaveAllTextWithEsc	(C_BCP pPath, EAJCTEC tec = AJCTEC_MBC, BOOL fBom = FALSE);		//	ＥＳＣシーケンスを付加し全テキストをファイルへ書込み(ASCII)
		BOOL		SaveAllTextWithEsc	(C_WCP pPath, EAJCTEC tec = AJCTEC_MBC, BOOL fBom = FALSE);		//	ＥＳＣシーケンスを付加し全テキストをファイルへ書込み(UNICODE)

		UI			GetLineCount		();														//	バッファに格納されている行数の取得

		BOOL		GetCursorPosInfo	(UIP pLine, UIP pCol);									//	カーソル位置の行番号と桁位置取得(ASCII)

		UI			GetLineText			(UI pos, BCP pBuf, UI lBuf);							//	指定行位置の行テキスト取得(ASCII)
		UI			GetLineText			(UI pos, WCP pBuf, UI lBuf);							//	指定行位置の行テキスト取得(UNICODE)

		UI			GetVScrollPos		();														//	縦スクロール位置の取得
		UI			GetHScrollPos		();														//	横スクロール位置の取得

		BOOL		SetVScrollPos		(UI pos);												//	縦スクロール位置の設定
		BOOL		SetHScrollPos		(UI pos);												//	横スクロール位置の設定

		BOOL		GetWindowSize		(LPSIZE pSize);											//	表示ウインドサイズ（行数，文字数）取得

		UI			SearchBelow			(C_BCP pStr, BC delimiter = 0);							//	文字列の後方検索(ASCII)
		UI			SearchBelow			(C_WCP pStr, WC delimiter = 0);							//	文字列の後方検索(UNICODE)

		UI			SearchAbove			(C_BCP pStr, BC delimiter = 0);							//	文字列の前方検索(ASCII)
		UI			SearchAbove			(C_WCP pStr, WC delimiter = 0);							//	文字列の前方検索(UNICODE)

		BOOL		Pause				(BOOL fPause);											//	画面表示の停止／再開

		BOOL		SetLFActInPopupMenu	(BOOL flag);											//	改行動作の設定をポップアップメニューに含めるか否かの設定
		BOOL		GetLFActInPopupMenu	();														//	改行動作の設定をポップアップメニューに含めるか否かの取得

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO	Attach			(HWND hWnd);					//	ハンドルを関連付け

		virtual	VO	OnNtcDblClk		(UI	flag);						//	ダブルクリック通知
		virtual	VO	OnNtcKeyIn		(UI	key, UI rep);				//	キー入力通知
		virtual	VO	OnNtcVKeyIn		(UI	key, UI rep);				//	拡張キー押下通知
		virtual	VO	OnNtcVKeyOut	(UI	key);						//	拡張キー離し通知
		virtual	VO	OnNtcDropFile	(UI nFiles );					//	ファイルドロップ通知
		virtual	VO	OnNtcDropDir	(UI nDirs  );					//	ディレクトリドロップ通知
		virtual	VO	OnNtcCharInfo	(UI	height );					//	文字サイズ情報の変化通知
		virtual	VO	OnNtcHScroll	(UI	left   );					//	横スクロール通知
		virtual	VO	OnNtcVScroll	(UI	top    );					//	縦スクロール通知
		virtual	VO	OnNtcRClick		(PCAJCVTHRCLK	pRClk  );		//	右クリック通知
		virtual	VO	OnNtcClear		();								//	画面クリアー通知
	};
}
/****************************************************************************************************************/
#endif
