﻿//
//	SW_BarGraph.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>

#define 	IDC_BAR 	5000

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hWndBack;						//	バックウインドハンドル（ダイアログとVT-100の親ウインド）
HWND			hWndBar;						//	棒グラフコントロールのウインドハンドル

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wndclass;

	hInst = hInstance;

	//----- バックウインド生成 -------------------------//
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Back);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= 0;
	wndclass.hInstance		= hInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= TEXT("BarGraph01");
	RegisterClass(&wndclass);

	hWndBack = CreateWindow(TEXT("BarGraph01"), 	// window class name
							TEXT("SW_BarGraph"),	// window caption
							WS_OVERLAPPEDWINDOW,	// window style
							0,						// initial x position
							0,						// initial y position
							500,					// initial x size
							350,					// initial y size
							NULL,					// parent window handle
							NULL,					// window menu handle
							hInst,					// program instance handle
							NULL);					// creation parameters

	//----- ウインド表示 -------------------------------//
	ShowWindow(hWndBack, iCmdShow);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	バックウインド・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE 		)
{
	//----- 棒グラフコントロール生成 ---------------------------------//
	hWndBar = CreateWindowEx(	WS_EX_ACCEPTFILES,
								TEXT("AjcCtrlBarGraph"),					// window class name
								TEXT("P: I=2, BC=0x0000FF"),				// window caption
								WS_CHILD | WS_VISIBLE,						// style
								0,											// initial x position
								0,											// initial y position
								0,											// initial x size
								0,											// initial y size
								hwnd,										// parent window handle
								(HMENU)IDC_BAR, 							// window menu handle
								hInst,										// program instance handle
								NULL);										// creation parameters
	//----- タイトル設定 ---------------------------------------------//
	AjcBarSetTitleText(hWndBar, TEXT("ウインドタイトル"), -1, -1, NULL);
	//----- チップテキスト設定 ---------------------------------------//
	AjcBarSetTipText	  (hWndBar,	TEXT("棒グラフ"));
	AjcBarSetChkBoxTipText(hWndBar, 0, TEXT("データ０"));
	AjcBarSetChkBoxTipText(hWndBar, 1, TEXT("データ１"));
	//----- 横線設定 -------------------------------------------------//
	AjcBarSetHLineAtt(hWndBar, 0, RGB(255, 0, 0), 1, AJCBAR_DOT);
	AjcBarSetHLinePos(hWndBar, 0, 60.0);
	AjcBarEnableHLine(hWndBar, 0, TRUE);
	//----- プロファイルからプロパティ値読み出し ---------------------//
	AjcBarLoadProp(hWndBar, TEXT("BarGraph"), NULL);
	//----- 最大データ数設定 -----------------------------------------//
	AjcBarSetBufSize(hWndBar, 100);
	//----- スケール値表示域の幅設定 ---------------------------------//
	AjcBarSetScaleWidth(hWndBar, 40);
	//----- 棒タイトル行数設定 ---------------------------------------//
	AjcBarSetTtlLines	(hWndBar, 3);
	//----- 縦軸の単位名設定 -----------------------------------------//
	AjcBarSetVUnit(hWndBar, TEXT("[％]"));
	//----- 棒タイトル名設定 -----------------------------------------//
	AjcBarSetBarTtl(hWndBar, TEXT("年\n月\n日"));
	//----- 棒間の幅設定 ---------------------------------------------//
	AjcBarSetItemWidth(hWndBar, 40);
	//----- テキスト描画 ---------------------------------------------//
	AjcBarTextOut(hWndBar, AJCTXO_CENTER, 3, TEXT("\x1B[30m■去年  \x1B[31m■今年"));
	//----- ウインド表示 ---------------------------------------------//
	ShowWindow(hWndBar , SW_SHOW);
	//----- データ投与タイマ起動 -------------------------------------//
	SetTimer(hwnd, 1, 200, NULL);

	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY		)
{
	//----- プロファイルへプロパティ値を記録 -------------------------//
	AjcBarSaveProp(hWndBar, TEXT("BarGraph"));
	//----- プログラム終了 -------------------------------------------//
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE			)
{
	UI	width  = LOWORD(lParam);
	UI	height = HIWORD(lParam);

	//----- 棒グラフウインド移動 ----------------------------//
	MoveWindow(hWndBar , 0, 0, width, height, FALSE);

	return 0;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_TIMER			)
{
	static	int yy = 2019, mm = 7, dd = 1;
	static	UI	Count = 0;
	int 	data[2];
	UT		txt[32];

	if (++Count <= 80) {
		data[0] = Count;
		data[1] = Count + 10;
		AjcSnPrintF(txt, sizeof txt, TEXT("%d\n%d\n%d"), yy, mm, dd);
		AjcBarPutIntData(hWndBar, data, txt);
		if (++dd > 31) {
			dd = 1;
			mm++;
		}
	}
	else {
		KillTimer(hwnd, 1);
	}
	return 0;
}
//----- 棒グラフコントロールからの通知 -------------------------------------------------------------------------//
AJC_WNDPROC(Back, IDC_BAR			)
{
	switch (HIWORD(wParam)) {
		case AJCBARN_RANGE: 		//	●グラフレンジ通知		lParam : PAJCBAR_NTC_RANGE
			break;

		case AJCBARN_SCRPOS:		//	●スクロール位置通知	lParam : クスロール位置
			break;

		case AJCBARN_RCLICK:		//	●右クリック
		{	PAJCBARRCLK	p = (PAJCBARRCLK)lParam;
			UT			txt[64] = {0};
			AjcSnPrintF(txt, 64, TEXT("%s%s右クリック発生(x = %d, y = %d)"), p->fShift ? TEXT("Shift+") : TEXT(""),
																			 p->fCtrl  ? TEXT("Ctrl+" ) : TEXT(""),
																			 p->x, p->y);
			MessageBox(hwnd, txt, TEXT("SW_BarGraph"), MB_OK);
			break;
		}
		case AJCBARN_DROPDIR:		//	●ディレクトリドロップ
		{	UT		path[MAX_PATH];
			UT		txt[4096];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- Dir dropped --\n"));
			while (AjcBarGetDroppedDir(hWndBar, path)) {
				MAjcStrCat(txt, AJCTSIZE(txt), path);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hwnd, txt, TEXT("Dropped Dir"), MB_OK);
			break;
		}
		case AJCBARN_DROPFILE:		//	●ファイルドロップ
		{	UT		path[MAX_PATH];
			UT		txt[4096];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- File dropped --\n"));
			while (AjcBarGetDroppedFile(hWndBar, path)) {
				MAjcStrCat(txt, AJCTSIZE(txt), path);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hwnd, txt, TEXT("Dropped File"), MB_OK);
			break;
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE	   )
	AJC_WNDMAP_MSG(Back, WM_DESTROY    )
	AJC_WNDMAP_MSG(Back, WM_SIZE	   )
	AJC_WNDMAP_MSG(Back, WM_TIMER	   )
	AJC_WNDMAP_CMD(Back, IDC_BAR	   )
AJC_WNDMAP_END
