﻿// SW_Ctk02C.c
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<tchar.h>

//==============================================================================================================//
//	ソーステキスト読み出し																						//
//																												//
//	引　数	：	pBuf	- ソーステキストを格納するバッファのアドレス											//
//				lBif	- ソーステキストを格納するバッファの文字数												//
//				xp		- コールバックパラメタ																	//
//																												//
//	戻り値	：	TRUE  - 有効なテキストを読み出した																//
//				FALSE - ＥＯＦ																					//
//==============================================================================================================//
static BOOL CALLBACK cbGetLine(UTP pBuf, UI lBuf, UX xp)
{
	return _fgetts(pBuf, lBuf, (FILE *)xp) != NULL;
}

//==============================================================================================================//
//																												//
//	m a i n 																									//
//																												//
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	FILE	*hFile;
	HAJCTK	hCtk;
	UI		tc, flg;
	UT		txt[256];

	AjcSetStdoutMode();

	do {
		//----- コマンドパラメタ チェック --------------------//
		if (argc <= 1) {
			AjcPrintF(TEXT("No source file name\n"));
			break;
		}
		//----- ソースファイル オープン ----------------------//
		if (_tfopen_s(&hFile, argv[1], TEXT("rt")) != 0) {
			AjcPrintF(TEXT("File %s open failure\n"), argv[1]);
			break;
		}
		//----- ヘッダテキスト出力 ---------------------------//
		AjcPrintF(TEXT("      S U R  V S P D  S  P P  M M M M  N W               \n"));
		AjcPrintF(TEXT("      Y S S  A T A E  P  R P  A A A A  X I               \n"));
		AjcPrintF(TEXT("      M R V  L R T L  A  E T  C C C C  T D               \n"));
		AjcPrintF(TEXT("      B S S  U I H I  C  P O  N W A B  S E               \n"));
		AjcPrintF(TEXT("      O Y Y  E N N M  E  R P  A I R O  P C               \n"));
		AjcPrintF(TEXT("      L M M  | G A I  |  O |  M T G D  C H               \n"));
		AjcPrintF(TEXT("      | | |  | | M T  |  | |  E H | Y  | A               \n"));
		AjcPrintF(TEXT("      | | |  | | E |  |  | |  | A | |  | R               \n"));
		AjcPrintF(TEXT("Token | | |  | | | |  |  | |  | R | |  | |               \n"));
		AjcPrintF(TEXT("Code  | | |  | | | |  |  | |  | G | |  | |  TokenString  \n"));
		AjcPrintF(TEXT("\n"));
		//----- トークン情報出力 ----------------------------//
		hCtk = AjcCtkCreate(AJCTKFLG_CPLUSPLUS | AJCTKFLG_DOTSYMBOL | AJCTKFLG_ASMHEX, cbGetLine, (UX)hFile);
		while (AjcCtkGetToken(hCtk, txt, sizeof txt)) {
			tc = AJCTK_TOKEN(hCtk);
			AjcPrintF(TEXT("%04X  "), tc);
			AjcPrintF(AJCTKIS_SYMBOL  (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(AJCTKIS_USRSYM  (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(AJCTKIS_RSVSYM  (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT("  "));
			AjcPrintF(AJCTKIS_VALUE   (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(AJCTKIS_STRING  (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(AJCTKIS_PATHNAME(tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(AJCTKIS_DELIMIT (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT("  "));
			AjcPrintF(AJCTKIS_SPACE   (tc)	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT("  "));
			flg = AJCTK_FLAG(hCtk);
			AjcPrintF(flg & AJCTKF_PREPRO	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(flg & AJCTKF_PPTOP	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT("  "));
			AjcPrintF(flg & AJCTKF_MACNAME	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(flg & AJCTKF_MACWITHARG ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(flg & AJCTKF_MACARG	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(flg & AJCTKF_MACBODY	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT("  "));
			AjcPrintF(flg & AJCTKF_NXTSPC	  ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT(" "));
			AjcPrintF(flg & AJCTKF_WIDECHAR   ? TEXT("1") : TEXT("."));
			AjcPrintF(TEXT("   "));

			AjcPrintF(TEXT("%s\n"), txt);
		}
		//----- インスタンス消去 -----------------------------//
		AjcCtkDelete(hCtk);
		//----- ソースファイル クローズ ----------------------//
		fclose(hFile);

	} while(0);

	AjcPrintF(TEXT("Hit Enter Key!"));
	getchar();

	return 0;
}
