﻿//
//	SW_DateAndTime1.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	SYSTEMTIME		SysTime;						//	SYSTEMTIME構造体領域
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 						)
{
	hDlgMain = hDlg;
	//	テキスト長制限
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_DLMDATE, 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_DLMTIME, 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_DLMMS  , 1);
	//	デフォルト設定
	AjcSetDlgItemChk(hDlg, IDC_RBT_AjcSetDateFromText, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_DATEFLAG_YYMMDD	 , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_DATEFLAG_ADJUST	 , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_DATEFLAG_SETDEF	 , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_DATEFLAG_SETDOW	 , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_TIMEFLAG_ADJUST	 , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_TIMEFLAG_SETDEF	 , TRUE);
	AjcSetDlgItemStr(hDlg, IDC_TXT_DLMDATE			 , TEXT("/"));
	AjcSetDlgItemStr(hDlg, IDC_TXT_DLMTIME			 , TEXT(":"));
	AjcSetDlgItemStr(hDlg, IDC_TXT_DLMMS			 , TEXT("."));
	//	設定値ロード
	AjcLoadAllControlSettings(hDlg, TEXT("MySect"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCRBT);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY							)
{
	//	設定値セーブ
	AjcSaveAllControlSettings(hDlg);
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL								)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- ラジオボタン（IDC_RBT_AjcSetDateFromText）--------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_AjcSetDateFromText			)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLG, FALSE, FALSE);
	return TRUE;
}
//----- ラジオボタン（IDC_RBT_AjcSetTimeFromText）--------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_AjcSetTimeFromText			)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLG, FALSE, FALSE);
	return TRUE;
}
//----- ラジオボタン（IDC_RBT_AjcSetDateAndTimeFromText）-------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_AjcSetDateAndTimeFromText		)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLG, FALSE, FALSE);
	return TRUE;
}
//----- ラジオボタン（IDC_RBT_AjcSetDateFromTextEx）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_AjcSetDateFromTextEx			)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLG    , TRUE , TRUE );
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLGDATE, TRUE , TRUE );
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLGTIME, FALSE, FALSE);
	return TRUE;
}
//----- ラジオボタン（IDC_RBT_AjcSetTimeFromTextEx）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_AjcSetTimeFromTextEx			)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLG    , TRUE , TRUE );
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLGDATE, FALSE, FALSE);
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLGTIME, TRUE , TRUE );
	return TRUE;
}
//----- ラジオボタン（IDC_RBT_AjcSetDateAndTimeFromTextEx）-----------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_AjcSetDateAndTimeFromTextEx	)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_FLG    , TRUE , TRUE );
	return TRUE;
}
//----- 構造体に日時設定ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETSYSTEMTIME					)
{
	UT		txt[256];

	SysTime.wYear		  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_YEAR		);
	SysTime.wMonth		  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_MONTH		);
	SysTime.wDay		  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_DAY			);
	SysTime.wDayOfWeek	  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_DAYOFWEEK	);
	SysTime.wHour		  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_HOUR		);
	SysTime.wMinute		  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_MINUTE		);
	SysTime.wSecond		  = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_SECOND		);
	SysTime.wMilliseconds = (UW)AjcGetDlgItemUInt(hDlg, IDC_TXT_MS			);

	AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("出力用の構造体領域に日時\n(%04d/%02d/%02d (曜日=%d), %02d:%02d:%02d.%03d)を設定しました。"), 
				SysTime.wYear, SysTime.wMonth, SysTime.wDay, SysTime.wDayOfWeek,
				SysTime.wHour, SysTime.wMinute, SysTime.wSecond, SysTime.wMilliseconds);
	AjcTipTextShowCenter(hDlg , txt, 5000, NULL);

	return TRUE;
}
//----- 実行ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK									)
{
	UI		flg = 0;
	UT		dlmDate[16];
	UT		dlmTime[16];
	UT		dlmMs  [16];
	UTP		pNext;
	UT		txt[256];
	BOOL	rsu;

	if (AjcGetDlgItemChk(hDlg, IDC_RBT_DATEFLAG_YYMMDD	))	flg |= AJCDATEFLAG_YYMMDD;
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_DATEFLAG_MMDDYY	))	flg |= AJCDATEFLAG_MMDDYY;
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_DATEFLAG_DDMMYY	))	flg |= AJCDATEFLAG_DDMMYY;
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_DATEFLAG_MMYYDD	))	flg |= AJCDATEFLAG_MMYYDD;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_DATEFLAG_ADJUST	))	flg |= AJCDATEFLAG_ADJUST;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_DATEFLAG_SETDEF	))	flg |= AJCDATEFLAG_SETDEF;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_DATEFLAG_SETDOW	))	flg |= AJCDATEFLAG_SETDOW;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TIMEFLAG_ADJUST	))	flg |= AJCTIMEFLAG_ADJUST;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TIMEFLAG_SETDEF	))	flg |= AJCTIMEFLAG_SETDEF;
	AjcGetDlgItemStr(hDlg, IDC_TXT_DLMDATE, dlmDate, AJCTSIZE(dlmDate));
	AjcGetDlgItemStr(hDlg, IDC_TXT_DLMTIME, dlmTime, AJCTSIZE(dlmTime));
	AjcGetDlgItemStr(hDlg, IDC_TXT_DLMMS  , dlmMs  , AJCTSIZE(dlmMs  ));

	AjcGetDlgItemStr(hDlg, IDC_TXT_INP, txt, AJCTSIZE(txt));

	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_AjcSetDateFromText		   )) rsu = AjcSetDateFromText	 	   (txt, &SysTime, &pNext);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_AjcSetDateFromTextEx	   )) rsu = AjcSetDateFromTextEx 	   (txt, &SysTime, &pNext, flg, dlmDate[0]);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_AjcSetTimeFromText		   )) rsu = AjcSetTimeFromText 		   (txt, &SysTime, &pNext);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_AjcSetTimeFromTextEx	   )) rsu = AjcSetTimeFromTextEx	   (txt, &SysTime, &pNext, flg, dlmTime[0], dlmMs[0]);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_AjcSetDateAndTimeFromText  )) rsu = AjcSetDateAndTimeFromText  (txt, &SysTime, &pNext);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_AjcSetDateAndTimeFromTextEx)) rsu = AjcSetDateAndTimeFromTextEx(txt, &SysTime, &pNext, flg, dlmDate[0], dlmTime[0], dlmMs[0]);

	AjcSetDlgItemUInt(hDlg, IDC_TXT_YEAR		, SysTime.wYear);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_MONTH		, SysTime.wMonth);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_DAY			, SysTime.wDay);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_DAYOFWEEK	, SysTime.wDayOfWeek);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_HOUR		, SysTime.wHour);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_MINUTE		, SysTime.wMinute);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_SECOND		, SysTime.wSecond);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_MS			, SysTime.wMilliseconds);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_RC			, rsu);

	if (pNext != NULL) {
		UX loc = (UX)pNext - (UX)txt;
		AjcSetDlgItemUInt(hDlg, IDC_TXT_LOC		, (UI)loc);
		AjcSetDlgItemStr (hDlg, IDC_TXT_PNEXT	, pNext);
	}
	else {
		AjcSetDlgItemStr (hDlg, IDC_TXT_PNEXT	, TEXT(""));
	}

	return TRUE;
}


//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG						)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 						)

	AJC_DLGMAP_CMD(Main, IDCANCEL							)
	AJC_DLGMAP_CMD(Main, IDC_RBT_AjcSetDateFromText			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_AjcSetTimeFromText			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_AjcSetDateAndTimeFromText	)
	AJC_DLGMAP_CMD(Main, IDC_RBT_AjcSetDateFromTextEx		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_AjcSetTimeFromTextEx		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_AjcSetDateAndTimeFromTextEx)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETSYSTEMTIME				)
	AJC_DLGMAP_CMD(Main, IDOK								)
AJC_DLGMAP_END

