﻿//
//	SW_DateAndTime3.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//	ファイルタイム
typedef union {
	FILETIME  ft;
	long long v;
} UFT;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVthLog;						//	ログウインドハンドル
static	UT				TopDir[MAX_PATH];				//	検索フォルダ
static	UT				WildCard[256];					//	ワイルドカード
static	SYSTEMTIME		stLo, stHi;						//	日時範囲
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static BOOL CALLBACK cbFind(UI nest, UTP pPath, UTP pName, UI attrib, UI wtime, UX cbp);
static	VO			 SetTimeStamp(C_UTP pPath, BOOL fAbleToSetStamp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	SYSTEMTIME	st;

	hDlgMain = hDlg;
	hVthLog  = GetDlgItem(hDlg, IDC_VTH_LOG);

	//	チップテキスト設定
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_TOPDIR	), TEXT("ファイルやフォルダのタイムスタンプを設定する最上位フォルダを指定します。"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_SETTOPDIR), TEXT("「検索するフォルダ」で指定したフォルダのタイムスタンプを設定します。"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_WILD 	), TEXT("設定対象となるファイルやフォルダの名称をワイルドカードで指定します。\n")
													   TEXT("複数指定する場合はセミコロン(;)で区切ります。(ex. *.txt;*.pdf)\n")
													   TEXT("いずれのファイルやフォルダも検索しない場合は、空白とします。"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_SET_STAMP), TEXT("タイムスタンプの設定を行います。\n")
													   TEXT("未チェックの場合は、タイムスタンプの設定は行わずに\n")
													   TEXT("検索したファイル／フォルダとタイムスタンプ値の表示のみ行います。"));
	//	フォルダドロップ許可
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_TOPDIR, AJCDROP_DIR);
	//	デフォルト設定
	AjcSetDlgItemStr (hDlg, IDC_TXT_WILD	, TEXT("*.*"));
	AjcSetDlgItemChk (hDlg, IDC_CHK_SETFILE , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_RAND	, TRUE);
	AjcSetDlgItemStr (hDlg, IDC_TXT_DATE_L	, TEXT("2000/01/01"));
	GetLocalTime(&st);
	AjcSetDlgItemStr (hDlg, IDC_TXT_DATE_H	, AjcDateStr(&st));
	AjcSetDlgItemStr (hDlg, IDC_TXT_TIME_L	, TEXT("00:00:00.000"));
	AjcSetDlgItemStr (hDlg, IDC_TXT_TIME_H	, TEXT("23:59:59.999"));
	//	ダイアログ設定値ロード
	AjcLoadAllControlSettings (hDlg, TEXT("MySect"), AJCOPT2(AJCCTL_SELACT_, ALL, NTCALL));
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ダイアログ設定値セーブ
	AjcSaveAllControlSettings(hDlg);
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- ワイルドカード -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_TXT_WILD		)
{
	UT		txt[256];

	AjcGetDlgItemStr(hDlg, IDC_TXT_WILD, txt, AJCTSIZE(txt));
	if (txt[0] == 0) AjcEnableDlgGroup(hDlg, IDC_GRP_CHKS, FALSE, FALSE);
	else			 AjcEnableDlgGroup(hDlg, IDC_GRP_CHKS, TRUE , TRUE );
	return TRUE;
}
//----- ラジオボタン（ランダム日時）----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_RAND		)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_H, TRUE , TRUE );
	return TRUE;
}
//----- ラジオボタン（固定日時）--------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_FIX		)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_H, FALSE, FALSE);
	return TRUE;
}
//----- 実行ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK				)
{
	UT		txt[256];
	UT		szDateL[64], szDateH[64];
	UT		szTimeL[64], szTimeH[64];

	do {
		//	フォルダパス設定有無チェック
		AjcGetDlgItemStr(hDlg, IDC_TXT_TOPDIR, TopDir, AJCTSIZE(TopDir));
		//	フォルダ有無チェック
		if (!AjcPathIsDirectory(TopDir)) {
			AjcTipTextShowCenter(hDlg, TEXT("\x1B[31m指定したフォルダが存在しません。"), 5000, NULL);
			break;
		}
		//	ワイルドカード設定
		AjcGetDlgItemStr(hDlg, IDC_TXT_WILD, WildCard, AJCTSIZE(WildCard));
		//	日時範囲デフォルト設定
		GetLocalTime(&stHi);
		stLo.wYear		   = 2000;
		stLo.wMonth 	   = 1;
		stLo.wDay		   = 1;
		stLo.wHour		   = 0;		stHi.wHour		   = 23;
		stLo.wMinute	   = 0;		stHi.wMinute	   = 59;
		stLo.wSecond	   = 0;		stHi.wSecond	   = 59;
		stLo.wMilliseconds = 0;		stHi.wMilliseconds = 999;
		//	開始日付設定
		AjcGetDlgItemStr(hDlg, IDC_TXT_DATE_L, txt, AJCTSIZE(txt));
		if (AjcSetDateFromText(txt, &stLo, NULL)) {
			AjcSetDlgItemStr(hDlg, IDC_TXT_DATE_L, AjcStrCpy(szDateL, AJCTSIZE(szDateL), AjcDateStr(&stLo)));
		}
		else {
			AjcTipTextShowCenter(hDlg, TEXT("\x1B[31m開始日付に誤りがあります。"), 5000, NULL);
			break;
		}
		//	開始時刻設定
		AjcGetDlgItemStr(hDlg, IDC_TXT_TIME_L, txt, AJCTSIZE(txt));
		if (AjcSetTimeFromText(txt, &stLo, NULL)) {
			AjcSetDlgItemStr(hDlg, IDC_TXT_TIME_L, AjcStrCpy(szTimeL, AJCTSIZE(szTimeL), AjcTimeStr(&stLo, TRUE)));
		}
		else {
			AjcTipTextShowCenter(hDlg, TEXT("\x1B[31m開始時刻に誤りがあります。"), 5000, NULL);
			break;
		}
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_RAND)) {
			//	終了日付設定
			AjcGetDlgItemStr(hDlg, IDC_TXT_DATE_H, txt, AJCTSIZE(txt));
			if (AjcSetDateFromText(txt, &stHi, NULL)) {
				AjcSetDlgItemStr(hDlg, IDC_TXT_DATE_H, AjcStrCpy(szDateH, AJCTSIZE(szDateH), AjcDateStr(&stHi)));
			}
			else {
				AjcTipTextShowCenter(hDlg, TEXT("\x1B[31m終了日付に誤りがあります。"), 5000, NULL);
				break;
			}
			//	終了時刻設定
			AjcGetDlgItemStr(hDlg, IDC_TXT_TIME_H, txt, AJCTSIZE(txt));
			if (AjcSetTimeFromText(txt, &stHi, NULL)) {
				AjcSetDlgItemStr(hDlg, IDC_TXT_TIME_H, AjcStrCpy(szTimeH, AJCTSIZE(szTimeH), AjcTimeStr(&stHi, TRUE)));
			}
			else {
				AjcTipTextShowCenter(hDlg, TEXT("\x1B[31m終了時刻に誤りがあります。"), 5000, NULL);
				break;
			}
		}
		//	実行確認
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_RAND)) {
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("日付 = %s ～ %s, 時刻 = %s ～ %s\nの範囲のランダムなタイムスタンプを%sします。\n\n")
											TEXT("よろしいですか？"), szDateL, szDateH,
																	  szTimeL, szTimeH,
											AjcGetDlgItemChk(hDlg, IDC_CHK_SET_STAMP) ? TEXT("設定") : TEXT("表示"));
		}
		else {
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("タイムスタンプ ( %s %s ) を%sします。\n\n")
											TEXT("よろしいですか？"), szDateL, szTimeL, 
											AjcGetDlgItemChk(hDlg, IDC_CHK_SET_STAMP) ? TEXT("設定") : TEXT("表示"));
		}
		if (MessageBox(hDlg, txt, TEXT("SW_DateAndTime3"), MB_YESNO) == IDYES) {
			//	ログクリアー
			AjcVthClear(hVthLog);
			//	検索フォルダのタイムスタンプ設定
			SetTimeStamp(TopDir, AjcGetDlgItemChk(hDlg, IDC_CHK_SETTOPDIR));
			//	実行（ファイル検索）
			if (WildCard[0] != 0) {
				AjcSearchFilesEx(TopDir, WildCard, AjcGetDlgItemChk(hDlg, IDC_CHK_SUBDIR), TRUE, 0, cbFind);
				AjcVthPrintF(hVthLog, TEXT("\x1B[0m"));
				SetFocus(GetDlgItem(hDlg, IDC_VTH_LOG));
			}
		}
	} while (0);
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )

	AJC_DLGMAP_CMD(Main, IDC_TXT_WILD	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_RAND	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_FIX	   )
	AJC_DLGMAP_CMD(Main, IDOK			   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	ファイル／フォルダ検索通知																					//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbFind(UI nest, UTP pPath, UTP pName, UI attrib, UI wtime, UX cbp)
{
	//	検索中のフォルダ通知
	if (nest == -1) {
	}
	//	検索したファイル／フォルダ通知
	else {
		SetTimeStamp(pPath, ( (attrib & _A_SUBDIR) && AjcGetDlgItemChk(hDlgMain, IDC_CHK_SETDIR )) ||
							(!(attrib & _A_SUBDIR) && AjcGetDlgItemChk(hDlgMain, IDC_CHK_SETFILE)));
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
//	タイムスタンプ設定																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SetTimeStamp(C_UTP pPath, BOOL fAbleToSetStamp)
{
	SYSTEMTIME	stStamp;
	C_UTP		pszColor = TEXT("");	//	表示色

	//	タイムスタンプ値設定
	if (AjcGetDlgItemChk(hDlgMain, IDC_RBT_RAND)) {
		AjcGetRandomDateAndTime (&stStamp, &stLo, &stHi);
	}
	else {
		memcpy(&stStamp, &stLo, sizeof(SYSTEMTIME));
	}

	if (fAbleToSetStamp && AjcGetDlgItemChk(hDlgMain, IDC_CHK_SET_STAMP)) {
		//	タイムスタンプ設定
		if (AjcSetFileTimeBySysTime(pPath, &stStamp, TRUE)) pszColor = TEXT("\x1B[34m");//	青表示（タイムスタンプ設定成功）
		else												pszColor = TEXT("\x1B[31m");//	赤表示（タイムスタンプ設定失敗）
	}
	else pszColor = TEXT("\x1B[0m");													//	黒表示（タイムスタンプ未設定）

	//	タイムスタンプとパス名表示
	AjcVthPrintF(hVthLog, TEXT("%s%04d/%02d/%02d %02d:%02d:%02d.%03d - %s\n"), pszColor, stStamp.wYear, stStamp.wMonth, stStamp.wDay,
														 stStamp.wHour, stStamp.wMinute, stStamp.wSecond, stStamp.wMilliseconds, pPath);
}
