﻿//
//	SW_DlgColor.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HMENU			hMenuBar;
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVth;
static	HWND			hLbx;
static	HBITMAP			hBmp1, hBmp2, hBmp3, hBmp4, hBmp5, hBmp6;
static	HBRUSH			hBruCtrl;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO		EvtLog(HWND hDlg, WPARAM wParam, LPARAM lParam, HWND hVth);
static	UI		IsAssociatedComboBox(LPARAM lParam, HWND hWndCbo);
static	UI		WndDistance(LPARAM lParam, HWND hW2);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 			msg;

	hInst = hInstance;

	//----- 描画色設定 ---------------------------------//
	AjcDgcSetup();
	AjcDgcSetColors (RGB(255, 240, 255), RGB(0, 0, 192));

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hVth	 = GetDlgItem(hDlg, IDC_VTH);
	hLbx	 = GetDlgItem(hDlg, IDC_LBX_OWN);

	hBruCtrl = CreateSolidBrush(RGB(255, 255, 225));
	hBmp1 = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP1));
	hBmp2 = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP2));
	hBmp3 = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP3));
	hBmp4 = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP4));
	hBmp5 = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP5));
	hBmp6 = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP6));
	AjcSetDlgItemChk(hDlg, IDC_CHK_ENA_DIS, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT4 	  , TRUE);

	AjcSetDlgItemStr(hDlg, IDC_TXT, TEXT("IDC_TXT"));

	//	リストボックス／コンボボックスに項目追加
	AjcSetDlgItemLstList(hDlg, IDC_LST_STD	   , TEXT("STD-001\0STD-002\0STD-003\0STD-004\0STD-005\0STD-006\0"));
	AjcLbxSetList		(hLbx				   , TEXT("OWN-001\0OWN-002\0OWN-003\0OWN-004\0OWN-005\0OWN-006\0"));
	AjcSetDlgItemCboList(hDlg, IDC_CBO_STD_DDL , TEXT("STD-010\0STD-020\0STD-030\0STD-040\0STD-050\0STD-060\0"));
	AjcSetDlgItemCboList(hDlg, IDC_CBO_STD_DD  , TEXT("STD-100\0STD-200\0STD-300\0STD-400\0STD-500\0STD-600\0"));
	AjcSetDlgItemCboList(hDlg, IDC_CBO_OWN_DDL , TEXT("OWN-010\0OWN-020\0OWN-030\0OWN-040\0OWN-050\0OWN-060\0"));
	AjcSetDlgItemCboList(hDlg, IDC_CBO_OWN_DD  , TEXT("OWN-100\0OWN-200\0OWN-300\0OWN-400\0OWN-500\0OWN-600\0"));

	//	リストボックス／コンボボックス リスト項目の高さ設定
	AjcSetDlgItemLstHeight(hDlg, IDC_LST_STD, 0, 0);		AjcSetDlgItemLstIx(hDlg, IDC_LST_STD, 0);
	AjcLbxSetItemHeight   (hLbx 			, 0, 0);		AjcLbxSetCurSel(hLbx				, 0);
	AjcSetDlgItemCboHeight(hDlg, IDC_CBO_STD_DDL, 0, 0);	AjcSetDlgItemCboIx(hDlg, IDC_CBO_STD_DDL, 0);
	AjcSetDlgItemCboHeight(hDlg, IDC_CBO_STD_DD , 0, 0);	AjcSetDlgItemCboIx(hDlg, IDC_CBO_STD_DD , 0);
	AjcSetDlgItemCboHeight(hDlg, IDC_CBO_OWN_DDL, 0, 0);	AjcSetDlgItemCboIx(hDlg, IDC_CBO_OWN_DDL, 0);
	AjcSetDlgItemCboHeight(hDlg, IDC_CBO_OWN_DD , 0, 0);	AjcSetDlgItemCboIx(hDlg, IDC_CBO_OWN_DD , 0);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	DeleteObject(hBruCtrl);
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND	 	)
{
	HWND	hCtrl = GetDlgItem(hDlg, LOWORD(wParam));
	UT		cname[256];

	GetClassName(hCtrl, cname, 256);
	if (_tcscmp(cname, TEXT("Button")) == 0) {
		EvtLog(hDlg, wParam, lParam, GetDlgItem(hDlg, IDC_VTH));
		SetTimer(hDlg, 1, 300, NULL);
	}
	return TRUE;
}
//----- WM_RBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_RBUTTONDOWN	)
{
	HMENU		hMenu	 = NULL;
	HMENU		hMTxt, hMBmp;
	HMENU		hPopup	 = NULL;
	int			id;
	POINT		pt;

	hMenu  = LoadMenu(hInst, MAKEINTRESOURCE(IDR_MENU1));
	hMTxt = CreatePopupMenu();
	InsertMenu(hMTxt, 0, MF_BYPOSITION | MFT_OWNERDRAW 												 , 5001, TEXT("\x1B[TNormal"));
	InsertMenu(hMTxt, 1, MF_BYPOSITION | MFT_OWNERDRAW 					| MFS_CHECKED				 , 5002, TEXT("CHK"));
	InsertMenu(hMTxt, 2, MF_BYPOSITION | MFT_OWNERDRAW | MFT_RADIOCHECK | MFS_CHECKED				 , 5003, TEXT("RBT"));
	InsertMenu(hMTxt, 3, MF_BYPOSITION | MF_SEPARATOR										   		 ,	  0, NULL 		);
	InsertMenu(hMTxt, 4, MF_BYPOSITION | MFT_OWNERDRAW 								  | MFS_DISABLED , 5004, TEXT("DIS"));
	InsertMenu(hMTxt, 5, MF_BYPOSITION | MFT_OWNERDRAW 					| MFS_CHECKED | MFS_DISABLED , 5005, TEXT("CHK, DIS"));
	InsertMenu(hMTxt, 6, MF_BYPOSITION | MFT_OWNERDRAW | MFT_RADIOCHECK | MFS_CHECKED | MFS_DISABLED , 5006, TEXT("RBT. DIS"));
	hMBmp = CreatePopupMenu();
	InsertMenu(hMBmp, 0, MF_BYPOSITION | MFT_OWNERDRAW 												 , 5011, (UTP)hBmp1);
	InsertMenu(hMBmp, 1, MF_BYPOSITION | MFT_OWNERDRAW 					| MFS_CHECKED				 , 5012, (UTP)hBmp2);
	InsertMenu(hMBmp, 2, MF_BYPOSITION | MFT_OWNERDRAW | MFT_RADIOCHECK | MFS_CHECKED				 , 5013, (UTP)hBmp3);
	InsertMenu(hMBmp, 3, MF_BYPOSITION | MF_SEPARATOR										   		 ,	  0, NULL 	   );
	InsertMenu(hMBmp, 4, MF_BYPOSITION | MFT_OWNERDRAW 								  | MFS_DISABLED , 5014, (UTP)hBmp4);
	InsertMenu(hMBmp, 5, MF_BYPOSITION | MFT_OWNERDRAW 					| MFS_CHECKED | MFS_DISABLED , 5015, (UTP)hBmp5);
	InsertMenu(hMBmp, 6, MF_BYPOSITION | MFT_OWNERDRAW | MFT_RADIOCHECK | MFS_CHECKED | MFS_DISABLED , 5016, (UTP)hBmp6);
	hPopup = CreatePopupMenu();
	InsertMenu(hPopup, 0, MF_BYPOSITION  |MFT_OWNERDRAW | MF_POPUP, (UX)hMTxt, TEXT("Text Menu"));
	InsertMenu(hPopup, 1, MF_BYPOSITION | MFT_OWNERDRAW | MF_POPUP , (UX)hMBmp, (UTP)hBmp1);
	GetCursorPos(&pt);
	id = AjcDgcTrackPopupMenuEx(hPopup, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hDlg, NULL);
	DestroyMenu(hPopup);
	DestroyMenu(hMenu);
	DestroyMenu(hMTxt);
	DestroyMenu(hMBmp);

	return TRUE;
}

//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER	 		)
{
	KillTimer(hDlg, 1);
	AjcVthPrintF(GetDlgItem(hDlg, IDC_VTH), TEXT("\n"));
	return TRUE;
}
//----- WM_INITMENU --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITMENU	 	)
{
	return 0;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- 全て許可／禁止 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_ENA_DIS	)
{
	BOOL	f = AjcGetDlgItemChk(hDlg, IDC_CHK_ENA_DIS);
	AjcEnableDlgGroup(hDlg, IDC_GRP_ALL, f, f);
	return TRUE;
}
//----- BS_FLAT 設定 -------------------------------------------------------------------------------------------//
#define	SET_STY(ID, STY) 																						\
	if (AjcGetDlgItemChk(hDlg, LOWORD(wParam))) MAjcSetWindowLong(GetDlgItem(hDlg, ID), GWL_STYLE, 				\
													MAjcGetWindowLong(GetDlgItem(hDlg, ID), GWL_STYLE) |  STY); \
	else										 MAjcSetWindowLong(GetDlgItem(hDlg, ID), GWL_STYLE,				\
													MAjcGetWindowLong(GetDlgItem(hDlg, ID), GWL_STYLE) & ~STY);	\
	InvalidateRect(GetDlgItem(hDlg, ID), NULL, TRUE)

AJC_DLGPROC(Main, IDC_CHK_SET_FLAT	)
{
	SET_STY(IDC_BTN_PUSH_L, BS_FLAT);
	SET_STY(IDC_BTN_PUSH_S, BS_FLAT);
	SET_STY(IDC_CHK1	  , BS_FLAT);
	SET_STY(IDC_CHK2L	  , BS_FLAT);
	SET_STY(IDC_CHK2S	  , BS_FLAT);
	SET_STY(IDC_CHK3L	  , BS_FLAT);
	SET_STY(IDC_CHK3S	  , BS_FLAT);
	SET_STY(IDC_CHK4L	  , BS_FLAT);
	SET_STY(IDC_CHK4S	  , BS_FLAT);
	SET_STY(IDC_GRP_RBT   , BS_FLAT);
	SET_STY(IDC_RBT1	  , BS_FLAT);
	SET_STY(IDC_RBT2L	  , BS_FLAT);
	SET_STY(IDC_RBT2S	  , BS_FLAT);
	SET_STY(IDC_RBT3	  , BS_FLAT);
	SET_STY(IDC_RBT4	  , BS_FLAT);
	return TRUE;
}
//----- BS_NOTIFY 設定 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_SET_NOTIFY)
{
	SET_STY(IDC_BTN_PUSH_L, BS_NOTIFY);
	SET_STY(IDC_BTN_PUSH_S, BS_NOTIFY);
	SET_STY(IDC_CHK1	  , BS_NOTIFY);
	SET_STY(IDC_CHK2L	  , BS_NOTIFY);
	SET_STY(IDC_CHK2S	  , BS_NOTIFY);
	SET_STY(IDC_CHK3L	  , BS_NOTIFY);
	SET_STY(IDC_CHK3S	  , BS_NOTIFY);
	SET_STY(IDC_CHK4L	  , BS_NOTIFY);
	SET_STY(IDC_CHK4S	  , BS_NOTIFY);
	SET_STY(IDC_GRP_RBT   , BS_NOTIFY);
	SET_STY(IDC_RBT1	  , BS_NOTIFY);
	SET_STY(IDC_RBT2L	  , BS_NOTIFY);
	SET_STY(IDC_RBT2S	  , BS_NOTIFY);
	SET_STY(IDC_RBT3	  , BS_NOTIFY);
	SET_STY(IDC_RBT4	  , BS_NOTIFY);
	return TRUE;
}
//----- C 更新 -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UPD_C		)
{
	AjcSetDlgItemChk(hDlg, IDC_CHK3S, (AjcGetDlgItemChk(hDlg, IDC_CHK3S) + 1) % 3);
	return TRUE;
}
//----- CHK4L 更新 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UPD_CHK4L	)
{
	AjcSetDlgItemChk(hDlg, IDC_CHK4L, (AjcGetDlgItemChk(hDlg, IDC_CHK4L) + 1) % 2);
	return TRUE;
}
//----- RBT3 更新 ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UPD_RBT3	)
{
	AjcSetDlgItemChk(hDlg, IDC_RBT3, (AjcGetDlgItemChk(hDlg, IDC_RBT3) + 1) % 2);
	return TRUE;
}
//----- RBT4 更新 ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UPD_RBT4	)
{
	AjcSetDlgItemChk(hDlg, IDC_RBT4, (AjcGetDlgItemChk(hDlg, IDC_RBT4) + 1) % 2);
	return TRUE;
}
//----- IDC_BTN_SPECIAL ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_BTN_SPECIAL	)
{
	return TRUE;
}
//----- IDC_LBX_OWN -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_LBX_OWN		)
{
	if (HIWORD(wParam) == AJCLBXN_LISTSTYLE) {
		PAJCLBXLSTSTY	p = (PAJCLBXLSTSTY)lParam;
		p->sty |= LBS_OWNERDRAWFIXED;
	}
	return TRUE;
}
//-----  AJCM_CTLCOLOR_BTN -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, AJCM_CTLCOLOR_BTN)
{
	PAJCDGCCTLCOLOR	pCC = (PAJCDGCCTLCOLOR)wParam;

	if ((HWND)lParam == GetDlgItem(hDlg, IDC_BTN_SPECIAL))	{
		pCC->hBrush    = hBruCtrl;
		pCC->TextColor = RGB(255,0,0);
	}
	return TRUE;
}
//-----  AJCM_CTLCOLOR_ANY -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, AJCM_CTLCOLOR_ANY)
{
	PAJCDGCCTLCOLOR	pCC = (PAJCDGCCTLCOLOR)wParam;

	//	コンボボックス（IDC_CBO_STD_DD）は、背景＝クリーム色，文字＝赤で表示
	if (IsAssociatedComboBox(lParam, GetDlgItem(hDlg, IDC_CBO_STD_DD))) {
		pCC->hBrush    = hBruCtrl;
		pCC->TextColor = RGB(255, 0, 0); 
		pCC->BkColor   = -1;
	}
	//	チェックボックス（IDC_CHK1）は、文字色＝赤
	else if ((HWND)lParam == GetDlgItem(hDlg, IDC_CHK1)) {
		pCC->TextColor = RGB(255, 0, 0); 
	}
	return TRUE;
}
//-----  AJCM_CTLCOLOR_LSI -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, AJCM_CTLCOLOR_LSI)
{
	PAJCDGCCTLCOLOR	pCC  = (PAJCDGCCTLCOLOR)wParam;
	PAJCDGCDRAWITEM pDis = (PAJCDGCDRAWITEM)lParam;

	if		(pDis->id == IDC_CBO_OWN_DDL) {
		if (pDis->ix == 1) pCC->TextColor = RGB(255,0,0);
	}
	else if (pDis->id == IDC_CBO_OWN_DD ) {
		if (pDis->ix == 2) pCC->TextColor = RGB(255,0,0);
	}
	return TRUE;
}
//-----  AJCM_CTLDRAW_LSI --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, AJCM_CTLDRAW_LSI)
{
	PAJCDGCCTLCOLOR	pCC  = (PAJCDGCCTLCOLOR)wParam;
	PAJCDGCDRAWITEM pDis = (PAJCDGCDRAWITEM)lParam;
	UT		txt[256];

	if (pDis->idLbx == IDC_LBX_OWN) {
		//	３番目の項目は、文字の上にグラフィック上書き
		if (pDis->ix == 2) {
			//	ＤＣオブジェクト設定
			HPEN	hPen = (HPEN  )SelectObject(pDis->hDC, GetStockObject(BLACK_PEN));
			HBRUSH	hBru = (HBRUSH)SelectObject(pDis->hDC, pCC->hBrush);
			//	項目塗りつぶしと外枠描画
			Rectangle(pDis->hDC, pDis->rect.left  , pDis->rect.top,
								 pDis->rect.right , pDis->rect.bottom);
			//	テキスト描画
			SendMessage(pDis->hWnd, LB_GETTEXT, 2,(LPARAM) txt);	//	項目のテキスト取得
			SetBkMode(pDis->hDC, TRANSPARENT);						//	テキスト背景＝透明
			TextOut(pDis->hDC, pDis->rect.left + 3, pDis->rect.top + 1, txt, (UI)MAjcStrLen(txt));
			//	タスク掛け斜線描画
			MoveToEx(pDis->hDC ,pDis->rect.left ,pDis->rect.bottom - 1, NULL);
			LineTo	(pDis->hDC, pDis->rect.right,pDis->rect.top);
			MoveToEx(pDis->hDC ,pDis->rect.left ,pDis->rect.top, NULL);
			LineTo	(pDis->hDC, pDis->rect.right,pDis->rect.bottom - 1);
			//	ＤＣオブジェクトを元に戻す
			SelectObject(pDis->hDC, hBru);
			SelectObject(pDis->hDC, hPen);
		}
		//	３番目以外の項目はテキストを通常描画
		else {
			//	テキスト描画
			SendMessage(pDis->hWnd, LB_GETTEXT, pDis->ix, (LPARAM) txt);	//	項目のテキスト取得
			SetBkColor(pDis->hDC, pCC->BkColor);					//	テキスト背景色設定
			TextOut(pDis->hDC, pDis->rect.left + 3, pDis->rect.top + 1, txt, (UI)MAjcStrLen(txt));
		}
		pDis->fDrawn = TRUE;	//　描画済フラグ設定
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_COMMAND 		)
	AJC_DLGMAP_MSG(Main, WM_RBUTTONDOWN		)
	AJC_DLGMAP_MSG(Main, WM_TIMER	 		)
	AJC_DLGMAP_MSG(Main, WM_INITMENU 		)

	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_CHK_ENA_DIS	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_SET_FLAT	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_SET_NOTIFY	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_UPD_C		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_UPD_CHK4L	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_UPD_RBT3	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_UPD_RBT4	)
	AJC_DLGMAP_CMD(Main, IDC_BTN_SPECIAL	)
	AJC_DLGMAP_CMD(Main, IDC_LBX_OWN		)
	AJC_DLGMAP_DGB(Main, AJCM_CTLCOLOR_BTN	)
	AJC_DLGMAP_DGC(Main, AJCM_CTLCOLOR_ANY	)
	AJC_DLGMAP_CLI(Main, AJCM_CTLCOLOR_LSI	)
	AJC_DLGMAP_DLI(Main, AJCM_CTLDRAW_LSI	)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	イベントログ表示																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	EvtLog(HWND hDlg, WPARAM wParam, LPARAM lParam, HWND hVth)
{
	UT		txt[256];

	AjcGetDlgItemStr(hDlg, LOWORD(wParam), txt, 256);
	AjcVthPrintF(hVth, TEXT("%s : "), txt);

	switch (HIWORD(wParam)) {
		case BN_CLICKED:	AjcVthPrintF(hVth, TEXT("BN_CLICKED\n"));	break;
		case BN_DBLCLK:		AjcVthPrintF(hVth, TEXT("BN_DBLCLK\n"));	break;
		case BN_KILLFOCUS:	AjcVthPrintF(hVth, TEXT("BN_KILLFOCUS\n"));	break;
		case BN_SETFOCUS:	AjcVthPrintF(hVth, TEXT("BN_SETFOCUS\n"));	break;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックス対象ウインドかチェック																		//
//--------------------------------------------------------------------------------------------------------------//
static	UI	IsAssociatedComboBox(LPARAM lParam, HWND hWndCbo)
{
    BOOL    rc = 0;		//  戻り値＝０：目的のコンボボックス関連のウインド以外
    UT      name[256];
    //  クラス名取得
    GetClassName((HWND)lParam, name, 256);
    //  戻り値＝１：コンボボックス自身（ドロップダウンリストの選択結果表示部）
    if      (lParam == (LPARAM)hWndCbo) rc = 1;
    //  戻り値＝２：テキストボックス（ドロップダウンの選択結果表示部）
    else if (MAjcStrICmp(name, TEXT("Edit"     )) == 0 && GetParent((HWND)lParam) == hWndCbo) rc = 3;
    //  戻り値＝３：リスト表示部
    else if (MAjcStrICmp(name, TEXT("ComboLBox")) == 0 && WndDistance(lParam, hWndCbo) < 5)   rc = 2;
    return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ウインド間の距離算出（hWndCboの右下から、(HWND)lParamの右上までの距離）										//
//--------------------------------------------------------------------------------------------------------------//
static	UI	WndDistance(LPARAM lParam, HWND hWndCbo)
{
	UI		rc;
	RECT	rc1, rc2;

	GetWindowRect((HWND)lParam, &rc1);
	GetWindowRect(hWndCbo	  , &rc2);
	rc = (UI)sqrt(pow(rc1.top - rc2.bottom, 2) + pow(rc1.left - rc2.left, 2));
	return rc;
}