﻿//
//	SW_DlgItem2.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HICON			hIcoOpen;
static	HICON			hIcoDel;
static	BOOL			fLoadGrpA = FALSE;				//	GRPAロード済フラグ
static	BOOL			fLoadGrpB = FALSE;				//	GRPBロード済フラグ
static	BOOL			fLoadAll  = FALSE;				//	全体ロード済フラグ
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static UTP CALLBACK cbGetTipText(HWND hCtrl, UTP pBuf, UI lBuf, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	//	プロファイルをINIファイルとする
	AjcSetProfileIsRegistory(FALSE);
	//	アイコン生成
	hIcoOpen  = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_OPEN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	hIcoDel   = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_DEL ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	//	ボタンへアイコン表示
	SendDlgItemMessage(hDlg, IDC_CMD_OPENINI, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoOpen);
	SendDlgItemMessage(hDlg, IDC_CMD_CLEAR	, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoDel );
	//	ラジオボタングループ化
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_LDSV));
	//	ツールチップ設定
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_OPENINI), TEXT("INIファイルを開く"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_CLEAR  ), TEXT("INIファイルをクリアーする"));
	//	コントロールの初期値設定
	AjcSetDlgItemChk   (hDlg, IDC_RBT_ALL, TRUE);
	AjcSetDlgItemStr   (hDlg, IDC_TXT_A, TEXT("str-A"));	AjcSetDlgItemStr   (hDlg, IDC_TXT_B, TEXT("str-B"));
	AjcSetDlgItemChk   (hDlg, IDC_CHK_A, TRUE);				AjcSetDlgItemChk   (hDlg, IDC_CHK_B, TRUE);
	AjcSetDlgItemUInt  (hDlg, IDC_INP_A, 11);				AjcSetDlgItemUInt  (hDlg, IDC_INP_B, 22);
	AjcSetDlgItemCboIns(hDlg, IDC_CBO_A, 0, TEXT("CBO-A1"), 0);	AjcSetDlgItemCboIns(hDlg, IDC_CBO_B, 0, TEXT("CBO-B1"), 0);
	AjcSetDlgItemCboIns(hDlg, IDC_CBO_A, 1, TEXT("CBO-A2"), 0);	AjcSetDlgItemCboIns(hDlg, IDC_CBO_B, 1, TEXT("CBO-B2"), 0);
	AjcSetDlgItemCboIx (hDlg, IDC_CBO_A, 0);				AjcSetDlgItemCboIx (hDlg, IDC_CBO_B, 1);
	SendDlgItemMessage(hDlg, IDC_LST_A, LB_INSERTSTRING, -1, (LPARAM)TEXT("LST-A1"));
	SendDlgItemMessage(hDlg, IDC_LST_A, LB_INSERTSTRING, -1, (LPARAM)TEXT("LST-A2"));
	SendDlgItemMessage(hDlg, IDC_LST_B, LB_INSERTSTRING, -1, (LPARAM)TEXT("LST-B1"));
	SendDlgItemMessage(hDlg, IDC_LST_B, LB_INSERTSTRING, -1, (LPARAM)TEXT("LST-B2"));
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_A), -1, TEXT("LBX-A1"));
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_A), -1, TEXT("LBX-A2"));
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_B), -1, TEXT("LBX-B1"));
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_B), -1, TEXT("LBX-B2"));
	AjcVthPrintF(GetDlgItem(hDlg, IDC_VTH_A), TEXT("VTH-A1\nあいうえお"));
	AjcVthPrintF(GetDlgItem(hDlg, IDC_VTH_B), TEXT("VTH-B1\nかきくけこ"));
	//	ツールチップ関連付け
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_CMD_LOAD   ), TEXT("")); AjcTipTextSetCallBack(GetDlgItem(hDlg, IDC_CMD_LOAD   ), 0, NULL, cbGetTipText);
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_CMD_SAVE   ), TEXT("")); AjcTipTextSetCallBack(GetDlgItem(hDlg, IDC_CMD_SAVE   ), 0, NULL, cbGetTipText);
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_CMD_SAVE_EX), TEXT("")); AjcTipTextSetCallBack(GetDlgItem(hDlg, IDC_CMD_SAVE_EX), 0, NULL, cbGetTipText);
	//	ウインド全体セーブ／ロード時、選択情報（３つのラジオボタン）は除外する
	AjcDlgItemSetPermAttGrp(hDlg, IDC_GRP_LDSV, AJCCTL_PSEL_EXCLUDE); // 選択情報(ラジオボタン)は除く
	//	選択情報（３つのラジオボタン）ロード
	AjcDlgLoadGrpControlSettings(hDlg, IDC_GRP_LDSV, TEXT("SecLDSV"	), AJCCTL_SELACT_ALL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	選択情報（３つのラジオボタン）セーブ
	AjcDlgSaveGrpControlSettings(hDlg, IDC_GRP_LDSV);
	//	アイコン破棄
	if (hIcoOpen  != NULL) {DeleteObject(hIcoOpen); hIcoOpen = NULL;}
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- ３つのラジオボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_LDSV		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		switch (lParam) {
			case 0:	AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, fLoadGrpA); break; // GRP_Aのみ
			case 1: AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, fLoadGrpB); break;	// GRP_Bのみ
			case 2: AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, fLoadAll);  break;	// ウインド全体
		}
	}
	return TRUE;
}
//----- ロード ボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LOAD		)
{
	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_A)) 
		AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, fLoadGrpA = AjcDlgLoadGrpControlSettings(hDlg, IDC_GRP_A, TEXT("SecA"	), AJCCTL_SELACT_ALL));
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_B))
		AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, fLoadGrpB = AjcDlgLoadGrpControlSettings(hDlg, IDC_GRP_B, TEXT("SecB"	), AJCCTL_SELACT_ALL));
	else
		AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, fLoadAll  = AjcLoadAllControlSettings	 (hDlg, 		   TEXT("SecAll"), AJCCTL_SELACT_CHKEXCLUDE));
	return TRUE;
}
//----- セーブ ボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SAVE		)
{
	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_A)) AjcDlgSaveGrpControlSettings(hDlg, IDC_GRP_A);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_B)) AjcDlgSaveGrpControlSettings(hDlg, IDC_GRP_B);
	else										AjcSaveAllControlSettings	(hDlg);
	return TRUE;
}
//----- 単独でセーブ ボタン ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SAVE_EX	)
{
	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_A)) AjcDlgSaveGrpControlSettingsEx(hDlg, IDC_GRP_A, TEXT("SecA"  ), AJCCTL_SELACT_ALL);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_B)) AjcDlgSaveGrpControlSettingsEx(hDlg, IDC_GRP_B, TEXT("SecB"  ), AJCCTL_SELACT_ALL);
	else										AjcSaveAllControlSettingsEx   (hDlg 		  , TEXT("SecAll"), AJCCTL_SELACT_CHKEXCLUDE);
	return TRUE;
}
//----- プロファイル クリアー ボタン ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLEAR		)
{
	HANDLE	hFile;
	UT		path[MAX_PATH];
	AjcGetIniFilePath(path, MAX_PATH);
	DeleteFile(path);
	if ((hFile = CreateFile(path, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
		CloseHandle(hFile);
	}
	return TRUE;
}
//----- INIファイルを開くボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPENINI	)
{
	UT		path[MAX_PATH];
	AjcGetIniFilePath(path, MAX_PATH);
	ShellExecute(NULL, TEXT("open"), path, NULL, NULL, SW_SHOWNORMAL);
	return TRUE;
}
//----- グループＡリセット -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RESET_A	)
{
	AjcSetDlgItemStr  (hDlg, IDC_TXT_A, TEXT(""));
	AjcSetDlgItemChk  (hDlg, IDC_CHK_A, FALSE);
	AjcSetDlgItemUInt (hDlg, IDC_INP_A, 0);
	SendDlgItemMessage(hDlg, IDC_CBO_A, CB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_LST_A, LB_RESETCONTENT, 0, 0);
	AjcLbxResetContent(GetDlgItem(hDlg, IDC_LBX_A));

	return TRUE;
}
//----- グループＢリセット -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RESET_B	)
{
	AjcSetDlgItemStr  (hDlg, IDC_TXT_B, TEXT(""));
	AjcSetDlgItemChk  (hDlg, IDC_CHK_B, FALSE);
	AjcSetDlgItemUInt (hDlg, IDC_INP_B, 0);
	SendDlgItemMessage(hDlg, IDC_CBO_B, CB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_LST_B, LB_RESETCONTENT, 0, 0);
	AjcLbxResetContent(GetDlgItem(hDlg, IDC_LBX_B));

	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_CMD(Main, IDC_GRP_LDSV	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_LOAD	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SAVE	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SAVE_EX  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLEAR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPENINI   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_RESET_A   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_RESET_B   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	チップテキスト取得のコールバック（ロード／セーブボタンで実行されるコードをチップ表示）						//
//--------------------------------------------------------------------------------------------------------------//
static UTP CALLBACK cbGetTipText(HWND hCtrl, UTP pBuf, UI lBuf, UX cbp)
{
	switch (MAjcGetWindowLong(hCtrl, GWL_ID)) {
	  case IDC_CMD_LOAD:	MAjcStrCpy(pBuf, lBuf, TEXT("永続化情報読み出し（このボタン押下でセーブボタンを有効化）\n"));	break;
	  case IDC_CMD_SAVE:	MAjcStrCpy(pBuf, lBuf, TEXT("永続化情報書き込み\n"));											break;
	  case IDC_CMD_SAVE_EX:	MAjcStrCpy(pBuf, lBuf, TEXT("永続化情報書き込み（ロードボタン押下不要）\n"));					break;
	}

	switch (MAjcGetWindowLong(hCtrl, GWL_ID)) {
	  case IDC_CMD_LOAD:
		switch (AjcGetDlgItemUInt(hDlgMain, IDC_GRP_LDSV)) {
		  case 0: MAjcStrCat(pBuf, lBuf, TEXT("AjcDlgLoadGrpControlSettings(hDlg, IDC_GRP_A, \"SecA\", AJCCTL_SELACT_ALL);")); break;
		  case 1: MAjcStrCat(pBuf, lBuf, TEXT("AjcDlgLoadGrpControlSettings(hDlg, IDC_GRP_B, \"SecB\", AJCCTL_SELACT_ALL);")); break;
		  case 2: MAjcStrCat(pBuf, lBuf, TEXT("AjcLoadAllControlSettings(hDlg, \"SecAll\", AJCCTL_SELACT_ALL);")); break;
		}
		break;
	  case IDC_CMD_SAVE:
		switch (AjcGetDlgItemUInt(hDlgMain, IDC_GRP_LDSV)) {
		  case 0: MAjcStrCat(pBuf, lBuf, TEXT("AjcDlgSaveGrpControlSettings(hDlg, IDC_GRP_A);")); break;
		  case 1: MAjcStrCat(pBuf, lBuf, TEXT("AjcDlgSaveGrpControlSettings(hDlg, IDC_GRP_B);")); break;
		  case 2: MAjcStrCat(pBuf, lBuf, TEXT("AjcSaveAllControlSettings(hDlg);")); break;
		}
		break;
	  case IDC_CMD_SAVE_EX:
		switch (AjcGetDlgItemUInt(hDlgMain, IDC_GRP_LDSV)) {
		  case 0: MAjcStrCat(pBuf, lBuf, TEXT("AjcDlgSaveGrpControlSettingsEx(hDlg, IDC_GRP_A, \"IndepA\"), AJCCTL_SELACT_ALL);")); break;
		  case 1: MAjcStrCat(pBuf, lBuf, TEXT("AjcDlgSaveGrpControlSettingsEx(hDlg, IDC_GRP_B, \"IndepB\"), AJCCTL_SELACT_ALL);")); break;
		  case 2: MAjcStrCat(pBuf, lBuf, TEXT("AjcSaveAllControlSettingsEx(hDlg, \"IndepAll\"), AJCCTL_SELACT_ALL);")); break;
		}
		break;
	}
	return pBuf;
}
