﻿//
//	SW_DlgItem4.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	ADD	FALSE
#define	INS	TRUE

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	SetText(HWND hDlg, BOOL fIns, UTP pTxt, UI ix, UI flag);
static	UI	GetIx  (HWND hDlg);
static	UI	GetFlag(HWND hDlg);
static	VO	ResetList(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;

	//	入力データ初期化
	AjcSetDlgItemLstIns(hDlg, IDC_LST_DATA, -1, TEXT("ggg"), AJCCBF_EXACT_WIDTH);
	AjcSetDlgItemLstIns(hDlg, IDC_LST_DATA, -1, TEXT("PPP"), AJCCBF_EXACT_WIDTH);
	AjcSetDlgItemLstIns(hDlg, IDC_LST_DATA, -1, TEXT("DDD"), AJCCBF_EXACT_WIDTH);
	AjcSetDlgItemLstIns(hDlg, IDC_LST_DATA, -1, TEXT("rrr"), AJCCBF_EXACT_WIDTH);
	AjcSetDlgItemLstIns(hDlg, IDC_LST_DATA, -1, TEXT("ppp"), AJCCBF_EXACT_WIDTH);
	AjcSetDlgItemLstIns(hDlg, IDC_LST_DATA, -1, TEXT("KKK"), AJCCBF_EXACT_WIDTH);

	//	ix
	AjcSetDlgItemChk(hDlg, IDC_RBT_IX_LAST, TRUE);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- IDC_CMD_ADD_M ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ADD_M		)
{
	UI		i, n;
	UI		flag	= GetFlag(hDlg);
	UI		ix		= GetIx  (hDlg);
	UT		txt[256];

	n = AjcGetDlgItemLstCount(hDlg, IDC_LST_DATA);
	for (i = 0; i < n; i++) {
		AjcGetDlgItemLstItem(hDlg, IDC_LST_DATA, i, txt, 256);
		SetText(hDlg, ADD, txt, ix, flag);
	}
	return TRUE;
}
//----- IDC_CMD_INS_M ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INS_M		)
{
	UI		i, n;
	UI		flag	= GetFlag(hDlg);
	UI		ix		= GetIx  (hDlg);
	UT		txt[256];

	n = AjcGetDlgItemLstCount(hDlg, IDC_LST_DATA);
	for (i = 0; i < n; i++) {
		AjcGetDlgItemLstItem(hDlg, IDC_LST_DATA, i, txt, 256);
		SetText(hDlg, INS, txt, ix, flag);
	}
	return TRUE;
}
//----- IDC_CMD_ADD_S ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ADD_S		)
{
	UI		flag	= GetFlag(hDlg);
	UI		ix		= GetIx  (hDlg);
	UT		txt[256];

	AjcGetDlgItemStr(hDlg, IDC_TXT_DATA, txt, 256);
	SetText(hDlg, ADD, txt, ix, flag);

	return TRUE;
}
//----- IDC_CMD_INS_S ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INS_S		)
{
	UI		flag	= GetFlag(hDlg);
	UI		ix		= GetIx  (hDlg);
	UT		txt[256];

	AjcGetDlgItemStr(hDlg, IDC_TXT_DATA, txt, 256);
	SetText(hDlg, INS, txt, ix, flag);

	return TRUE;
}
//----- IDC_CMD_FINDLST ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FINDLST	)
{
	int		rc;
	UI		flag	= GetFlag(hDlg);
	UT		txt[256];

	AjcGetDlgItemStr(hDlg, IDC_TXT_FINDLST, txt, 256);
	rc = AjcGetDlgItemLstFind(hDlg, IDC_LST, -1, txt, flag);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_FINDLSTRSU, rc);
	return TRUE;
}
//----- IDC_CMD_FINDCBO ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FINDCBO	)
{
	int		rc;
	UI		flag	= GetFlag(hDlg);
	UT		txt[256];

	AjcGetDlgItemStr(hDlg, IDC_TXT_FINDCBO, txt, 256);
	rc = AjcGetDlgItemCboFind(hDlg, IDC_CBO, -1, txt, flag);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_FINDCBORSU, rc);

	return TRUE;
}
//----- IDC_CMD_RESET ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RESET		)
{
	ResetList(hDlg);

	return TRUE;
}
//----- IDCANCEL -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ADD_M	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_INS_M	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ADD_S	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_INS_S	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_FINDLST   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_FINDCBO   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_RESET	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
static	VO	SetText(HWND hDlg, BOOL fIns, UTP pTxt, UI ix, UI flag)
{
	if (fIns) {
		AjcSetDlgItemLstIns(hDlg, IDC_LST  , ix, pTxt, flag);
		AjcSetDlgItemLstIns(hDlg, IDC_LST_M, ix, pTxt, flag);
		AjcSetDlgItemLstIns(hDlg, IDC_LST_S, ix, pTxt, flag);
		AjcSetDlgItemCboIns(hDlg, IDC_CBO  , ix, pTxt, flag);
		AjcSetDlgItemCboIns(hDlg, IDC_CBO_S, ix, pTxt, flag);
	}
	else {
		AjcSetDlgItemLstAdd(hDlg, IDC_LST  , ix, pTxt, flag);
		AjcSetDlgItemLstAdd(hDlg, IDC_LST_M, ix, pTxt, flag);
		AjcSetDlgItemLstAdd(hDlg, IDC_LST_S, ix, pTxt, flag);
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO  , ix, pTxt, flag);
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO_S, ix, pTxt, flag);
	}
}
//--------------------------------------------------------------------------------------------------------------//
static	UI	GetIx(HWND hDlg)
{
	BOOL	rc = 0;

	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_IX_0			)) rc = 0;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_1			)) rc = 1;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_2			)) rc = 2;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_3			)) rc = 3;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_4			)) rc = 4;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_LAST			)) rc = -1;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_APPEND		)) rc = AJCCBI_APPEND;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_ASCENDING	)) rc = AJCCBI_ASCENDING;
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_IX_DESCENDING	)) rc = AJCCBI_DESCENDING;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	UI	GetFlag(HWND hDlg)
{
	BOOL	rc = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SORT			)) rc |= AJCCBF_SORT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_EXACT_STR	)) rc |= AJCCBF_EXACT_STR;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_EXACT_WIDTH	)) rc |= AJCCBF_EXACT_WIDTH;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_EXCLUSION	)) rc |= AJCCBF_EXCLUSION;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SAME_ERR		)) rc |= AJCCBF_SAME_ERR;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SELECT		)) rc |= AJCCBF_SELECT;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	ResetList(HWND hDlg)
{
	AjcSetDlgItemLstReset(hDlg, IDC_LST);
	AjcSetDlgItemLstReset(hDlg, IDC_LST_M);
	AjcSetDlgItemLstReset(hDlg, IDC_LST_S);
	AjcSetDlgItemCboReset(hDlg, IDC_CBO);
	AjcSetDlgItemCboReset(hDlg, IDC_CBO_S);
}