﻿//
//	SW_FFT.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define		N		256

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;
HWND			hDlgMain;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	hDlgMain = hDlg;

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	PostQuitMessage(0);
	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- ＯＫ ---------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK			)
{
	HWND		hCtrl;
	AJCTCPROP	prop;
	HAJCFFT		hFft;
	int			i;
	double		t, step;
	double		wav[N][3];
	AJCCOMPLEX	dat[N];
	double		fft[1];

	//	タイムチャート表示色設定
	hCtrl = GetDlgItem(hDlg, IDC_TMC);
	AjcTchGetProp(hCtrl, &prop);
	prop.Item[0].rgb = RGB(128, 128, 128);
	prop.Item[1].rgb = RGB(192, 192, 192);
	prop.Item[2].rgb = RGB(  0,   0,   0);
	AjcTchSetProp(hCtrl, &prop);
	//	3Hzの波形データ作成
	step = (AJC_PAI * 2.0) / 256.0 * 3.0;
	for (i = 0, t = 0; i < N; i++, t += step) wav[i][0] = sin(t);
	//	20Hzの波形データ作成
	step = (AJC_PAI * 2.0) / 256.0 * 20.0;
	for (i = 0, t = 0; i < N; i++, t += step) wav[i][1] = sin(t) * 0.4;
	//	合成波形作成
	for (i = 0; i < N; i++) wav[i][2] = wav[i][0] + wav[i][1];
	//	波形表示
	AjcTchPurge(hCtrl);
	for (i = 0; i < N; i++) AjcTchPutRealData(hCtrl, wav[i]);

	//	FFT解析データ作成
	memset(dat, 0, sizeof dat);
	for (i = 0; i < N; i++) dat[i].re = wav[i][2];
	//	FFT実行
	hFft = AjcFftCreate(N);
	AjcFftCalc(hFft, dat, FALSE);
	AjcFftDelete(hFft);
	//	振幅データ表示
	hCtrl = GetDlgItem(hDlg, IDC_FFT);
	AjcBarPurge(hCtrl);
	for (i = 0; i < 26; i++) {
		UT	txt[16];
		fft[0] = sqrt(pow(dat[i].re, 2) + pow(dat[i].im, 2));
		AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%d"), i);
		AjcBarPutRealData(hCtrl, fft, txt);
	}
	//	注釈クリアー
	AjcSetDlgItemStr(hDlg, IDC_LBL_OK, TEXT(""));

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)

	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDOK			)
AJC_DLGMAP_END

