﻿//
//	SW_LzhDecodeC.c
//
#include	<AjrCstXX.h>
#include	<direct.h>
#include	<tchar.h>
#include	<imagehlp.h>

//==============================================================================================================//
//	書庫ファイル読み出し用コールバック																			//
//																												//
//	引　数	：	xp	 - コールバックパラメタ（本プログラムでは、ＬＺＨファイルのハンドルとして使用） 			//
//				pBuf - 読み出したデータを格納するバッファのアドレス 											//
//				len  - 読み出すバイト数 																		//
//																												//
//	戻り値	：	実際に読み出したバイト数																		//
//==============================================================================================================//
static UI	CALLBACK	cbRead(UX xp, VOP pBuf, UI len)
{
	return (UI)fread(pBuf, 1, len, (FILE *)xp);
}
//==============================================================================================================//
//	書庫ファイルのバイト位置設定用コールバック																	//
//																												//
//	引　数	：	xp	 - コールバックパラメタ（本プログラムでは、ＬＺＨファイルのハンドルとして使用） 			//
//				ofs  - 設定するバイト位置																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
static	VO	CALLBACK	cbSeek(UX xp, UL ofs)
{
	fseek((FILE *)xp, ofs, SEEK_SET);
}
//==============================================================================================================//
//	m a i n 																									//
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	UW			crc;						//	ＣＲＣ算出ワーク
	AJCLZHERR	err;						//	ＬＺＨデコード エラーコード
	HAJCLZH 	hLzhSearch = NULL;			//	ＬＺＨハンドル（検索用）
	HAJCLZH 	hLzhRead   = NULL;			//	ＬＺＨハンドル（読出用）
	FILE		*hFileLzh  = NULL;			//	ＬＺＨ書庫ファイル・ハンドル
	FILE		*hFileOut  = NULL;			//	出力ファイルハンドル
	UT			szPath	  [MAX_PATH];		//	パス編集ワーク
	UT			szTopDir  [MAX_PATH];		//	先頭フォルダパス
	BOOL		fIgnoreDir = TRUE;			//	ディレクトリ無視フラグ
	AJCLZHFILEINFO	FInfo;					//	ファイル情報
	UT			drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], fext[_MAX_EXT];
	UI			rbytes; 					//	読み出したバイト数
	UB			buf[1024];					//	読み出しバッファ

	AjcSetStdoutMode();

	//	ＬＺＨ書庫(.lzh)ファイルオープン
	if (argc >= 2 && (_tfopen_s(&hFileLzh, (UTP)argv[1], TEXT("rb"))) == 0) {
		//	トップフォルダ名設定
		MAjcSplitPath(argv[1] , drv, dir, fname, fext);
		MAjcMakePath (szTopDir, drv, dir, NULL , NULL);
		//	書庫内のファイル検索初期化
		if ((hLzhSearch = AjcLzhFindFirst(TEXT("*.*"), AJCLZHF_SUBDIR, (UX)hFileLzh, cbRead, cbSeek)) != NULL) {
			//	書庫内の全ファイルループ
			do {
				//----- ファイル情報取得 ---------------------------------------------------------------------------//
				AjcLzhGetFileInfo(hLzhSearch, &FInfo);
				//----- フォルダ作成 -------------------------------------------------------------------------------//
				if (FInfo.szDirName[0] != 0) {
					UTP 	p;
					UT		tmp [MAX_PATH];
					MAjcStrCpy(szPath, AJCTSIZE(szPath), szTopDir);
					MAjcStrCpy(tmp, AJCTSIZE(tmp), FInfo.szDirName);
					if (p = MAjcStrTok(tmp, TEXT("\\"))) {
						do {
							AjcPathCat(szPath, p, MAX_PATH);
							 _tmkdir(szPath);
						} while (p = MAjcStrTok(NULL, TEXT("\\")));
					}
				}
				//----- ファイル出力 -------------------------------------------------------------------------------//
				if (hLzhRead = AjcLzhOpen(FInfo.szPathName, 0, (UX)hFileLzh, cbRead, cbSeek)) {
					AjcPrintF(TEXT("Extracting %s - "), FInfo.szFileName);
					MAjcStrCpy(szPath, MAX_PATH, szTopDir);
					AjcPathCat(szPath, FInfo.szPathName, MAX_PATH);
					if (_tfopen_s(&hFileOut, szPath, TEXT("wb")) == 0) {
						//	ファイル出力とＣＲＣ算出
						crc = 0;
						while (rbytes = AjcLzhRead(hLzhRead, buf, sizeof buf)) {
							crc = AjcPartCrc16R(buf, rbytes, crc);
							fwrite(buf, 1, rbytes, hFileOut);
						}
						//	ＣＲＣチェック
						if ((err = AjcLzhGetLastError()) == AJCLZHERR_OK) {
							if (crc == hLzhRead->crc) AjcPrintF(TEXT("OK\n"));
							else					  AjcPrintF(TEXT("NG (CRC error)\n"));
						}
						else {
							AjcPrintF(TEXT("NG (err = 0x%04X)\n"), err);
						}
						//	出力ファイル・クローズ
						fclose(hFileOut);
					}
					else {
						AjcPrintF(TEXT("NG (Creation failure)\n"));
					}
					// ＬＺＨ読み出しハンドル・クローズ
					AjcLzhClose(hLzhRead);
				}
				else {
					AjcPrintF(TEXT("File not found (%s)\n"), FInfo.szPathName);
				}
			} while(AjcLzhFindNext(hLzhSearch));
			// ＬＺＨ検索ハンドル・クローズ
			AjcLzhClose(hLzhSearch);
		}
		else {
			AjcPrintF(TEXT("ＬＺＨ書庫内にファイルが見つかりません\n"));
		}
		//	ＬＺＨ書庫(.lzh)ファイル クローズ
		if (hFileLzh != NULL) fclose(hFileLzh);
	}
	else {
		AjcPrintF(TEXT("ＬＺＨ書庫ファイルのオープン失敗\n"));
	}

	getchar();
	return 0;
}
