﻿//
//	SW_MonInfo.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hG2d;
static	HWND			hVth;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UI		i, nMon;
	RECT	rcMon, rcG2d, rLab, rG2d;
	RECT	rcM, rcW;
	double	cxMon, cyMon, cxG2d, cyG2d;
	double	fact;
	double	cx, cy;
	AJCMONITORSINFO mi;
	HWND		hLab, hG2d;
	AJC3DGPROP prop;

	hDlgMain = hDlg;
	hG2d = GetDlgItem(hDlg, IDC_G2D);
	hVth = GetDlgItem(hDlg, IDC_VTH);

	//	パレットを明るい色に変更
	AjcG2dGetProp(hG2d, &prop);
	prop.Item[ 0].rgbP = RGB(192, 192, 255);	prop.Item[ 4].rgbP = RGB(255, 192, 255);
	prop.Item[ 1].rgbP = RGB(255, 192, 192);	prop.Item[ 5].rgbP = RGB(192, 192, 192);
	prop.Item[ 2].rgbP = RGB(192, 224, 192);	prop.Item[ 6].rgbP = RGB(192, 192, 192);
	prop.Item[ 3].rgbP = RGB(192, 224, 224);	prop.Item[ 7].rgbP = RGB(218, 218, 218);
	AjcG2dSetProp(hG2d, &prop);
	//	モニタ全体の矩形情報取得
	nMon = AjcGetMonitorsRect(&rcMon);
	cxMon = rcMon.right - rcMon.left;
	cyMon = rcMon.bottom - rcMon.top;
	//	Ｇ２Ｄウインド矩形情報取得
	GetWindowRect(hG2d, &rcG2d);
	cxG2d = rcG2d.right - rcG2d.left;
	cyG2d = rcG2d.bottom - rcG2d.top;
	//	モニタ数表示
	AjcSetDlgItemUInt(hDlg, IDC_TXT_COUNT, nMon);
	//	レンジ表示
	AjcSetDlgItemSInt(hDlg, IDC_LBL_TOP   , rcMon.top);
	AjcSetDlgItemSInt(hDlg, IDC_LBL_BOTTOM, rcMon.bottom);
	AjcSetDlgItemSInt(hDlg, IDC_LBL_LEFT  , rcMon.left);
	AjcSetDlgItemSInt(hDlg, IDC_LBL_RIGHT , rcMon.right);
	//	２Ｄグラフサイズ設定
	fact = cxMon / cyMon;
	cx = cyMon * fact;
	cy = cyMon;
	//	アスペクト比に合わせて２Ｄグラフウインドサイズ設定
	fact = cyG2d / cyMon;
	cx *= fact;
	cy *= fact;
	SetWindowPos(hG2d, NULL, 0, 0, (int)cx, (int)cy, SWP_NOMOVE);
	//	右端スケール値移動
	hLab = GetDlgItem(hDlg, IDC_LBL_RIGHT);				hG2d = GetDlgItem(hDlg, IDC_G2D);
	GetWindowRect(hLab, &rLab);							GetWindowRect(hG2d, &rG2d);
	MapWindowPoints(NULL, hDlg, (LPPOINT)&rLab, 2);		MapWindowPoints(NULL, hDlg, (LPPOINT)&rG2d, 2);
	rLab.left = rG2d.left + (int)cx - 20;
	SetWindowPos(hLab, NULL, rLab.left, rLab.top, 0, 0, SWP_NOSIZE); 
	//	２Ｄグラフモード設定
	AjcG2dInit(hG2d, rcMon.left , rcMon.bottom,
					 rcMon.right, rcMon.top   ,
					 AJC3DGS_2DMODE & ~AJC3DGS_SCALELINE);
	//	平面アングル設定（Ｘ方向＝Ｘ軸昇順，Ｙ方向＝Ｙ軸降順）
	AjcG2dSetPlane(hG2d, AJCG2DAXIS_DIR_XP, AJCG2DAXIS_DIR_YM);
	//	各モニタの矩形描画
	AjcGetMonitorsInfo(&mi);
	for (i = 0; i < nMon; i++) {
		AJC2DVEC v;
		int		  w, h;
		AjcG2dRectangle(hG2d, i, mi.rcMon[i].left, mi.rcMon[i].top, mi.rcMon[i].right, mi.rcMon[i].bottom);
		w = (mi.rcMon[i].right	- mi.rcMon[i].left);
		h = (mi.rcMon[i].bottom - mi.rcMon[i].top );
		v.x = mi.rcMon[i].left + w / 2;
		v.y = mi.rcMon[i].top  + h / 2;
		AjcG2dFillSV(hG2d, i, &v);
		AjcG2dRectangle(hG2d, 15, mi.rcMon[i].left , mi.rcMon[i].top , mi.rcMon[i].right , mi.rcMon[i].bottom );
		AjcG2dRectangle(hG2d, 15, mi.rcWork[i].left, mi.rcWork[i].top, mi.rcWork[i].right, mi.rcWork[i].bottom);
		AjcG2dPrintFV(hG2d,  AJCG2DTXOMD_ABOVE_CENTER, &v, TEXT("モニタ %d ( %d × %d )"), i + 1, w, h);

		AjcVthPrintF(hVth, TEXT("モニタ %d 全体領域   (%4d, %4d) - (%4d, %4d), %4d × %4d\n"), i + 1, 
									 mi.rcMon[i].left, mi.rcMon[i].top, mi.rcMon[i].right, mi.rcMon[i].bottom, 
									 mi.rcMon[i].right - mi.rcMon[i].left,	mi.rcMon[i].bottom - mi.rcMon[i].top);
		AjcVthPrintF(hVth, TEXT("モニタ %d 作業領域   (%4d, %4d) - (%4d, %4d), %4d × %4d\n"), i + 1, 
									 mi.rcWork[i].left, mi.rcWork[i].top, mi.rcWork[i].right, mi.rcWork[i].bottom, 
									 mi.rcWork[i].right - mi.rcWork[i].left,  mi.rcWork[i].bottom - mi.rcWork[i].top);
		AjcVthPrintF(hVth, TEXT("\n"));
	}
	AjcVthPrintF(hVth, TEXT("\n"));
	AjcGetPrimaryMonitorInfo(&rcM, &rcW);
	AjcVthPrintF(hVth, TEXT("プライマリ 全体領域 (%4d, %4d) - (%4d, %4d), %4d × %4d\n"),
								 rcM.left, rcM.top, rcM.right, rcM.bottom, 
								 rcM.right - rcM.left,	rcM.bottom - rcM.top);
	AjcVthPrintF(hVth, TEXT("プライマリ 作業領域 (%4d, %4d) - (%4d, %4d), %4d × %4d\n"),
								 rcW.left, rcW.top, rcW.right, rcW.bottom, 
								 rcW.right - rcW.left, rcW.bottom - rcW.top);

	AjcVthPrintF(hVth, TEXT("\n"));
	AjcGetMonitorsRect(&rcM);
	AjcVthPrintF(hVth, TEXT("モニタ全体          (%4d, %4d) - (%4d, %4d), %4d × %4d\n"),
								 rcM.left, rcM.top, rcM.right, rcM.bottom, 
								 rcM.right - rcM.left,	rcM.bottom - rcM.top);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- 「このウインドをモニタに収まる位置へ移動」ボタン -------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_MOVE		)
{
	POINT	pt;
	SIZE	sz;
	UI		flag;
	AjcGetWndInfoToFitOnMonitor(hDlg, &pt, &sz, &flag);
	SetWindowPos(hDlg, NULL, pt.x, pt.y, sz.cx, sz.cy, flag);
	return TRUE;
}
//----- 「このウインドをプライマリモニタの中央へ移動」ボタン ---------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_MOVEP		)
{
	int		cx, cy, cxM, cyM;
	RECT	rc, RcMon, RcWork;
	GetWindowRect(hDlg, &rc);
	cx = rc.right - rc.left;
	cy = rc.bottom - rc.top;
	AjcGetPrimaryMonitorInfo(&RcMon, &RcWork);
	cxM = RcWork.right - RcWork.left;
	cyM = RcWork.bottom - RcWork.top;
	SetWindowPos(hDlg, NULL, RcWork.left + (cxM - cx) / 2, RcWork.top + (cyM - cy) / 2, 0, 0, SWP_NOSIZE);
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_MOVE	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_MOVEP	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

