﻿//
//	SW_PrintImage.c
//

#include	<AjrCstXX.h>
#include	<Shlwapi.h>
#include	<io.h>
#include	<tchar.h>
#include	<sys/stat.h>
#include	"resource.h"
#pragma comment(lib, "shlwapi.lib")

#define	PICL	400

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hLbx;

static	BOOL			fImgValid = FALSE;
static	BOOL			fPrintContinue;
static	HAJCPRN 		hPrn;							//	印刷インスタンス
static	AJCPRN_INFO		PrnInfo;						//	プリンタ情報
static	AJC_IMGINFO 	ImgInfo;						//	イメージ情報
static	HBITMAP 		hBmpPic = NULL; 				//	ピクチャビットマップハンドル
static	UT				ImgFile[MAX_PATH];				//	ピクチャファイル


//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	VO		DrawToPic(VO);
static	BOOL	SearchImageFile(VO);

static	BOOL CALLBACK cbQueryPage	   (PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo, UX cbp);
static	BOOL CALLBACK cbDrawByDibSectDC(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;
	memset(&ImgInfo, 0, sizeof ImgInfo);

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hLbx	 = GetDlgItem(hDlg, IDC_LBX_FILES);

	SetWindowPos(GetDlgItem(hDlg, IDC_PIC_IMAGE), NULL, 0, 0, PICL, PICL, SWP_NOMOVE);

	//----- 印刷インスタンス生成 --------------------------//
	hPrn = AjcPrnCreate();
	//----- ページ印刷開始通知コールバック設定 ------------//
	AjcPrnSetCallbackQueryPage(hPrn, cbQueryPage);
	//----- １ページ印刷用コールバック設定 ----------------//
	AjcPrnSetCallbackByDibSect(hPrn, cbDrawByDibSectDC);
	//----- プリンタ情報読み出し --------------------------//
	AjcSetDlgItemStr(hDlg, IDC_LBL_PRNAME, AjcPrnGetInfo(hPrn, &PrnInfo));
	//----- ダイアログ初期化 ------------------------------//
	AjcSetDlgItemUInt(hDlg, IDC_INP_SPC_L, PrnInfo.MrgIf.mm.l);
	AjcSetDlgItemUInt(hDlg, IDC_INP_SPC_R, PrnInfo.MrgIf.mm.r);
	AjcSetDlgItemUInt(hDlg, IDC_INP_SPC_U, PrnInfo.MrgIf.mm.u);
	AjcSetDlgItemUInt(hDlg, IDC_INP_SPC_D, PrnInfo.MrgIf.mm.d);
	//----- 設定値ロード ----------------------------------//
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);
	//----- 画像表示 --------------------------------------//
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_LBX_FILES, AJCLBXN_SELCHANGE), (LPARAM)hLbx);
	//----- 画像選択状態監視タイマ起動 --------------------//
	SetTimer(hDlg, 1, 100, NULL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- タイマ停止 ------------------------------------//
	KillTimer(hDlg, 1);
	//----- 設定値セーブ ----------------------------------//
	AjcSaveAllControlSettings(hDlg);
	//----- リソース解放 ----------------------------------//
	AjcPrnDelete(hPrn);
	AjcImgFuncRelease(&ImgInfo);
	//----- プログラム終了 --------------------------------//
	PostQuitMessage(0);

	return TRUE;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	if (AjcLbxGetCurSel(hLbx) >= 0 && ImgInfo.fValid) {
		ShowWindow(GetDlgItem(hDlg, IDC_PIC_IMAGE), SW_SHOW);
		AjcEnableDlgItem(hDlg, IDC_CMD_START, TRUE);
	}
	else {
		ShowWindow(GetDlgItem(hDlg, IDC_PIC_IMAGE), SW_HIDE);
		AjcEnableDlgItem(hDlg, IDC_CMD_START, FALSE);
	}
	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		)
{
	int 	cmd = LOWORD(wParam);

	if (cmd == IDC_INP_SPC_U || cmd == IDC_INP_SPC_D || cmd == IDC_INP_SPC_L || cmd == IDC_INP_SPC_R) {
		if (HIWORD(wParam) == AJCIVN_INTVALUE) {
			AJCPRN_MARGIN	mrg;
			mrg.u = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_U);
			mrg.d = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_D);
			mrg.l = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_L);
			mrg.r = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_R);
			AjcPrnSetMargin(hPrn, &mrg);
		}
	}
	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- プリンタの設定ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETPRN	)
{
	if (AjcPrnSelectDlg(hPrn, &PrnInfo, 0, hDlg)) {
		//	プリンタ名表示
		AjcSetDlgItemStr(hDlg, IDC_LBL_PRNAME, AjcPrnGetInfo(hPrn, NULL));
	}
	return TRUE;
}
//----- 印刷開始ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START )
{
	AJCPRN_OPT	opt = {0};

	if (HIWORD(wParam) == BN_CLICKED) {
		opt.Flags = (
		//	AJCPRNF_DISABLECOPIES		|	//	「印刷部数」を無効化する
		//	AJCPRNF_DISABLEPAGEINFO		|	//	「印刷範囲」を無効にする
		//	AJCPRNF_ALLPAGES			|	//	「すべて」を選択状態にする
		//	AJCPRNF_SELECTION			|	//	「選択した部分」を選択状態にする
		//	AJCPRNF_NOSELECTION			|	//	「選択した部分」を無効状態にする
		//	AJCPRNF_PAGENUMS			|	//	「ページ指定」を選択状態にする
		//	AJCPRNF_NOPAGENUMS			|	//	「ページ指定」を無効状態にする
		//	AJCPRNF_NOWARNING			|	//	既定のプリンタがない場合に警告メッセージ非表示
		//	AJCPRNF_PRINTTOFILE			|	//	「ファイルへ出力」をチェックする
		//	AJCPRNF_DISABLEPRINTTOFILE	|	//	「ファイルへ出力」を無効化する
		//	AJCPRNF_HIDEPRINTTOFILE		|	//	ファイルへ出力」を非表示
			AJCPRNF_USEDEVMODECOPIES	|	//	アプリで「部単位で印刷」が未サポートであることを指定
			0);
		opt.nCopies 	= 1;				//	コピー部数
		opt.nFromPage	= 1;				//	開始ページ
		opt.nToPage		= 1;				//	終了ページ
		opt.nMinPage	= 1;				//	ページ範囲の最小値
		opt.nMaxPage	= 10;				//	ページ範囲の最小値
		if (AjcPrnPrintDlg(hPrn, NULL, &opt, hDlg)) {
			//--- プリンタ名表示 ------------//
			AjcSetDlgItemStr(hDlg, IDC_LBL_PRNAME, AjcPrnGetInfo(hPrn, NULL));
			//--- 印刷継続フラグ初期化 ------//
			fPrintContinue = TRUE;
			//--- 中止ボタンのみ有効化 ------//
			AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_ALL ), FALSE, FALSE);
			EnableWindow  (GetDlgItem(hDlg, IDC_CMD_STOP), TRUE);
			//--- 印刷開始 ------------------//
			AjcPrnStart (hPrn, (opt.Flags & AJCPRNF_OUTPUTTOFILE) != 0);
			//--- グレー状態解除 -----------//
			AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_ALL ), TRUE, TRUE);
			EnableWindow  (GetDlgItem(hDlg, IDC_CMD_STOP), FALSE);
		}
	}
	return TRUE;
}
//----- 印刷中止ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		//--- グレー状態解除 -----------//
		AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_ALL ), TRUE, TRUE);
		EnableWindow  (GetDlgItem(hDlg, IDC_CMD_STOP), FALSE);
		//--- 印刷終了の旨、設定 -------//
		fPrintContinue = FALSE;
	}
	return TRUE;
}
//----- リストボックスからの通知 -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_LBX_FILES		)
{
	int				ix;
	static UT SvFile[MAX_PATH];

	if (HIWORD(wParam) == AJCLBXN_SELCHANGE) {
		if ((ix = AjcLbxGetCurSel(hLbx)) >= 0) {				//	選択項目有り
			AjcLbxGetText(hLbx, ix, ImgFile, MAX_PATH);			//	選択ファイルパス取得
			if (MAjcStrCmp(ImgFile, SvFile) != 0) {				//		前回のファイルと異なる？
				AjcImgFuncRelease(&ImgInfo);					//			前回読み出し済のイメージ解放
				if (AjcImgFuncRead(&ImgInfo, ImgFile)) {		//			イメージファイル読み出し，成功？
					DrawToPic();								//				イメージ表示
				}
			//	else MessageBox(hDlg, TEXT("イメージファイルの読み出しを失敗しました。"), TEXT("SW_PrintImage"), MB_ICONERROR);
				MAjcStrCpy(SvFile, MAX_PATH, ImgFile);			//			イメージファイルパス退避
			}
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_TIMER	 		)
	AJC_DLGMAP_MSG(Main, WM_COMMAND 		)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETPRN 	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_START		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP		)
	AJC_DLGMAP_CMD(Main, IDC_LBX_FILES		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ピクチャコントロールににイメージ描画																		//
//																												//
//	引　数	：　なし																							//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawToPic(VO)
{
	HDC 	hdc, mdc;
	HBITMAP hSvBmp;
	HPEN	hSvPen;
	HBRUSH	hSvBru;
	int 	pw, ph;
	RECT	rcS, rcD;

	if(ImgInfo.fValid) {
		//	画像のアスペクトに合わせたピクチャサイズ設定
		if (ImgInfo.height >= ImgInfo.width) {pw = PICL * ImgInfo.width / ImgInfo.height; ph = PICL;}	//	縦長
		else								 {pw = PICL; ph = PICL * ImgInfo.height / ImgInfo.width;}	//	横長
		//	ＤＣ設定
		hdc = GetDC(hDlgMain);
		mdc = CreateCompatibleDC(hdc);
		//	描画ビットマップオブジェクト作成
		if (hBmpPic != NULL) DeleteObject(hBmpPic);
		hBmpPic = CreateCompatibleBitmap(hdc, pw, ph);
		hSvBmp	= (HBITMAP)SelectObject(mdc, hBmpPic);
		//	用紙域をクリアー
		hSvPen = (HPEN	)SelectObject(mdc, GetStockObject(NULL_PEN));
		hSvBru = (HBRUSH)SelectObject(mdc, CreateSolidBrush(GetSysColor(COLOR_BTNFACE)));
		Rectangle(mdc, 0, 0, pw + 1, ph + 1);
		SelectObject(mdc, hSvPen);
		DeleteObject(SelectObject(mdc, hSvBru));
		//	メモリＤＣへイメージ描画
		SetRect(&rcS, 0, 0, ImgInfo.width, ImgInfo.height);
		SetRect(&rcD, 0, 0, pw, ph);
		AjcImgFuncDraw(&ImgInfo, &rcS, mdc, &rcD);
		//	作成したビットマップのハンドル設定
		hBmpPic = (HBITMAP)SelectObject(mdc, hSvBmp);
		//	ＤＣ解放
		DeleteDC(mdc);
		ReleaseDC(hDlgMain, hdc);
		//	ピクチャ描画
		SendDlgItemMessage(hDlgMain, IDC_PIC_IMAGE, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpPic);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ページ印刷開始）																				//
//																												//
//	引　数	：	pPrnInfo	- プリンタ情報																		//
//				pPgInfo		- ページ情報（余白サイズ，印刷の向き）へのポインタ									//
//				cbp 		- コールバックパラメタ																//
//																												//
//	戻り値	：	TRUE  - 印刷継続																				//
//				FALSE - 印刷終了（以降、何も印刷せずに終了する）												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbQueryPage(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPgInfo, UX cbp)
{
	BOOL	rc = TRUE;

	AjcDoEvent();				//	印刷中止ボタンチェック
	rc = fPrintContinue;		//	・

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ＤＩＢへ描画）																				//
//																												//
//	引　数	：	hdc 		- ＤＩＢセクションビットマップのＤＣ												//
//				pPrnInfo	- プリンタ情報へのポインタ															//
//				pDibInfo	- ＤＩＢセクション情報へのポインタ													//
//				cbp 		- コールバックパラメタ																//
//																												//
//	戻り値	：	TRUE  - 印刷継続																				//
//				FALSE - 印刷終了（このページを印刷後に終了）													//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbDrawByDibSectDC(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp)
{
	BOOL	rc = FALSE;
	RECT	rcS, rcR, rcB;

	//	イメージ描画矩形設定
	rcS.left   = 0;
	rcS.top    = 0;
	rcS.right  = ImgInfo.width;
	rcS.bottom = ImgInfo.height;
	//	イメージ描画矩形算出（ページ中央に50%のサイズ）
	rcR.left   = pDibInfo->width  / 4;
	rcR.top    = pDibInfo->height / 4;
	rcR.right  = rcR.left + pDibInfo->width  / 2;
	rcR.bottom = rcR.top  + pDibInfo->height / 2;
	//	アスペクトを維持してイメージ描画矩形算出
	AjcAspGetZoomedRect(&rcS, &rcR, &rcB);
	//	イメージ描画
	AjcImgFuncDraw(&ImgInfo, &rcS, hdc, &rcB);
	//	外枠描画
	{
		HBRUSH hBru = (HBRUSH)SelectObject(hdc, GetStockObject(NULL_BRUSH));
		HPEN   hPen = (HPEN  )SelectObject(hdc, CreatePen(PS_SOLID, 5, RGB(0, 0, 0)));
		//	ページ外枠
		Rectangle(hdc, 0, 0, pDibInfo->width, pDibInfo->height);
		//	イメージ域外枠
		Rectangle(hdc, rcR.left, rcR.top, rcR.right, rcR.bottom);
		SelectObject(hdc, hBru);
		DeleteObject(SelectObject(hdc, hPen));
	}
	return FALSE;		//	FALSE:終了，TRUE：継続
}
