﻿//
//	SW_ProcessMem.c
//
#define _AJCSOCKSERV_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)
#define	IDC_FINDER		5001

typedef struct	{
	TC_ITEM	tci;
	UT		txt[256];
} MYWORK, *PMYWORK;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;					//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;				//	ダイアログボックスハンドル
HWND			hWndDrag;				//	ドラッグ＆ドロップ ツールウインド
HWND			hWndProp;				//	エクスプローラのドライブ・プロパティウインド
HWND			hVth;					//	ログ表示ウインド
HBITMAP			hBmpFind;				//	ドラッグ＆ドロップツールのビットマップ

BOOL			fCapture = FALSE;		//	マウスキャプチャ中フラグ
POINT			ptSrt;					//	ドラッグ開始時のマウス位置
RECT			rcSrt;					//	ドラッグ開始時のウインド位置

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main	);
AJC_WNDPROC_DEF(PicFind );
AJC_WNDPROC_DEF(FindDrag);
static	BOOL CALLBACK cbEnumChild(HWND hwnd, LPARAM lParam);


//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wndclass;

	hInst = hInstance;

	//----- 検索ウインドクラス生成 ---------------------//
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(FindDrag);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= 0;
	wndclass.hInstance		= hInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= TEXT("S_ProcessMem1");
	RegisterClass(&wndclass);

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	BOOL	 w64 = FALSE;

	hDlgMain = hDlg;
	hVth	 = GetDlgItem(hDlg, IDC_VTH);

	//	実行環境チェック（６４ビットＯＳ下の３２ビットプロセスの場合メッセージ表示）
	if	(IsWow64Process(GetCurrentProcess(), &w64) && w64) {
		AjcTipTextShowCenter(hDlg, TEXT("\x1B[31m\x1B[T")
								   TEXT("このプログラムは、\n")
								   TEXT("64ビットWindowsでは正常に実行されません。\n")
								   TEXT("SW_ProcessMem_64Aを実行してください。")
								   TEXT("\x1B[0m"), 10000, NULL);
	}

	//	ウインドタイトル
	#ifdef _WIN64
		SetWindowText(hDlg, TEXT("S_ProcessMem1 (64 bit)"));
	#else
		SetWindowText(hDlg, TEXT("S_ProcessMem1 (32 bit)"));
	#endif

	//	ドラッグ＆ドロップ用ツールウインド生成（非表示）
	hWndDrag = CreateWindowEx(WS_EX_TOPMOST | WS_EX_TOOLWINDOW,
							  TEXT("S_ProcessMem1"),	// window class name
							  TEXT(""),					// window caption
							  WS_POPUP,					// window style
							  0,						// initial x position
							  0,						// initial y position
							  19,						// initial x size
							  19,						// initial y size
							  NULL,						// parent window handle
							  NULL,						// window menu handle
							  hInst,					// program instance handle
							  NULL);					// creation parameters
	ShowWindow(hWndDrag, SW_HIDE);

	//	ドラッグ＆ドロップ開始用ピクチャ・コントロールをサブクラス化
	MAjcMmpSetSubclass(PicFind, GetDlgItem(hDlg, IDC_PIC_FIND));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//	ドラッグ用ウインド破棄
	DestroyWindow(hWndDrag);
	//	プログラム終了
	PostQuitMessage(0);

	return TRUE;
}
//----- ＯＫボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK)
{
	HWND	hTab;
	UI		Count, i=0;
	MYWORK	wrk;
	HAJCPM	hPm;

	if (IsWindow(hWndProp)) {
		//	プロパティウインド内のタブコントロール検索
		hTab = NULL;
		EnumChildWindows(hWndProp, cbEnumChild, (LPARAM)&hTab);
		//	タブコントロールあり・・・
		if (IsWindow(hTab)) {
			//	ログウインドクリアー
			AjcVthClear(hVth);
			//	エクスプローラ・プロセス内にメモリ確保
			hPm = AjcPmCreateByWnd(hWndProp, sizeof wrk);
			//	タブコントロールのタブ数取得
			Count = (UI)SendMessage(hTab, TCM_GETITEMCOUNT, 0, 0);
			//	タブコントロール内のタブテキストをログ表示
			memset(&wrk, 0, sizeof wrk);
			wrk.tci.mask = TCIF_TEXT;
			wrk.tci.pszText = (UTP)AjcPmGetAddr(hPm, sizeof wrk.tci);
			wrk.tci.cchTextMax = sizeof wrk.txt;
			for (i = 0; i < Count; i++) {
				AjcPmSendMessage(hPm, hTab, TCM_GETITEM, i, AJCPM_LPARAM_R(hPm, &wrk, sizeof wrk));
				AjcVthPrintF(hVth, TEXT("  %s\n"), wrk.txt);
			}
			//	エクスプローラ・プロセス内のメモリ解放
			AjcPmDelete(hPm);
		}
		//	タブコントロールなし・・・
		else {
			AjcVthPrintF(hVth, TEXT("\x1B[31mタブコントロールが見つかりません。\x1B[0m\n"), wrk.txt);
		}
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	//	メイン・ダイアログ破棄
	DestroyWindow(hDlg);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)

	AJC_DLGMAP_CMD(Main, IDOK			)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END

//==============================================================================================================//
//																												//
//	ウインド検索用ピクチャ(IDC_PIC_FIND) サブクラス・ウインドプロシージャ										//
//																												//
//==============================================================================================================//
//----- WM_LBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(PicFind, WM_LBUTTONDOWN		)
{
	RECT	r;
	//	ドラッグ＆ドロップ開始用ピクチャ・コントロール非表示
	ShowWindow(hwnd, SW_HIDE);
	//	ドラッグ＆ドロップ用ツールウインド表示
	GetWindowRect(GetDlgItem(hDlgMain, IDC_PIC_FIND), &r);
	SetWindowPos(hWndDrag, NULL, r.left, r.top, 0, 0, SWP_NOSIZE);
	ShowWindow(hWndDrag, SW_SHOW);
	//	開始カーソル位置，ウインド位置退避
	GetCursorPos(&ptSrt);
	GetWindowRect(hWndDrag, &rcSrt);
	//	マウスキャプチャ開始
	SetCapture(hwnd);
	fCapture = TRUE;

	return 0;	//	インターセプト（オリジナルのウインドプロシージャは実行しない）
}
//----- WM_LBUTTONUP -------------------------------------------------------------------------------------------//
AJC_WNDPROC(PicFind, WM_LBUTTONUP		)
{
	POINT	pt;
	UT		txt[256];

	//	マウスキャプチャ停止
	ReleaseCapture();
	fCapture = FALSE;
	//	ドラッグ＆ドロップ開始用ピクチャ・コントロール表示
	ShowWindow(hwnd, SW_SHOW);
	//	ドラッグ＆ドロップ用ツールウインド非表示
	ShowWindow(hWndDrag, SW_HIDE);
	InvalidateRect(hDlgMain, NULL, TRUE);
	//	ドラッグ位置のウインド・ハンドル取得
	GetCursorPos(&pt);
	hWndProp = WindowFromPoint(pt);
	//	エクスプローラ・ドライブ・プロパティウインドのタイトル表示
	if (IsWindow(hWndProp)) {
		AjcVthClear(hVth);
		GetWindowText(hWndProp, txt, AJCTSIZE(txt));
		AjcSetDlgItemStr(hDlgMain, IDC_TXT_TITLE, txt);

	}

	return 0;	//	インターセプト（オリジナルのウインドプロシージャは実行しない）
}
//----- WM_MOUSEMOVE -------------------------------------------------------------------------------------------//
AJC_WNDPROC(PicFind, WM_MOUSEMOVE		)
{
	POINT	pt;
	int		x, y;

	//	マウスキャプチャ中・・・
	if (fCapture) {
		//	ドラッグ＆ドロップ用ツールウインドを現カーソル位置に移動
		GetCursorPos(&pt);
		x = rcSrt.left + pt.x - ptSrt.x;
		y = rcSrt.top  + pt.y - ptSrt.y;
		SetWindowPos(hWndDrag, NULL, x, y, 0, 0, SWP_NOSIZE);
	}
	return 0;	//	インターセプト（オリジナルのウインドプロシージャは実行しない）
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(PicFind)
	AJC_WNDMAP_MSG(PicFind, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(PicFind, WM_LBUTTONUP	)
	AJC_WNDMAP_MSG(PicFind, WM_MOUSEMOVE	)
AJC_WNDMAP_END
//==============================================================================================================//
//																												//
//	ドラッグ＆ドロップツール ウインドプロシージャ																//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(FindDrag, WM_CREATE			)
{
	RECT	r;

	AjcChangeBitmapColor(hBmpFind = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_FIND)), RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
	GetWindowRect(GetDlgItem(hDlgMain, IDC_PIC_FIND), &r);
	MapWindowPoints(NULL, hDlgMain, (LPPOINT)&r, 2);
	SetWindowPos(hwnd, NULL, r.left, r.top, 0, 0, SWP_NOSIZE);
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(FindDrag, WM_DESTROY			)
{
	DeleteObject(hBmpFind);
	hWndDrag = NULL;
	return 0;
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(FindDrag, WM_PAINT			)
{
	PAINTSTRUCT	ps;
	HDC			hdc, mdc;

	hdc  = BeginPaint(hwnd, &ps);
	mdc = CreateCompatibleDC(hdc);
	SelectObject(mdc, hBmpFind);
	BitBlt(hdc, 0, 0, 19, 19, mdc, 0, 0, SRCCOPY);
	DeleteDC(mdc);
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(FindDrag)
	AJC_WNDMAP_MSG(FindDrag, WM_CREATE		)
	AJC_WNDMAP_MSG(FindDrag, WM_DESTROY		)
	AJC_WNDMAP_MSG(FindDrag, WM_PAINT			)
AJC_WNDMAP_END


//--------------------------------------------------------------------------------------------------------------//
//	エクスプローラ・ドライブ・プロパティウインド内のタブコントロール（子孫ウインド）検索						//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEnumChild(HWND hwnd, LPARAM lParam)
{
	BOOL	rc = TRUE;
	UT		name[256];

	GetClassName(hwnd, name, 256);

	if (MAjcStrICmp(name, TEXT("SysTabControl32")) == 0) {
		*((HWND*)lParam) = hwnd;
		rc = FALSE;
	}
	return rc;
}

