﻿//
//	SW_RadioBbutton.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hGrp1;
HWND			hGrp2;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- プロファイルをレジストリとする場合は、以下の行のコメントを解除します -----//
	// AjcSetProfileIsRegistory(TRUE);

	//----- メイン・ダイアログオープン -----------------------------------------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------------------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	//----- グループボックスのハンドル設定 ----------------------//
	hGrp1 = GetDlgItem(hDlg, IDC_GRP_1);
	hGrp2 = GetDlgItem(hDlg, IDC_GRP_2);
	//----- グループボックス内のラジオボタンを統合化 ------------//
	AjcSbcRadioBtns(hGrp1);
	AjcSbcRadioBtns(hGrp2);
	//----- プロファイルからラジオボタン状態を読み出して設定 ----//
	AjcSbcSetRbt(hGrp1, AjcGetProfileUInt(TEXT("SW_RadioBbutton"), TEXT("GRP1"), 0));
	AjcSbcSetRbt(hGrp2, AjcGetProfileUInt(TEXT("SW_RadioBbutton"), TEXT("GRP2"), 0));
	//----- 初期のラジオボタン選択状態表示 ----------------------//
	AjcSetDlgItemUInt(hDlg, IDC_TXT_1, AjcSbcGetRbt(hGrp1));
	AjcSetDlgItemUInt(hDlg, IDC_TXT_2, AjcSbcGetRbt(hGrp2));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- プロファイルへラジオボタン状態を記録する -------------//
	AjcPutProfileUInt(TEXT("SW_RadioBbutton"), TEXT("GRP1"), AjcSbcGetRbt(hGrp1));
	AjcPutProfileUInt(TEXT("SW_RadioBbutton"), TEXT("GRP2"), AjcSbcGetRbt(hGrp2));
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);

	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		   )
{
	DestroyWindow(hDlg);

	return TRUE;
}
//----- グループボックス１ -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_1 	   )
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		AjcSetDlgItemUInt(hDlg, IDC_TXT_1, (UI)lParam);
	}
	return TRUE;
}
//----- グループボックス２ -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_2 	   )
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		AjcSetDlgItemUInt(hDlg, IDC_TXT_2, (UI)lParam);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDC_GRP_1		)
	AJC_DLGMAP_CMD(Main, IDC_GRP_2		)
AJC_DLGMAP_END


