﻿//
//	SW_SerialComPort5A.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	WM_SCPEVENT			WM_APP
#define	IDC_VTH				5001
#define	VTH_HEIGHT			200

//--------------------------------------------------------------------------------------------------------------//
//	通信パケットコマンド																						//
//--------------------------------------------------------------------------------------------------------------//
//	グラフデータ形式
#define	CMD_REQ_START	0x01	//	グラフデータ送信開始要求
#define	CMD_RSP_START	0x11	//			〃			応答
#define	CMD_REQ_STOP	0x02	//	グラフデータ送信停止要求
#define	CMD_RSP_STOP	0x12	//			〃			応答
#define	CMD_DATA		0x40	//	グラフデータ

typedef struct {
	UB			cmd;			//	コマンドコード
	UB			fil[3];			//	－
	AJC3DVEC	vec;			//	グラフデータ
} CMDDATA, *PCMDDATA;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst	 = NULL;				//	ＤＬＬインスタンスハンドル
static	HWND			hWndBack = NULL;				//	バックウインドハンドル（ダイアログとVT-100の親ウインド）
static	HWND			hDlgMain = NULL;				//	ダイアログボックスハンドル
static	HWND			hWndVth  = NULL;				//	ＶＴＨウインドハンドル
static	HAJCSCP			hScp	 = NULL;				//	ＳＣＰハンドル
static	HANDLE			hMut5A	 = NULL;				//	自プログラム起動を示すミューテックス
static	HANDLE			hMut5B	 = NULL;				//	相手プログラム起動チェック用ミューテックス
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wc;

	hInst = hInstance;

	//	バックウインド生成
	wc.style		= 0;						wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.lpfnWndProc	= AJC_WNDPROC_NAME(Back);	wc.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.cbClsExtra 	= 0;						wc.lpszMenuName		= NULL;
	wc.cbWndExtra 	= 0;						wc.lpszClassName	= TEXT("SW_SerialComPort5A");
	wc.hInstance	= hInst;
	wc.hIcon		= NULL;
	RegisterClass(&wc);

	hWndBack = CreateWindow(TEXT("SW_SerialComPort5A"), TEXT("SW_SerialComPort5A"),
							WS_OVERLAPPEDWINDOW,
							0, 0, 400, 300,
							NULL, NULL, hInst, NULL);

	//	ウインド表示
	ShowWindow(hWndBack, iCmdShow);

	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	バックウインド・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE 		)
{
	RECT	r;

	//	自ミューテックス生成
	hMut5A = CreateMutex(NULL, TRUE, TEXT("SW_SerialComPort5A"));

	//	相手プログラム起動
	hMut5B = CreateMutex(NULL, TRUE, TEXT("SW_SerialComPort5B"));
	if (GetLastError() != ERROR_ALREADY_EXISTS) {
		UT	path[MAX_PATH];
		CloseHandle(hMut5B);
		AjcGetAppPath(path, MAX_PATH);
		ShellExecute(NULL, NULL, TEXT("SW_SerialComPort5B_32W.exe"), TEXT(""), path, SW_SHOWNORMAL);
	}
	//	メイン・ダイアログ生成
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), hwnd, AJC_DLGPROC_NAME(Main));
	GetWindowRect(hDlgMain, &r);
	AdjustWindowRect(&r, WS_OVERLAPPEDWINDOW, FALSE);
	SetWindowPos(hwnd, NULL, 0, 0, r.right - r.left, r.bottom - r.top + VTH_HEIGHT, SWP_NOMOVE);
	//	ダイアログ表示
	ShowWindow(hDlgMain, SW_SHOW);
	//	ＶＴＨウインド生成
	GetWindowRect(hDlgMain, &r);
	hWndVth = CreateWindowEx(WS_EX_ACCEPTFILES, 										// extend style
								TEXT("AjcCtrlVT100"),									// window class name
								TEXT("P: VW=120, VH=25, FN=MS Gothic"),					// window caption
								WS_CHILD | WS_VISIBLE | WS_DISABLED | AJCVTHS_LFCTRL,	// window style
								0, 														// initial x position
								r.bottom - r.top, 										// initial y position
								r.right - r.left, 										// initial x size
								VTH_HEIGHT,												// initial y size
								hwnd,													// parent window handle
								(HMENU)IDC_VTH,											// window menu handle
								hInst, 													// program instance handle
								NULL); 													// creation parameters
	//	ツールチップ設定
	AjcTipTextAdd(hWndVth, TEXT("以下のコマンドを入力しENTERキーを押してください。\n")
						   TEXT("    ・DATE  -- 今日の日付表示\n")
						   TEXT("    ・TIME  -- 現在時刻表示")
	);
	//	ＶＴＨウインドをフォーカス
	SetFocus(hWndVth);

	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY		)
{
	if (hMut5A	 != NULL) CloseHandle(hMut5A);
	if (hScp	 != NULL) AjcScpDelete(hScp);
	if (hDlgMain != NULL) DestroyWindow(hDlgMain);
	if (hWndVth  != NULL) DestroyWindow(hWndVth );
	//	プログラム終了
	PostQuitMessage(0);

	return 0;
}
//----- ＶＴ１００ウインドからの通知 ---------------------------------------------------------------------------//
AJC_WNDPROC(Back, IDC_VTH			)
{
	if (HIWORD(wParam) == AJCVTHN_KEYIN) {
		AjcScpSendText(hScp, (C_UTP)&lParam, 1);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE		)
	AJC_WNDMAP_MSG(Back, WM_DESTROY		)
	AJC_WNDMAP_CMD(Back, IDC_VTH		)
AJC_WNDMAP_END
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	//	ＳＣＰセットアップ
	hScp = AjcScpCreate();											//	ＳＣＰインスタンス生成
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_TEXT);			//	モード設定
	AjcScpSetRxTextCode(hScp, AJCSCP_TXT_SJIS);						//	受信テキストコード＝SJIS
	AjcScpSetTxTextCode(hScp, AJCSCP_TXT_SJIS);						//	送信テキストコード＝SJIS
	AjcScpSetEvtMask(hScp,	AJCSCP_EV_PORTSTATE |					//		ポート状態通知
							AJCSCP_EV_RXPKT 	|					//		パケットデータ受信通知
							AJCSCP_EV_RXNOPKT);						//		パケット外データ受信通知
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	hDlgMain = NULL;
	return TRUE;
}
//----- ＳＣＭイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT		)
{
	UI		time = GetTickCount();
	UI		len, param;
	UT		txt[256];
	union {UBP pCmd; UTP pTxt; VOP vp; PCMDDATA pDat;} u;

	AjcScpGetEventData(hScp, lParam, &u.vp, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知
		switch (param) {
			case AJCSCP_CLOSED:											//		・クローズ状態
				AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("OPEN"));
				AjcEnableDlgItem(hDlg, IDC_CMD_START, FALSE);
				AjcEnableDlgItem(hDlg, IDC_CMD_STOP , FALSE);
				EnableWindow(hWndVth, FALSE);
				SetFocus(GetDlgItem(hDlg, IDC_CMD_OPEN));
				break;
			case AJCSCP_OPENED:											//		・オープン状態
				AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("CLOSE"));
				AjcEnableDlgItem(hDlg, IDC_CMD_START, TRUE);
				AjcEnableDlgItem(hDlg, IDC_CMD_STOP , TRUE);
				EnableWindow(hWndVth, TRUE);
				SetFocus(hWndVth);
				break;
			case AJCSCP_OPENFAIL:										//		・オープン失敗
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%s オープン失敗"), u.pTxt);
				MessageBox(hDlg, txt, TEXT("SW_SerialComPort5A"), MB_ICONERROR);
				break;
		}
	}
	if (wParam & AJCSCP_EV_RXPKT  ) {									//	●パケットデータ受信通知
		switch (*u.pCmd) {
			case CMD_RSP_START:			//	グラフデータ送信開始応答
				break;
			case CMD_RSP_STOP:			//	グラフデータ送信停止応答
				break;
			case CMD_DATA:				//	グラフデータ
				AjcTchPutRealData(GetDlgItem(hDlg, IDC_TCH), &u.pDat->vec.x);
				break;
		}
	}
	if (wParam & AJCSCP_EV_RXNOPKT) { 									//	●パケット外テキスト受信通知
		AjcVthPutText(hWndVth, u.pTxt, len);
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- グラフ表示開始ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START		)
{
	UB	cmd;

	if (HIWORD(wParam) == BN_CLICKED) {
		cmd = CMD_REQ_START;
		AjcScpSendPacket(hScp, (C_VOP)&cmd, 1);
	}
	SetFocus(hWndVth);
	return 0;
}
//----- グラフ表示停止ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	UB	cmd;

	if (HIWORD(wParam) == BN_CLICKED) {
		cmd = CMD_REQ_STOP;
		AjcScpSendPacket(hScp, (C_VOP)&cmd, 1);
	}
	SetFocus(hWndVth);
	return 0;
}
//----- ポート設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETPORT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpDlgParamEasy(hScp, hDlg);
	}
	SetFocus(hWndVth);
	return 0;
}
//----- ＯＰＥＮボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcScpIsOpened(hScp)) {
			AjcScpClose(hScp);
		}
		else {
			AjcScpOpenDefault(hScp);
		}
	}
	SetFocus(hWndVth);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY		)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_START	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETPORT)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN	)
AJC_DLGMAP_END

