﻿//
//	SW_SockClient2C.c
//
#define AJCSOCKSERV_H_
#define AJCSERIALCOMPORT_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル

static	HAJCSCT 		hSct;
static	UI				TotalBytes;
static	BOOL			fConnect = FALSE;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	hDlgMain   = hDlg;

	//	ウインド位置ロード
	AjcLoadWndPos(hDlg, NULL);

	//	ダイアログ項目のロード
	MAjcSetDlgPropStr (hDlg, IDC_TXT_SERV, TEXT("127.0.0.1"), NULL , 0);
	MAjcSetDlgPropStr (hDlg, IDC_TXT_PORT, TEXT("14238"    ), NULL , 0);
	AjcLoadDlgProfiles(hDlg, TEXT("DlgSetting"));

	hSct = AjcSctCreate();													// インスタンス生成
	AjcSctSetChunkMode(hSct, AJCSCT_CM_BIN);								//	モード設定
	AjcSctSetEvtMask(hSct, AJCSCT_EV_CONNECT | AJCSCT_EV_DISCONNECT |		//	イベントマスク設定
						   AJCSCT_EV_CNFAIL  | AJCSCT_EV_RXCHUNK);
	
	AjcSetDlgItemStr (hDlg, IDC_TXT_MSG, TEXT("接続ボタンを押して、サーバと接続してください。"));
	AjcSetDlgItemUInt(hDlg, IDC_TXT_BYTES	, 0);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//	ウインド位置セーブ
	AjcSaveWndPos(hDlg, NULL);
	//	ダイアログ項目セーブ
	AjcSaveDlgProfiles(hDlg, TEXT("DlgSetting"));
	AjcReleaseDlgProps(hDlg);
	//	インスタンス消去
	AjcSctDelete(hSct);

	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＭイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT	)
{
	static	UI		TotalBytes = 0;
	VOP 	pDat;
	UI		len, param;

	AjcSctGetEventData(hSct, lParam, &pDat, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCT_EV_RXCHUNK ) {									//	●チャンクデータ受信通知？
		//	バイト数表示
		TotalBytes += len;
		AjcSepDlgItemUInt(hDlg, IDC_TXT_BYTES, TotalBytes);
		//	データ返送
		AjcSctSendBinData(hSct, pDat, len);
	}
	if(wParam & AJCSCT_EV_CONNECT) {									//	●接続通知？
		fConnect = TRUE;
		AjcSetDlgItemStr(hDlg, IDC_CMD_CONNECT, TEXT("切断"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_MSG , TEXT("\nサーバと接続状態です。"));
		//	バイト数リセット
		AjcSetDlgItemUInt(hDlg, IDC_TXT_BYTES, TotalBytes = 0);
	}
	if(wParam & AJCSCT_EV_DISCONNECT) {									//	●切断通知？
		fConnect = FALSE;
		AjcSetDlgItemStr(hDlg, IDC_CMD_CONNECT, TEXT("接続"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_MSG , TEXT("\n接続ボタンを押して、サーバと接続してください。"));
	}
	if(wParam & AJCSCT_EV_CNFAIL) {									//	●接続失敗通知？
		AjcSetDlgItemStr(hDlg, IDC_TXT_MSG, TEXT("接続を失敗しました。\r\n")
											TEXT("接続ボタンを押して、サーバと接続してください。"));
	}
	AjcSctRelEventData(hSct, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- 接続／切断ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CONNECT	 )
{
	if (fConnect) {
		AjcSctDisconnect(hSct);
	}
	else {
		UT		serv[MAX_PATH];
		UT		port[MAX_PATH];
		TotalBytes = 0;
		AjcGetDlgItemStr(hDlg, IDC_TXT_SERV, serv, AJCTSIZE(serv));
		AjcGetDlgItemStr(hDlg, IDC_TXT_PORT, port, AJCTSIZE(port));
		AjcSctConnect(hSct, serv, port, AF_INET, hDlg, WM_SCPEVENT);
		AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Open in progress"));
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT	)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_CONNECT)
AJC_DLGMAP_END
