﻿//
//	SW_SockClient2C.c
//
#define AJCSOCKSERV_H_
#define AJCSERIALCOMPORT_H_
#include	<AjrCstXX.h>
#include	<conio.h>
#include	<tchar.h>

//	ヘルプテキスト
static	UT			HelpText[] = TEXT("起動パラメタの形式\n\n"					)
								 TEXT("      /S<Name>  - TCP/IPサーバ名\n"		)
								 TEXT("      /Pnnn     - TCP/IPポート番号\n"	)
								 TEXT("\n"										)
								 TEXT("↑：以前に入力したパラメタ\n"			)
								 TEXT("↓：次のパラメタ"						);
//	ソケット通信クライアントインスタンス
static	HAJCSCT 	hSct = NULL;
//	通信パラメタ
static UT			TcpServ[256] = TEXT("127.0.0.1");		//	TCP/IPサーバ名
static UT			TcpPort[256] = TEXT("14238");			//	TCP/IPポート番号
//	バイトカウントタ
static	UI			ByteCount = 0;

//----- コンソール入力のコールバック（起動パラメタ解析）--------------------------------------------------------//
static VO	CALLBACK cbNtcArgs(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	int		i;

	for (i = 0; i < argc; i++) {
		if		(MAjcStrNICmp(argv[i], TEXT("/S"  ), 2) == 0) {MAjcStrCpy(TcpServ, AJCTSIZE(TcpServ), argv[i] + 2);}
		else if (MAjcStrNICmp(argv[i], TEXT("/P"  ), 2) == 0) {MAjcStrCpy(TcpPort, AJCTSIZE(TcpPort), argv[i] + 2);}
		else {
			AjcPrintF(TEXT("*** Invalid parameter %s ***\n"), argv[i]);
		}
	}
}

//----- コンソール強制終了ハンドラ -----------------------------------------------------------------------------//
static BOOL CALLBACK cbConApExit(DWORD CtrlType)
{
	//	シリアル通信インスタンス消去
	if (hSct != NULL) {
		AjcSctDelete(hSct);
		hSct = NULL;
	}
	return FALSE;	//	FALSE : 次のハンドラをコール
}
//--------------------------------------------------------------------------------------------------------------//
//	主制御
int AjcMain(int argc, UTP argv[])
{
	WPARAM		wParam;
	LPARAM		lParam;
	UTP 		pDat;
	UI			lDat;
	UI			param;
	BOOL		rsu;
	BOOL		fExit = FALSE;
	UT			buf[256];

	AjcSetStdoutMode();

	do {
		//	コンソール強制終了ハンドラ設定
		SetConsoleCtrlHandler(cbConApExit, TRUE);
		//	初期メッセージ
		AjcPrintF(TEXT("サーバからの受信データをエコーバックします。\nいずれかのキーを押すとプログラムを終了します。\n\n"));
		//	コマンドパラメタ解析／入力
		if (argc >= 2) {
			cbNtcArgs(argc - 1, &argv[1], GetCommandLine(), 0);
		}
		else {
			AjcPrintF(TEXT("\n 起動パラメタを入力してください。(F1, F2 : ヘルプ)\n  "));
			if (!AjcConInputEx(NULL, 256, buf, AJCTSIZE(buf), AJCCIN_ALL, -1, -1, HelpText, 0, cbNtcArgs)) {
				break;
			}
		}
		AjcPrintF(TEXT("\n"));
		//	ソケット通信インスタンス生成
		hSct = AjcSctCreate();
		//	モード設定（バイナリチャンク受信）
		AjcSctSetChunkMode(hSct, AJCSCT_CM_BIN);
		//	使用するイベント設定
		AjcSctSetEvtMask(hSct, AJCSCT_EV_CONNECT | AJCSCT_EV_DISCONNECT |
							   AJCSCT_EV_CNFAIL  | AJCSCT_EV_RXCHUNK);

		//	サーバと接続
		rsu = AjcSctConnect(hSct, TcpServ, TcpPort, AF_INET, NULL, 0);
		if (rsu) { 																	//	ポート オープン成功？
			while (!fExit) {														//	　キー押下までループ
				if (AjcSctWaitEvent(hSct, &wParam, &lParam, 200)) { 				//	　　イベント待ち，イベントあり？
					AjcSctGetEventData(hSct, lParam, &pDat, &lDat, &param); 		//	　　　イベントデータ取得
					if(wParam & AJCSCT_EV_RXCHUNK ) {								//	●チャンクデータ受信通知？
						AjcSctSendBinData(hSct, pDat, lDat);						//	　　　　エコーバック送信
						ByteCount += lDat;
						AjcPrintF(TEXT("    %u\r"), ByteCount);
					}
					if(wParam & AJCSCT_EV_CONNECT) {								//	●接続通知？
						AjcPrintF(TEXT("サーバと接続しました。\n"));
						AjcPrintF(TEXT("Received bytes count:\n\n    0\r"));
					}
					if(wParam & AJCSCT_EV_DISCONNECT) {								//	●切断通知？
						AjcPrintF(TEXT("通信回線を切断しました。\n"));
					}
					if(wParam & AJCSCT_EV_CNFAIL) {									//	●接続失敗通知？
						AjcPrintF(TEXT("サーバとの接続を失敗しました。\n"));
						fExit = TRUE;
					}
					AjcSctRelEventData(hSct, lParam);								//	　　　イベントデータ開放
				}
				//	キー入力チェック
				if (_kbhit()) fExit = TRUE;
			}
			AjcSctDisconnect(hSct);													//	　回線切断
		}
		else {																		//	Ｃｏｎｅｃｔ失敗？
			AjcPrintF(TEXT("Connectを失敗しました\n"));
		}
		AjcSctDelete(hSct); 														//	インスタンス消去
	} while(0);

	AjcPrintF(TEXT("Ｅｎｔｅｒキーを押してください"));
	getchar();
	return 0;
}
