﻿//
//	SW_SockServer1.c
//
#define AJCSERIALCOMPORT_H_
#include	<AjrCstXX.h>
#include	"resource.h"

#define	WM_SSVEVENT	(WM_APP + 100)
#define	MAX_TXTBOX_LEN	128

//--------------------------------------------------------------------------------------------------------------//
//	ツールチップ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int		id;
	C_UTP	pTxt;
} TIPTBL, *PTIPTBL;
typedef const TIPTBL *PCTIPTBL;

static const TIPTBL TipTbl[] = {
	{IDC_TXT_SNDTEXT	, TEXT("Ｃ言語表記のテキストを設定してください。（ex. ABC\\n）")									},
	{IDC_VTH_TXTCHUNK	, TEXT("リアルタイムに受信したデータをテキストデータとして表示します。\n")
						  TEXT("複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。")			},
	{IDC_VTH_BINCHUNK	, TEXT("リアルタイムに受信したデータをバイナリデータとして表示します。")							},
	{IDC_VTH_INVCHUNK	, TEXT("リアルタイムに受信したテキストデータに不正な制御コードが含まれる場合は、\n")
						  TEXT("テキストチャンクではなく、不正チャンクテキストとしてバイナリ表示します。\n")
						  TEXT("不正な制御コードとは、TAB(0x09)～CR(0x0D)以外の制御コードを意味します。")					},
	{IDC_VTH_TEXT		, TEXT("受信ストリームから制御コード（TAB以外）で区切られたテキストデータを抜き出して表示します。\n")
						  TEXT("\x1B[34mここにファイルをドロップすると、ファイルの内容をバイナリデータとして送信します。")	},
	{IDC_VTH_CTRL		, TEXT("受信ストリームから制御コード（TAB以外）を抜き出して表示します。")							},
	{IDC_VTH_ESC		, TEXT("受信したストリームから、ＥＳＣシーケンス（0x1B～英字）を抜きだして表示します。")			},
	{IDC_VTH_PKT		, TEXT("受信したパケットデータ（DLE・STX～DLE・ETX でサンドイッチされたデータ）をバイナリ表示します。")},
	{IDC_VTH_NOPKT		, TEXT("リアルタイムに受信したデータ内のパケットデータ（DLE・STX～DLE・ETX）以外の部分をテキストとして表示します。\n")
						  TEXT("複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。")}
};

#define	MAX_TIPTBL	(sizeof TipTbl / sizeof TipTbl[0])

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hLbxClients;
static	HAJCSSV 		hSsv;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_DLGPROC_DEF(Client);
static	VO	SetRxTextCode(HWND hDlg);
static	VO	SetTxTextCode(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);
	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	メイン ダイアログ・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UL		lHost;
	UT		szHost[128];
	UT		txt[256];

	hDlgMain		= hDlg;
	hLbxClients		= GetDlgItem(hDlg, IDC_LBX_CLIENTS);

	//	ウインド位置ロード
	AjcLoadWndPos(hDlg, NULL);
	//	ラジオボタンのグループ化
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_RXTEC));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_TXTEC));
	//	ウインドタイトル表示
	lHost = AJCTSIZE(szHost);
	GetComputerName(szHost, &lHost);
	AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("SW_SockServer1 ( %s : 14238 )"), szHost);
	SetWindowText(hDlg, txt);
	//	ホスト名表示
	AjcSetDlgItemStr(hDlg, IDC_LBL_MYNAME, szHost);
	//	ダイアログ項目の初期化
	AjcSetDlgItemUInt(hDlg, IDC_TXT_PORTNO 	 , 14238);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_MAXCLIENT, 10	);
	AjcSetDlgItemChk (hDlg, IDC_RBT_RXSJIS	 , TRUE	);
	AjcSetDlgItemChk (hDlg, IDC_RBT_RXUTF8	 , FALSE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_RXEUC	 , FALSE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_RXAUTO	 , FALSE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_TXSJIS	 , TRUE	);
	AjcSetDlgItemChk (hDlg, IDC_RBT_TXUTF8	 , FALSE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_TXEUC	 , FALSE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_TXAUTO	 , FALSE);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_RXTEC	 , 0	);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_TXTEC	 , 0	);
	//	ソケットサーバ インスタンス生成
	hSsv = AjcSsvCreate();
	//	送受信テキスト文字コード設定
	SetRxTextCode(hDlg);
	SetTxTextCode(hDlg);
	//	チャンクモード設定
	AjcSsvSetChunkMode(hSsv, AJCSSV_CM_BOTH);
	//	ダイアログ項目のロード
	AjcLoadAllControlSettings (hDlg, TEXT("DlgSetting"), AJCOPT3(AJCCTL_SELACT_, ALL, NTCCHK, NTCRBT));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
//	クライアント・ダイアログ クローズ
static BOOL CALLBACK cbDisconnect(HAJCSSVCLI hCli, UX cbp)
{
	HWND	hDlgCli;
	if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
		DestroyWindow(hDlgCli);
	}
	return TRUE;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ウインド位置セーブ
	AjcSaveWndPos(hDlg, NULL);
	//	全クライアントダイアログ クローズ
	AjcSsvEnumClients(hSsv, 0, cbDisconnect);
	//	ダイアログ項目のセーブ
	AjcSaveAllControlSettings(hDlg);
	//	ソケットサーバ インスタンス消去
	AjcSsvDelete(hSsv);

	PostQuitMessage(0);
	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND	 	)
{
	int		id = LOWORD(wParam);
	if (HIWORD(wParam) == BN_CLICKED) {
		if		(id >= IDC_RBT_RXSJIS && id <= IDC_RBT_RXAUTO) SetRxTextCode(hDlg);
		else if (id >= IDC_RBT_TXSJIS && id <= IDC_RBT_TXAUTO) SetRxTextCode(hDlg);
	}
	return TRUE;
}
//----- ソケット(TCP/IP)イベント -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SSVEVENT		)
{
	UI		time = GetTickCount();
	UI		len, param;
	union {UTP pTxt; BCP pBcp; UBP pBin; VOP pVop;} u;
	HAJCSSVCLI	hCli = NULL;
	UI			ThreadId = 0;
	UT			szIpAddr[256] = {0};
	HWND		hDlgCli;
	HWND		hLog, hVth;

	//	イベントデータ取得
	AjcSsvGetEventData(hSsv, lParam, &u.pVop, &len, &param);
	//	クライアント情報を取得し、クライアントのＩＰアドレスを設定
	if (AjcSsvGetClient   (hSsv, lParam, &hCli)) {
		ThreadId = AjcSsvGetThreadId(hCli);
		AjcSsvGetIpAddrStr(hCli, szIpAddr, AJCTSIZE(szIpAddr));
	}

	switch (wParam) {
		case AJCSSV_EV_START:									//●サーバ開始通知
			//	サーバ開始／終了ボタン有効化変更
			AjcEnableDlgItem(hDlgMain, IDC_CMD_START, FALSE);
			AjcEnableDlgItem(hDlgMain, IDC_CMD_STOP , TRUE );
			//	コントロールの無効化
			AjcEnableDlgItem(hDlg, IDC_TXT_PORTNO	, FALSE);
			AjcEnableDlgItem(hDlg, IDC_TXT_MAXCLIENT, FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_RXTEC	, FALSE, FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_TXTEC	, FALSE, FALSE);
			break;

		case AJCSSV_EV_STOP:									//●サーバ停止通知
			//	サーバ開始／終了ボタン有効化変更
			AjcEnableDlgItem(hDlgMain, IDC_CMD_START, TRUE );
			AjcEnableDlgItem(hDlgMain, IDC_CMD_STOP , FALSE);
			//	コントロールの有効化
			AjcEnableDlgItem(hDlg, IDC_TXT_PORTNO	, TRUE);
			AjcEnableDlgItem(hDlg, IDC_TXT_MAXCLIENT, TRUE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_RXTEC	, TRUE, TRUE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_TXTEC	, TRUE, TRUE);
			break;

		case AJCSSV_EV_CONNECT:									//●接続通知
		{	int		ix;
			UT		txt[256];
			//	クライアント用ダイアログ生成
			hDlgCli = CreateDialogParam(hInst, MAKEINTRESOURCE(IDD_CLIENT), NULL, AJC_DLGPROC_NAME(Client), (LPARAM)hCli);
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("クライアントウインド（IP-Address = %s, Thread-ID = 0x%08X）"), szIpAddr, ThreadId);
			SetWindowText(hDlgCli, txt);
			ShowWindow(hDlgCli, SW_SHOW);
			//	クライアントにダイアログを関連付ける
			AjcSsvSetClientData(hCli, (UX)hDlgCli);
			//	リストボックスにクライアント登録
			ix = AjcLbxAddString(hLbxClients, szIpAddr);
			AjcLbxSetItemData(hLbxClients, ix, (UX)hCli);
			break;
		}
		case AJCSSV_EV_DISCONNECT:								//●切断通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				int		ix;
				//	クライアントダイアログを閉じる
				DestroyWindow(hDlgCli);
				//	リストボックスからクライアント削除
				if ((ix = AjcLbxFindString(hLbxClients, -1, szIpAddr)) >= 0) {
					AjcLbxDeleteString(hLbxClients, ix);
				}
			}
			break;

		case AJCSSV_EV_RXCHUNK:									//●チャンクデータ受信通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				AjcVthPrintF(hLog, TEXT("%9d: RXCHUNK   len=%5d, param=0x%08X\n"), time, len, param);
				//	バイナリチャンク
				if (param == 0) {
					hVth = GetDlgItem(hDlgCli, IDC_VTH_BINCHUNK);
					AjcVthHexDump(hVth, (C_VOP)u.pBin, len);
					AjcVthPrintF (hVth, TEXT("\n"));
				}
				//	テキストチャンク
				else {
					hVth = GetDlgItem(hDlgCli, IDC_VTH_TXTCHUNK);
					AjcVthPutText(hVth, u.pTxt, -1);
				}
			}
			break;

		case AJCSSV_EV_RXTEXT:									//●テキストデータ通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				hVth = GetDlgItem(hDlgCli, IDC_VTH_TEXT);
				AjcVthPrintF(hLog, TEXT("%9d: RXTEXT    len=%5d, param=0x%08X\n"), time, len, param);
				AjcVthPrintF(hVth, TEXT("%s\n"), u.pTxt);
			}
			break;

		case AJCSSV_EV_RXESC:									//●ＥＳＣデータ通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				hVth = GetDlgItem(hDlgCli, IDC_VTH_ESC);
				AjcVthPrintF(hLog, TEXT("%9d: RXESC     len=%5d, param=0x%08X\n"), time, len, param);
				AjcVthPrintF(hVth, TEXT("\\x1B%s\n"), u.pTxt + 1);
			}
			break;

		case AJCSSV_EV_RXCTRL:									//●制御コード通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				hVth = GetDlgItem(hDlgCli, IDC_VTH_CTRL);
				AjcVthPrintF(hLog, TEXT("%9d: RXCTRL    len=%5d, param=0x%08X, data=%02X\n"), time, len, param, *u.pBin);
				AjcVthPrintF(hVth, TEXT("%02X\n"), *u.pTxt);
			}
			break;

		case AJCSSV_EV_RXPKT:									//●パケットデータ通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				hVth = GetDlgItem(hDlgCli, IDC_VTH_PKT);
				AjcVthPrintF (hLog, TEXT("%9d: RXPKT     len=%5d, param=0x%08X\n"), time, len, param);
				AjcVthHexDump(hVth, (C_VOP)u.pBin, len);
				AjcVthPrintF (hVth, TEXT("\n"));
			}
			break;

		case AJCSSV_EV_TXEMPTY:									//●送信完了通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				AjcVthPrintF(hLog, TEXT("%9d: TXEMPTY   len=%5d, param=0x%08X\n"), time, len, param);
			}
			break;

		case AJCSSV_EV_RXNOPKT:									//●パケット外テキストデータ
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				hVth = GetDlgItem(hDlgCli, IDC_VTH_NOPKT);
				AjcVthPrintF (hLog, TEXT("%9d: RXNOPKT   len=%5d, param=0x%08X\n"), time, len, param);
				AjcVthPutText(hVth, u.pTxt, -1);
			}
			break;

		case AJCSSV_EV_INVCHUNK:								//●不正チャンクテキスト受信通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				hVth = GetDlgItem(hDlgCli, IDC_VTH_INVCHUNK);
				AjcVthPrintF (hLog, TEXT("%9d: INVCHUNK  len=%5d, param=0x%08X\n"), time, len, param);
				AjcVthHexDump(hVth, (C_VOP)u.pBin, len);
				AjcVthPrintF (hVth, TEXT("\n"));
			}
			break;

		case AJCSSV_EV_RXERR:									//●受信エラー通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				AjcVthPrintF(hLog, TEXT("%9d: RXERR     len=%5d, param=0x%08X\n"), time, len, param);
			}
			break;

		case AJCSSV_EV_TXERR:									//●送信エラー通知
			if (AjcSsvGetClientData(hCli, (UXP)&hDlgCli)){
				hLog = GetDlgItem(hDlgCli, IDC_VTH_EVTLOG);
				AjcVthPrintF(hLog, TEXT("%9d: TXERR     len=%5d, param=0x%08X\n"), time, len, param);
			}
			break;

		case AJCSSV_EV_ERR:										//●その他のエラー通知
			hLog = GetDlgItem(hDlgMain, IDC_VTH_ERROR);
			AjcVthPrintF(hLog, TEXT("%9d: ERR       len=%5d, param=0x%08X\n"), time, len, param);
			break;

	}

	//	イベントデータ開放
	AjcSsvRelEventData(hSsv, lParam);
			
	return TRUE;
}
//----- サーバ開始ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START		)
{
	UI		MaxClient;
	UT		szPort[64];	

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgItemStr (hDlg, IDC_TXT_PORTNO, szPort, AJCTSIZE(szPort));
		MaxClient = AjcGetDlgItemUInt(hDlg, IDC_TXT_MAXCLIENT);
		AjcSsvStart(hSsv, szPort, AF_INET, MaxClient, hDlg, WM_SSVEVENT);
	}
	return TRUE;
}
//----- サーバ停止ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcSsvStop(hSsv, 10000);
	}
	return TRUE;
}
//----- 受信テキストエンコード ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_RXTEC		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		//	受信テキストエンコード設定
		switch (lParam) {
			case 0: AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_SJIS);	break;
			case 1: AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_UTF8);	break;
			case 2: AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_EUC );	break;
			case 3: AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_AUTO);	break;
		}
		//	送信テキストエンコード設定（送信エンコードが AUTO の場合、受信エンコードと同一とするため）
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_TXTEC, AJCRBTN_SELECT), AjcGetDlgItemUInt(hDlg, IDC_GRP_TXTEC));
	}
	return TRUE;
}
//----- 送信テキストエンコード ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_TXTEC		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		//	送信テキストエンコード設定
		switch (lParam) {
			case 0: AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_SJIS);	break;
			case 1: AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_UTF8);	break;
			case 2: AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_EUC );	break;
			case 3: AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_AUTO);	break;
		}
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_COMMAND 	   )
	AJC_DLGMAP_MSG(Main, WM_SSVEVENT 	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_START	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	   )
	AJC_DLGMAP_CMD(Main, IDC_GRP_RXTEC	   )
	AJC_DLGMAP_CMD(Main, IDC_GRP_TXTEC	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END
//==============================================================================================================//
//																												//
//	クライアント ダイアログ・プロシージャ																		//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, WM_INITDIALOG 	)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)lParam;
	UI			i;
	UT			szIpAddr[256];
	UT			sect[256];
	//	ダイアログにクライアントハンドルを関連付ける
	SetProp(hDlg, TEXT("ClientHandle"), (HANDLE)lParam);
	//	ＩＰアドレス文字列取得
	AjcSsvGetIpAddrStr(hCli, szIpAddr, AJCTSIZE(szIpAddr));
	//	ウインド位置ロード
	AjcSnPrintF(sect, AJCTSIZE(sect), TEXT("WndPos_%s"), szIpAddr);
	AjcLoadWndPos(hDlg, sect);
	//	 設定値ロード
	AjcSnPrintF(sect, AJCTSIZE(sect), TEXT("Settings_%s"), szIpAddr);
	AjcLoadAllControlSettings(hDlg, sect, AJCCTL_SELACT_ALL);
	//	テキストボックス長設定
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDTEXT, MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDESC , MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDBIN , MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDPKT , MAX_TXTBOX_LEN - 1);
	//----- ツールチップ設定 ------------------------//
	for (i = 0; i < MAX_TIPTBL; i++) {
		AjcTipTextAdd(GetDlgItem(hDlg, TipTbl[i].id), TipTbl[i].pTxt);
	}
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, WM_DESTROY		)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	UT			szIpAddr[256];
	UT			sect[256];
	//	ＩＰアドレス文字列取得
	AjcSsvGetIpAddrStr(hCli, szIpAddr, AJCTSIZE(szIpAddr));
	//	ウインド位置セーブ
	AjcSnPrintF(sect, AJCTSIZE(sect), TEXT("WndPos_%s"), szIpAddr);
	AjcSaveWndPos(hDlg, sect);
	//	 設定値セーブ
	AjcSnPrintF(sect, AJCTSIZE(sect), TEXT("Settings_%s"), szIpAddr);
	AjcSaveAllControlSettings(hDlg);
	return TRUE;
}
//----- テキスト送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_CMD_SNDTEXT			)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	UT			txt[MAX_TXTBOX_LEN];
	UT			snd[MAX_TXTBOX_LEN];
	AjcGetDlgItemStr(hDlg, IDC_TXT_SNDTEXT, txt, AJCTSIZE(txt));
	AjcCLangStrToBin(txt, snd, AJCTSIZE(snd));
	AjcSsvSendText(hCli, snd, -1);
	return TRUE;
}
//----- ＥＳＣ送信ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_CMD_SNDESC			)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	UT			txt[MAX_TXTBOX_LEN];
	AjcGetDlgItemStr(hDlg, IDC_TXT_SNDESC, txt, AJCTSIZE(txt));
	AjcSsvSendChar(hCli, 0x1B);
	AjcSsvSendText(hCli, txt, -1);
	return TRUE;
}
//----- バイナリ送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_CMD_SNDBIN			)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	UI	ix;
	UTP	p;
	UT	txt[MAX_TXTBOX_LEN];
	UB	bin[MAX_TXTBOX_LEN];
	ix = 0;
	AjcGetDlgItemStr(hDlg, IDC_TXT_SNDBIN, txt, AJCTSIZE(txt));
	if (p = MAjcStrTok(txt, TEXT(" "))) {
		do {
			if (AjcHexStrToUB(p, 2, &bin[ix])) {
				ix++;
			}
		} while (p = MAjcStrTok(NULL, TEXT(" ")));
	}
	if (ix != 0) {
		AjcSsvSendBinData(hCli, bin, ix);
	}
	return TRUE;
}
//----- パケット送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_CMD_SNDPKT			)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	UI	ix;
	UTP	p;
	UT	txt[MAX_TXTBOX_LEN];
	UB	bin[MAX_TXTBOX_LEN];
	ix = 0;
	AjcGetDlgItemStr(hDlg, IDC_TXT_SNDPKT, txt, AJCTSIZE(txt));
	if (p = MAjcStrTok(txt, TEXT(" "))) {
		do {
			if (AjcHexStrToUB(p, 2, &bin[ix])) {
				ix++;
			}
		} while (p = MAjcStrTok(NULL, TEXT(" ")));
	}
	if (ix != 0) {
		AjcSsvSendPacket(hCli, bin, ix);
	}
	return TRUE;
}
//----- 切断ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_CMD_DISC			)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	AjcSsvDisconnect(hCli);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDCANCEL			)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));
	//	クライアント切断
	AjcSsvDisconnect(hCli);
	//	ダイアログをクローズ
	DestroyWindow(hDlg);
	return TRUE;
}
//----- 全てクリアーボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_CMD_CLRALL	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_TXTCHUNK));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_BINCHUNK));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_TEXT	 ));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_CTRL	 ));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_ESC	 ));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_INVCHUNK));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_PKT	 ));
		AjcVthClear(GetDlgItem(hDlg, IDC_VTH_NOPKT	 ));
	}
	return TRUE;
}
//----- ＶＴＨ（テキスト）からの通知 ---------------------------------------------------------------------------//
AJC_DLGPROC(Client, IDC_VTH_TEXT	)
{
	HAJCSSVCLI	hCli = (HAJCSSVCLI)GetProp(hDlg, TEXT("ClientHandle"));

	if (HIWORD(wParam) == AJCVTHN_DROPFILE) {		//	ファイルドロップ
		UI		i, nFile = (UI)lParam;
		HANDLE	hFile;
		UL		bytes;
		UT		path[MAX_PATH];
		UB		buf[2014];
		HWND	hVth = GetDlgItem(hDlg, IDC_VTH_TEXT);

		for (i = 0; i < nFile; i++) {
			AjcVthGetDroppedFile(hVth, path);
			if ((hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL)) != INVALID_HANDLE_VALUE) {
				while (ReadFile(hFile, buf, sizeof buf, &bytes, NULL) && bytes != 0) {
					AjcSsvSendBinData(hCli, buf, bytes);
				}
				CloseHandle(hFile);
			}
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Client)
	AJC_DLGMAP_MSG(Client, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Client, WM_DESTROY		)

	AJC_DLGMAP_CMD(Client, IDC_CMD_SNDTEXT	)
	AJC_DLGMAP_CMD(Client, IDC_CMD_SNDESC	)
	AJC_DLGMAP_CMD(Client, IDC_CMD_SNDBIN	)
	AJC_DLGMAP_CMD(Client, IDC_CMD_SNDPKT	)
	AJC_DLGMAP_CMD(Client, IDC_CMD_DISC		)
	AJC_DLGMAP_CMD(Client, IDC_CMD_CLRALL	)
	AJC_DLGMAP_CMD(Client, IDCANCEL			)
	AJC_DLGMAP_CMD(Client, IDC_VTH_TEXT		)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	受信テキストエンコード設定																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetRxTextCode(HWND hDlg)
{
	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_RXSJIS)) AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_SJIS);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_RXUTF8)) AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_UTF8);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_RXEUC )) AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_EUC );
	else											 AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_AUTO);
}
//--------------------------------------------------------------------------------------------------------------//
//	送信テキストエンコード設定																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetTxTextCode(HWND hDlg)
{
	if		(AjcGetDlgItemChk(hDlg, IDC_RBT_TXSJIS)) AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_SJIS);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_TXUTF8)) AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_UTF8);
	else if (AjcGetDlgItemChk(hDlg, IDC_RBT_TXEUC )) AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_EUC );
	else											 AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_AUTO);
}
