﻿//
//	SW_SubClass2.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define	WM_SUBCLASS	(WM_APP + 100)

//----- 作業領域 -----------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HWND			hButton;
static	WNDPROC			WndProcButton = NULL;
static	HWND			hBtn, hTxt, hSpn;

//----- 内部サブ関数 -------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_WNDPROC_DEF(SUB);

//--------------------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain(HINSTANCE hInstance, HINSTANCE hinstPrev, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	AjcDgcSetup();

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UDACCEL	acc[1] = {0, -1};

	hDlgMain = hDlg;
	hBtn	 = GetDlgItem(hDlg, IDC_BUTTON );
	hTxt	 = GetDlgItem(hDlg, IDC_TEXTBOX);
	hSpn	 = GetDlgItem(hDlg, IDC_SPIN   );

	//	ツールチップ設定
	AjcTipTextAdd(hBtn, TEXT("右の数値をクリアーします（0を設定します）"));
	AjcTipTextAdd(hTxt, TEXT("数値設定用テキストボックス（-10 ～ 10）"));
	AjcTipTextAdd(hSpn, TEXT("左の数値を増減します"));
	//	スピンボタン初期化
	SendMessage(hSpn, UDM_SETRANGE, 0, MAKELONG(-10, 10));
	SendMessage(hSpn, UDM_SETACCEL, 1, (LPARAM)acc);
	//	サブクラス化
	WndProcButton = MAjcMmpSetSubclass(SUB, hBtn);
	WndProcButton = MAjcMmpSetSubclass(SUB, hTxt);
	WndProcButton = MAjcMmpSetSubclass(SUB, hSpn);
	//	ウインドを中央に移動
	AjcMoveWindowToCenterOfMonitor(hDlg);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	PostQuitMessage(0);
	return TRUE;
}
//----- IDC_BUTTON ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_BUTTON		)
{
	AjcSetDlgItemSInt(hDlg, IDC_TEXTBOX, 0);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_CMD(Main, IDC_BUTTON		)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	３つのコントロールをサブクラス化したウインドプロシージャ													//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB, WM_RBUTTONDOWN			)
{
	MessageBox(NULL, TEXT("右クリックしました。"), TEXT("SW_SubClass2"), MB_OK);
	return MAjcMmpCallOrgWndProc(SUB);	//	オリジナルのウインドプロシージャへ続く（インターセプトする場合は０を返す）
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB)
	AJC_WNDMAP_MSG(SUB, WM_RBUTTONDOWN	)
AJC_WNDMAP_END

