﻿ //
 //  SW_TextFile.c
 //
#include	<AjrCstXX.h>
#include	<shlwapi.h>
#include	"resource.h"

#define	MAX_CBOSTR	MAX_PATH
#define	EXTRA_FILE_ATT (FILE_ATTRIBUTE_ARCHIVE | FILE_ATTRIBUTE_NORMAL)
//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	UT			AppName[] = TEXT("エンコード変換");
static	HINSTANCE	hInst		= NULL;			//	自インスタンスハンドル
static	HWND		hDlgMain	= NULL;			//	ダイアログハンドル
static	HWND		hCboPath	= NULL;			//	入力パス・コンボボックスハンドル
static	HWND		hTxtPath	= NULL;			//	入力パス・テキストボックスハンドル
static	HWND		hCboWild	= NULL;			//	ワイルドカード・コンボボックスハンドル
static	HWND		hTxtWild	= NULL;			//	ワイルドカード・テキストボックスハンドル
static	HWND		hVth		= NULL;			//	VTHコントロール

static	SIZE		WndMinSize;					//	ダイアログ最小サイズ
static	int			yVth;						//	ＶＴＨ表示位置

static	HAJCFILE	hLogFile	= NULL;			//	ログファイルハンドル
static	BOOL		fLogFirst	= TRUE;			//	初回ログ出力フラグ
static	EAJCTEC		TecTo		= AJCTEC_UTF_8;	//	変換するファイルエンコード
static	BOOL		fBusy		= FALSE;		//	変換処理中フラグ
static	BOOL		fStop		= FALSE;		//	中止フラグ
static	BOOL		fCan		= FALSE;		//	キャンセルフラグ
static	UI			Count		= 0;			//	ファイルカウンタ
static	UI			nOK			= 0;			//	成功数カウンタ
static	UI			nNG			= 0;			//	失敗数カウンタ
static	UI			nNC			= 0;			//	未変換カウンタ
static	UT			szWild[256];				//	対象ファイルのワイルドカード
static	UT			szSrcPath[MAX_PATH];		//	ソースパス
static	UT			szSavPath[MAX_PATH];		//	ソース退避パス
static	UT			szSavTime[MAX_PATH];		//	ソース退避サブパス（末尾に日時付加）
static	UT			szLogFile[MAX_PATH];		//	ログファイルパス

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main	);
static	BOOL		SaveSource(HWND hDlg, C_UTP pWild);
static	BOOL		ChangeTec (HWND hDlg, C_UTP pWild);
static	BOOL		ChkInpTec(HWND hDlg, EAJCTEC tec, BOOL bom);
static	C_UTP		TecName(EAJCTEC tec, BOOL bom);
static	VO			LogPrintF(C_UTP pFmt, ...);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;


	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	RECT	rect;
	UT		path[MAX_PATH];

	hDlgMain = hDlg;
	hCboPath = GetDlgItem(hDlg, IDC_CBO_PATH);	hTxtPath = AjcGetCtrlCboEditHandle(hCboPath);
	hCboWild = GetDlgItem(hDlg, IDC_CBO_WILD);	hTxtWild = AjcGetCtrlCboEditHandle(hCboWild);
	hVth	 = GetDlgItem(hDlg, IDC_VTH);
	//	ダイアログ最小サイズ設定
	GetWindowRect(hDlg, &rect);
	WndMinSize.cx = rect.right - rect.left;
	WndMinSize.cy = rect.bottom - rect.top;
	//	VTH先頭位置設定
	GetWindowRect(hVth, &rect);
	MapWindowPoints(NULL, hDlg, (LPPOINT)&rect, 2);
	yVth = rect.top;
	//	入力退避パスデフォルト設定
	GetTempPath(MAX_PATH, path);
	AjcPathCat(path, TEXT("ChangeTextEncode"), MAX_PATH);
	CreateDirectory(path, NULL);
	AjcSetDlgItemStr(hDlg, IDC_TXT_SVPATH, path);
	//	コンボボックスサブクラス化
	AjcSbcComboBoxEx(hCboPath, 40, MAX_CBOSTR - 1, AJCSBCF_IGNORWIDTH);
	AjcSbcTipCtrl	(hCboPath, TRUE);
	AjcSbcComboBoxEx(hCboWild, 40, MAX_CBOSTR - 1, AJCSBCF_IGNORWIDTH);
	AjcSbcTipCtrl	(hCboWild, TRUE);

	//	ラジオボタングループ化
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_TECAFT));
	//	チェックボックス／ラジオボタン初期化
	AjcSetDlgItemChk (hDlg, IDC_CHK_SJIS  , TRUE);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_TECAFT, AJCTEC_UTF_8);
	//	フォルダドロップ許可
	AjcEnableCtrlToDrop   (hTxtPath, AJCDROP_DIR);
	AjcEnableCtrlToDrop   (hTxtWild, AJCDROP_DIR);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_SVPATH, AJCDROP_DIR);
	//	全設定値読み出し
	AjcLoadAllControlSettings (hDlg, TEXT("MySect"), AJCCTL_SELACT_ALL);
	//	VTH配置
	GetClientRect(hDlg, &rect);
	SendMessage(hDlg, WM_SIZE, SIZE_RESTORED, MAKELONG(rect.right - rect.left, rect.bottom - rect.top));

	//	初期メッセージ
	AjcVthPutText(hVth, TEXT(" 指定されたファイルのエンコード（Shift-JIS / UTF-8 / EUC-J / UTF-16）を変更します。\n"), -1);
	AjcVthPutText(hVth, TEXT("\n"), -1);
	AjcVthPutText(hVth, TEXT(" 「入力パス」下の「ワイルドカード」で指定したファイルエンコード変更対象となります。\n"), -1);
	AjcVthPutText(hVth, TEXT("\n"), -1);
	AjcVthPutText(hVth, TEXT(" 変更対象のファイルは「入力ファイル退避パス」下に、日時を付加したフォルダを作成し退避されます。\n"), -1);
	AjcVthPutText(hVth, TEXT("\n"), -1);
	AjcVthPutText(hVth, TEXT(" 「ワイルドカード」はセミコロン( ; )か、スラッシュ( / )で区切って複数指定できます。\n"), -1);
	AjcVthPutText(hVth, TEXT("\n"), -1);
	AjcVthPutText(hVth, TEXT(" ログの内容は、「入力ファイル退避パス」下にも出力されます。（ .logv ファイル ）\n"), -1);

	return TRUE;
}
//----- WM_DESTROY --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	 )
{
	//	ログファイルクローズ
	if (hLogFile != NULL) {
		AjcFClose(hLogFile);
		hLogFile = NULL;
	}
	//	全設定値セーブ
	AjcSaveAllControlSettings (hDlg);

	PostQuitMessage(0);
	return TRUE;
}
//----- WM_SIZING ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZING	 )
{
	LPRECT		p = (LPRECT)lParam;
	int			w = p->right - p->left;
	int			h = p->bottom - p->top;

	if (w < WndMinSize.cx) p->right	= p->left + WndMinSize.cx;
	if (h < WndMinSize.cy) p->bottom = p->top + WndMinSize.cy;

	return TRUE;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE	 )
{
	RECT	rect;
	int		w, h;
	GetClientRect(hDlg, &rect);
	w = rect.right - rect.left;
	h = rect.bottom - rect.top;
	SetWindowPos(hVth, NULL, 0, yVth, w - GetSystemMetrics(SM_CXVSCROLL), h - yVth - 5, SWP_NOMOVE);

	return TRUE;
}
//----- IDC_GRP_TEC --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_TECAFT	)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		if (lParam == AJCTEC_UTF_8 || lParam == AJCTEC_UTF_16LE || lParam == AJCTEC_UTF_16BE) {
			AjcEnableDlgItem(hDlg, IDC_CHK_BOM, TRUE);
		}
		else {
			AjcEnableDlgItem(hDlg, IDC_CHK_BOM, FALSE);
		}
	}
	return TRUE;
}
//----- IDC_CMD_STOP -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP	)
{
	if (fBusy) {
		fStop = TRUE;
	}
	return TRUE;
}
//----- IDOK（開始） -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK )
{
	SYSTEMTIME	lt;
	UT	last [MAX_PATH];
	UT	tstr [128];
	UT	fname[MAX_PATH];
	UT	fext [MAX_PATH];

	//	ソースパス設定
	AjcGetCtrlStr(hTxtPath, szSrcPath, MAX_PATH);
	PathRemoveBackslash(szSrcPath);

	//	ソース退避パス設定
	AjcGetDlgItemStr(hDlg, IDC_TXT_SVPATH, szSavPath, MAX_PATH);
	PathRemoveBackslash(szSavPath);

	//	対象ワイルドカード設定
	AjcGetCtrlStr(hTxtWild, szWild, AJCTSIZE(szWild));

	//	テキストエンコード設定
	TecTo = (EAJCTEC)AjcGetDlgItemUInt(hDlg, IDC_GRP_TECAFT);	//	変更先エンコード

	//	ボタングレー化
	AjcEnableDlgItem(hDlg, IDOK 	   , FALSE);
	AjcEnableDlgItem(hDlg, IDCANCEL    , FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, TRUE);

	//	フラグ初期化
	fBusy = TRUE;		//	エンコード変更処理中
	fStop = FALSE;		//	中止フラグ
	fCan  = FALSE;		//	キャンセルフラグ
	Count = 0;			//	ファイルカウンタ

	do {
		//	ソースパスチェック
		if (szSrcPath[0] == 0 || !AjcPathIsDirectory(szSrcPath)) {
			UT	txt[MAX_PATH + 128];
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("ソースフォルダが見つかりません(%s)\n"), szSrcPath);
			MessageBox(hDlg, txt, AppName, MB_ICONERROR);
			goto idok_end;
		}
		//	ソース退避パスチェック
		if (szSavPath[0] == 0 || !AjcPathIsDirectory(szSavPath)) {
			UT	txt[MAX_PATH + 128];
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("ソース退避フォルダが見つかりません(%s)\n"), szSavPath);
			MessageBox(hDlg, txt, AppName, MB_ICONERROR);
			goto idok_end;
		}
		//	コンボボックスの現表示パスを最新項目に設定
		AjcSbcSetMostNew(hCboPath);
		AjcSbcSetMostNew(hCboWild);

		//	時刻文字列作成
		GetLocalTime(&lt);
		AjcSnPrintF(tstr, AJCTSIZE(tstr), TEXT("(%04d-%02d-%02d_%02d-%02d-%02d-%03d)"),
								lt.wYear, lt.wMonth, lt.wDay, lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);

		//	ソースフォルダの最終パス名抜出
		MAjcSplitPath(szSrcPath, NULL, NULL, fname, fext);
		MAjcMakePath (last	   , NULL, NULL, fname, fext);

		//	ログファイルパス作成
		AjcStrCpy(szLogFile, MAX_PATH, szSavPath);
		AjcPathCat(szLogFile, last, MAX_PATH);
		MAjcStrCat(szLogFile, MAX_PATH, tstr);
		MAjcStrCat(szLogFile, MAX_PATH, TEXT(".logv"));

		//	ログファイル生成（エラー発生しても続行する）
		if (!(hLogFile = AjcFCreate(szLogFile, AJCTEC_UTF_8, TRUE))) {
			LogPrintF(TEXT("\x1B[31m"));
			LogPrintF(TEXT("\tログファイルの作成を失敗しました(%s)\n"), szLogFile);
			LogPrintF(TEXT("\x1B[0m"));
		}

		//	開始ログ
		LogPrintF(TEXT("\x1B[37;40m"));
		LogPrintF(TEXT("処理を開始します - %s%s\n"), last, tstr);
		LogPrintF(TEXT("\x1B[0m"));

		//	ソース退避ディレクトリ作成
		{
			//	ソース退避ディレクトリ名作成
			MAjcStrCpy(szSavTime, MAX_PATH, szSavPath);
			AjcPathCat(szSavTime, last, MAX_PATH);
			MAjcStrCat(szSavTime, MAX_PATH, tstr);
			//	ディレクトリ作成
			if (!CreateDirectory(szSavTime, NULL)) {
				LogPrintF(TEXT("\x1B[31m"));
				LogPrintF(TEXT("\tソース退避ディレクトリの作成を失敗しました。(%s)。\n"), szSavTime);
				LogPrintF(TEXT("\x1B[0m"));
				break;
			}
		}
		//	ソース退避処理
		{	UT	wild[MAX_PATH];
			LogPrintF(TEXT("●ソースファイルを退避します\n"));
			MAjcStrCpy(wild, MAX_PATH, szSrcPath);
			AjcPathCat(wild, TEXT("*.*"), MAX_PATH);
			Count = 0;
			SaveSource(hDlg, wild);
		}

		//	エンコード変更処理
		{	UT	wild[MAX_PATH];
			LogPrintF(TEXT("●エンコード変換を実行します\n"));
			MAjcStrCpy(wild, MAX_PATH, szSrcPath);
			AjcPathCat(wild, TEXT("*.*"), MAX_PATH);
			Count = nOK = nNG = nNC = 0;
			ChangeTec(hDlg, wild);
		}

	} while(0);

	//	キャンセル押下ならば、終了
	if (fCan) {
		LogPrintF(TEXT("\x1B[31m"));
		LogPrintF(TEXT("\tキャンセルされました。処理を終了します。\n"));
		LogPrintF(TEXT("\x1B[0m"));
		DestroyWindow(hDlg);
	}

	//	中止ボタン押下
	if (fStop) {
		LogPrintF(TEXT("\x1B[31m"));
		LogPrintF(TEXT("\t処理を中止しました。\n"));
		LogPrintF(TEXT("\x1B[0m"));
	}
	else {
		//	終了ログ
		LogPrintF(TEXT("\x1B[34m"));
		LogPrintF(TEXT("処理を終了しました - %s%s ( OK = %d (No Change = %d), NG = %d )\n"), last, tstr, nOK, nNC, nNG);
		LogPrintF(TEXT("\x1B[0m"));
	}
idok_end:;

	//	フラグ解除
	fBusy = FALSE;
	fStop = FALSE;
	fCan  = FALSE;

	//	ボタングレー化解除
	AjcEnableDlgItem(hDlg, IDOK		   , TRUE);
	AjcEnableDlgItem(hDlg, IDCANCEL    , TRUE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, FALSE);

	//	ログファイルクローズ
	if (hLogFile != NULL) {
		AjcFClose(hLogFile);
		hLogFile = NULL;
	}
	return TRUE;
}
//----- IDCANCEL -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL)
{
	if (fBusy) {
		fStop = TRUE;
		fCan  = TRUE;
	}
	else {
		DestroyWindow(hDlg);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY		)
	AJC_DLGMAP_MSG(Main, WM_SIZING		)
	AJC_DLGMAP_MSG(Main, WM_SIZE		)
	AJC_DLGMAP_CMD(Main, IDC_GRP_TECAFT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	)
	AJC_DLGMAP_CMD(Main, IDOK			)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	ソースフォルダセーブ処理																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SaveSource(HWND hDlg, C_UTP pWild)
{
	HANDLE				hFind = NULL;
	WIN32_FIND_DATA		fd;
	HAJCFILE			hInp = NULL;
	HAJCFILE			hOut = NULL;
	UT					drv[MAX_PATH];
	UT					dir[MAX_PATH];

	AjcDoEvent();

	if (!fStop && !fCan) {
		if ((hFind = FindFirstFile(pWild, &fd)) != INVALID_HANDLE_VALUE) {
			do {
				AjcDoEvent();
				//	ファイル
				if (!(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
					UT	path_inp[MAX_PATH];
					UT	path_out[MAX_PATH];
					UT	path_dir[MAX_PATH];
					//	ファイルパス名作成
					MAjcSplitPath(pWild   , drv, dir, NULL, NULL);
					MAjcMakePath (path_inp, drv, dir, NULL, NULL);
					AjcPathCat	 (path_inp, fd.cFileName, MAX_PATH);
					//	ワイルドカード一致
					if (AjcPathMatchSpec(path_inp, szWild)) {
						UI	stl;
						//	転送先ファイルパス設定
						stl = (UI)MAjcStrLen(szSrcPath);
						MAjcStrCpy(path_out, MAX_PATH, szSavTime);
						AjcPathCat(path_out, &path_inp[stl], MAX_PATH);
						//	転送先ディレクトリ作成
						MAjcSplitPath(path_out, drv, dir, NULL, NULL);
						MAjcMakePath (path_dir, drv, dir, NULL, NULL);
						AjcCreateDirectoryStruct(path_dir);
						//	ファイルコピー
						if (CopyFile(path_inp, path_out, FALSE)) {
							LogPrintF(TEXT("\t%5d : Save OK - %s\n"), ++Count, path_out);
						}
						else {
							LogPrintF(TEXT("\x1B[31m"));
							LogPrintF(TEXT("\t%5d : Save NG - %s\n"), ++Count, path_out);
							LogPrintF(TEXT("\x1B[0m"));
						}
					}
				}
				//	ディレクトリならば、サブディレクトリ検索（再帰呼び出し）
				else {
					if (AjcGetDlgItemChk(hDlg, IDC_CHK_SUBDIR)) {
						UT	wild[MAX_PATH];
						if (MAjcStrCmp(fd.cFileName, TEXT(".")) != 0 && MAjcStrCmp(fd.cFileName, TEXT("..")) != 0) {
							MAjcSplitPath(pWild, drv, dir, NULL, NULL);
							MAjcMakePath (wild , drv, dir, NULL, NULL);
							AjcPathCat(wild, fd.cFileName, MAX_PATH);
							AjcPathCat(wild, TEXT("*.*"), MAX_PATH);
							//	サブディレクトリ検索（再帰呼び出し）
							SaveSource(hDlg, wild);
						}
					}
				}
			} while (FindNextFile(hFind, &fd));
			//	ファイル検索クローズ
			FindClose(hFind);
		}
	}
	return (!fStop && !fCan);	//	TRUE:完了
}
//--------------------------------------------------------------------------------------------------------------//
//	エンコード変更処理																							//
//--------------------------------------------------------------------------------------------------------------//
#define		UTC_TIME	FALSE
static	BOOL	ChangeTec(HWND hDlg, C_UTP pWild)
{
	HANDLE				hFind = NULL;	//	検索ハンドル
	WIN32_FIND_DATA		fd;				//	検索したファイル情報
	EAJCTEC				tec;			//	入力ファイルのエンコード種別
	BOOL				bom;			//	入力ファイルのＢＯＭ有無
	HAJCFILE			hInp = NULL;	//	入力ファイルハンドル
	HAJCFILE			hOut = NULL;	//	出力ファイルハンドル
	UI					att;			//	入力ファイル属性
	AJCFTIMES			ftm;			//	入力ファイルタイムスタンプ
	UT					buf[4096];		//	ファイル入力バッファ
	UT					drv[MAX_PATH];	//	パス編集ワーク
	UT					dir[MAX_PATH];	//	・

	AjcDoEvent();

	if (!fStop && !fCan) {
		if ((hFind = FindFirstFile(pWild, &fd)) != INVALID_HANDLE_VALUE) {
			do {
				AjcDoEvent();
				//	ファイルならば、エンコード変換処理
				if (!(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
					UT	path_inp[MAX_PATH];
					UT	path_out[MAX_PATH];
					//	ファイルパス名作成
					MAjcSplitPath(pWild   , drv, dir, NULL, NULL);
					MAjcMakePath (path_inp, drv, dir, NULL, NULL);
					AjcPathCat(path_inp, fd.cFileName, MAX_PATH);
					//	ワイルドカード一致（エンコード変換対象ファイル）
					if (AjcPathMatchSpec(path_inp, szWild)) {
						BOOL	fErr = FALSE;	//	エラー発生フラグ
						BOOL	fOut = FALSE;	//	出力ファイル生成済フラグ
						//	入力ファイルオープン
						if (hInp = AjcFOpen(path_inp, AJCTEC_AUTO)) {
							//	入力ファイルエンコード取得
							tec = AjcFGetTec(hInp);
							bom = AjcFGetBOM(hInp);
							//	入力対象エンコード
							if (ChkInpTec(hDlg, tec, bom)) {
								BOOL	bom_out = AjcGetDlgItemChk(hDlg, IDC_CHK_BOM);
								//	出力ファイルパス作成
								GetTempPath(MAX_PATH, path_out);
								AjcPathCat(path_out, TEXT("Temp.tmp"), MAX_PATH);
								//	出力ファイル生成
								if (hOut = AjcFCreate(path_out, TecTo, bom_out)) {
									fOut = TRUE;	//	出力ファイル生成済
									LogPrintF(TEXT("\t%5d : %s -> %s - %s"), ++Count, TecName(tec, bom),
																					  TecName(TecTo, bom_out), path_inp);
									//	ファイル入出力ループ
									while (AjcFGetS(hInp, buf, AJCTSIZE(buf))) {
										if (!AjcFPutS(hOut, buf, -1)) {
											fErr = TRUE;
											break;
										}
									}
									//	出力ファイルクローズ
									AjcFClose(hOut);
									hOut = NULL;
								}
								else {
									LogPrintF(TEXT("\x1B[31m"));
									AjcVthPrintF(hVth, TEXT("\t%5d : File Creation Error       - %s"), ++Count, path_inp);
									LogPrintF(TEXT("\x1B[0m"));
									fErr = TRUE;
								}
							}
							//	入力対象外のエンコード
							else {
								LogPrintF(TEXT("\t%5d : %s -> NoChange      - %s"), ++Count, TecName(tec, bom), path_inp);
								nNC++;
							}
							//	入力ファイルクローズ
							if (hInp != NULL) {
								AjcFClose(hInp);
								hInp = NULL;
							}
							//	出力ファイル成作済みならば、入力側へコピー（上書き）
							if (fOut) {			//	出力ファイル生成済み？
								if (!fErr) {	//	エラーなし？
									//	タイムスタンプコピー
									if (AjcGetFileTime(path_inp, &ftm, NULL, UTC_TIME) &&
										AjcSetFileTime(path_out, &ftm, UTC_TIME)) {
										//	出力ファイルの属性設定
										if ((att = GetFileAttributes(path_inp) != INVALID_FILE_ATTRIBUTES) &&
											(SetFileAttributes(path_out, (att & ~EXTRA_FILE_ATT)))) {
											//	出力ファイルを入力側へコピー
											SetFileAttributes(path_inp, FILE_ATTRIBUTE_NORMAL);
											if (!CopyFile(path_out, path_inp, FALSE)) {
												fErr = TRUE;
											}
										}
										else fErr = TRUE;
									}
									else fErr = TRUE;
								}
								//	出力ファイル削除
								SetFileAttributes(path_out, FILE_ATTRIBUTE_NORMAL);
								DeleteFile(path_out);
							}
						}
						//	入力ファイルオープン失敗
						else {	//	!(hInp = AjcFOpen(path_inp, AJCTEC_AUTO)
							LogPrintF(TEXT("\x1B[31m"));
							AjcVthPrintF(hVth, TEXT("\t%5d : File Open Error           - %s"), ++Count, path_inp);
							LogPrintF(TEXT("\x1B[0m"));
							fErr = TRUE;
						}
						//	結果ログ
						if (!fErr) {
							//	正常ログ
							LogPrintF(TEXT(" - OK\n"));
							nOK++;
						}
						//	出力ファイル作成失敗ならば、エラーログ
						else {
							//	エラーログ
							LogPrintF(TEXT("\x1B[31m"));
							LogPrintF(TEXT(" - NG\n"));
							LogPrintF(TEXT("\x1B[0m"));
							nNG++;
						}
					}
				}
				//	ディレクトリならば、サブディレクトリ検索
				else {
					if (AjcGetDlgItemChk(hDlg, IDC_CHK_SUBDIR)) {
						UT	wild[MAX_PATH];
						if (MAjcStrCmp(fd.cFileName, TEXT(".")) != 0 && MAjcStrCmp(fd.cFileName, TEXT("..")) != 0) {
							MAjcSplitPath(pWild, drv, dir, NULL, NULL);
							MAjcMakePath (wild , drv, dir, NULL, NULL);
							AjcPathCat(wild, fd.cFileName, MAX_PATH);
							AjcPathCat(wild, TEXT("*.*"), MAX_PATH);
							//	サブディレクトリ検索（再帰呼び出し）
							ChangeTec(hDlg, wild);
						}
					}
				}
			} while (FindNextFile(hFind, &fd));
			//	ファイル検索クローズ
			FindClose(hFind);
		}
	}
	return (!fStop && !fCan);	//	TRUE:完了
}
//--------------------------------------------------------------------------------------------------------------//
//	入力ファイルエンコードチェック																				//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	ChkInpTec(HWND hDlg, EAJCTEC tec, BOOL bom)
{
	BOOL	rc = FALSE;
	BOOL	fChkSJis	= AjcGetDlgItemChk(hDlg, IDC_CHK_SJIS);
	BOOL	fChkUtf8	= AjcGetDlgItemChk(hDlg, IDC_CHK_UTF8);
	BOOL	fChkEucJ	= AjcGetDlgItemChk(hDlg, IDC_CHK_EUCJ);
	BOOL	fChkUtf16LE	= AjcGetDlgItemChk(hDlg, IDC_CHK_UTF16LE);
	BOOL	fChkUtf16BE	= AjcGetDlgItemChk(hDlg, IDC_CHK_UTF16BE);
	EAJCTEC	OutTec		= (EAJCTEC)AjcGetDlgItemUInt(hDlg, IDC_GRP_TECOUT);
	BOOL	OutBom		= AjcGetDlgItemChk(hDlg, IDC_CHK_BOM);

	switch (tec) {
		case AJCTEC_MBC:		rc = (fChkSJis	  && (OutTec != AJCTEC_MBC));						break;
		case AJCTEC_UTF_8:		rc = (fChkUtf8	  && (OutTec != AJCTEC_UTF_8	|| OutBom != bom));	break;
		case AJCTEC_EUC_J:		rc = (fChkEucJ	  && (OutTec != AJCTEC_EUC_J));						break;
		case AJCTEC_UTF_16LE:	rc = (fChkUtf16LE && (OutTec != AJCTEC_UTF_16LE || OutBom != bom));	break;
		case AJCTEC_UTF_16BE:	rc = (fChkUtf16BE && (OutTec != AJCTEC_UTF_16BE || OutBom != bom));	break;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ファイルエンコード名取得																					//
//--------------------------------------------------------------------------------------------------------------//
static	C_UTP	TecName(EAJCTEC tec, BOOL bom)
{
	C_UTP	rc;

	switch (tec) {
		case AJCTEC_MBC:		rc = 		TEXT("Shift JIS    "); 	break;		//	マルチバイト
		case AJCTEC_UTF_8:		rc = bom ?	TEXT("UTF-8(BOM)   "):				//	ＵＴＦ－８
											TEXT("UTF-8        "); 	break;
		case AJCTEC_EUC_J:		rc = 		TEXT("EUC-J        "); 	break;		//	ＥＵＣ（日本語）
		case AJCTEC_UTF_16LE:	rc = bom ?	TEXT("UTF-16LE(BOM)"):				//	ＵＴＦ－１６ＬＥ
											TEXT("UTF-16LE     ");	break;
		case AJCTEC_UTF_16BE:	rc = bom ?	TEXT("UTF-16BE(BOM)"):				//	ＵＴＦ－１６ＢＥ
											TEXT("UTF-16BE     ");	break;
		default:				rc = 		TEXT("UnKnown      ");	break;		//	エラー
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ログ出力																									//
//--------------------------------------------------------------------------------------------------------------//
static	VO		LogPrintF(C_UTP pFmt, ...)
{
	va_list 	vls;
	UT			buf[1024];

	va_start(vls, pFmt);
	AjcVSnPrintF(buf, 1024, pFmt, vls);
	buf[1023] = 0;
	va_end	(vls);
	//	初回ログならば、画面クリアー
	if (fLogFirst) {
		AjcVthClear(hVth);
		fLogFirst = FALSE;
	}
	//	ログファイル出力
	if (hLogFile != NULL) {
		AjcFPutS(hLogFile, buf, -1);
	}
	//	ログ画面出力
	AjcVthPutText(hVth, buf, -1);
}

