﻿//
//	SW_TextFileInput.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define		MYSECT		TEXT("DlgSettings")
#define		UTMASK(C)	(C & ((UI)0xFFFFFFFF >> (32 - sizeof(UT) * 8)))

//--------------------------------------------------------------------------------------------------------------//
//	ラジオボタン・コード																						//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	ENC_SJIS		= 0,
	ENC_UTF8		= 1,
	ENC_EUC			= 2,
	ENC_UTF16LE		= 3,
	ENC_UTF16BE		= 4,
} RBT_ENCODE;

typedef enum {
	LFC_CR			= 0,
	LFC_LF			= 1,
	LFC_CRLF		= 2,
} RBT_LFCODE;

typedef enum {
	SUR_INVALID		= 0,
	SUR_VALID		= 1,
} RBT_SURR;

//--------------------------------------------------------------------------------------------------------------//
//	UNICODEモード識別フラグ																						//
//--------------------------------------------------------------------------------------------------------------//
#ifdef UNICODE
static	const BOOL fUnicode = TRUE;
#else
static	const BOOL fUnicode = FALSE;
#endif

//--------------------------------------------------------------------------------------------------------------//
//	ＢＯＭ																										//
//--------------------------------------------------------------------------------------------------------------//
static	const BC	bom_utf8   [3] = {0xEF, 0xBB, 0xBF};
static	const BC	bom_utf16le[2] = {0xFF, 0xFE};
static	const BC	bom_utf16be[2] = {0xFE, 0xFF};

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVthFImg;						//	入力テキストファイルのイメージ表示用
static	HWND			hVthLog;						//	ＡＰＩ実行ログ表示用
static	HAJCFILE		hFile = NULL;					//	テキストファイルアクセス ハンドル
static	UT				FilePath[MAX_PATH];				//	テスト用テキストファイルパス

static	BC		bc_sjis[64] =  "東京都\r\n港区\r\n1の23の4\r\n";
static	WC		wc_surr[64] = L"𠀀𢈘𪛀\r\n𤟱A𩸽B😀\r\n";

static	BC		bc_txt [128];
static	WC		wc_txt [128];
static	WC		wc_tmp [128];

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO		MkInpFile(HWND hDlg);
static	UL		ShowBOM(HANDLE hdl);
static	VO		ShowCond(HWND hDlg);
static	UI		ShowByteCharData(EAJCTEC tec, UI loc, BCP pTxt, UI lTxt, UI lMax);
static	UI		ShowWideCharData(EAJCTEC tec, UI loc, WCP pTxt, UI lTxt, UI lMax);
static	VO		ConvLfCodeA(HWND hDlg, BCP pTxt, UI lTxt);
static	VO		ConvLfCodeW(HWND hDlg, WCP pTxt, UI lTxt);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UT		name[MAX_PATH];

	hDlgMain = hDlg;
	hVthFImg  = GetDlgItem(hDlg, IDC_VTH_FIMG);
	hVthLog   = GetDlgItem(hDlg, IDC_VTH_LOG );

	//	バイトモード時はサロゲートの選択を非表示
	if (!fUnicode) {
		AjcShowDlgGroup(hDlg, IDC_GRP_SURR, FALSE);
	}

	//	ウインドタイトル表示
	AjcGetAppName(name, MAX_PATH);
	SetWindowText(hDlg, name);

	//	テスト用テキストファイルパス設定
	GetTempPath(MAX_PATH, FilePath);
	AjcPathCat(FilePath, TEXT("inp.txt"), MAX_PATH);

	//	ラジオボタングループ化
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_LFCODE));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_ENCODE));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_SURR  ));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_LFCONV));

	//	デフォルト設定
	AjcSetDlgItemChk (hDlg, IDC_RBT_SJIS	  , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_INP_CRLF  , TRUE );
	AjcSetDlgItemChk (hDlg, IDC_RBT_NOSURR	  , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_CRLF_TO_LF, TRUE);
	AjcSetDlgItemUInt(hDlg, IDC_INP_LBUF	  , 64);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_POINT	  , 0);

	//	ダイアログ項目のロード
	AjcLoadAllControlSettings (hDlg, MYSECT, AJCOPT3(AJCCTL_SELACT_, ALL, NTCCHK, NTCRBT));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ダイアログ項目のセーブ
	AjcSaveAllControlSettings(hDlg);
	//	テキストファイルクローズ
	if (hFile != NULL) AjcFClose(hFile);
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- ラジオボタン（エンコード） -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_ENCODE	)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		if (lParam== ENC_SJIS || lParam == ENC_EUC) AjcEnableDlgGroup(hDlg, IDC_GRP_SURR, FALSE, FALSE);
		else										AjcEnableDlgGroup(hDlg, IDC_GRP_SURR, TRUE , TRUE );
		MkInpFile(hDlg);
	}
	return TRUE;
}
//----- ラジオボタン（改行コード） -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_LFCODE	)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		MkInpFile(hDlg);
	}
	return TRUE;
}
//----- ラジオボタン（サロゲート） -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_SURR		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		MkInpFile(hDlg);
	}
	return TRUE;
}
//----- チェックボックス（ＢＯＭ） -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_BOM		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		MkInpFile(hDlg);
	}
	return TRUE;
}
//----- AjcFOpenボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FOPEN		)
{
	if (HIWORD(wParam) ==BN_CLICKED) {
		hFile = AjcFOpen(FilePath, (EAJCTEC)AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE));
		if (hFile != NULL) {
			ShowCond(hDlg);
			AjcVthPrintF(hVthLog, TEXT("- AjcFOpen()      - OK\n"));
			AjcEnableDlgItem (hDlg, IDC_CMD_FOPEN , FALSE);
			AjcEnableDlgItem (hDlg, IDC_CMD_FCLOSE, TRUE );
			AjcEnableDlgGroup(hDlg, IDC_GRP_RBTS  , FALSE, FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_FUNCS , TRUE , TRUE );
			//	改行コード変換モード設定
			AjcFSetLfConv(hFile, (AJCFLFCONV)AjcGetDlgItemUInt(hDlg, IDC_GRP_LFCONV));
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFOpen()     - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFCloseボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FCLOSE	)
{
	if (HIWORD(wParam) ==BN_CLICKED) {
		if (AjcFClose(hFile)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFClose()     - OK\n"));
			hFile = NULL;
			AjcEnableDlgItem (hDlg, IDC_CMD_FOPEN , TRUE );
			AjcEnableDlgItem (hDlg, IDC_CMD_FCLOSE, FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_RBTS  , TRUE , TRUE );
			AjcEnableDlgGroup(hDlg, IDC_GRP_FUNCS , FALSE, FALSE);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFClose()     - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFGetSボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FGETS		)
{
	UI		i, stl, lBuf;
	UTP		p;
	UT		bc[256];
	UT		cc[256];

	if (HIWORD(wParam) == BN_CLICKED) {
		lBuf = AjcGetDlgItemUInt(hDlg, IDC_INP_LBUF);
		if (p = AjcFGetS(hFile, bc, lBuf)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetS()      - OK\n"));
			stl = (UI)_tcslen(bc);
			AjcBinToCLangStr(bc, cc, 256);
			AjcVthPrintF(hVthLog, TEXT("  len = %d, str = \"%s\"\n"), stl, cc);
			if (stl != 0) {
				AjcVthPrintF(hVthLog, TEXT(" "));
				for (i = 0; i < stl; i++) {
					AjcVthPrintF(hVthLog, TEXT(" %0*X"), sizeof(UT) * 2, UTMASK(bc[i]));
				}
				AjcVthPrintF(hVthLog, TEXT("\n"));
			}
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetS()      - EOF\n"));
		}
	}
	return TRUE;
}
//----- AjcFGetCボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FGETC		)
{
	UT		c;

	if (HIWORD(wParam) ==BN_CLICKED) {
		c = AjcFGetC(hFile);
		if (c != (UT)-1) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetC()      - %0*X\n"), sizeof(UT) * 2, UTMASK(c));
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetC()      - EOF\n"));
		}
	}
	return TRUE;
}
//----- AjcFGetCodeボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FGETCODE	)
{
	UI		c;

	if (HIWORD(wParam) ==BN_CLICKED) {
		c = AjcFGetCode(hFile);
		if (c != -1) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetCode()   - %08X\n"), c);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetCode()   - EOF\n"));
		}
	}
	return TRUE;
}
//----- AjcFEofボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FEOF		)
{
	if (HIWORD(wParam) ==BN_CLICKED) {
		if (AjcFEof(hFile)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFEof()       - EOF\n"));
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFEof()       - Not EOF\n"));
		}
	}
	return TRUE;
}
//----- AjcFSavePointボタン ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FSAVEPOINT)
{
	if (HIWORD(wParam) ==BN_CLICKED) {
		ULL		ptr;
		ptr = AjcFSavePoint(hFile);
		if (ptr != -1) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFSavePoint() - point = %d\n"), (UI)ptr);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFSavePoint() - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFRecvPointボタン ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FRECVPOINT)
{
	if (HIWORD(wParam) ==BN_CLICKED) {
		if (AjcFRecvPoint(hFile)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFRecvPoint() - OK\n"));
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFRecvPoint() - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFGetPointボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FGETPOINT	)
{
	if (HIWORD(wParam) ==BN_CLICKED) {
		ULL		ptr;
		ptr = AjcFGetPoint(hFile);
		if (ptr != -1) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetPoint()  - point = %d\n"), (UI)ptr);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFGetPoint()  - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFSetPointボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FSETPOINT	)
{
	ULL		ptr;

	if (HIWORD(wParam) ==BN_CLICKED) {
		ptr = AjcGetDlgItemUI64(hDlg, IDC_TXT_POINT);
		if (AjcFSetPoint(hFile, ptr)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFSetPoint()  - OK (point = %d)\n"), (UI)ptr);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFSetPoint()  - NG\n"));
		}
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY			)

	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_GRP_ENCODE		)
	AJC_DLGMAP_CMD(Main, IDC_GRP_LFCODE		)
	AJC_DLGMAP_CMD(Main, IDC_GRP_SURR		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_BOM		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FOPEN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FCLOSE		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FGETS		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FGETC		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FGETCODE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FEOF		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FSAVEPOINT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FRECVPOINT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FGETPOINT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FSETPOINT	)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	入力ファイル作成																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		MkInpFile(HWND hDlg)
{
	HANDLE	hdl = INVALID_HANDLE_VALUE;
	UL		loc = 0;

	//	入力ファイル作成
	hdl = CreateFile(FilePath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE)) {
		UL i, len, bytes;
		case AJCTEC_MBC:				//	●S-JIS
			//	S-JISテキスト作成
			strcpy_s(bc_txt, AJCTSIZE(bc_txt), bc_sjis);
			ConvLfCodeA(hDlg, bc_txt, AJCTSIZE(bc_txt));
			WriteFile(hdl, bc_txt, (UI)strlen(bc_txt), &bytes, NULL);
			break;
		case AJCTEC_UTF_8:				//	●UTF-8
			//	BOM作成
			if (AjcGetDlgItemChk(hDlg, IDC_CHK_BOM)) {
				WriteFile(hdl, bom_utf8, 3, &bytes, NULL);
			}
			//	MTF-8テキスト作成
			if (AjcGetDlgItemUInt(hDlg, IDC_GRP_SURR) == SUR_VALID) {
				len = WideCharToMultiByte(CP_UTF8, 0, wc_surr, (UI)wcslen(wc_surr), bc_txt, AJCTSIZE(bc_txt), NULL, NULL);
			}
			else {
				len = MultiByteToWideChar(CP_ACP , 0, bc_sjis, (UI)strlen(bc_sjis), wc_tmp, AJCTSIZE(wc_tmp));
				len = WideCharToMultiByte(CP_UTF8, 0, wc_tmp , len				  , bc_txt, AJCTSIZE(bc_txt), NULL, NULL);
			}
			bc_txt[len] = 0;
			ConvLfCodeA(hDlg, bc_txt, AJCTSIZE(bc_txt));
			WriteFile(hdl, bc_txt, (UI)strlen(bc_txt), &bytes, NULL);
			break;
		case AJCTEC_EUC_J:				//	●EUC-J
			//	EUC-Jテキスト作成
			len = AjcSJisToEucEx(bc_sjis, (UI)strlen(bc_sjis), bc_txt, AJCTSIZE(bc_txt));
			ConvLfCodeA(hDlg, bc_txt, AJCTSIZE(bc_txt));
			WriteFile(hdl, bc_txt, (UI)strlen(bc_txt), &bytes, NULL);
			break;
		case AJCTEC_UTF_16LE:			//	●UTF-16(LE)
		case AJCTEC_UTF_16BE:			//	●UTF-16(BE)
			//	BOM作成
			if (AjcGetDlgItemChk(hDlg, IDC_CHK_BOM)) {
				if (AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE) == ENC_UTF16LE) {
					WriteFile(hdl, bom_utf16le, 2, &bytes, NULL);
				}
				else {
					WriteFile(hdl, bom_utf16be, 2, &bytes, NULL);
				}
			}
			//	UTF-16テキスト作成
			if (AjcGetDlgItemUInt(hDlg, IDC_GRP_SURR) == SUR_VALID) {
				wcscpy_s(wc_txt, AJCTSIZE(wc_txt), wc_surr);
				len = (UI)wcslen(wc_txt);
			}
			else {
				len = MultiByteToWideChar(CP_ACP , 0, bc_sjis, -1, wc_txt, AJCTSIZE(wc_txt));
				len = (UI)wcslen(wc_txt);
			}
			//	BEならばバイト順反転
			if (AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE) == ENC_UTF16BE) {
				for (i = 0; i < len; i++) {
					wc_txt[i] = AjcExcWord(wc_txt[i]);
				}
			}
			ConvLfCodeW(hDlg, wc_txt, AJCTSIZE(wc_txt));
			WriteFile(hdl, wc_txt, (UI)wcslen(wc_txt) * 2, &bytes, NULL);
			break;
	}
	CloseHandle(hdl);
	//	入力ファイルイメージ表示
	AjcVthClear(hVthFImg);
	;
	do {
		if ((hdl = CreateFile(FilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
			AjcVthPrintF(hVthFImg, TEXT("--- ファイルがありません(%s) ---\n\n"), FilePath);
			break;
		}
		if (GetFileSize(hdl, NULL) == 0) {
			AjcVthPrintF(hVthFImg, TEXT("--- ファイルの内容がありません(%s) ---\n\n"), FilePath);
			break;
		}
		switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE)) {
			case AJCTEC_MBC:
			{	UL		i, len, bytes, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- S-JIS - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data    string(UNICODE)\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data    string(S-JIS)\n\n"));
				ReadFile(hdl, bc_txt, sizeof bc_txt, &bytes, NULL);
				len = bytes;
				for (i = 0; i < len;) {
					cl	 = ShowByteCharData(AJCTEC_MBC, loc, &bc_txt[i], len - i, 2);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_UTF_8:
			{	UL		i, len, bytes, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- UTF-8 - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data                string(UNICODE[, U+])\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data                string(S-JIS)\n\n"));
				loc = ShowBOM(hdl);
				ReadFile(hdl, bc_txt, sizeof bc_txt, &bytes, NULL);
				len = bytes;
				for (i = 0; i < len;) {
					cl	 = ShowByteCharData(AJCTEC_UTF_8, loc, &bc_txt[i], len - i, 6);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_EUC_J:
			{	UL		i, len, bytes, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- EUC-J - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data       string(UNICODE)\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data       string(S-JIS)\n\n"));
				ReadFile(hdl, bc_txt, sizeof bc_txt, &bytes, NULL);
				len = bytes;
				for (i = 0; i < len;) {
					cl	 = ShowByteCharData(AJCTEC_EUC_J, loc, &bc_txt[i], len - i, 3);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_UTF_16LE:
			{	UL		i, len, bytes, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- UTF-16(LE) - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data        string(UNICODE[, U+])\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data        string(S-JIS)\n\n"));
				loc = ShowBOM(hdl);
				ReadFile(hdl, wc_txt, sizeof wc_txt, &bytes, NULL);
				len = bytes / 2;
				for (i = 0; i < len;) {
					cl	 = ShowWideCharData(AJCTEC_UTF_16LE, loc, &wc_txt[i], len - i, 2);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_UTF_16BE:
			{	UL		i, len, bytes, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- UTF-16(BE) - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data        string(UNICODE[, U+])\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data        string(S-JIS)\n\n"));
				loc = ShowBOM(hdl);
				ReadFile(hdl, wc_tmp, sizeof wc_tmp, &bytes, NULL);
				len = bytes / 2;
				for (i = 0; i < len;) {
					cl	 = ShowWideCharData(AJCTEC_UTF_16BE, loc, &wc_txt[i], len - i, 2);
					i	+= cl;
					loc += cl;
				}
				break;
			}
		}
	} while (0);
	CloseHandle(hdl);
}
//--------------------------------------------------------------------------------------------------------------//
//	選択された条件表示																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowCond(HWND hDlg)
{
	UI		ix;
	UT		txt[128] = {0};

	AjcVthPrintF(hVthLog, TEXT("\n\n---"), txt);
	//	テキストコード
	if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_ENCODE))) != -1) {
		GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_ENCODE), ix), txt, AJCTSIZE(txt));
		AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
	}
	//	改行コード
	if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_LFCODE))) != -1) {
		GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_LFCODE), ix), txt, AJCTSIZE(txt));
		AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
	}
	//	サロゲート
	if (fUnicode) {
		if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_SURR))) != -1) {
			GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_SURR), ix), txt, AJCTSIZE(txt));
			AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
		}
	}
	//	BOM
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_BOM)) {
		AjcVthPrintF(hVthLog, TEXT("  BOM "), txt);
	}
	else {
		AjcVthPrintF(hVthLog, TEXT("  NoBOM "), txt);
	}
	//	改行コード変換
	if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_LFCONV))) != -1) {
		GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_LFCONV), ix), txt, AJCTSIZE(txt));
		AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
	}
	AjcVthPrintF(hVthLog, TEXT("---\n\n"), txt);
}
//--------------------------------------------------------------------------------------------------------------//
//	ＢＯＭ表示																									//
//--------------------------------------------------------------------------------------------------------------//
static	UL		ShowBOM(HANDLE hdl)
{
	UL		loc = 0;
	UL		bytes;
	UB		bom[3];

	ReadFile(hdl, bom, 3, &bytes, NULL);
	//	UTF-8
	if		(bytes >= 3 && memcmp(bom, bom_utf8   , 3) == 0) {
		AjcVthPrintF(hVthFImg, TEXT("%4d : %02X %02X %02X (BOM)\n"), loc, (UB)bom[0], (UB)bom[1], (UB)bom[2]);
		SetFilePointer(hdl, 3, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 3;									//	読み出しバイト位置を返す
	}
	//	UTF-16(LE)
	else if (bytes >= 2 && memcmp(bom, bom_utf16le, 2) == 0) {
		AjcVthPrintF(hVthFImg, TEXT("%4d : %02X %02X (BOM)\n"), loc, (UB)bom[0], (UB)bom[1]);
		SetFilePointer(hdl, 2, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 1;									//	読み出しワード位置を返す
	}
	//	UTF-16(BE)
	else if (bytes >= 2 && memcmp(bom, bom_utf16be, 2) == 0) {
		AjcVthPrintF(hVthFImg, TEXT("%4d : %02X %02X (BOM)\n"), loc, (UB)bom[0], (UB)bom[1]);
		SetFilePointer(hdl, 2, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 1;									//	読み出しワード位置を返す
	}
	//	BOM無し
	else {
		SetFilePointer(hdl, 0, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 0;									//	読み出し位置＝先頭を返す
	}

	return loc;
}
//--------------------------------------------------------------------------------------------------------------//
//	バイト文字ファイルデータ表示	( pppp : hh hh ss (hh hh )													//
//--------------------------------------------------------------------------------------------------------------//
static	UI		ShowByteCharData(EAJCTEC tec, UI loc, BCP pTxt, UI lTxt, UI lMax)
{
	UI		rc = 0;
	UI		i, bl, sl, wl;
	BC		bc[16];				//	元のバイトデータ
	BC		sc[16], scc[16];	//	S-JIS文字  , Ｃ言語表示文字列
	WC		wc[16],	wcc[16];	//	UNICODE文字, Ｃ言語表示文字列

	AjcVthPrintFA(hVthFImg, "%4d : ", loc);
	//	１文字分のバイト数設定
	switch (tec) {
		case AJCTEC_MBC:	bl = AjcStrChkMbcLen (pTxt, lTxt);	break;
		case AJCTEC_UTF_8:	bl = AjcStrChkUtf8Len(pTxt, lTxt);	break;
		case AJCTEC_EUC_J:	bl = AjcStrChkEucLen (pTxt, lTxt);	break;
	}
	if (bl != 0) {
		//	１文字分のバイト文字切り出し
		memset(bc, 0, sizeof bc);
		memcpy(bc, pTxt, bl);
		//	１文字分のバイト文字コード表示
		for (i = 0; i < bl; i++) {
			AjcVthPrintFA(hVthFImg, "%02X ", (UB)bc[i]);
		}
		for (; i < lMax; i++) {
			AjcVthPrintFA(hVthFImg, "   ");
		}
		//	バイト文字 → S-JIS文字，ワイド文字変換
		switch (tec) {
			case AJCTEC_MBC:	strcpy_s(sc, AJCTSIZE(sc), bc); 						   sl = (UI)strlen(sc);
								MultiByteToWideChar(CP_ACP , 0, sc, -1, wc, AJCTSIZE(wc)); wl = (UI)wcslen(wc);
								break;
			case AJCTEC_UTF_8:	AjcUtf8ToMbc(bc, sc, AJCTSIZE(sc)); 					   sl = (UI)strlen(sc);
								MultiByteToWideChar(CP_UTF8, 0, bc, -1, wc, AJCTSIZE(wc)); wl = (UI)wcslen(wc);
								break;
			case AJCTEC_EUC_J:	AjcEucToSJis(bc, sc, AJCTSIZE(sc)); 					   sl = (UI)strlen(sc);
								MultiByteToWideChar(CP_ACP , 0, sc, -1, wc, AJCTSIZE(wc)); wl = (UI)wcslen(wc);
								break;
		}
		//	Ｃ言語表記の文字列作成
		AjcBinToCLangStrA(sc, scc, AJCTSIZE(scc));
		AjcBinToCLangStrW(wc, wcc, AJCTSIZE(wcc));
		//	１文字の文字フェースとUNICODEコード表示
		if (fUnicode) {
			if (MAjcIsLeadW(wc[0])) {
				UI code = AjcTextToCodePointW(wc);
				AjcVthPrintFW(hVthFImg, L"- %s (%04X %04X, %08X)\n", wcc, (UW)wc[0], (UW)wc[1], code);
			}
			else {
				if (wcslen(wcc) == 1 && !AjcIsBigCharW(wc)) AjcVthPrintFW(hVthFImg, L"- %-2s (%04X)\n", wcc, (UW)wc[0]);
				else										AjcVthPrintFW(hVthFImg, L"- %s (%04X)\n"  , wcc, (UW)wc[0]);
			}
		}
		//	１文字の文字フェースとS-JISコード表示
		else {
			if (MAjcIsLeadA(sc[0])) AjcVthPrintFA(hVthFImg,  "- %-2s (%02X %02X)\n", scc, (UB)sc[0], (UB)sc[1]);
			else					AjcVthPrintFA(hVthFImg,  "- %-2s (%02X)\n"	   , scc, (UB)sc[0]);
		}
		rc = bl;
	}
	else {
		AjcVthPrintFA(hVthFImg, "%02X       - ?\n", (UB)pTxt[0]);
		rc = 1;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ワイド文字ファイルデータ表示	( pppp : hhhh hhhh ss (hh hh )												//
//--------------------------------------------------------------------------------------------------------------//
static	UI		ShowWideCharData(EAJCTEC tec, UI loc, WCP pTxt, UI lTxt, UI lMax)
{
	UI		rc = 0;
	UI		i, bl, sl, wl;
	WC		bc[16];				//	元のワイド文字
	BC		sc[16], scc[16];	//	S-JIS文字	, Ｃ言語表示文字列
	WC		wc[16],	wcc[16];	//	UNICODE文字 , Ｃ言語表示文字列

	AjcVthPrintFA(hVthFImg, "%4d : ", loc);
	//	１文字分のワイド文字数設定
	switch (tec) {
		case AJCTEC_UTF_16LE:	bl = (MAjcIsLead(*pTxt) 				? 2 : 1);	break;
		case AJCTEC_UTF_16BE:	bl = (MAjcIsLead((WC)AjcExcWord(*pTxt)) ? 2 : 1);	break;
	}
	if (bl != 0) {
		//	１文字分のワイド文字切り出し
		memset (bc, 0, sizeof bc);
		wcsncpy_s(bc, AJCTSIZE(bc), pTxt, bl);
		//	１文字分のワイドコード文字表示
		for (i = 0; i < bl; i++) {
			AjcVthPrintFA(hVthFImg, "%04X ", (UW)bc[i]);
		}
		for (; i < lMax; i++) {
			AjcVthPrintFA(hVthFImg, "     ");
		}
		//	元データ文字 → UNICODE文字. S-JIS文字変換
		switch (tec) {
			case AJCTEC_UTF_16LE:	wcscpy_s(wc, AJCTSIZE(wc), bc); 										wl = (UI)wcslen(wc);
									WideCharToMultiByte(CP_ACP, 0, wc, -1, sc, AJCTSIZE(sc), NULL, NULL);	sl = (UI)strlen(sc);
									break;
			case AJCTEC_UTF_16BE:	for (i = 0; i < bl; i++) {wc[i] = (WC)AjcExcWord(pTxt[i]);}	wc[i] = 0;	wl = (UI)wcslen(wc);
									WideCharToMultiByte(CP_ACP, 0, wc, -1, sc, AJCTSIZE(sc), NULL, NULL);	sl = (UI)strlen(sc);
									break;
		}
		//	Ｃ言語表記の文字列作成
		AjcBinToCLangStrA(sc, scc, AJCTSIZE(scc));
		AjcBinToCLangStrW(wc, wcc, AJCTSIZE(wcc));
		//	１文字の文字フェースとUNICODEコード表示
		if (fUnicode) {
			if (MAjcIsLeadW(wc[0])) {
				UI code = AjcTextToCodePointW(wc);
				AjcVthPrintFW(hVthFImg, L"- %s (%04X %04X, %08X)\n", wcc, (UW)wc[0], (UW)wc[1], code);
			}
			else {
				if (wcslen(wcc) == 1 && !AjcIsBigCharW(wc)) AjcVthPrintFW(hVthFImg, L"- %-2s (%04X)\n", wcc, (UW)wc[0]);
				else										AjcVthPrintFW(hVthFImg, L"- %s (%04X)\n"  , wcc, (UW)wc[0]);
			}
		}
		//	１文字の文字フェースとS-JISコード表示
		else {
			if (MAjcIsLeadA(sc[0])) AjcVthPrintFA(hVthFImg,  "- %-2s (%02X %02X)\n", scc, (UB)sc[0], (UB)sc[1]);
			else					AjcVthPrintFA(hVthFImg,  "- %-2s (%02X)\n"	   , scc, (UB)sc[0]);
		}
		rc = bl;
	}
	else {
		AjcVthPrintFA(hVthFImg, "%02X       - ?\n", (UB)pTxt[0]);
		rc = 1;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	改行コード変換																								//
//--------------------------------------------------------------------------------------------------------------//
//	バイト文字
static	VO		ConvLfCodeA(HWND hDlg, BCP pTxt, UI lTxt)
{
	BCP		p;

	switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_LFCODE)) {
		case LFC_CR:		//	CR
			while (p = strstr(pTxt, "\r\n")) {
				AjcRepPartStrA(pTxt, lTxt, (UI)((UX)p - (UX)pTxt), 2, "\r", 1);
			}
			break;
		case LFC_LF:		//	LF
			while (p = strstr(pTxt, "\r\n")) {
				AjcRepPartStrA(pTxt, lTxt, (UI)((UX)p - (UX)pTxt), 2, "\n", 1);
			}
			break;
		case LFC_CRLF:		//	CR, LF
			break;
	}
}
//	ワイド文字
static	VO		ConvLfCodeW(HWND hDlg, WCP pTxt, UI lTxt)
{
	WCP		p;

	switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_LFCODE)) {
		case LFC_CR:		//	CR
			while (p = wcsstr(pTxt, L"\r\n")) {
				AjcRepPartStrW(pTxt, lTxt, (UI)(((UX)p - (UX)pTxt) / 2), 2, L"\r", 1);
			}
			break;
		case LFC_LF:		//	LF
			while (p = wcsstr(pTxt, L"\r\n")) {
				AjcRepPartStrW(pTxt, lTxt, (UI)(((UX)p - (UX)pTxt) / 2), 2, L"\n", 1);
			}
			break;
		case LFC_CRLF:		//	CR, LF
			break;
	}
}

