﻿//
//	SW_TextFileOutput.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define		MYSECT		TEXT("DlgSettings")
#define		UTMASK(C)	(C & ((UI)0xFFFFFFFF >> (32 - sizeof(UT) * 8)))

//--------------------------------------------------------------------------------------------------------------//
//	ラジオボタン・コード																						//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	ENC_SJIS		= 0,
	ENC_UTF8		= 1,
	ENC_EUC			= 2,
	ENC_UTF16LE		= 3,
	ENC_UTF16BE		= 4,
} RBT_ENCODE;

typedef enum {
	LFC_CR			= 0,
	LFC_LF			= 1,
	LFC_CRLF		= 2,
} RBT_LFCODE;

typedef enum {
	SUR_INVALID		= 0,
	SUR_VALID		= 1,
} RBT_SURR;

//--------------------------------------------------------------------------------------------------------------//
//	UNICODEモード識別フラグ																						//
//--------------------------------------------------------------------------------------------------------------//
#ifdef UNICODE
static	const BOOL fUnicode = TRUE;
#else
static	const BOOL fUnicode = FALSE;
#endif

//--------------------------------------------------------------------------------------------------------------//
//	ＢＯＭ																										//
//--------------------------------------------------------------------------------------------------------------//
static	const BC	bom_utf8   [3] = {0xEF, 0xBB, 0xBF};
static	const BC	bom_utf16le[2] = {0xFF, 0xFE};
static	const BC	bom_utf16be[2] = {0xFE, 0xFF};

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVthFImg;						//	入力テキストファイルのイメージ表示用
static	HWND			hVthLog;						//	ＡＰＩ実行ログ表示用
static	HAJCFILE		hFile = NULL;					//	テキストファイルアクセス ハンドル
static	UT				FilePath[MAX_PATH];				//	テスト用テキストファイルパス

static	WC		wc_sjis1[64] = L"東京都\r\n";
static	WC		wc_sjis2[64] = L"港区\r\n";
static	WC		wc_sjis3[64] = L"1の23の4\r\n";
static	WC		wc_surr [64] = L"𠀀𢈘𪛀\r\n𤟱A𩸽B😀\r\n";
static	WC		wc_div1 [64] = L"仙台市泉区";
static	WC		wc_div2 [64] = L"😀😁😈😍😌";

static	BC		bc_txt [128];
static	WC		wc_txt [128];

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO		SubFPutS	(HWND hDlg, UI idChkBox);
static	VO		SubFDivS	(HWND hDlg, UI idChkBox);
static	VO		SubFPutC	(HWND hDlg, UI idChkBox);
static	VO		SubFPutCode(HWND hDlg, UI idChkBox);

static	VO		SetOutTxt(HWND hDlg, UI id, WCP pTxt);
static	VO		ShowOutFileImage(HWND hDlg);
static	VO		ShowCond(HWND hDlg);
static	UL		ShowBOM(HANDLE hdl);
static	UI		ShowByteCharData(EAJCTEC tec, UI loc, BCP pTxt, UI lTxt, UI lMax);
static	UI		ShowWideCharData(EAJCTEC tec, UI loc, WCP pTxt, UI lTxt, UI lMax);
static	VO		ConvLfCodeA(HWND hDlg, BCP pTxt, UI lTxt);
static	VO		ConvLfCodeW(HWND hDlg, WCP pTxt, UI lTxt);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UT		name[MAX_PATH];

	hDlgMain = hDlg;
	hVthFImg  = GetDlgItem(hDlg, IDC_VTH_FIMG);
	hVthLog   = GetDlgItem(hDlg, IDC_VTH_LOG );

	//	ウインドタイトル表示
	AjcGetAppName(name, MAX_PATH);
	SetWindowText(hDlg, name);

	//	出力テキストファイルパス設定
	GetTempPath(MAX_PATH, FilePath);
	AjcPathCat(FilePath, TEXT("out.txt"), MAX_PATH);

	//	ラジオボタングループ化
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_LFCODE));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_ENCODE));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_LFCONV));

	//	デフォルト設定
	AjcSetDlgItemChk (hDlg, IDC_RBT_SJIS	  , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_INP_LF	  , TRUE );
	AjcSetDlgItemChk (hDlg, IDC_RBT_NOSURR	  , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_RBT_LF_TO_CRLF, TRUE);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_LTEXT	  , -1);
	AjcSepDlgItemHex (hDlg, IDC_TXT_C		  , 0x41, sizeof(UT) * 2);

	//	ダイアログ項目のロード
	AjcLoadAllControlSettings (hDlg, MYSECT, AJCOPT2(AJCCTL_SELACT_, ALL, NTCRBT));
	AjcSepDlgItemHex (hDlg, IDC_TXT_C, AjcGetDlgItemHex(hDlg, IDC_TXT_C), sizeof(UT) * 2);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ダイアログ項目のセーブ
	AjcSaveAllControlSettings(hDlg);
	//	テキストファイルクローズ
	if (hFile != NULL) AjcFClose(hFile);
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- 改行コード ラジオボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_LFCODE	)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		SetOutTxt(hDlg, IDC_CHK_TXT1, wc_sjis1);
		SetOutTxt(hDlg, IDC_CHK_TXT2, wc_sjis2);
		SetOutTxt(hDlg, IDC_CHK_TXT3, wc_sjis3);
		SetOutTxt(hDlg, IDC_CHK_DIV1, wc_div1 );
		SetOutTxt(hDlg, IDC_CHK_DIV2, wc_div2 );
		if (fUnicode) {
			SetOutTxt(hDlg, IDC_CHK_TXT4, wc_surr);
			ShowWindow(GetDlgItem(hDlg, IDC_CHK_DIV1), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_LBL_DIV1), SW_HIDE);
		}
		else {
			ShowWindow(GetDlgItem(hDlg, IDC_CHK_TXT4), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_CHK_DIV2), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_LBL_DIV2), SW_HIDE);
		}
	}
	return TRUE;
}
//----- AjcFCreateボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FCREATE	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		hFile = AjcFCreate(FilePath, (EAJCTEC)AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE), AjcGetDlgItemChk(hDlg, IDC_CHK_BOM));
		if (hFile != NULL) {
			ShowCond(hDlg);
			AjcVthPrintF(hVthLog, TEXT("- AjcFCreate()    - OK\n"));
			AjcEnableDlgItem (hDlg, IDC_CMD_FCREATE, FALSE);
			AjcEnableDlgItem (hDlg, IDC_CMD_FCLOSE , TRUE );
			AjcEnableDlgGroup(hDlg, IDC_GRP_RBTS   , FALSE, FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_FUNCS  , TRUE , TRUE );
			//	改行コード変換モード設定
			AjcFSetLfConv(hFile, (AJCFLFCONV)AjcGetDlgItemUInt(hDlg, IDC_GRP_LFCONV));
			//	ファイルイメージの表示クリアー
			AjcVthClear(hVthFImg);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFCreate()   - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFCloseボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FCLOSE	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcFClose(hFile)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFClose()     - OK\n"));
			hFile = NULL;
			AjcEnableDlgItem (hDlg, IDC_CMD_FCREATE, TRUE );
			AjcEnableDlgItem (hDlg, IDC_CMD_FCLOSE , FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_RBTS   , TRUE , TRUE );
			AjcEnableDlgGroup(hDlg, IDC_GRP_FUNCS  , FALSE, FALSE);
			//	出力ファイルイメージ表示
			ShowOutFileImage(hDlg);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFClose()     - NG\n"));
		}
	}
	return TRUE;
}
//----- AjcFPutSボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FPUTS		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT1)) SubFPutS(hDlg, IDC_CHK_TXT1);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT2)) SubFPutS(hDlg, IDC_CHK_TXT2);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT3)) SubFPutS(hDlg, IDC_CHK_TXT3);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT4)) SubFPutS(hDlg, IDC_CHK_TXT4);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_DIV1)) SubFDivS(hDlg, IDC_CHK_DIV1);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_DIV2)) SubFDivS(hDlg, IDC_CHK_DIV2);
	}
	return TRUE;
}
//----- AjcFPutCボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FPUTC		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT1)) SubFPutC(hDlg, IDC_CHK_TXT1);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT2)) SubFPutC(hDlg, IDC_CHK_TXT2);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT3)) SubFPutC(hDlg, IDC_CHK_TXT3);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT4)) SubFPutC(hDlg, IDC_CHK_TXT4);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_DIV1)) SubFPutC(hDlg, IDC_CHK_DIV1);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_DIV2)) SubFPutC(hDlg, IDC_CHK_DIV2);
	}
	return TRUE;
}
//----- AjcFPutCodeボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FPUTCODE	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT1)) SubFPutCode(hDlg, IDC_CHK_TXT1);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT2)) SubFPutCode(hDlg, IDC_CHK_TXT2);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT3)) SubFPutCode(hDlg, IDC_CHK_TXT3);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_TXT4)) SubFPutCode(hDlg, IDC_CHK_TXT4);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_DIV1)) SubFPutCode(hDlg, IDC_CHK_DIV1);
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_DIV2)) SubFPutCode(hDlg, IDC_CHK_DIV2);
	}
	return TRUE;
}
//----- AjcFPutCodeボタン（任意のバイト／ワード出力）-----------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FPUTC_ANY	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT		c;
		c = AjcGetDlgItemHex(hDlg, IDC_TXT_C);
		if (AjcFPutC(hFile, c)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFPutC(0x%0*X)  - OK\n"), sizeof(UT) * 2, UTMASK(c));
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFPutC(0x%0*X)  - NG\n"), sizeof(UT) * 2, UTMASK(c));
		}
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY			)

	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_GRP_LFCODE		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FCREATE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FCLOSE		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FPUTS		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FPUTC		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FPUTCODE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FPUTC_ANY	)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	AjcFPutS()実行																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubFPutS(HWND hDlg, UI idChkBox)
{
	UI		i, lText, stl, len;
	UT		cc [128];
	UT		txt[128];

	AjcGetDlgItemStr(hDlg, idChkBox, cc, AJCTSIZE(txt));
	AjcCLangStrToBin(cc, txt, AJCTSIZE(txt));
	stl = (UI)_tcslen(txt);
	lText = AjcGetDlgItemSInt(hDlg, IDC_TXT_LTEXT);
	if (AjcFPutS(hFile, txt, lText)) {
		AjcVthPrintF(hVthLog, TEXT("- AjcFPutS(%s\"%s\", %d) - OK\n"), fUnicode ? "L" : "", cc, lText);
		AjcVthPrintF(hVthLog, TEXT(" "));
		len = __min(stl, lText);
		for (i = 0; i < len; i++) {
			AjcVthPrintF(hVthLog, TEXT(" %02X"), UTMASK(txt[i]));
		}
		AjcVthPrintF(hVthLog, TEXT("\n"));
	}
	else {
		AjcVthPrintF(hVthLog, TEXT("- AjcFPutS(%S\"%s\", %d) - NG\n"), fUnicode ? "L" : "", cc, lText);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	AjcFPutS()を２回に分けて実行																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubFDivS(HWND hDlg, UI idChkBox)
{
	UT		txt[128];
	UI		stl, dvl;
	UT		tdv[2][64];
	UT		cdv[2][64];
	UT		item[64];
	UI		i, j;

	AjcGetDlgItemStr(hDlg, idChkBox, txt, AJCTSIZE(txt));
	stl = (UI)MAjcStrLen(txt);
	dvl = stl / 2;
	MAjcStrNCpy(tdv[0], 64, &txt[0]  , dvl);
	MAjcStrNCpy(tdv[1], 64, &txt[dvl], dvl);

	cdv[0][0] = 0;
	cdv[1][0] = 0;
	for (i = 0; i < 2; i++) {
		for (j = 0; j < dvl; j++) {
			UI	ut = UTMASK(tdv[i][j]);
			AjcSnPrintF(item, 64, TEXT("\\x%0*X"), sizeof(UT) * 2, ut);
			MAjcStrCat(cdv[i], 64, item);
		}

		if (AjcFPutS(hFile, tdv[i], dvl)) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFPutS(%s\"%s\", %d) - OK\n"), fUnicode ? "L" : "", cdv[i], dvl);
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFPutS(%s\"%s\", %d) - NG\n"), fUnicode ? "L" : "", cdv[i], dvl);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	AjcFPutC()実行																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubFPutC(HWND hDlg, UI idChkBox)
{
	UI		i, stl;
	UT		cc [128];
	UT		txt[128];

	AjcGetDlgItemStr(hDlg, idChkBox, cc, AJCTSIZE(txt));
	AjcCLangStrToBin(cc, txt, AJCTSIZE(txt));
	stl = (UI)_tcslen(txt);
	for (i = 0; i < stl; i++) {
		if (AjcFPutC(hFile, txt[i])) {
			AjcVthPrintF(hVthLog, TEXT("- AjcFPutC(0x%0*X)  - OK\n"), sizeof(UT) * 2, UTMASK(txt[i]));
		}
		else {
			AjcVthPrintF(hVthLog, TEXT("- AjcFPutC(0x%0*X)  - NG\n"), sizeof(UT) * 2, UTMASK(txt[i]));
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	AjcFPutCode()実行																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubFPutCode(HWND hDlg, UI idChkBox)
{
	UI		i, stl, code;
	UT		cc [128];
	UT		txt[128];

	AjcGetDlgItemStr(hDlg, idChkBox, cc, AJCTSIZE(txt));
	AjcCLangStrToBin(cc, txt, AJCTSIZE(txt));
	stl = (UI)_tcslen(txt);
	#ifdef UNICODE
		for (i = 0; i < stl;) {
			if (MAjcIsLeadW(txt[i])) {code = AjcTextToCodePointW(&txt[i]); i += 2;}
			else					 {code = txt[i++];}
			if (AjcFPutCode(hFile, code)) {
				AjcVthPrintF(hVthLog, TEXT("- AjcFPutCode(0x%08X)  - OK\n"), code);
			}
			else {
				AjcVthPrintF(hVthLog, TEXT("- AjcFPutCode(0x%08X)  - NG\n"), code);
			}
		}
	#else
		for (i = 0; i < stl;) {
			code = (UB)txt[i++];
			if (MAjcIsLeadA(txt[i])) {code |= ((UW)((UB)txt[i++]) << 8);}
			if (AjcFPutCode(hFile, code)) {
				AjcVthPrintF(hVthLog, TEXT("- AjcFPutCode(0x%08X)  - OK\n"), code);
			}
			else {
				AjcVthPrintF(hVthLog, TEXT("- AjcFPutCode(0x%08X)  - NG\n"), code);
			}
		}
	#endif
}
//--------------------------------------------------------------------------------------------------------------//
//	出力テキスト設定																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SetOutTxt(HWND hDlg, UI id, WCP pTxt)
{
	WC		txt[128];
	WC		wcc[128];

	AjcSnPrintFW(txt, AJCTSIZE(txt), L"%s", pTxt);
	ConvLfCodeW(hDlg, txt, AJCTSIZE(txt));
	AjcBinToCLangStrW(txt, wcc, AJCTSIZE(wcc));
	AjcSetDlgItemStrW(hDlg, id, wcc);
}

//--------------------------------------------------------------------------------------------------------------//
//	出力ファイルイメージ表示																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOutFileImage(HWND hDlg)
{
	HANDLE	hdl = INVALID_HANDLE_VALUE;
	UL		loc = 0;
	UL		bytes;

	AjcVthClear(hVthFImg);
	do {
		if ((hdl = CreateFile(FilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
			AjcVthPrintF(hVthFImg, TEXT("--- ファイルがありません(%s) ---\n\n"), FilePath);
			break;
		}
		if (GetFileSize(hdl, NULL) == 0) {
			AjcVthPrintF(hVthFImg, TEXT("--- ファイルの内容がありません(%s) ---\n\n"), FilePath);
			break;
		}
		//	ファイルイメージ表示
		switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE)) {
			case AJCTEC_MBC:
			{	UL		i, len, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- S-JIS - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data    string(UNICODE)\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data    string(S-JIS)\n\n"));
				ReadFile(hdl, bc_txt, sizeof bc_txt, &bytes, NULL);
				len = bytes;
				for (i = 0; i < len;) {
					cl	 = ShowByteCharData(AJCTEC_MBC, loc, &bc_txt[i], len - i, 2);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_UTF_8:
			{	UL		i, len, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- UTF-8 - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data                string(UNICODE[, U+])\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data                string(S-JIS)\n\n"));
				loc = ShowBOM(hdl);
				ReadFile(hdl, bc_txt, sizeof bc_txt, &bytes, NULL);
				len = bytes;
				for (i = 0; i < len;) {
					cl	 = ShowByteCharData(AJCTEC_UTF_8, loc, &bc_txt[i], len - i, 6);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_EUC_J:
			{	UL		i, len, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- EUC-J - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data       string(UNICODE)\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data       string(S-JIS)\n\n"));
				ReadFile(hdl, bc_txt, sizeof bc_txt, &bytes, NULL);
				len = bytes;
				for (i = 0; i < len;) {
					cl	 = ShowByteCharData(AJCTEC_EUC_J, loc, &bc_txt[i], len - i, 3);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_UTF_16LE:
			{	UL		i, len, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- UTF-16(LE) - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data        string(UNICODE, [U+])\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data        string(S-JIS)\n\n"));
				loc = ShowBOM(hdl);
				ReadFile(hdl, wc_txt, sizeof wc_txt, &bytes, NULL);
				len = bytes / 2;
				for (i = 0; i < len;) {
					cl	 = ShowWideCharData(AJCTEC_UTF_16LE, loc, &wc_txt[i], len - i, 2);
					i	+= cl;
					loc += cl;
				}
				break;
			}
			case AJCTEC_UTF_16BE:
			{	UL		i, len, cl;
				AjcVthPrintF(hVthFImg, TEXT("--- UTF-16(BE) - %s ---\n\n"), FilePath);
				if (fUnicode) AjcVthPrintF(hVthFImg, TEXT("point  data        string(UNICODE, [U+])\n\n"));
				else		  AjcVthPrintF(hVthFImg, TEXT("point  data        string(S-JIS)\n\n"));
				loc = ShowBOM(hdl);
				ReadFile(hdl, wc_txt, sizeof wc_txt, &bytes, NULL);
				len = bytes / 2;
				for (i = 0; i < len;) {
					cl	 = ShowWideCharData(AJCTEC_UTF_16BE, loc, &wc_txt[i], len - i, 2);
					i	+= cl;
					loc += cl;
				}
				break;
			}
		}
	} while(0);

	if (hdl != INVALID_HANDLE_VALUE) CloseHandle(hdl);
}
//--------------------------------------------------------------------------------------------------------------//
//	選択された条件表示																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowCond(HWND hDlg)
{
	UI		ix;
	UT		txt[128] = {0};

	AjcVthPrintF(hVthLog, TEXT("\n\n---"), txt);
	//	テキストコード
	if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_ENCODE))) != -1) {
		GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_ENCODE), ix), txt, AJCTSIZE(txt));
		AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
	}
	//	改行コード
	if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_LFCODE))) != -1) {
		GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_LFCODE), ix), txt, AJCTSIZE(txt));
		AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
	}
	//	BOM
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_BOM)) {
		AjcVthPrintF(hVthLog, TEXT("  BOM "), txt);
	}
	else {
		AjcVthPrintF(hVthLog, TEXT("  NoBOM "), txt);
	}
	//	改行コード変換
	if ((ix = AjcSbcGetRbt(GetDlgItem(hDlg, IDC_GRP_LFCONV))) != -1) {
		GetWindowText(AjcSbcGetRbtHandle(GetDlgItem(hDlg, IDC_GRP_LFCONV), ix), txt, AJCTSIZE(txt));
		AjcVthPrintF(hVthLog, TEXT("  %s "), txt);
	}
	AjcVthPrintF(hVthLog, TEXT("---\n\n"), txt);
}
//--------------------------------------------------------------------------------------------------------------//
//	ＢＯＭ表示																									//
//--------------------------------------------------------------------------------------------------------------//
static	UL		ShowBOM(HANDLE hdl)
{
	UL		loc = 0;
	UL		bytes;
	UB		bom[3];

	ReadFile(hdl, bom, 3, &bytes, NULL);
	//	UTF-8
	if		(bytes >= 3 && memcmp(bom, bom_utf8   , 3) == 0) {
		AjcVthPrintF(hVthFImg, TEXT("%4d : %02X %02X %02X (BOM)\n"), loc, (UB)bom[0], (UB)bom[1], (UB)bom[2]);
		SetFilePointer(hdl, 3, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 3;									//	読み出しバイト位置を返す
	}
	//	UTF-16(LE)
	else if (bytes >= 2 && memcmp(bom, bom_utf16le, 2) == 0) {
		AjcVthPrintF(hVthFImg, TEXT("%4d : %02X %02X (BOM)\n"), loc, (UB)bom[0], (UB)bom[1]);
		SetFilePointer(hdl, 2, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 1;									//	読み出しワード位置を返す
	}
	//	UTF-16(BE)
	else if (bytes >= 2 && memcmp(bom, bom_utf16be, 2) == 0) {
		AjcVthPrintF(hVthFImg, TEXT("%4d : %02X %02X (BOM)\n"), loc, (UB)bom[0], (UB)bom[1]);
		SetFilePointer(hdl, 2, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 1;									//	読み出しワード位置を返す
	}
	//	BOM無し
	else {
		SetFilePointer(hdl, 0, NULL, FILE_BEGIN);	//	読み出しバイト位置設定
		loc = 0;									//	読み出し位置＝先頭を返す
	}

	return loc;
}

//--------------------------------------------------------------------------------------------------------------//
//	バイト文字ファイルデータ表示	( pppp : hh hh ss (hh hh )													//
//--------------------------------------------------------------------------------------------------------------//
static	UI		ShowByteCharData(EAJCTEC tec, UI loc, BCP pTxt, UI lTxt, UI lMax)
{
	UI		rc = 0;
	UI		i, bl, sl, wl;
	BC		bc[16];				//	元のバイトデータ
	BC		sc[16], scc[16];	//	S-JIS文字  , Ｃ言語表示文字列
	WC		wc[16],	wcc[16];	//	UNICODE文字, Ｃ言語表示文字列

	AjcVthPrintFA(hVthFImg, "%4d : ", loc);
	//	１文字分のバイト数設定
	switch (tec) {
		case AJCTEC_MBC:	bl = AjcStrChkMbcLen (pTxt, lTxt);	break;
		case AJCTEC_UTF_8:	bl = AjcStrChkUtf8Len(pTxt, lTxt);	break;
		case AJCTEC_EUC_J:	bl = AjcStrChkEucLen (pTxt, lTxt);	break;
	}
	if (bl != 0) {
		//	１文字分のバイト文字切り出し
		memset(bc, 0, sizeof bc);
		memcpy(bc, pTxt, bl);
		//	１文字分のバイト文字コード表示
		for (i = 0; i < bl; i++) {
			AjcVthPrintFA(hVthFImg, "%02X ", (UB)bc[i]);
		}
		for (; i < lMax; i++) {
			AjcVthPrintFA(hVthFImg, "   ");
		}
		//	バイト文字 → S-JIS文字，ワイド文字変換
		switch (tec) {
			case AJCTEC_MBC:	strcpy_s(sc, AJCTSIZE(sc), bc); 						   sl = (UI)strlen(sc);
								MultiByteToWideChar(CP_ACP , 0, sc, -1, wc, AJCTSIZE(wc)); wl = (UI)wcslen(wc);
								break;
			case AJCTEC_UTF_8:	AjcUtf8ToMbc(bc, sc, AJCTSIZE(sc)); 					   sl = (UI)strlen(sc);
								MultiByteToWideChar(CP_UTF8, 0, bc, -1, wc, AJCTSIZE(wc)); wl = (UI)wcslen(wc);
								break;
			case AJCTEC_EUC_J:	AjcEucToSJis(bc, sc, AJCTSIZE(sc)); 					   sl = (UI)strlen(sc);
								MultiByteToWideChar(CP_ACP , 0, sc, -1, wc, AJCTSIZE(wc)); wl = (UI)wcslen(wc);
								break;
		}
		//	Ｃ言語表記の文字列作成
		AjcBinToCLangStrA(sc, scc, AJCTSIZE(scc));
		AjcBinToCLangStrW(wc, wcc, AJCTSIZE(wcc));
		//	１文字の文字フェースとUNICODEコード表示
		if (fUnicode) {
			if (MAjcIsLeadW(wc[0])) {
				UI code = AjcTextToCodePointW(wc);
				AjcVthPrintFW(hVthFImg, L"- %s (%04X %04X. %08X)\n", wcc, (UW)wc[0], (UW)wc[1], code);
			}
			else {
				if (wcslen(wcc) == 1 && !AjcIsBigCharW(wc)) AjcVthPrintFW(hVthFImg, L"- %-2s (%04X)\n", wcc, (UW)wc[0]);
				else										AjcVthPrintFW(hVthFImg, L"- %s (%04X)\n"  , wcc, (UW)wc[0]);
			}
		}
		//	１文字の文字フェースとS-JISコード表示
		else {
			if (MAjcIsLeadA(sc[0])) AjcVthPrintFA(hVthFImg,  "- %-2s (%02X %02X)\n", scc, (UB)sc[0], (UB)sc[1]);
			else					AjcVthPrintFA(hVthFImg,  "- %-2s (%02X)\n"	   , scc, (UB)sc[0]);
		}
		rc = bl;
	}
	else {
		AjcVthPrintFA(hVthFImg, "%02X       - ?\n", (UB)pTxt[0]);
		rc = 1;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ワイド文字ファイルデータ表示	( pppp : hhhh hhhh ss (hh hh )												//
//--------------------------------------------------------------------------------------------------------------//
static	UI		ShowWideCharData(EAJCTEC tec, UI loc, WCP pTxt, UI lTxt, UI lMax)
{
	UI		rc = 0;
	UI		i, bl, sl, wl;
	WC		bc[16];				//	元のワイド文字
	BC		sc[16], scc[16];	//	S-JIS文字	, Ｃ言語表示文字列
	WC		wc[16],	wcc[16];	//	UNICODE文字 , Ｃ言語表示文字列

	AjcVthPrintFA(hVthFImg, "%4d : ", loc);
	//	１文字分のワイド文字数設定
	switch (tec) {
		case AJCTEC_UTF_16LE:	bl = (MAjcIsLeadW(*pTxt)				 ? 2 : 1);	break;
		case AJCTEC_UTF_16BE:	bl = (MAjcIsLeadW((WC)AjcExcWord(*pTxt)) ? 2 : 1);	break;
	}
	if (bl != 0) {
		//	１文字分のワイド文字切り出し
		memset (bc, 0, sizeof bc);
		wcsncpy_s(bc, AJCTSIZE(bc), pTxt, bl);
		//	１文字分のワイドコード文字表示
		for (i = 0; i < bl; i++) {
			AjcVthPrintFA(hVthFImg, "%04X ", (UW)bc[i]);
		}
		for (; i < lMax; i++) {
			AjcVthPrintFA(hVthFImg, "     ");
		}
		//	元データ文字 → UNICODE文字. S-JIS文字変換
		switch (tec) {
			case AJCTEC_UTF_16LE:	wcscpy_s(wc, AJCTSIZE(wc), bc); 										wl = (UI)wcslen(wc);
									WideCharToMultiByte(CP_ACP, 0, wc, -1, sc, AJCTSIZE(sc), NULL, NULL);	sl = (UI)strlen(sc);
									break;
			case AJCTEC_UTF_16BE:	for (i = 0; i < bl; i++) {wc[i] = (WC)AjcExcWord(pTxt[i]);}	wc[i] = 0;	wl = (UI)wcslen(wc);
									WideCharToMultiByte(CP_ACP, 0, wc, -1, sc, AJCTSIZE(sc), NULL, NULL);	sl = (UI)strlen(sc);
									break;
		}
		//	Ｃ言語表記の文字列作成
		AjcBinToCLangStrA(sc, scc, AJCTSIZE(scc));
		AjcBinToCLangStrW(wc, wcc, AJCTSIZE(wcc));
		//	１文字の文字フェースとUNICODEコード表示
		if (fUnicode) {
			if (MAjcIsLeadW(wc[0])) {
				UI code = AjcTextToCodePointW(wc);
				AjcVthPrintFW(hVthFImg, L"- %s (%04X %04X, %08X)\n", wcc, (UW)wc[0], (UW)wc[1], code);
			}
			else {
				if (wcslen(wcc) == 1 && !AjcIsBigCharW(wc)) AjcVthPrintFW(hVthFImg, L"- %-2s (%04X)\n", wcc, (UW)wc[0]);
				else										AjcVthPrintFW(hVthFImg, L"- %s (%04X)\n"  , wcc, (UW)wc[0]);
			}
		}
		//	１文字の文字フェースとS-JISコード表示
		else {
			if (MAjcIsLeadA(sc[0])) AjcVthPrintFA(hVthFImg,  "- %-2s (%02X %02X)\n", scc, (UB)sc[0], (UB)sc[1]);
			else					AjcVthPrintFA(hVthFImg,  "- %-2s (%02X)\n"	   , scc, (UB)sc[0]);
		}
		rc = bl;
	}
	else {
		AjcVthPrintFA(hVthFImg, "%02X       - ?\n", (UB)pTxt[0]);
		rc = 1;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	改行コード変換																								//
//--------------------------------------------------------------------------------------------------------------//
//	バイト文字
static	VO		ConvLfCodeA(HWND hDlg, BCP pTxt, UI lTxt)
{
	BCP		p;

	switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_LFCODE)) {
		case LFC_CR:		//	CR
			while (p = strstr(pTxt, "\r\n")) {
				AjcRepPartStrA(pTxt, lTxt, (UI)((UX)p - (UX)pTxt), 2, "\r", 1);
			}
			break;
		case LFC_LF:		//	LF
			while (p = strstr(pTxt, "\r\n")) {
				AjcRepPartStrA(pTxt, lTxt, (UI)((UX)p - (UX)pTxt), 2, "\n", 1);
			}
			break;
		case LFC_CRLF:		//	CR, LF
			break;
	}
}
//	ワイド文字
static	VO		ConvLfCodeW(HWND hDlg, WCP pTxt, UI lTxt)
{
	WCP		p;

	switch (AjcGetDlgItemUInt(hDlg, IDC_GRP_LFCODE)) {
		case LFC_CR:		//	CR
			while (p = wcsstr(pTxt, L"\r\n")) {
				AjcRepPartStrW(pTxt, lTxt, (UI)(((UX)p - (UX)pTxt) / 2), 2, L"\r", 1);
			}
			break;
		case LFC_LF:		//	LF
			while (p = wcsstr(pTxt, L"\r\n")) {
				AjcRepPartStrW(pTxt, lTxt, (UI)(((UX)p - (UX)pTxt) / 2), 2, L"\n", 1);
			}
			break;
		case LFC_CRLF:		//	CR, LF
			break;
	}
}

