﻿//
//	SW_TipTextM.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"


//--------------------------------------------------------------------------------------------------------------//
//	コントロールの公開情報																						//
//--------------------------------------------------------------------------------------------------------------//
//	クラス名
#define		CMYCTRL		TEXT("MyControlClass")
//	ＡＰＩ
extern	VO		MyControlInit(VO);
extern	VO		MyControlEnd(VO);
extern	int		MyControlGetValue(HWND hCtrl);
extern	int		MyControlGetCount(HWND hCtrl);
//	通知コード（WM_COMMANDのHIWORD(wParam)）
#define	NTC_UPDATED		0x1234

//==============================================================================================================//
//																												//
//	メインプログラム																							//
//																												//
//==============================================================================================================//
//	ワーク
static	HINSTANCE		hInst;
static	HWND			hDlgMain;

//	メインダイアログプロシージャ プロトタイプ
AJC_DLGPROC_DEF(Main);

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メイン・プログラム																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//	コントロール初期化
	MyControlInit();

	//	メイン・ダイアログ生成
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//	ダイアログ表示
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	//	コントロール後処理
	MyControlEnd();

	return (int)msg.wParam ;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メイン・ダイアログ・プロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;

	//	コントロールのチップテキスト設定
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_MYCTRL1), TEXT("コントロール１： 値の増減を行います。\n"
												 TEXT("増減する値の範囲は、-100 ～ 100です。")));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_MYCTRL2), TEXT("コントロール２： 値の増減を行います。\n"
												 TEXT("増減する値の範囲は、-100 ～ 100です。")));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- 値の増減コントロールからの通知（１）--------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_MYCTRL1		)
{
	if (HIWORD(wParam) == NTC_UPDATED) {
		AjcSetDlgItemSInt(hDlg, IDC_TXT_VAL1, MyControlGetValue(GetDlgItem(hDlg, IDC_MYCTRL1)));
		AjcSetDlgItemSInt(hDlg, IDC_TXT_CNT1, MyControlGetCount(GetDlgItem(hDlg, IDC_MYCTRL1)));
	}
	return TRUE;
}
//----- 値の増減コントロールからの通知（２）--------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_MYCTRL2		)
{
	if (HIWORD(wParam) == NTC_UPDATED) {
		AjcSetDlgItemSInt(hDlg, IDC_TXT_VAL2, MyControlGetValue(GetDlgItem(hDlg, IDC_MYCTRL2)));
		AjcSetDlgItemSInt(hDlg, IDC_TXT_CNT2, MyControlGetCount(GetDlgItem(hDlg, IDC_MYCTRL2)));
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )

	AJC_DLGMAP_CMD(Main, IDC_MYCTRL1	   )
	AJC_DLGMAP_CMD(Main, IDC_MYCTRL2	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//==============================================================================================================//
//																												//
//	数値の増減コントロール																						//
//																												//
//==============================================================================================================//
//	コントロールのクラスアトム
static	ATOM	AtmMyCtrl = 0;

//	コントロールのワーク
typedef struct {
	int		val;		//	現在値
	int		cnt;		//	更新回数
	HWND	hWndCtrl;	//	コントロールのメインウインド
	HWND	hDlgSub;	//	サブダイアログハンドル
} WRKMYCTRL, *PWRKMYCTRL;
typedef const WRKMYCTRL *PCWRKMYCTRL;

//	ウインドプロシージャ・プロトタイプ
AJC_WNDPROC_DEF(MyControl);
AJC_DLGPROC_DEF(SubDialog);
AJC_WNDPROC_DEF(SubClass );

//--------------------------------------------------------------------------------------------------------------//
//	コントロール初期化																							//
//--------------------------------------------------------------------------------------------------------------//
VO		MyControlInit(VO)
{
	WNDCLASS	wndclass;

	//	コントロールクラス生成
	wndclass.style			= CS_GLOBALCLASS;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(MyControl);
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= sizeof(PWRKMYCTRL);
	wndclass.hInstance		= hInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= CMYCTRL;
	AtmMyCtrl = RegisterClass(&wndclass);
}
//--------------------------------------------------------------------------------------------------------------//
//	コントロール後処理																							//
//--------------------------------------------------------------------------------------------------------------//
VO		MyControlEnd(VO)
{
	//	コントロールクラス破棄
	UnregisterClass((UTP)AtmMyCtrl, hInst);
}

//--------------------------------------------------------------------------------------------------------------//
//	コントロールから数値取得																					//
//--------------------------------------------------------------------------------------------------------------//
int		MyControlGetValue(HWND hCtrl)
{
	PWRKMYCTRL		pW = (PWRKMYCTRL)MAjcGetWindowLong(hCtrl, 0);
	return pW->val;
}

//--------------------------------------------------------------------------------------------------------------//
//	コントロールから更新回数取得																				//
//--------------------------------------------------------------------------------------------------------------//
int		MyControlGetCount(HWND hCtrl)
{
	PWRKMYCTRL		pW = (PWRKMYCTRL)MAjcGetWindowLong(hCtrl, 0);
	return pW->cnt;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロール・ウインドプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(MyControl, WM_CREATE		)
{
	PWRKMYCTRL		pW = NULL;
	RECT			r;

	//	ワーク生成
	pW = (PWRKMYCTRL)malloc(sizeof(WRKMYCTRL));
	//	ウインド・エクストラ領域へワークポインタ設定
	MAjcSetWindowLong(hwnd, 0, (UX)pW);
	//	ワーク初期化
	memset(pW, 0, sizeof(WRKMYCTRL));
	pW->hWndCtrl = hwnd;
	//	サブ・ダイアログ生成
	pW->hDlgSub  = CreateDialogParam(hInst, MAKEINTRESOURCE(IDD_DLGSUB), hwnd, AJC_DLGPROC_NAME(SubDialog), (LPARAM)pW);
	ShowWindow(pW->hDlgSub, SW_SHOW);
	//	コントロールのサイズをダイアログに合わせる
	GetWindowRect(pW->hDlgSub, &r);
	SetWindowPos(hwnd, NULL, 0, 0, r.right - r.left, r.bottom - r.top, SWP_NOMOVE);
	//	ツールチップの制御対象をサブダイアログとするように指示
	AJCTIPCTRL_SETHWND(hwnd, pW->hDlgSub);
	//	以下のテキストボックスとスピンボタンでもチップテキストを表示するように設定
	AJCTIP_SETFRIEND(GetDlgItem(pW->hDlgSub, IDC_TXT));
	AJCTIP_SETFRIEND(GetDlgItem(pW->hDlgSub, IDC_SPN));

	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(MyControl, WM_DESTROY	)
{
	PWRKMYCTRL		pW = (PWRKMYCTRL)MAjcGetWindowLong(hwnd, 0);

	//	サブ・ダイアログ破棄
	DestroyWindow(pW->hDlgSub);
	//	ワーク破棄
	free(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MyControl)
	AJC_WNDMAP_MSG(MyControl, WM_CREATE		)
	AJC_WNDMAP_MSG(MyControl, WM_DESTROY	)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロール・サブダイアログプロシージャ																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(SubDialog, WM_INITDIALOG 	)
{
	PWRKMYCTRL		pW = (PWRKMYCTRL)lParam;
	
	//	ダイアログにワークポインタを関連付ける
	SetProp(hDlg, TEXT("SubDlgProp"), (HANDLE)lParam);
	//	スピンボタン初期設定
	AjcSetCtrlSpnRange(GetDlgItem(hDlg, IDC_SPN), -100,  100);
	//	テキストボックスとスピンボタンをサブクラス化し、マウスイベントをトラップする
	MAjcMmpSetSubclass(SubClass, GetDlgItem(hDlg, IDC_TXT));
	MAjcMmpSetSubclass(SubClass, GetDlgItem(hDlg, IDC_SPN));
	return TRUE;
}
//----- ダイアログ破棄 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(SubDialog, WM_DESTROY	 	)
{
	//	ダイアログに関連付けたワークポインタ解放
	RemoveProp(hDlg, TEXT("SubDlgProp"));

	return TRUE;
}
//----- IDC_TXT ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SubDialog, IDC_TXT			)
{
	PWRKMYCTRL		pW = (PWRKMYCTRL)GetProp(hDlg, TEXT("SubDlgProp"));

	if (HIWORD(wParam) == EN_CHANGE) {
		//	スピンボタンに「AutoBuddy」が設定されている場合「WM_INITDIALOG」より先にテキストボックスが設定される場合がある為、
		//	「WM_INITDIALOG」が実行されていない場合は、処理を行わないようにする必要があります。
		if (pW != NULL) {
			pW->val = AjcGetDlgItemSInt(hDlg, IDC_TXT);
			pW->cnt++;
			SendMessage(GetParent(pW->hWndCtrl), WM_COMMAND, 
								MAKELONG(MAjcGetWindowLong(pW->hWndCtrl, GWL_ID), NTC_UPDATED), (LPARAM)pW->hWndCtrl);
		}
	}
	return TRUE;
}
//----- IDC_CMD_CLR --------------------------------------------------------------------------------------------//
AJC_DLGPROC(SubDialog, IDC_CMD_CLR		)
{
	PWRKMYCTRL		pW = (PWRKMYCTRL)GetProp(hDlg, TEXT("SubDlgProp"));

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcSetDlgItemSInt(hDlg, IDC_TXT, pW->val = 0);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SubDialog)
	AJC_DLGMAP_MSG(SubDialog, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(SubDialog, WM_DESTROY	   )
	AJC_DLGMAP_CMD(SubDialog, IDC_TXT		   )
	AJC_DLGMAP_CMD(SubDialog, IDC_CMD_CLR	   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	サブクラス化したウインドプロシージャ（テキストボックス，スピンボタン）										//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubClass, WM_MOUSEMOVE		   )
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SubClass);;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubClass, WM_LBUTTONDOWN	   )
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SubClass);;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubClass, WM_MBUTTONDOWN	   )
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SubClass);;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubClass, WM_RBUTTONDOWN	   )
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SubClass);;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SubClass)
	AJC_WNDMAP_MSG(SubClass, WM_MOUSEMOVE  )
	AJC_WNDMAP_MSG(SubClass, WM_LBUTTONDOWN)
	AJC_WNDMAP_MSG(SubClass, WM_MBUTTONDOWN)
	AJC_WNDMAP_MSG(SubClass, WM_RBUTTONDOWN)
AJC_WNDMAP_END

