﻿//
//	SW_VMbxC.c
//
#include	<AjrCstXX.h>
#include	<process.h>
#include	<tchar.h>

//----- メールデータ種別 ---------------------------------------------------------------------------------------//
typedef enum {
	CMD_STR = 1 ,			//	文字列通知
	CMD_END 				//	終了
} CMDCODE;

//----- メールデータ形式 ---------------------------------------------------------------------------------------//
typedef struct {
	CMDCODE 	cmd;		//	メールデータ種別
	UTP 		pStr2;		//	文字列２へのポインタ
	UT			Str1[64];	//	文字列１
} MAILDATA, *PMAILDATA;


//==============================================================================================================//
//																												//
//	メールデータ作成																							//
//																												//
//==============================================================================================================//
static	UI		MakeMailData(PMAILDATA pBuf, CMDCODE cmd, C_UTP pStr1, C_UTP pStr2)
{
	UI	lStr1 = (UI)MAjcStrLen(pStr1) + 1;
	UI	lStr2 = (UI)MAjcStrLen(pStr2) + 1;

	pBuf->cmd	= cmd;
	MAjcStrCpy(pBuf->Str1, AJCTSIZE(pBuf->Str1), pStr1);
	pBuf->pStr2 = AjcTAlloc(lStr2);
	MAjcStrCpy(pBuf->pStr2, lStr2, pStr2);

	return sizeof(MAILDATA) - sizeof pBuf->Str1 + (lStr1 * sizeof(UT));
}
//==============================================================================================================//
//																												//
//	破棄メールデータ通知用コールバック関数																		//
//																												//
//==============================================================================================================//
static	VO	CALLBACK	cbRemove(VOP pD, UI lDat, UX cbp)
{
	PMAILDATA	pDat = (PMAILDATA)pD;
	AjcPrintF(TEXT("Removed: len=%3d, %s %s\n"), lDat, pDat->Str1, pDat->pStr2);
	AjcTFree(pDat->pStr2);
}
//==============================================================================================================//
//																												//
//	サブスレッド																								//
//																												//
//==============================================================================================================//
static	VO		SubThread(VOP param)
{
	HAJCVMBX	hVMbx = (HAJCVMBX)param;
	UI			lDat;
	MAILDATA	MailData;

	//----- １秒周期で文字列をメインスレッドに通知（３回）-----------//
	lDat = MakeMailData(&MailData, CMD_STR, TEXT("Apple is" ), TEXT("fruit"    ));
	AjcVMbxEnque(hVMbx, &MailData, lDat);
	Sleep(1000);
	lDat = MakeMailData(&MailData, CMD_STR, TEXT("Dog is"	), TEXT("animal"   ));
	AjcVMbxEnque(hVMbx, &MailData, lDat);
	Sleep(1000);
	lDat = MakeMailData(&MailData, CMD_STR, TEXT("Flower is"), TEXT("beautiful"));
	AjcVMbxEnque(hVMbx, &MailData, lDat);
	Sleep(1000);
	//----- メインスレッドに終了を通知 ------------------------------//
	lDat = MakeMailData(&MailData, CMD_END, TEXT("The"), TEXT("End"));
	AjcVMbxEnque(hVMbx, &MailData, lDat);
	//----- 余分なデータ通知 ----------------------------------------//
	lDat = MakeMailData(&MailData, CMD_STR, TEXT("Remained"), TEXT("Data 1"));
	AjcVMbxEnque(hVMbx, &MailData, lDat);
	lDat = MakeMailData(&MailData, CMD_STR, TEXT("Remained"), TEXT("Data 2"));
	AjcVMbxEnque(hVMbx, &MailData, lDat);
	//----- サブスレッド終了 ----------------------------------------//
	_endthread();
}

//==============================================================================================================//
//																												//
//	m a i n 																									//
//																												//
//==============================================================================================================//
int 	AjcMain(int argc, UTP argv[])
{
	HAJCVMBX	hVMbx;
	MAILDATA	MailData;
	UI			lDat;
	BOOL		fEnd = FALSE;

	AjcSetStdoutMode();

	//----- メールボックス・インスタンス生成 ------------------------//
	hVMbx = AjcVMbxCreate(0, cbRemove);
	//----- サブスレッド生成 ----------------------------------------//
	_beginthread(SubThread, 0, hVMbx);
	Sleep(1);
	//----- サブスレッドからの通知待ちループ ------------------------//
	MailData.cmd = 0;
	while (!fEnd) {
		memset(&MailData, 0, sizeof MailData);
		if ((lDat = AjcVMbxDequeEx(hVMbx, &MailData, sizeof MailData, 300)) != -1) {	// サブスレッドからの通知あり？
			switch (MailData.cmd) {
				case CMD_STR:												//		● 文字列通知
					AjcPrintF(TEXT("String : len=%3d, %s %s\n"), lDat, MailData.Str1, MailData.pStr2);
					AjcTFree(MailData.pStr2);
					break;

				case CMD_END:												//		● 終了通知
					AjcPrintF(TEXT("Exit   : len=%3d, %s %s\n"), lDat, MailData.Str1, MailData.pStr2);
					AjcTFree(MailData.pStr2);
					fEnd = TRUE;
					break;
			}
		}
		else {																//	タイムアウト？
			AjcPrintF(TEXT("Timeout!\n"));
		}
	}
	Sleep(100);

	//----- 残留メールデータ破棄 ------------------------------------//
	AjcVMbxPurge(hVMbx);

	//----- メールボックス・インスタンス消去 ------------------------//
	AjcVMbxDelete(hVMbx);

	getchar();
	return	0;
}

