﻿//
//	SW_VQueC.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<string.h>
#include	<tchar.h>

static	VOP		GetNodeAddr(UI ix);

//------------------------------------------------------------------------------------------//
//	作業領域																				//
//------------------------------------------------------------------------------------------//
static	HAJCVQUE	hQue;

//------------------------------------------------------------------------------------------//
//	ノード削除通知																			//
//------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemove(VOP pDat, UI len, UX cbp)
{
	AjcPrintF(TEXT("ノード削除 %p : %s, len = %d\n"), pDat, pDat, len); 
}
//------------------------------------------------------------------------------------------//
//	テキスト入力通知																		//
//------------------------------------------------------------------------------------------//
static	VO CALLBACK cbNtcInput(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	VOP	pDat;
	UI	bytes, seq;

	//	入力テキスト表示
	AjcPrintF(TEXT("%s\n"), pTxt);
	if (argc >= 1) {
		//	文字列データを持つノードを末尾に挿入
		if		(_tcsicmp(argv[0], TEXT("Q")) == 0) {
			if (argc == 2) AjcVQueEnque(hQue, argv[1], ((UI)_tcslen(argv[1]) + 1) * (sizeof(UT)));
			else		   AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	文字列データを持つノードを先頭に挿入
		else if (_tcsicmp(argv[0], TEXT("QT")) == 0) {
			if (argc == 2) AjcVQueEnqTop(hQue, argv[1], ((UI)_tcslen(argv[1]) + 1) * (sizeof(UT)));
			else		   AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノードデータ一覧を表
		else if (_tcsicmp(argv[0], TEXT("L")) == 0) {
			seq = 0;
			if (pDat = (UTP)AjcVQueTopNode(hQue, &bytes)) {
				do {
					AjcPrintF(TEXT("%2d - %p : %s\n"), seq++, pDat, pDat);
				} while(pDat = AjcVQueNextNode(hQue, pDat, &bytes));
			}
		}
		//	全ノードを取り出して表示
		else if (_tcsicmp(argv[0], TEXT("G"))  == 0) {
			UT	buf[256];
			seq = 0;
			while ((AjcVQueDequeEx(hQue, &buf, sizeof buf)) != -1) {
				AjcPrintF(TEXT("%2d - %s\n"), seq++, buf);
			}
		}
		//	全ノードを破棄
		else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
			AjcVQuePurge(hQue);
		}
		//	ノードヘッダのダンプ表示
		else if (_tcsicmp(argv[0], TEXT("DMP"))  == 0) {
			seq = 0;
			if (pDat = (UTP)AjcVQueTopNode(hQue, &bytes)) {
				do {
					PAJCVQNODE pH = ((PAJCVQNODE)pDat) - 1;
					AjcPrintF(TEXT("%2d - %p : next = %p, len = %d, dat = %p : %s\n"), seq++, pH, pH->pNxt, pH->len, pDat, pDat);
				} while(pDat = AjcVQueNextNode(hQue, pDat, &bytes));
			}
		}
		//	その他
		else {
			AjcPrintF(TEXT("*** Invalid command.\n"));
		}
	}
}
//------------------------------------------------------------------------------------------//
//	Ｎ番目のノードデータアドレス取得														//
//------------------------------------------------------------------------------------------//
MAJCVQUEPTR(PTRARR, UTP)
static	VOP		GetNodeAddr(UI ix)
{
	VOP		rc = NULL;
	UI		n;
	PCPTRARR pArr = (PPTRARR)AjcVQueCreatePtrArr(hQue, &n);
	if (ix < n) {
		rc = (VOP)pArr[ix].pNode;
	}
	AjcVQueReleasePtrArr(hQue, (PCAJCVQUEPTR)pArr);
	return rc;
}

//------------------------------------------------------------------------------------------//
//	ｍ ａ ｉ ｎ 																			//
//------------------------------------------------------------------------------------------//
int  AjcMain(int argc, UTP argv[])
{
	AjcSetStdoutMode();

	AjcSetConsoleBufSize(128, 64);
	AjcSetConsoleWndRect(0, 0, 127, 30);

	AjcPrintF(TEXT("\n 以下のコマンドを入力してください。\n\n"));
	AjcPrintF(TEXT("  Q   <文字列>     : 文字列データを持つノードを末尾に挿入\n"));
	AjcPrintF(TEXT("  QT  <文字列>     : 文字列データを持つノードを先頭に挿入\n"));
	AjcPrintF(TEXT("  L                : ノードデータ一覧を表示（昇順）\n"));
	AjcPrintF(TEXT("  G                : 全ノードを取り出して表示\n"));
	AjcPrintF(TEXT("  A                : 全ノードを破棄\n"));
	AjcPrintF(TEXT("  DMP              : ノードヘッダのダンプ表示\n"));
	AjcPrintF(TEXT("  <ESC>キー        : 終了\n"));
	AjcPrintF(TEXT("\n"));

	//	線形リストインスタンス生成
	hQue = AjcVQueCreate(0, cbRemove);

	AjcPrintF(TEXT("Input(%3u) - "), AjcVQueGetCount(hQue));
	while (AjcConInputByNtc(0, cbNtcInput)) {
		AjcPrintF(TEXT("Input(%3u) - "), AjcVQueGetCount(hQue));
	}
	//	線形リストインスタンス消去
	AjcVQueDelete(hQue);

	return 0;
}
