﻿//
//	SW_VT100.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define 	IDC_VTH 	5000

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hWndBack;						//	バックウインドハンドル（ダイアログとVT-100の親ウインド）
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hWndVth;						//	タイムチャート・グラフコントロールのウインドハンドル

int 			WndWidth, WndHeight;			//	ウインドの幅と高さ
int 			DlgWidth, DlgHeight;			//	ダイアログの幅と高さ
BOOL			fTimeStampLog = FALSE;			//	タイムスタンプログ動作状態
UI				TxtColor, BkColor, BkWnd;		//	描画色（パレット番号）

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
AJC_DLGPROC_DEF(Main);
static	VO	SetStyleToCheckBox(VO);
static	VO	SetCheckBoxToStyle(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wndclass;
	hInst = hInstance;

	//----- バックウインド生成 -------------------------//
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Back);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= 0;
	wndclass.hInstance		= hInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= TEXT("SW_VT100");
	RegisterClass(&wndclass);

	hWndBack = CreateWindow(TEXT("SW_VT100"),			// window class name
							TEXT("SW_VT100"),			// window caption
							WS_OVERLAPPEDWINDOW,		// window style
							0,							// initial x position
							0,							// initial y position
							0,							// initial x size
							0,							// initial y size
							NULL,						// parent window handle
							NULL,						// window menu handle
							hInst,						// program instance handle
							NULL);						// creation parameters

	//----- ウインド表示 -------------------------------//
	ShowWindow(hWndBack, iCmdShow);
	//----- ＶＴ－１００ウインドをフォーカス -----------//
	SetFocus(hWndVth);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	バックウインド・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE 		)
{
	RECT	r;
	int		sty = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
	int		exs = (int)MAjcGetWindowLong(hwnd, GWL_EXSTYLE);

	hWndBack = hwnd;

	//----- VT-100エミュレーション・コントロール生成 -----------------//
	hWndVth = CreateWindowEx(WS_EX_ACCEPTFILES, 										// extend style
								TEXT("AjcCtrlVT100"),									// window class name
								TEXT("P: VW=120, VH=25, FN=MS Gothic"),					// window caption
								WS_CHILD | WS_VISIBLE | AJCVTHS_LOGFILE | AJCVTHS_LFCTRL | AJCVTHS_SEPARATE,
								0, 														// initial x position
								0, 														// initial y position
								0, 														// initial x size
								0,														// initial y size
								hwnd,													// parent window handle
								(HMENU)IDC_VTH,											// window menu handle
								hInst, 													// program instance handle
								NULL); 													// creation parameters
	//----- VT100設定値ロード ----------------------------------------//
	AjcLoadAllControlSettings(hwnd, TEXT("Settings"), AJCCTL_SELACT_ALL);
	//----- 文字列検索情報セクションの設定と読み出し -----------------//
	AjcVthSetFindProfileSect(hWndVth, TEXT("FindSect"));
	//----- タイトル設定 ---------------------------------------------//
	AjcVthSetTitleText(hWndVth, TEXT(" ウインドタイトル "), -1, -1, NULL);
	//----- ツールチップ設定　----------------------------------------//
	AjcVthSetTipText(hWndVth, TEXT("ＶＴ１００エミュレーションウインド"));
	//----- メイン・ダイアログ生成 -----------------------------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), hwnd, AJC_DLGPROC_NAME(Main));
	//	ダイアログサイズ設定
	GetWindowRect(hDlgMain, &r);
	DlgWidth  = r.right - r.left;
	DlgHeight = r.bottom - r.top;
	//----- 初期ウインドサイズ設定 -----------------------------------//
	sty = (int)MAjcGetWindowLong(hWndBack, GWL_STYLE);
	exs = (int)MAjcGetWindowLong(hWndBack, GWL_EXSTYLE);
	AdjustWindowRectEx(&r, sty, FALSE, exs);
	WndWidth  = r.right - r.left;
	WndHeight = r.bottom - r.top + 200;
	SetWindowPos(hwnd, NULL, 0, 0, WndWidth, WndHeight, SWP_NOMOVE);
	//----- ウインド位置，サイズロード -------------------------------//
	AjcLoadWndRect(hwnd, TEXT("WndRect"));
	//----- ウインド表示 ---------------------------------------------//
	ShowWindow(hDlgMain, SW_SHOW);
	ShowWindow(hWndVth , SW_SHOW);

	return 0;
}
//----- WM_SIZING ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZING			)
{
	LPRECT	p = (LPRECT)lParam;

	if (p->right - p->left < WndWidth) {
		p->right  = p->left + WndWidth;
	}
	if (p->bottom - p->top < WndHeight) {
		p->bottom = p->top	+ WndHeight;
	}

	return TRUE;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE			)
{
	UI	width  = LOWORD(lParam);
	UI	height = HIWORD(lParam);

	//----- ダイアログとVT-100ウインド移動 ----------------------------//
	MoveWindow(hDlgMain, 0, 0		 , width, DlgHeight 		, TRUE);
	MoveWindow(hWndVth , 0, DlgHeight, width, height - DlgHeight, TRUE);

	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY		)
{
	//----- ウインド位置，サイズセーブ -------------------------------//
	AjcSaveWndRect(hwnd, TEXT("WndRect"));
	//----- VT100設定値セーブ ----------------------------------------//
	AjcSaveAllControlSettings(hwnd);
	//----- プログラム終了 -------------------------------------------//
	PostQuitMessage(0);
	return 0;
}
//----- ＶＴ１００ コントロールからの通知 ----------------------------------------------------------------------//
AJC_WNDPROC(Back, IDC_VTH			)
{
	int 	cw, ch, sw, sh, sty, exs;
	RECT	r;
	UT		path[MAX_PATH];

	switch (HIWORD(wParam)) {
		case AJCVTHN_KEYIN: 		//	●キー入力（入力した文字を描画）
			AjcVthPutText(hWndVth, (UTP)&lParam, 1);
			break;

		case AJCVTHN_VKEYIN:		//	●拡張キー押下（↑↓←→でカーソル移動）
			switch (lParam) {
				case VK_UP: 	AjcVthPutText(hWndVth, TEXT("\x1B[A"), -1); break;
				case VK_DOWN:	AjcVthPutText(hWndVth, TEXT("\x1B[B"), -1); break;
				case VK_RIGHT:	AjcVthPutText(hWndVth, TEXT("\x1B[C"), -1); break;
				case VK_LEFT:	AjcVthPutText(hWndVth, TEXT("\x1B[D"), -1); break;
			}
			break;

		case AJCVTHN_DBLCLK:		//	●ダブルクリック（ウインドをＶＲＡＭサイズに合わせる）
			AjcVthGetVramFitSize(hWndVth, &cw, &ch);
			r.top = r.left = 0;
			r.right  = __max(DlgWidth, cw);
			r.bottom = DlgHeight + ch;
			sty = (int)MAjcGetWindowLong(hWndBack, GWL_STYLE);
			exs = (int)MAjcGetWindowLong(hWndBack, GWL_EXSTYLE);
			AdjustWindowRectEx(&r, sty, FALSE, exs);
			sw = GetSystemMetrics(SM_CXSCREEN) * 90 / 100;
			sh = GetSystemMetrics(SM_CYSCREEN) * 90 / 100;
			cw = __min(sw, r.right - r.left);
			ch = __min(sh, r.bottom - r.top);
			SetWindowPos(hWndBack, NULL, 0, 0, cw, ch, SWP_NOMOVE);
			break;

		case AJCVTHN_DROPFILE:		//	●ファイル ドロップ（ファイルの内容を描画）
			while (AjcVthGetDroppedFile(hWndVth, path)) {
				HAJCFILE	hFile;
				WC			wbuf[256];
				AjcVthPrintF(hWndVth, TEXT("\r\n\x1B[34m[[[ FILE = %s ]]]\x1B[0m\r\n"), path);
				if (hFile = AjcFOpen(path, AJCTEC_AUTO)) {
					while (AjcFGetSW(hFile, wbuf, 256)) {
						AjcVthPutTextW(hWndVth, wbuf, -1);
					}
					AjcFClose(hFile);
				}
			}
			break;

		case AJCVTHN_DROPDIR:		//	●ディレクトリ ドロップ（ディレクトリ名表示）
			while (AjcVthGetDroppedDir(hWndVth, path)) {
				AjcVthPrintF(hWndVth, TEXT("\r\n\x1B[35m[[[ DIR = %s ]]]]\x1B[0m\r\n"), path);
			}
			break;

		case AJCVTHN_RCLICK:		//	●右クリック
		{	PAJCVTHRCLK	p = (PAJCVTHRCLK)lParam;
			UT			txt[64] = {0};
			AjcSnPrintF(txt, 64, TEXT("%s%s右クリック発生(x = %d, y = %d)"), p->fShift ? TEXT("Shift+") : TEXT(""),
																			 p->fCtrl  ? TEXT("Ctrl+" ) : TEXT(""),
																			 p->x, p->y);
			MessageBox(hwnd, txt, TEXT("S_CtrlVT100_01"), MB_OK);
			break;
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE	   )
	AJC_WNDMAP_MSG(Back, WM_SIZE	   )
	AJC_WNDMAP_MSG(Back, WM_SIZING	   )
	AJC_WNDMAP_MSG(Back, WM_DESTROY    )
	AJC_WNDMAP_CMD(Back, IDC_VTH	   )
AJC_WNDMAP_END
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UI			sty;

	hDlgMain = hDlg;

	//----- ダイアログ項目初期設定 -------------------------------------------------------------//
	sty = (UI)MAjcGetWindowLong(hWndVth, GWL_STYLE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_LOGFILE	 , (sty & AJCVTHS_LOGFILE	) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_FIXEDPITCH, (sty & AJCVTHS_FIXEDPITCH) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_FAST 	 , (sty & AJCVTHS_FAST		) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_NOCLSBTN  , (sty & AJCVTHS_NOCLSBTN	) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_FIXEDFONT , (sty & AJCVTHS_FIXEDFONT ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_FIXEDLF	 , (sty & AJCVTHS_FIXEDFONT ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_NOVSCROLL , (sty & AJCVTHS_NOVSCROLL ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_NOHSCROLL , (sty & AJCVTHS_NOHSCROLL ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_NOSCRL	 , (sty & AJCVTHS_NOSCRL	) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_NOBORDER  , (sty & AJCVTHS_NOBORDER	) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_NOSCRLOUT , (sty & AJCVTHS_NOSCRLOUT ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_CRCTRL	 , (sty & AJCVTHS_CRCTRL	) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_LFCTRL	 , (sty & AJCVTHS_LFCTRL	) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SEPARATE  , (sty & AJCVTHS_SEPARATE	) != 0);

	sty = (UI)MAjcGetWindowLong(hWndVth, GWL_EXSTYLE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_ACCEPTFILES, (sty & WS_EX_ACCEPTFILES) != 0);

	AjcSetDlgItemUInt(hDlg, IDC_TXT_LINE, 10);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_COL , 40);
	AjcSetDlgItemUInt(hDlg, IDC_INP_TXTCOLOR, 0);
	AjcSetDlgItemUInt(hDlg, IDC_INP_BKCOLOR , 7);
	AjcSetDlgItemUInt(hDlg, IDC_INP_BKWND	, 7);

	//----- 初期メッセージ表示 ------------------------------------------------------------------//
	AjcVthPrintF(hWndVth, TEXT("\x1B[35;46m"));
	AjcVthPrintF(hWndVth, TEXT("      【 ＶＴ－１００エミュレーション ウインド 】                                        \n"));
	AjcVthPrintF(hWndVth, TEXT("\x1B[0m"));
	AjcVthPrintF(hWndVth, TEXT("                                                                                         \n"));
	AjcVthPrintF(hWndVth, TEXT("\x1B[34;47m"));
	AjcVthPrintF(hWndVth, TEXT("    ・右クリックでポップアップメニューを表示します                                       \n"));
	AjcVthPrintF(hWndVth, TEXT("    ・↑↓←→キーでカーソルを移動します                                                 \n"));
	AjcVthPrintF(hWndVth, TEXT("    ・任意の文字キーを押すとその文字を描画します                                         \n"));
	AjcVthPrintF(hWndVth, TEXT("    ・テキストファイルをドロップすると、そのファイル名に続いてファイルの内容を描画します \n"));
	AjcVthPrintF(hWndVth, TEXT("    ・フォルダをドロップすると、そのフォルダ名を表示します                               \n"));
	AjcVthPrintF(hWndVth, TEXT("    ・ダブルクリックで、仮想ＶＲＡＭに合わせてウインドサイズを調整します                 \n"));
	AjcVthPrintF(hWndVth, TEXT("    ・仮想ＶＲＡＭは、２５行×１２０桁に設定されています                                 \n"));
	AjcVthPrintF(hWndVth, TEXT("                                                                                         \n"));
	AjcVthPrintF(hWndVth, TEXT("\x1B[0m\r\n"));

	//----- 設定値ロード ------------------------------------------------------------------------//
	//	ウインドスタイルをチェックボックスに反映
	SetStyleToCheckBox();
	//	設定値ロード
	AjcDlgItemSetPermAtt(hDlg, IDC_TXT_GETTEXT, AJCCTL_PSEL_EXCLUDE);					// GetTextは除外
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_CHKEXCLUDE);		// ChkBoxは除外
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CHK_PAUSE, BN_CLICKED), (LPARAM)hDlg);	// PAUSEチェックボタン
	//	チェックボックスをウインドスタイルに反映
	SetCheckBoxToStyle();

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- 設定値セーブ -----------------------------------//
	AjcSaveAllControlSettings(hDlg);

	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	UI			line, col;
	SYSTEMTIME	lt;
	static UI cnt = 1;

	//----- カーソル移動 -----------------------------------//
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_FIXEDPOS)) {
		line = AjcGetDlgItemUInt(hDlg, IDC_TXT_LINE);
		col  = AjcGetDlgItemUInt(hDlg, IDC_TXT_COL );
		AjcVthLocate(hWndVth, line, col);
	}
	//----- タイムスタンプログ表示 -------------------------//
	GetLocalTime(&lt);
	AjcVthPrintF(hWndVth, TEXT("%5u - %d/%02d/%02d  %02d:%02d:%02d.%03d"), cnt++, lt.wYear, lt.wMonth, lt.wDay,
														 lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);
	//----- 改行と行クリアー -------------------------------//
	if (!AjcGetDlgItemChk(hDlg, IDC_CHK_FIXEDPOS)) {
		AjcVthPrintF(hWndVth, TEXT("\n\x1B[K"));
	}

	return TRUE;
}
//----- COMMAND ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		)
{
	BOOL		rc = FALSE;
	int 		cmd = LOWORD(wParam);
	UI			sty;

	//----- スタイル設定チェックボックス操作 -------------------------------------------------//
	if (cmd >= IDC_CHK_LOGFILE && cmd <= IDC_CHK_ACCEPTFILES && HIWORD(wParam) == BN_CLICKED) {
		//----- ウインドスタイル -----//
		SetCheckBoxToStyle();
		//----- 拡張スタイル ---------//
		sty = (UI)MAjcGetWindowLong(hWndVth, GWL_EXSTYLE);
		sty &= ~WS_EX_ACCEPTFILES;
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_ACCEPTFILES)) sty |= WS_EX_ACCEPTFILES;
		MAjcSetWindowLong(hWndVth, GWL_EXSTYLE, sty);
		rc = TRUE;
	}

	return rc;
}
//----- 「テキスト描画」ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_PUTTEXT)
{
	UT		txt[1024];
	UT		bin[1024];

	AjcGetDlgItemStr(hDlg, IDC_TXT_PUTTEXT, txt, sizeof txt);
	AjcCLangStrToBin(txt, bin, sizeof bin);
	AjcVthPutText(hWndVth, bin , -1);

	return TRUE;
}
//----- 「タイムスタンプ ログ開始／停止」ボタン ----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LOG	 )
{
	if (fTimeStampLog) {
		fTimeStampLog = FALSE;
		KillTimer(hDlg, 1);
		AjcSetDlgItemStr(hDlg, IDC_CMD_LOG, TEXT("タイムスタンプ ログ開始"));
	}
	else {
		fTimeStampLog = TRUE;
		SetTimer(hDlg, 1, 100, NULL);
		AjcSetDlgItemStr(hDlg, IDC_CMD_LOG, TEXT("タイムスタンプ ログ停止"));
	}
	return TRUE;
}
//----- 「文字色」入力 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_TXTCOLOR)
{
	AJCVTHPROP	prop;
	HWND		hCtrl = GetDlgItem(hDlg, IDC_INP_TXTCOLOR);

	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		TxtColor = (UI)lParam;
		AjcVthGetProp(hWndVth, &prop);
		SendMessage(hCtrl, AJCIVM_SETBORDERCOLOR, prop.rgb[TxtColor], 0);
		AjcVthSetColor	(hWndVth, TxtColor);
	}

	return TRUE;
}
//----- 「背景色」入力 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_BKCOLOR)
{
	AJCVTHPROP	prop;
	HWND		hCtrl = GetDlgItem(hDlg, IDC_INP_BKCOLOR);

	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		BkColor = (UI)lParam;
		AjcVthGetProp(hWndVth, &prop);
		SendMessage(hCtrl, AJCIVM_SETBORDERCOLOR, prop.rgb[BkColor], 0);
		AjcVthSetBkColor(hWndVth, BkColor );
	}

	return TRUE;
}
//----- 「ウインド背景色」入力 ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_BKWND)
{
	AJCVTHPROP	prop;
	HWND		hCtrl = GetDlgItem(hDlg, IDC_INP_BKWND);

	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		BkWnd = (UI)lParam;
		AjcVthGetProp(hWndVth, &prop);
		SendMessage(hCtrl, AJCIVM_SETBORDERCOLOR, prop.rgb[BkWnd], 0);
		AjcVthSetWndBkColor(hWndVth, BkWnd);
	}

	return TRUE;
}
//----- 「Enable」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ENABLE	)
{
	EnableWindow(hWndVth, TRUE);
	return TRUE;
}
//----- 「Disable」ボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DISABLE	)
{
	EnableWindow(hWndVth, FALSE);
	return TRUE;
}
//----- 「Get Text」ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETTEXT	)
{
	UT		txt[1024];

	GetWindowText(hWndVth, txt, 1024);
	AjcSetDlgItemStr(hDlg, IDC_TXT_GETTEXT, txt);
	return TRUE;
}
//----- 「Set Text」ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETTEXT	)
{
	UT		txt[1024];

	AjcGetDlgItemStr(hDlg, IDC_TXT_GETTEXT, txt, 1024);
	SetWindowText(hWndVth, txt);
	return TRUE;
}
//----- 「PAUSE」チェックボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_PAUSE		)
{
	AjcVthPause(hWndVth, AjcGetDlgItemChk(hDlg, IDC_CHK_PAUSE));
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	 )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	 )
	AJC_DLGMAP_MSG(Main, WM_TIMER		 )
	AJC_DLGMAP_MSG(Main, WM_COMMAND 	 )
	AJC_DLGMAP_CMD(Main, IDC_CMD_PUTTEXT )
	AJC_DLGMAP_CMD(Main, IDC_CMD_LOG	 )
	AJC_DLGMAP_CMD(Main, IDC_INP_TXTCOLOR)
	AJC_DLGMAP_CMD(Main, IDC_INP_BKCOLOR )
	AJC_DLGMAP_CMD(Main, IDC_INP_BKWND	 )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ENABLE  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_DISABLE )
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETTEXT )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETTEXT )
	AJC_DLGMAP_CMD(Main, IDC_CHK_PAUSE	 )
	AJC_DLGMAP_CMD(Main, IDCANCEL		 )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ウインドスタイル値をチェックボックスに設定																	//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetStyleToCheckBox(VO)
{
	UI		sty, exs;

	sty = (UI)MAjcGetWindowLong(hWndVth, GWL_STYLE	);
	exs = (UI)MAjcGetWindowLong(hWndVth, GWL_EXSTYLE);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_LOGFILE 		, (sty & AJCVTHS_LOGFILE 	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_FIXEDPITCH	, (sty & AJCVTHS_FIXEDPITCH	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_FAST			, (sty & AJCVTHS_FAST		) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOCLSBTN		, (sty & AJCVTHS_NOCLSBTN	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_FIXEDFONT	, (sty & AJCVTHS_FIXEDFONT	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_FIXEDLF		, (sty & AJCVTHS_FIXEDLF	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOVSCROLL	, (sty & AJCVTHS_NOVSCROLL 	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOHSCROLL	, (sty & AJCVTHS_NOHSCROLL	) != 0);

	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOSCRL 		, (sty & AJCVTHS_NOSCRL 	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOBORDER		, (sty & AJCVTHS_NOBORDER	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOSCRLOUT	, (sty & AJCVTHS_NOSCRLOUT	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_CRLFCTRL		, (sty & AJCVTHS_CRLFCTRL	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_CRCTRL		, (sty & AJCVTHS_CRCTRL		) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_LFCTRL		, (sty & AJCVTHS_LFCTRL		) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_SEPARATE		, (sty & AJCVTHS_SEPARATE	) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_ACCEPTFILES	, (exs & WS_EX_ACCEPTFILES	) != 0);
}
//--------------------------------------------------------------------------------------------------------------//
//	チェックボックスの設定をスタイルに反映																		//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetCheckBoxToStyle(VO)
{
	UI		sty, exs;

	sty = (UI)MAjcGetWindowLong(hWndVth, GWL_STYLE);
	sty &= ~(AJCVTHS_LOGFILE   | AJCVTHS_FIXEDPITCH | AJCVTHS_FAST		| AJCVTHS_NOCLSBTN | AJCVTHS_FIXEDFONT |
			 AJCVTHS_FIXEDLF   | AJCVTHS_NOVSCROLL	| AJCVTHS_NOHSCROLL	| AJCVTHS_NOSCRL   | AJCVTHS_NOBORDER  |
			 AJCVTHS_NOSCRLOUT | AJCVTHS_CRLFCTRL	| AJCVTHS_CRCTRL 	| AJCVTHS_LFCTRL   | AJCVTHS_SEPARATE);
	exs = (UI)MAjcGetWindowLong(hWndVth, GWL_EXSTYLE);
	exs &= ~WS_EX_ACCEPTFILES;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LOGFILE 		 )) sty |= AJCVTHS_LOGFILE;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_FIXEDPITCH	 )) sty |= AJCVTHS_FIXEDPITCH;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_FAST			 )) sty |= AJCVTHS_FAST;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOCLSBTN 	 )) sty |= AJCVTHS_NOCLSBTN;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_FIXEDFONT	 )) sty |= AJCVTHS_FIXEDFONT;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_FIXEDLF		 )) sty |= AJCVTHS_FIXEDLF;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOVSCROLL	 )) sty |= AJCVTHS_NOVSCROLL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOHSCROLL	 )) sty |= AJCVTHS_NOHSCROLL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOSCRL 		 )) sty |= AJCVTHS_NOSCRL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOBORDER		 )) sty |= AJCVTHS_NOBORDER;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOSCRLOUT	 )) sty |= AJCVTHS_NOSCRLOUT;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_CRLFCTRL		 )) sty |= AJCVTHS_CRLFCTRL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_CRCTRL		 )) sty |= AJCVTHS_CRCTRL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LFCTRL		 )) sty |= AJCVTHS_LFCTRL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SEPARATE		 )) sty |= AJCVTHS_SEPARATE;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_ACCEPTFILES	 )) exs |= WS_EX_ACCEPTFILES;
	MAjcSetWindowLong(hWndVth, GWL_STYLE  , sty);
	MAjcSetWindowLong(hWndVth, GWL_EXSTYLE, exs);
}


