﻿//
//	SW_Watch.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	ID1		1
#define	ID2		2
#define	ID3		3

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HANDLE			hWat;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	UI	GetState1(HWND hDlg);
static	UI	GetState2(HWND hDlg);
static	UI	GetState3(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hWat = AjcWatCreate(hDlg, 0, TEXT("WndPos"));
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_ALL);
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	AjcWatDelete(hWat);
	AjcSaveAllControlSettings(hDlg);
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- ＩＤ１	表示 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD1_SHOW		)
{
	AjcWatShow(hWat, ID1, GetState1(hDlg), AjcGetDlgItemChk(hDlg, IDC_CHK1_PROFILE) ? TEXT("Sect1") : NULL);
	return TRUE;
}
//----- ＩＤ１	表示状態設定 -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD1_SETSTATE	)
{
	AjcWatSetShowState(hWat, ID1, GetState1(hDlg));
	return TRUE;
}
//----- ＩＤ１	非表示 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD1_HIDEBYID	)
{
	AjcWatHideByID(hWat, ID1);
	return TRUE;
}
//----- ＩＤ２	表示 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD2_SHOW		)
{
	AjcWatShow(hWat, ID2, GetState2(hDlg), AjcGetDlgItemChk(hDlg, IDC_CHK2_PROFILE) ? TEXT("Sect2") : NULL);
	return TRUE;
}
//----- ＩＤ２	表示状態設定 -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD2_SETSTATE	)
{
	AjcWatSetShowState(hWat, ID2, GetState2(hDlg));
	return TRUE;
}
//----- ＩＤ２	非表示 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD2_HIDEBYID	)
{
	AjcWatHideByID(hWat, ID2);
	return TRUE;
}
//----- ＩＤ３	表示 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD3_SHOW		)
{
	AjcWatShow(hWat, ID3, GetState3(hDlg), AjcGetDlgItemChk(hDlg, IDC_CHK3_PROFILE) ? TEXT("Sect3") : NULL);
	return TRUE;
}
//----- ＩＤ３	表示状態設定 -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD3_SETSTATE	)
{
	AjcWatSetShowState(hWat, ID3, GetState3(hDlg));
	return TRUE;
}
//----- ＩＤ３	非表示 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD3_HIDEBYID	)
{
	AjcWatHideByID(hWat, ID3);
	return TRUE;
}
//----- 非表示 -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HIDE		)
{
	AjcWatHide(hWat);
	return TRUE;
}
//----- 全て非表示 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HIDEALL	)
{
	AjcWatHideAll(hWat);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)

	AJC_DLGMAP_CMD(Main, IDC_CMD1_SHOW		)
	AJC_DLGMAP_CMD(Main, IDC_CMD1_SETSTATE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD1_HIDEBYID	)

	AJC_DLGMAP_CMD(Main, IDC_CMD2_SHOW		)
	AJC_DLGMAP_CMD(Main, IDC_CMD2_SETSTATE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD2_HIDEBYID	)

	AJC_DLGMAP_CMD(Main, IDC_CMD3_SHOW		)
	AJC_DLGMAP_CMD(Main, IDC_CMD3_SETSTATE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD3_HIDEBYID	)

	AJC_DLGMAP_CMD(Main, IDC_CMD_HIDE		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_HIDEALL	)
AJC_DLGMAP_END

//----- ＩＤ１，ステータス取得 ---------------------------------------------------------------------------------//
static	UI	GetState1(HWND hDlg)
{
	UI	rc = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK1_DISLCLK)) rc |= AJCWATSS_DISLCLK;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK1_DISRCLK)) rc |= AJCWATSS_DISRCLK;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK1_TOPMOST)) rc |= AJCWATSS_TOPMOST;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK1_TRANS  )) rc |= AJCWATSS_TRANSPARENT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK1_SECHAND)) rc |= AJCWATSS_SECHAND;

	return rc;
}

//----- ＩＤ２，ステータス取得 ---------------------------------------------------------------------------------//
static	UI	GetState2(HWND hDlg)
{
	UI	rc = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK2_DISLCLK)) rc |= AJCWATSS_DISLCLK;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK2_DISRCLK)) rc |= AJCWATSS_DISRCLK;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK2_TOPMOST)) rc |= AJCWATSS_TOPMOST;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK2_TRANS  )) rc |= AJCWATSS_TRANSPARENT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK2_SECHAND)) rc |= AJCWATSS_SECHAND;

	return rc;
}

//----- ＩＤ３，ステータス取得 ---------------------------------------------------------------------------------//
static	UI	GetState3(HWND hDlg)
{
	UI	rc = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK3_DISLCLK)) rc |= AJCWATSS_DISLCLK;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK3_DISRCLK)) rc |= AJCWATSS_DISRCLK;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK3_TOPMOST)) rc |= AJCWATSS_TOPMOST;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK3_TRANS  )) rc |= AJCWATSS_TRANSPARENT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK3_SECHAND)) rc |= AJCWATSS_SECHAND;

	return rc;
}

