﻿//
//	SZOld_Cip1.c
//

#pragma warning(disable:4996)
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hWndCip;						//	ＣＩＰウインドハンドル
static	HICON			hIcoOpen;
static	BC				InpPath[MAX_PATH];				//	マクロファイルパス
static	BOOL			ixLast; 						//	コンボボックス直前の選択項目
static	int				DlgWidth;						//	メインダイアログサイズ
static	int				DlgHeight;						//	・
static	int				yCip;							//	ＣＩＰコントロールのＹ位置

static	BOOL			fRun  = FALSE;					//	マクロ実行中を示すフラグ
static	BOOL			fExit = FALSE;					//	プログラム終了を示すフラグ

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	SubSetDefaultFile(HWND hDlg, C_BCP pFileName);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- プロファイル先をレジストリとする -----------//
	AjcSetProfileIsRegistory(TRUE);
	AjcSetRegOptionVolatile (FALSE);
	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);
	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	int		ix;
	RECT	r;

	hDlgMain = hDlg;
	hWndCip  = GetDlgItem(hDlg, IDC_CIP);

	//	最小ウインドサイズ設定
	GetWindowRect(hDlg, &r);
	DlgWidth  = r.right - r.left;
	DlgHeight = r.bottom - r.top;

	//	ＣＩＰコントロールのＹ位置設定
	GetWindowRect(hWndCip, &r);
	ScreenToClient(hDlg, (LPPOINT)&r);
	yCip = r.top;

	//	ＣＩＰコントロール配置
	GetClientRect(hDlg, &r);
	SetWindowPos(hWndCip, NULL, 0, yCip, r.right - r.left, (r.bottom - r.top) - yCip, SWP_NOZORDER);

	//	アイコン生成
	hIcoOpen  = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_OPEN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	//	ボタンへアイコン表示
	SendDlgItemMessage(hDlg, IDC_CMD_OPEN, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoOpen);

	//	コンボボックス初期化
	AjcSbcComboBox	   (GetDlgItem(hDlg, IDC_CBO_FILE), 100, MAX_PATH);
	AjcSbcLoadItems	   (GetDlgItem(hDlg, IDC_CBO_FILE), "S_SbcComboBox");
	AjcSbcSetCompExact (GetDlgItem(hDlg, IDC_CBO_FILE), FALSE); // 大小区別しないで比較
	AjcSbcShowFirstLine(GetDlgItem(hDlg, IDC_CBO_FILE), "/*\t\r\n");
	AjcSbcTipCtrl	   (GetDlgItem(hDlg, IDC_CBO_FILE),TRUE);
	//	チップテキストコントロール生成
	AjcTipTextCreate();

	//	デフォルトのマクロファイル名設定
	if (AjcGetDlgItemCboCount(hDlg, IDC_CBO_FILE) == 0) {
		SubSetDefaultFile(hDlg, "M010.txt");	SubSetDefaultFile(hDlg, "M075.txt");
		SubSetDefaultFile(hDlg, "M020.txt");	SubSetDefaultFile(hDlg, "M076.txt");
		SubSetDefaultFile(hDlg, "M021.txt");	SubSetDefaultFile(hDlg, "M077.txt");
		SubSetDefaultFile(hDlg, "M030.txt");	SubSetDefaultFile(hDlg, "M078.txt");
		SubSetDefaultFile(hDlg, "M040.txt");	SubSetDefaultFile(hDlg, "M079.txt");
		SubSetDefaultFile(hDlg, "M050.txt");	SubSetDefaultFile(hDlg, "M080.txt");
		SubSetDefaultFile(hDlg, "M051.txt");	SubSetDefaultFile(hDlg, "M090.txt");
		SubSetDefaultFile(hDlg, "M052.txt");	SubSetDefaultFile(hDlg, "M100.txt");
		SubSetDefaultFile(hDlg, "M060.txt");	SubSetDefaultFile(hDlg, "M101.txt");
		SubSetDefaultFile(hDlg, "M061.txt");	SubSetDefaultFile(hDlg, "M110.txt");
		SubSetDefaultFile(hDlg, "M062.txt");	SubSetDefaultFile(hDlg, "M120.txt");
		SubSetDefaultFile(hDlg, "M063.txt");	SubSetDefaultFile(hDlg, "M130.txt");
		SubSetDefaultFile(hDlg, "M064.txt");	SubSetDefaultFile(hDlg, "M140.txt");
		SubSetDefaultFile(hDlg, "M070.txt");	SubSetDefaultFile(hDlg, "M150.txt");
		SubSetDefaultFile(hDlg, "M071.txt");	SubSetDefaultFile(hDlg, "M160.txt");
		SubSetDefaultFile(hDlg, "M072.txt");
		SubSetDefaultFile(hDlg, "M073.txt");
		SubSetDefaultFile(hDlg, "M074.txt");
	}
	//	コンボボックスからマクロファイル名取得
	ix = AjcGetDlgItemCboIx(hDlg, IDC_CBO_FILE);
	AjcGetDlgItemCboItem(hDlg, IDC_CBO_FILE, ix, InpPath, MAX_PATH);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	コンボボックス設定内容退避
	AjcSbcSaveItems(GetDlgItem(hDlg, IDC_CBO_FILE), "S_SbcComboBox");
	//	アイコン破棄
	DeleteObject(hIcoOpen);
	//	チップテキストコントロール破棄
	AjcTipTextDelete();
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- サイズ変更中 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZING			)
{
	LPRECT	p = (LPRECT)lParam;
	int		w = p->right - p->left;
	int		h = p->bottom - p->top;

	if (w < DlgWidth ) p->right  = p->left + DlgWidth;
	if (h < DlgHeight) p->bottom = p->top  + DlgHeight;

	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE			)
{
	int		w  = LOWORD(lParam);
	int		h  = HIWORD(lParam);

	SetWindowPos(hWndCip, NULL, 0, yCip, w, h - yCip, SWP_NOZORDER);
	return TRUE;
}
//----- ファイル選択ボタン(...) --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FILE	   )
{
	static BC	   path[MAX_PATH] = {0};

	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetOpenFile(hDlgMain,				//	オーナーウインドハンドル
						   "Get open file", 	  	//	ウインドタイトル
						   "txt/*.txt/all/*.*",   	//	フィルタ
						   "txt",				  	//	デフォルト拡張子
						   path,					//	パス名格納バッファ
						   MAX_PATH)) { 			//	バッファの文字数
			SendDlgItemMessage(hDlg, IDC_CBO_FILE, CB_INSERTSTRING, 0, (LPARAM)path);
			strcpy(InpPath, path);
		}
	}
	return TRUE;
}
//----- ファイルを開くボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN		)
{
	int		ix = AjcGetDlgItemCboIx(hDlg, IDC_CBO_FILE);
	UT		path[MAX_PATH];
	if (ix >= 0) {
		AjcGetDlgItemCboItem(hDlg, IDC_CBO_FILE, ix, path, MAX_PATH);
		ShellExecute(NULL, TEXT("open"), path, NULL, NULL, SW_SHOWNORMAL);
	}
	return TRUE;
}
//----- トレース表示ウインド ボタン ----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TRC		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcCipCreateTraceWindow(hWndCip);
	}
	return TRUE;
}
//----- ステップトレース・ウインド ボタン ----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STEP		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcCipCreateStepWindow(hWndCip);
	}
	return TRUE;
}
//----- 実行ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RUN		)
{
	C_BCP	pTxt;

	if (HIWORD(wParam) == BN_CLICKED) {
		int ix = AjcGetDlgItemCboIx(hDlg, IDC_CBO_FILE);
		if (ix >= 0) {
			AjcGetDlgItemCboItem(hDlg, IDC_CBO_FILE, ix, InpPath, sizeof InpPath);
			if (AjcCipLoad(hWndCip, InpPath)) {
				PAJCCIPCALL	pCall;
				//	関数呼び出し情報設定
				if (pCall = AjcCipCallInfoInit(hWndCip, "main")) {				//	呼び出し情報生成
					EnableWindow(GetDlgItem(hDlg, IDC_CMD_RUN  ), FALSE);
					EnableWindow(GetDlgItem(hDlg, IDC_CMD_STOP ), TRUE);
					EnableWindow(GetDlgItem(hDlg, IDC_CHK_EVENT), TRUE);
					//	実行
					fRun = TRUE;
					if (AjcCipExec(hWndCip, pCall)) {
						AjcCipPrintF(hWndCip, "\n");
						//	_Exit()によるテキスト表示
						if (pTxt = AjcCipGetExitText(hWndCip)) {
							AjcCipPrintF(hWndCip, "_Exit() により設定されたテキスト＝'%s'\n", pTxt);
						}
						AjcCipPrintF(hWndCip, "マクロの実行を終了しました。\n");
					}
					else {
						AjcCipPrintF(hWndCip, "マクロの実行中にエラーが発生しました。\n");
					}
					AjcCipCallInfoDelete(hWndCip, pCall);
					fRun = FALSE;
					EnableWindow(GetDlgItem(hDlg, IDC_CMD_RUN  ), TRUE);
					EnableWindow(GetDlgItem(hDlg, IDC_CMD_STOP ), FALSE);
					EnableWindow(GetDlgItem(hDlg, IDC_CHK_EVENT), FALSE);
					//	プログラム終了判断
					if (fExit) {
						DestroyWindow(hDlg);
					}
				}
				else {
					AjcCipPrintF(hWndCip, "マクロテキストに main() 関数がありません。\n");
				}
			}
			else {
				AjcCipPrintF(hWndCip, "マクロの読み出しを失敗しました。\n");
			}
		}
	}
	return TRUE;
}
//----- 中止ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcCipStop(hWndCip);
	}
	return TRUE;
}
//----- マクロへのイベント通知（イベント・チェックボックス）----------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_EVENT		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		PAJCCIPCALL	pCall;
		//	関数呼び出し情報設定
		if (pCall = AjcCipCallInfoInit(hWndCip, "OnUserEvent")) {
			//	第１引数(チェック状態)
			AjcCipCallInfoInsInteger(hWndCip, pCall, AjcGetDlgItemChk(hDlg, IDC_CHK_EVENT));
			//	イベント実行
			AjcCipEvent(hWndCip, pCall);
		}
	}
	return TRUE;
}
//----- マクロインタプリタからの通知 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CIP			)
{
	switch (HIWORD(wParam)) {
		case AJCCIPN_FUN:					//	●外部関数呼び出し通知
		{
			PAJCCIPEVPFUN	pCbp = (PAJCCIPEVPFUN)lParam;
			AjcCipNtcErrByUser(hWndCip, pCbp->pCall, AJCLNGSEL("関数 <%s> は未定義です", "Undefined function <%s>."),
																							 pCbp->pCall->pFunName);
			break;
		}
		case AJCCIPN_EXE:					//	●ステップ実行通知
		{
			break;
		}
		case AJCCIPN_ERR:					//	●エラー発生通知
		{
			PAJCCIPEVPERR	pCbp = (PAJCCIPEVPERR)lParam;
			AjcCipPrintF(hWndCip, "err = %d, lno=%d\n   %s\n", pCbp->err, pCbp->lno, pCbp->pMsg);
			break;
		}
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	if (fRun) {
		AjcCipStop(hWndCip);
		fExit = TRUE;
	}
	else {
		DestroyWindow(hDlg);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_SIZING 		   )
	AJC_DLGMAP_MSG(Main, WM_SIZE 		   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_FILE	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_TRC	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STEP	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_RUN	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	   )
	AJC_DLGMAP_CMD(Main, IDC_CHK_EVENT	   )
	AJC_DLGMAP_CMD(Main, IDC_CIP		   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスにデフォルトマクロファイル設定																//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubSetDefaultFile(HWND hDlg, C_BCP pFileName)
{
	BC		path[MAX_PATH];
	BCP		pFile;

	AjcGetAppPath(path, MAX_PATH);
	strcat(path, "..\\MacTxt\\");
	strcat(path, pFileName);
	GetFullPathName(path, sizeof InpPath, InpPath, &pFile);
	AjcSetDlgItemCboAdd(hDlg, IDC_CBO_FILE, -1, InpPath, AJCCBF_ALL);
}
