﻿//
//	SZOld_DlgItem1.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;
HWND			hDlgMain;

//	ダイアログ項目と関連付ける変数
UI				vUInt, vHex, vChkSel;
SI				vSInt;
double			vReal;
ULL 			vUI64, vH64;
SLL 			vSI64;
UT				vText[512];
UI				vCboIx;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	ShowVariables(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG		)
{
	hDlgMain = hDlg;

	//	チップテキスト設定
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SETVAL ), TEXT("ダイアログ項目を変数に設定"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SETITEM), TEXT("変数値をダイアログ項目に設定"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_ADDCBO ), TEXT("コンボボックスへ項目追加"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_CBOITEM), TEXT("コンボボックスへ追加するテキスト"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDOK 		  ), TEXT("ダイアログ項目をプロファイルに記録して終了"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDCANCEL 	  ), TEXT("ダイアログ項目をプロファイルに記録しないで終了"));
	//	ダイアログ項目と変数を関連付ける
	MAjcSetDlgPropUInt(hDlg, IDC_TXT_UINT ,   3456				, TRUE	  , &vUInt	  );
	MAjcSetDlgPropSInt(hDlg, IDC_TXT_SINT ,  -3456				, TRUE	  , &vSInt	  );
	MAjcSetDlgPropHex (hDlg, IDC_TXT_HEX  , 0x3456				, 8 	  , &vHex	  );
	MAjcSetDlgPropReal(hDlg, IDC_TXT_REAL ,  3.456				, TRUE , 3, &vReal	  );
	MAjcSetDlgPropUI64(hDlg, IDC_TXT_UI64 ,  123456789123456789 , TRUE	  , &vUI64	  );
	MAjcSetDlgPropSI64(hDlg, IDC_TXT_SI64 , -123456789123456789 , TRUE	  , &vSI64	  );
	MAjcSetDlgPropH64 (hDlg, IDC_TXT_H64  , 0x0123456789ABCDEF	, 16	  , &vH64	  );
	MAjcSetDlgPropChk (hDlg, IDC_CHK_SEL  , TRUE						  , &vChkSel  );
	MAjcSetDlgPropStr (hDlg, IDC_TXT_TEXT , _T("DefaultString") 		  , vText, 512);
	MAjcSetDlgPropCbo (hDlg, IDC_CBO	  , _T("AAA\0")_T("BBB\0")_T("CCC\0"), 1, &vCboIx);
	//	プロファイルから読み出した値をダイアログ項目群へ設定
	AjcLoadDlgProfiles(hDlg, TEXT("MySect"));
	//	ダイアログ項目群の内容を変数へ設定
	AjcGetDlgValues(hDlg);
	//	変数値表示
	ShowVariables(hDlg);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ダイアログ項目関連付けリソース解放
	AjcReleaseDlgProps(hDlg);

	PostQuitMessage(0);
	return TRUE;
}
//----- コンボボックス項目を変数へ設定（「→」ボタン） ---------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETVAL	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgValues(hDlg);
		ShowVariables(hDlg);
	}
	return TRUE;
}
//----- 変数値をコンボボックス項目へ設定（「←」ボタン）  ------------------------------------------------------//
#define	SETINT(ID, VAR, FUN)	AjcSetDlgItem##FUN(hDlg, ID, VAR = AjcGetDlgItem##FUN(hDlg, ID))
#define	SETREL(ID, VAR, FUN)	AjcSetDlgItem##FUN(hDlg, ID, VAR = AjcGetDlgItem##FUN(hDlg, ID), 3)

AJC_DLGPROC(Main, IDC_CMD_SETITEM	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		//	変数値設定
		SETINT(IDC_TXT_VUINT  , vUInt  , UInt);
		SETINT(IDC_TXT_VSINT  , vSInt  , SInt);
		SETINT(IDC_TXT_VHEX   , vHex   , Hex );
		SETREL(IDC_TXT_VREAL  , vReal  , Real);
		SETINT(IDC_TXT_VUI64  , vUI64  , UI64);
		SETINT(IDC_TXT_VSI64  , vSI64  , SI64);
		SETINT(IDC_TXT_VH64   , vH64   , H64 );
		SETINT(IDC_TXT_VCHKSEL, vChkSel, UInt);
		AjcGetDlgItemStr(hDlg, IDC_TXT_VTEXT, vText, AJCTSIZE(vText));
		SETINT(IDC_TXT_VCBOIX, vCboIx, UInt);
		//	変数をコンボボックス項目へ設定
		AjcSetDlgValues(hDlg);
	}
	return TRUE;
}
//----- コンボボックスへ項目追加（「↑」ボタン）----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ADDCBO	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT		txt[256];
		AjcGetDlgItemStr(hDlg, IDC_TXT_CBOITEM, txt, AJCTSIZE(txt));
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO, 0, txt, AJCCBF_SORT);
	}
	return TRUE;
}
//----- ＯＫ ---------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK				)
{
	//	ダイアログ項目群の値をプロファイルへ記録する
	AjcSaveDlgProfiles(hDlg, TEXT("MySect"));

	DestroyWindow(hDlg);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)

	AJC_DLGMAP_CMD(Main, IDC_CMD_SETVAL	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETITEM)
	AJC_DLGMAP_CMD(Main, IDC_CMD_ADDCBO	)
	AJC_DLGMAP_CMD(Main, IDOK			)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	変数の値表示																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowVariables(HWND hDlg)
{
	AjcSetDlgItemUInt(hDlg, IDC_TXT_VUINT  , vUInt);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_VSINT  , vSInt);
	AjcSetDlgItemHex (hDlg, IDC_TXT_VHEX   , vHex );
	AjcSetDlgItemReal(hDlg, IDC_TXT_VREAL  , vReal, 3);
	AjcSetDlgItemUI64(hDlg, IDC_TXT_VUI64  , vUI64);
	AjcSetDlgItemSI64(hDlg, IDC_TXT_VSI64  , vSI64);
	AjcSetDlgItemH64 (hDlg, IDC_TXT_VH64   , vH64);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_VCHKSEL, vChkSel);
	AjcSetDlgItemStr (hDlg, IDC_TXT_VTEXT  , vText);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_VCBOIX , vCboIx);
}
