﻿
// S_MFC_01Dlg.cpp : 実装ファイル
//

#include "stdafx.h"
#include "S_MFC_01.h"
#include "S_MFC_01Dlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CS_MFC_01Dlg ダイアログ

CS_MFC_01Dlg::CS_MFC_01Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CS_MFC_01Dlg::IDD, pParent)
{

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CS_MFC_01Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CS_MFC_01Dlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CMD_OPEN , &CS_MFC_01Dlg::OnBnClickedCmdOpen )
	ON_BN_CLICKED(IDC_CMD_CLOSE, &CS_MFC_01Dlg::OnBnClickedCmdClose)
	ON_BN_CLICKED(IDC_CMD_PORT , &CS_MFC_01Dlg::OnBnClickedCmdPort )
END_MESSAGE_MAP()

// CS_MFC_01Dlg メッセージ ハンドラー

BOOL CS_MFC_01Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// このダイアログのアイコンを設定します。アプリケーションのメイン ウィンドウがダイアログでない場合、
	//	Framework は、この設定を自動的に行います。
	SetIcon(m_hIcon, TRUE);			// 大きいアイコンの設定
	SetIcon(m_hIcon, FALSE);		// 小さいアイコンの設定

	// TODO: 初期化をここに追加します。
	m_VthScp.SetUp(std::bind(&CS_MFC_01Dlg::EnableOpenButton , this, std::placeholders::_1), 
				   std::bind(&CS_MFC_01Dlg::EnableCloseButton, this, std::placeholders::_1));
	m_VthScp.Attach(GetDlgItem(IDC_VTH)->m_hWnd);
	m_VthScp.Init	(TEXT("MyScpParam"), AJCSCP_CM_TEXT);
	m_VthScp.SetTxTextCode(AJCSCP_TXT_UTF8);
	m_VthScp.SetRxTextCode(AJCSCP_TXT_AUTO);
	m_VthScp.SetEvtMask(AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXCHUNK);

	m_VthScp.PrintF(TEXT("・シリアル回線からの受信データ(S-JIS / UTF-8 / EUC-J)をテキスト表示します。\n"));
	m_VthScp.PrintF(TEXT("・ここにファイルをドロップすると、ファイルの内容を UTF-8 テキストとして送信します。\n"));
	m_VthScp.PrintF(TEXT("・ここにフォルダをドロップすると、ドロップしたフォルダのパス名を表示します。\n"));
	m_VthScp.PrintF(TEXT("\n"));

	m_VthScp.SetTitleText(TEXT(" Closed "));

	return TRUE;  // フォーカスをコントロールに設定した場合を除き、TRUE を返します。
}

// ダイアログに最小化ボタンを追加する場合、アイコンを描画するための
//	下のコードが必要です。ドキュメント/ビュー モデルを使う MFC アプリケーションの場合、
//	これは、Framework によって自動的に設定されます。

void CS_MFC_01Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 描画のデバイス コンテキスト

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// クライアントの四角形領域内の中央
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// アイコンの描画
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ユーザーが最小化したウィンドウをドラッグしているときに表示するカーソルを取得するために、
//	システムがこの関数を呼び出します。
HCURSOR CS_MFC_01Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

//	●	回線オープンボタン
void CS_MFC_01Dlg::OnBnClickedCmdOpen()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	if (!m_VthScp.IsOpened()) {
		m_VthScp.Open();
	}
}

//	●	回線クローズボタン
void CS_MFC_01Dlg::OnBnClickedCmdClose()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	if (m_VthScp.IsOpened()) {
		m_VthScp.Close();
	}
}

//	●	ポート設定ボタン
void CS_MFC_01Dlg::OnBnClickedCmdPort()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	m_VthScp.DlgParamEasy(m_hWnd);
}

//	●	アプリ終了ボタン
void CS_MFC_01Dlg::OnCancel()
{
	// TODO: ここに特定なコードを追加するか、もしくは基本クラスを呼び出してください。
	CDialogEx::OnCancel();
}

//	●	オープンボタン許可／禁止
void CS_MFC_01Dlg::EnableOpenButton(bool fEnable)
{
	AjcEnableDlgItem(m_hWnd, IDC_CMD_OPEN , fEnable);
}

//	●	クローズボタン許可／禁止
void CS_MFC_01Dlg::EnableCloseButton(bool fEnable)
{
	AjcEnableDlgItem(m_hWnd, IDC_CMD_CLOSE, fEnable);
}
