﻿#include "StdAfx.h"
#include "VthScp.h"


CVthScp::CVthScp(void)
{
}


CVthScp::~CVthScp(void)
{
}

	VO	CVthScp::SetUp(std::function<void(bool)> EnableOpenButton,
			  std::function<void(bool)> EnableCloseButton)
{
	m_EnableOpenButton  = EnableOpenButton;
	m_EnableCloseButton = EnableCloseButton;
}


// ●ディレクトリドロップ
VO	CVthScp::OnNtcDropDir (UI nFiles)
{
	// ドロップされたディレクトリ表示
	UT path[MAX_PATH] = {0};
	while (GetDroppedDir(path)) {
		PrintF(TEXT("Directory dropped : %s\n"), path);
	}
}
// ●ファイルドロップ
VO	CVthScp::OnNtcDropFile(UI nFiles)
{
	CAjxFile f;
	UT	path[MAX_PATH];
	UT	buf[1024];
	while (GetDroppedFile(path)) {
		PrintF(TEXT("\x1B[34m【 %s 】\x1B[0m\n"), path);
		if (f.FOpen(path)) {
			PrintF(TEXT("Send File : %s\n"), path);
			while (f.FGetS(buf, AJCTSIZE(buf))) {
				SendText(buf, MAjcStrLen(buf));
			}
			f.FClose();
		}
	}
}
//	●ポート状態通知
VO	CVthScp::OnNtcPortState(C_UTP pPortName, UI Param)
{
	switch (Param) {
		case AJCSCP_CLOSED:		SetTitleText(TEXT(" Closed "));	m_EnableOpenButton(true ); m_EnableCloseButton(false); break;
		case AJCSCP_OPENED:		SetTitleText(TEXT(" Opened "));	m_EnableOpenButton(false); m_EnableCloseButton(true ); break;
		case AJCSCP_OPENFAIL:	SetTitleText(TEXT(" Closed "));
		  PrintF(TEXT("\x1b[31mポートのオープンを失敗しました\x1b[0m\n"));	break;
	}
}
//	●	テキストチャンク受信通知
VO	CVthScp::OnNtcRxTextChunk(C_UTP pText)
{
	PutText(pText);
}

