﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_3DGraphic1
{
	public partial class Form1 : Form
	{
		//	規定球の中心と半径
		const double CX =	0.2;
		const double CY	=	0.4;
		const double CZ	=	0.1;
		const double R	=	2.0;

		//	描画色ＩＤ
		const int		ID_PLOT1	=	0;		//	プロット点１
		const int		ID_PLOT2	=	1;		//	プロット点２
		const int		ID_BALL		=	6;		//	算出した球
		const int		ID_INS1		=	4;		//	球の内接円１
		const int		ID_INS2		=	12;		//	球の内接円２

		const int		ID_TRACK1	=	8;		//	軌道円１
		const int		ID_TRACK2	=	9;		//	軌道円２

		const int		ID_2DGRID	=	6;		//	２Ｄ方眼
		const int		ID_2DSHAPE	=	7;		//	２Ｄ図形
		const int		ID_3DSHAPE	=	5;		//	２Ｄ図形
		const int		ID_TXTPOINT	=	1;		//	テキスト描画ポイント

		//	プロットデータ収集バッファ情報
		const int		MAX_PLOT	=	4;
		struct PLOTINFO {
			public int			id1, id2, id3;	//	描画色ＩＤ
			public double		dist;			//	プロット間の最低距離
			public int			num;			//	プロット収集個数
			public int			cnt;			//	プロットデータカウンタ
			public AJC3DVEC[]	plt;			//	プロット点収集バッファ
			public AJC3DVEC 	cent;			//	中心
			public double		radius;			//	半径
			public AJC3DVEC		vec;			//	法線
		}
		PLOTINFO	PltBall;					//	球算出用プロットバッファ
		PLOTINFO[]	PltCir;						//	軌道円算出用プロットバッファ

		//	ワーク
		AJCSPD_PARAM[]	 m_prm; 				//	プロット点演算パラメタ
		CAjrSphereData[] m_spd; 				//	プロット点演算オブジェクト
		Size			 m_MinSize; 			//	ウインド最小サイズ
		bool			 m_fPlot = false;		//	プロット中フラグ
		string			 m_TipText; 			//	チップテキスト
		
		private TipCbkNeedText m_cbNeedText;	//	チップテキスト取得コールバック

		public Form1()
		{
			InitializeComponent();
		}
		//----- フォームロード ---------------------------------------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			//----- スタイルチェックボックスのツールチップ設定 -----------//
			SAjrTip.Add(chkEnableDepthControl , "遠近表現（原点の手前側と向う側の色分け）許可"); 
			SAjrTip.Add(chkShowFilter		  , "フィルタチェックボックス許可"); 
			SAjrTip.Add(chkShowBorder		  , "外枠表示"); 
			SAjrTip.Add(chkEnableAngle		  , "ドラッグによる回転許可"); 
			SAjrTip.Add(chkShowAxisX		  , "Ｘ軸表示"); 
			SAjrTip.Add(chkShowAxisX		  , "Ｙ軸表示"); 
			SAjrTip.Add(chkShowAxisX		  , "Ｚ軸表示"); 
			SAjrTip.Add(chkShowRectScale	  , "方眼スケール表示（表示面はShowScale XY/XZ/YZで指定）"); 
			SAjrTip.Add(chkShowEllipseScale   , "同心円スケール表示（表示面はShowScale XY/XZ/YZで指定）"); 
			SAjrTip.Add(chkShowSphereScale	  , "球体スケール表示"); 
			SAjrTip.Add(chkShowScaleXY		  , "ＸＹ平面にスケール表示（スケールはShowRectScale, ShowEllipseScaleで指定）"); 
			SAjrTip.Add(chkShowScaleXZ		  , "ＸＺ平面にスケール表示（スケールはShowRectScale, ShowEllipseScaleで指定）"); 
			SAjrTip.Add(chkShowScaleYZ		  , "ＹＺ平面にスケール表示（スケールはShowRectScale, ShowEllipseScaleで指定）"); 
			SAjrTip.Add(chkShowScaleValueX	  , "Ｘ軸の値表示"); 
			SAjrTip.Add(chkShowScaleValueY	  , "Ｙ軸の値表示"); 
			SAjrTip.Add(chkShowScaleValueZ	  , "Ｚ軸の値表示");
			//----- ボタンチップテキスト設定 -----------------------------//
			SAjrTip.Add(btnTest1, "３Ｄ図形描画／消去");
			SAjrTip.Add(btnTest2, "２Ｄ図形描画／消去");
			SAjrTip.Add(btnTest3, "テキスト描画／消去");
			//----- チップテキスト表示設定（状況依存で球情報表示）--------//
			m_cbNeedText = new TipCbkNeedText(cbNeedText);
			SAjrTip.Add		   (g3d, "", 1000, 3000);
			SAjrTip.SetCallBack(g3d, (IntPtr)0, m_cbNeedText);
			//----- ウインド最小サイズ設定 -------------------------------//
			m_MinSize = this.Size;
			//----- プロット点演算パラメタ 初期化 ------------------------//
			m_prm = new AJCSPD_PARAM[2];
			m_prm[0] = new AJCSPD_PARAM() {cent_x = CX, cent_y = CY, cent_z = CZ, radius = R, noise = 3.0, xrot = 0.5, yrot = 0.8, pitch = 9.0};
			m_prm[1] = new AJCSPD_PARAM() {cent_x = CX, cent_y = CY, cent_z = CZ, radius = R, noise = 3.0, xrot = 0.6, yrot = 0.7, pitch = 8.5};
			//----- プロット点演算オブジェクト ---------------------------//
			m_spd	 = new CAjrSphereData[2];
			m_spd[0] = spd1;
			m_spd[1] = spd2;
			//----- 球算出用プロットバッファ初期化 -----------------------//
			PltBall 	  = new PLOTINFO()	{id1 = ID_INS1	, id2 = ID_INS2,	id3 = ID_BALL,	dist = R * 0.6,	 num = 4 };
			PltBall.plt   = new AJC3DVEC[MAX_PLOT]; 
			PltCir		  = new PLOTINFO[2];
			PltCir[0]	  = new PLOTINFO()	{id1 = ID_TRACK1,									dist = R * 0.4,	 num = 3 };
			PltCir[1]	  = new PLOTINFO()	{id1 = ID_TRACK2,									dist = R * 0.4,	 num = 3 };
			PltCir[0].plt = new AJC3DVEC[MAX_PLOT];
			PltCir[1].plt = new AJC3DVEC[MAX_PLOT];
			//----- 演算球表示色設定 -------------------------------------//
			g3d.SetItemColorP(ID_BALL, Color.FromArgb(0xA0E0E0));
			g3d.SetItemColorN(ID_BALL, Color.FromArgb(0xD0F0F0));
			//----- 設定値ロード -----------------------------------------//
			SAjrReg.LoadAllCtrls(this);
			//----- グラフレンジ設定 -------------------------------------//
			g3d.CenterX = CX; g3d.CenterY = CY; g3d.CenterZ = CZ;
			g3d.RadiusX = g3d.RadiusY = g3d.RadiusZ = R;
		}
		//----- フォームクローズ -------------------------------------------------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//----- フォームサイズ変更 -----------------------------------------------------------------------------//
		private void Form1_Resize(object sender, EventArgs e)
		{
			if (this.Width	< m_MinSize.Width ) this.Width	= m_MinSize.Width;
			if (this.Height < m_MinSize.Height) this.Height = m_MinSize.Height;
		}
		//----- コントロールからのイベント ---------------------------------------------------------------------//
		//	スタイル・チェックボックス群
		private void chkEnableDepthControl_CheckedChanged(object sender, EventArgs e) {g3d.EnableDepthControl = chkEnableDepthControl.Checked;}
		private void chkShowFilter_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowFilter		 = chkShowFilter		.Checked;}
		private void chkShowBorder_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowBorder		 = chkShowBorder		.Checked;}
		private void chkEnableAngle_CheckedChanged		 (object sender, EventArgs e) {g3d.EnableAngle		 = chkEnableAngle		.Checked;}
		private void chkShowAxisX_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowAxisX 		 = chkShowAxisX 		.Checked;}
		private void chkShowAxisY_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowAxisY 		 = chkShowAxisY 		.Checked;}
		private void chkShowAxisZ_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowAxisZ 		 = chkShowAxisZ 		.Checked;}
		private void chkShowRectScale_CheckedChanged	 (object sender, EventArgs e) {g3d.ShowRectScale 	 = chkShowRectScale 	.Checked;}
		private void chkShowEllipseScale_CheckedChanged	 (object sender, EventArgs e) {g3d.ShowEllipseScale	 = chkShowEllipseScale	.Checked;}
		private void chkShowSphereScale_CheckedChanged	 (object sender, EventArgs e) {g3d.ShowSphereScale	 = chkShowSphereScale	.Checked;}
		private void chkShowScaleXY_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowScaleXY		 = chkShowScaleXY		.Checked;}
		private void chkShowScaleXZ_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowScaleXZ		 = chkShowScaleXZ		.Checked;}
		private void chkShowScaleYZ_CheckedChanged		 (object sender, EventArgs e) {g3d.ShowScaleYZ		 = chkShowScaleYZ		.Checked;}
		private void chkShowScaleValueX_CheckedChanged	 (object sender, EventArgs e) {g3d.ShowScaleValueX	 = chkShowScaleValueX	.Checked;}
		private void chkShowScaleValueY_CheckedChanged	 (object sender, EventArgs e) {g3d.ShowScaleValueY	 = chkShowScaleValueY	.Checked;}
		private void chkShowScaleValueZ_CheckedChanged	 (object sender, EventArgs e) {g3d.ShowScaleValueZ	 = chkShowScaleValueZ	.Checked;}
		//	プロット線描画チェックボックス
		private void chkPlotLine_CheckedChanged			 (object sender, EventArgs e) {g3d.PlotLine			 = chkPlotLine			.Checked;}
		//	球算出情報描画チェックボックス
		private void chkBallInfo_CheckedChanged			 (object sender, EventArgs e) {}
		//	軌道円算出情報描画チェックボックス
		private void chkCirInfo_CheckedChanged			 (object sender, EventArgs e) {}
		//	プロット数０
		private void inpPlotNum0_OnNtcIntValue(object sender, IvArgNtcIntValue e) {g3d.SetMaxPlot(0, e.value);}
		//	プロット数１
		private void inpPlotNum1_OnNtcIntValue(object sender, IvArgNtcIntValue e) {g3d.SetMaxPlot(1, e.value);}
		//	サンプリング周期
		private void inpPeriod_OnNtcIntValue  (object sender, IvArgNtcIntValue e) {tim.Interval = e.value;}
		//	ノイズ
		private void inpNoise_OnNtcRealValue  (object sender, IvArgNtcRealValue e){m_prm[0].noise = e.value; m_spd[0].SetParam(m_prm[0]);
																				   m_prm[1].noise = e.value; m_spd[1].SetParam(m_prm[1]);}
		//	クリアーボタン
		private void btnClear_Click(object sender, EventArgs e)   {
			g3d.Purge();
			m_fTest1 = m_fTest2 = m_fTest3 = false;
		}
		//	Enableボタン
		private void btnEnable_Click(object sender, EventArgs e)  {g3d.Enabled = true; }
		//	Disableボタン
		private void btnDisable_Click(object sender, EventArgs e) {g3d.Enabled = false;}
		//	テスト１ボタン
		bool m_fTest1 = false;
		private void btnTest1_Click(object sender, EventArgs e)
		{
			if (!m_fTest1) {
				g3d.Cube	(ID_3DSHAPE, +0.1, +0.2, +0.3, 0.2, 0.3, 0.4, 8);
				g3d.Sphere	(ID_3DSHAPE, +0.7, +0.6, +0.8, 0.2, 0.3, 0.4, 12, 8);
				g3d.MoveTo	(ID_3DSHAPE, -0.6, 0.2, 0.3);
				g3d.LineTo	(ID_3DSHAPE, -0.3, -0.2, -0.1);
				g3d.Triangle(ID_3DSHAPE, -0.8, -0.7, -0.6, -0.4, -0.3, -0.5, -0.4, -0.5, -0.3);
				g3d.Square	(ID_3DSHAPE, 0.0, -0.1, 0.6, -0.2, -0.5, 0.6, -0.7, -0.5, 0.3, -0.6, -0.3, 0.1);
				m_fTest1 = true;
			}
			else {
				g3d.PurgeData(ID_3DSHAPE);
				m_fTest1 = false;
			}
		}
		//	テスト２ボタン
		bool m_fTest2 = false;
		private void btnTest2_Click(object sender, EventArgs e)
		{
			double	x, y;

			if (!m_fTest2) {
				for (int i = 0; i < 16; i++)
				{
					g3d.DefPlane(i, 0.2, 0.1, 0.0, 0.6738, -0.5510, 0.4924, 0.1, 0.0, 0.0);
				}
				for (x = -0.8; x < -0.01; x += 0.2) g3d.Line(ID_2DGRID, x, -0.9, x, +0.9);
				for (x = 0.2;  x < 0.89;  x += 0.2) g3d.Line(ID_2DGRID, x, -0.9, x, +0.9);
				for (y = -0.8; y < -0.01; y += 0.2) g3d.Line(ID_2DGRID, -0.9, y, +0.9, y);
				for (y = 0.2;  y < 0.89;  y += 0.2) g3d.Line(ID_2DGRID, -0.9, y, +0.9, y);
				g3d.Line	(ID_2DSHAPE, -0.9, 0.0, +0.9, 0.0);
				g3d.Line	(ID_2DSHAPE, 0.0, -0.9, 0.0, +0.9);
				g3d.Triangle(ID_2DSHAPE, -0.6, -0.7, -0.3, -0.3, -0.1, -0.7);
				g3d.Square	(ID_2DSHAPE, 0.2, 0.3, 0.4, 0.7, 0.9, 0.7, 0.7, 0.3);
				g3d.Pixel	(ID_2DSHAPE, 0.3, -0.5, 2);
				g3d.Ellipse (ID_2DSHAPE, 0.3, -0.5, 0.4, 0.3);
				g3d.Pixel	(ID_2DSHAPE, 0.6, 0.8, 3);
				m_fTest2 = true;
			}
			else {
				g3d.PurgeData(ID_2DGRID);
				g3d.PurgeData(ID_2DSHAPE);
				m_fTest2 = false;
			}
		}
		//	テスト３ボタン
		bool m_fTest3 = false;
		private void btnTest3_Click(object sender, EventArgs e)
		{
			if (!m_fTest3) {
				g3d.Pixel(ID_TXTPOINT, 1, 1, 1, 3);
				g3d.TextOut(EAJCTXOMD.BELLOW_CENTER, 1, 1, 1, "\x1B[1;31m    ↑    \n(1, 1, 1)");
				m_fTest3 = true;
			}
			else {
				g3d.PurgeShape(ID_TXTPOINT);
				g3d.PurgeText();
				m_fTest3 = false;
			}

		}
		//	プロット開始／停止ボタン
		private void btnStartStop_Click(object sender, EventArgs e)
		{
			if (m_fPlot) {
				m_fPlot = false;
				tim.Stop();
				btnStartStop.Text = "プロット開始";
			}
			else {
				m_fPlot = true;
				tim.Start();
				btnStartStop.Text = "プロット停止";
			}
		}
		//	プロット周期タイマ
		private void tim_Tick(object sender, EventArgs e)
		{
			AJC3DVEC[]	v = new AJC3DVEC[2];
			for (int id = 0; id < 2; id++) {
				//	ランダムなプロットデータ生成
				v[id] = m_spd[id].Calc();
				//	プロットデータ投与
				g3d.PutData(id, v[id]);
				//	球データ収集と算出した球の表示
				BallCorrectAndShow(v[id], ref PltBall);
				//	軌道円データ収集と算出した軌道円の表示
				CirCorrectAndShow (v[id], ref PltCir[id]);
				//	ログ表示
				vth.PrintTimeStamp();
				vth.PutText(string.Format(": x1={0,6:f2}, y1={0,6:f2}, z1={0,6:f2} | x2={0,6:f2}, y2={0,6:f2}, z2={0,6:f2}\n",
															v[0].x, v[0].y, v[0].z, v[1].x, v[1].y, v[1].z));
			}
		}
		//----- 動的ツールチップ取得用コールバック -------------------------------------------------------------//
		private string cbNeedText(IntPtr Handle, IntPtr cbp)
		{
			return m_TipText;
		}
		//----- ３Ｄグラフ - 右クリック通知 --------------------------------------------------------------------//
		private void g3d_OnRClick(object sender, G3dArgRClick e)
		{
			SAjrTip.ShowCenter(g3d, (e.shift ? "Shift + " : "") + (e.ctrl  ? "Ctrl + "	: "") +
									 "右クリック発生(x = " + e.x.ToString() + ", y = " + e.y.ToString() + ")");
		}
		//----- ３Ｄグラフ - ディレクトリドロップ通知 ----------------------------------------------------------//
		private void g3d_OnDirDrop(object sender, G3dArgDirDrop e)
		{
			string txt = "-- Dir dropped --";
			for (int i = 0; i < e.n; i++) {
				txt = txt + "\n" + g3d.GetDroppedDir();
			}
			SAjrTip.ShowCenter(g3d, txt);
		}
		//----- ３Ｄグラフ - ファイルドロップ通知 --------------------------------------------------------------//
		private void g3d_OnFileDrop(object sender, G3dArgFileDrop e)
		{
			string txt = "-- File dropped --";
			for (int i = 0; i < e.n; i++) {
				txt = txt + "\n" + g3d.GetDroppedFile();
			}
			SAjrTip.ShowCenter(g3d, txt);
		}
		//----- ３Ｄグラフ - プロットリスト通知 ----------------------------------------------------------------//
		private void g3d_OnPltLst(object sender, G3dArgPltLst e)
		{
			Point pt = Control.MousePosition;
			SAjrTip.Show(pt.X, pt.Y + 16, "x=" + e.p[0].v.x.ToString("0.00") + ", " +
										  "y=" + e.p[0].v.y.ToString("0.00") + ", " +
										  "z=" + e.p[0].v.z.ToString("0.00"), 3000);
		}
		//------------------------------------------------------------------------------------------------------//
		//	球算出用プロット点の収集と描画																		//
		//------------------------------------------------------------------------------------------------------//
		void		BallCorrectAndShow(AJC3DVEC Vec, ref PLOTINFO Buf)
		{
			int		i;

			//	プロット間の最低距離チェック
			for (i = 0; i < Buf.cnt; i++) {
				if (SAjrMath.V3dDistP2P(Vec, Buf.plt[i]) < Buf.dist) {
					break;
				}
			}
			//	プロット点の収集
			if (i >= Buf.cnt) {
				Buf.plt[i] = Vec;
				Buf.cnt++;
			}
			//	球の算出と表示
			if (Buf.cnt >= Buf.num) {
				AJC3DSPHINFO	sph;
				if ((Buf.radius = SAjrMath.V3dCalcSphere(Buf.plt[0], Buf.plt[1], Buf.plt[2], Buf.plt[3], out Buf.cent, out sph)) != -1) {
					//	２つの平面円の角度が30度以上ならば球描画
					double t = SAjrMath.V3dTheta(sph.cif1.lvc.v, sph.cif2.lvc.v);
					if (t > 30 && t < 180 - 30) {
						//	チップテキスト（球情報）設定
						m_TipText = "球算出情報：\n" +
									"  中心 = " + Buf.cent.x.ToString("0.00") + ", " +
												  Buf.cent.y.ToString("0.00") + ", " +
												  Buf.cent.z.ToString("0.00") + "\n" +
									"  半径 = " + Buf.radius.ToString("0.00");
						//	前回の球表示をクリアー
						g3d.PurgeData(Buf.id3);
						//	球表示
						g3d.Sphere(Buf.id3, Buf.cent.x, Buf.cent.y, Buf.cent.z, Buf.radius, Buf.radius, Buf.radius, 8, 8);
						//	前回の内接円表示をクリアー
						g3d.PurgeData(Buf.id1);
						g3d.PurgeData(Buf.id2);
						//	２つの内接円描画
						if (chkBallInfo.Checked) {
							//	球中心点描画
							g3d.Pixel(Buf.id1, Buf.cent, 3);
							g3d.Pixel(Buf.id2, Buf.cent, 3);
							//	球に内接する２つの円の情報を描画
							DrawInscribedCircle(sph.cif1, Buf.id1);
							DrawInscribedCircle(sph.cif2, Buf.id2);
							//	内接円中心から球中心への垂線
							g3d.Line(Buf.id1, sph.cif1.lvc.p, Buf.cent);
							g3d.Line(Buf.id2, sph.cif2.lvc.p, Buf.cent);
						}
					}
				}
				//	球の情報クリアー
				Buf.cnt = 0;
			}
		}
		//------------------------------------------------------------------------------------------------------//
		//	軌道円算出用プロット点の収集と描画																	//
		//------------------------------------------------------------------------------------------------------//
		void		CirCorrectAndShow(AJC3DVEC Vec, ref PLOTINFO Buf)
		{
			int 	i;

			//	プロット間の最低距離チェック
			for (i = 0; i < Buf.cnt; i++) {
				if (SAjrMath.V3dDistP2P(Vec, Buf.plt[i]) < Buf.dist) {
					break;
				}
			}
			//	プロット点の収集
			if (i >= Buf.cnt) {
				Buf.plt[i] = Vec;
				Buf.cnt++;
			}

			//	軌道円の算出と表示
			if (Buf.cnt >= Buf.num) {
				AJC3DCIRINFO	cif;
				if ((Buf.radius = SAjrMath.V3dCalcCircle(Buf.plt[0], Buf.plt[1], Buf.plt[2], out Buf.cent, out Buf.vec, out cif)) != -1) {
					if (chkCirInfo.Checked) {
						//	前の軌道円描画クリアー
						g3d.PurgeData(Buf.id1);
						//	３点描画
						g3d.Pixel(Buf.id1, Buf.plt[0], 4);
						g3d.Pixel(Buf.id1, Buf.plt[1], 4);
						g3d.Pixel(Buf.id1, Buf.plt[2], 4);
						//	内接円描画
						DrawInscribedCircle(cif, Buf.id1);
					}
				}
				//	軌道円の情報クリアー
				Buf.cnt = 0;
			}
		}
		//------------------------------------------------------------------------------------------------------//
		//	球算出の内接円／軌道円の描画																		//
		//------------------------------------------------------------------------------------------------------//
		void		DrawInscribedCircle(AJC3DCIRINFO Cif, int id)
		{
			//	円に内接する２つの直線と端点
			g3d.Line (id, Cif.lt1.p1, Cif.lt1.p2);
			g3d.Line (id, Cif.lt2.p1, Cif.lt2.p2);
			g3d.Pixel(id, Cif.lt1.p1, 4);
			g3d.Pixel(id, Cif.lt1.p2, 4);
			g3d.Pixel(id, Cif.lt2.p1, 4);
			g3d.Pixel(id, Cif.lt2.p2, 4);
			//	内接線中点からの垂線
			g3d.Line (id, Cif.lc1.p1, Cif.lc1.p2);
			g3d.Line (id, Cif.lc2.p1, Cif.lc2.p2);
			//	内接円と内接円の中心点
			g3d.DefPlane(id, Cif.lvc, new AJC3DVEC(0, 0, 0));
			g3d.Ellipse (id, 0, 0, Cif.cr, Cif.cr);
			g3d.Pixel	(id, 0, 0, 4);
		}
	}
}
