﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_3DGraphic2
{
	public partial class Form1 : Form
	{
		const double X1	= 1200.0;
		const double X2	= 1300.0;
		const double Y1	= 300.0;
		const double Y2	= 400.0;
		const double XC	= ((X1 + X2) / 2.0);
		const double YC	= ((Y1 + Y2) / 2.0);
		const int	 RAND_MAX = 10000;

		Size			m_MinSize; 				//	ウインド最小サイズ
		bool			m_fPlot = false;		//	プロット中フラグ
		bool			m_fTest = false;		//	テストボタンで描画中
		double[]		m_theta = new double[4]  {0, 0, 0, 0};
		Random			cRandom = new System.Random();

		public Form1()
		{
			InitializeComponent();
		}
		//----- フォームロード ---------------------------------------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			//----- スタイルチェックボックスのツールチップ設定 -----------//
			SAjrTip.Add(chkShowFilter		  , "フィルタチェックボックス許可"); 
			SAjrTip.Add(chkShowBorder		  , "外枠表示"); 
			SAjrTip.Add(chkShowAxisX		  , "Ｘ軸表示"); 
			SAjrTip.Add(chkShowAxisY		  , "Ｙ軸表示"); 
			SAjrTip.Add(chkShowRectScale	  , "方眼スケール表示（表示面はShowScale XYで指定）"); 
			SAjrTip.Add(chkShowEllipseScale   , "同心円スケール表示（表示面はShowScale XYで指定）"); 
			SAjrTip.Add(chkShowScaleXY		  , "ＸＹ平面にスケール表示（スケールはShowRectScale, ShowEllipseScaleで指定）"); 
			SAjrTip.Add(chkShowScaleValueX	  , "Ｘ軸の値表示"); 
			SAjrTip.Add(chkShowScaleValueY	  , "Ｙ軸の値表示"); 
            //----- ボタンチップテキスト設定 -----------------------------//
            SAjrTip.Add(btnTest, "２Ｄ図形描画／消去");
			//----- ウインド最小サイズ設定 -------------------------------//
			m_MinSize = this.Size;

			//----- 設定値ロード -----------------------------------------//
			SAjrReg.LoadAllCtrls(this);
			//----- グラフレンジ設定 -------------------------------------//
			g3d.SetRange(X1, Y1, X2, Y2);		 
		}
		//----- フォームクローズ -------------------------------------------------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//----- フォームサイズ変更 -----------------------------------------------------------------------------//
		private void Form1_Resize(object sender, EventArgs e)
		{
			if (this.Width	< m_MinSize.Width ) this.Width	= m_MinSize.Width;
			if (this.Height < m_MinSize.Height) this.Height = m_MinSize.Height;
		}

 		//----- コントロールからのイベント ---------------------------------------------------------------------//
		//	スタイル・チェックボックス群
		private void chkShowFilter_CheckedChanged		(object sender, EventArgs e) {g3d.ShowFilter		 = chkShowFilter		.Checked;}
		private void chkShowBorder_CheckedChanged		(object sender, EventArgs e) {g3d.ShowBorder		 = chkShowBorder		.Checked;}
		private void chkShowAxisX_CheckedChanged		(object sender, EventArgs e) {g3d.ShowAxisX 		 = chkShowAxisX 		.Checked;}
		private void chkShowAxisY_CheckedChanged		(object sender, EventArgs e) {g3d.ShowAxisY 		 = chkShowAxisY 		.Checked;}
		private void chkShowRectScale_CheckedChanged	(object sender, EventArgs e) {g3d.ShowRectScale 	 = chkShowRectScale 	.Checked;}
		private void chkShowEllipseScale_CheckedChanged	(object sender, EventArgs e) {g3d.ShowEllipseScale	 = chkShowEllipseScale	.Checked;}
		private void chkShowScaleXY_CheckedChanged		(object sender, EventArgs e) {g3d.ShowScaleXY		 = chkShowScaleXY		.Checked;}
		private void chkShowScaleValueX_CheckedChanged	(object sender, EventArgs e) {g3d.ShowScaleValueX	 = chkShowScaleValueX	.Checked;}
		private void chkShowScaleValueY_CheckedChanged	(object sender, EventArgs e) {g3d.ShowScaleValueY	 = chkShowScaleValueY	.Checked;}
		//	プロット線描画チェックボックス
		private void chkPlotLine_CheckedChanged			(object sender, EventArgs e) {g3d.PlotLine			 = chkPlotLine			.Checked;}
		//	プロット数
		private void inpPlotNum0_OnNtcIntValue(object sender, IvArgNtcIntValue e) {g3d.SetMaxPlot(0, e.value);}
		private void inpPlotNum1_OnNtcIntValue(object sender, IvArgNtcIntValue e) {g3d.SetMaxPlot(1, e.value);}
		private void inpPlotNum2_OnNtcIntValue(object sender, IvArgNtcIntValue e) {g3d.SetMaxPlot(2, e.value);}
		private void inpPlotNum3_OnNtcIntValue(object sender, IvArgNtcIntValue e) {g3d.SetMaxPlot(3, e.value);}
		//	サンプリング周期
		private void inpPeriod_OnNtcIntValue  (object sender, IvArgNtcIntValue e) {tim.Interval = e.value;}
		//	テストボタン
		private void btnTest_Click(object sender, EventArgs e)
		{
			if (!m_fTest) {
                g3d.Star (4, 1270, 370, 20.0, 0.0, 5, 0.0, true);
                g3d.FillB(5, 4, 1270, 370);
                g3d.Pixel(4, 1270, 370, 3);
				g3d.Ellipse (5, 1270, 370,	23, 23);
				g3d.Triangle(6, 1210, 350,	1230, 390,	1240, 370);
				g3d.Ellipse (7, 1250, 330,	40, 15);
				m_fTest = true;
			}
			else {
				g3d.PurgeShape();
				m_fTest = false;
			}
		}
		//	プロット開始／停止ボタン
		private void btnStartStop_Click(object sender, EventArgs e)
		{
			if (m_fPlot) {
				m_fPlot = false;
				tim.Stop();
				btnStartStop.Text = "プロット開始";
			}
			else {
				m_fPlot = true;
				tim.Start();
				btnStartStop.Text = "プロット停止";
			}
		}
        //  クリアーボタン
        private void btnClear_Click(object sender, EventArgs e)
        {
            m_fTest = false;
            g3d.Purge();
        }
        //	周期タイマ
		private void tim_Tick(object sender, EventArgs e)
		{
			double	x, y, r, xc, yc;

			for (int i = 0; i < 4; i++) {
				xc = XC; yc = YC;
				r  = 10 * (i + 1);
				x  = r * SAjrMath.Cos(m_theta[i]);
				y  = r * SAjrMath.Sin(m_theta[i]);
				g3d.PutData(i, XC + x, YC + y);
				if (m_theta[i] >= 0.0 && m_theta[i] <= 90.0) {
					g3d.Ellipse (i, xc, yc, r, r);
				}
				else {
					g3d.PurgeShape(i);
				}
				m_theta[i] += 10.0 * ((double)cRandom.Next(RAND_MAX) / (double)RAND_MAX);
				m_theta[i]	=(m_theta[i] % 360.0);
			}
		}
	}
}
