﻿//
//	Sil_BarGraph1
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_BarGraph1
{
	public partial class Form1 : Form
	{
		double	d1 = 40.0;
		double	d2 = 50.0;
		double	d3 = 60.0;
		Random	rnd = new System.Random();

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 -------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");

			//----- タイトルテキスト設定 ---------------------------------------//
			bar.SetTitleText(" Bar chart " , Color.Blue, Color.Aqua, 
												new Font("Terminal", 9, FontStyle.Bold | FontStyle.Italic));
			lin.SetTitleText(" Line chart ", Color.Blue, Color.Aqua,
												new Font("Terminal", 9, FontStyle.Bold | FontStyle.Italic));
            //----- テキスト描画 -----------------------------------------------//
            bar.TextOut(Txo.Center, 3, "\x1B[30m■一昨日 \x1B[31m■昨日 \x1B[32m■今日");
            lin.TextOut(Txo.Center, 3, "\x1B[30m■一昨日 \x1B[31m■昨日 \x1B[32m■今日");
			//----- 0.0と100.0の位置に点線表示 ---------------------------------//
			bar.SetHoriLinePos	(0, 0.0);
			bar.SetHoriLineStyle(0, Color.Gray, 1, EBarLineStyle.Dot);
			bar.EnableHoriLine	(0, true);

			bar.SetHoriLinePos	(1, 100.0);
			bar.SetHoriLineStyle(1, Color.Gray, 1, EBarLineStyle.Dot);
			bar.EnableHoriLine	(1, true);

			lin.SetHoriLinePos	(0, 0.0);
			lin.SetHoriLineStyle(0, Color.Gray, 1, EBarLineStyle.Dot);
			lin.EnableHoriLine	(0, true);

			lin.SetHoriLinePos	(1, 100.0);
			lin.SetHoriLineStyle(1, Color.Gray, 1, EBarLineStyle.Dot);
			lin.EnableHoriLine	(1, true);

            //----- ウインド位置ロード -----------------------------------------//
            SAjrReg.LoadWndPos(this.Handle);
		}
		//----- 開始ボタン -----------------------------------------------------//
		private void cmdStart_Click(object sender, EventArgs e)
		{
			tim.Enabled 	 = true;
			cmdStart.Enabled = false;
			cmdStop.Enabled  = true;
		}
		//----- 停止ボタン -----------------------------------------------------//
		private void cmdStop_Click(object sender, EventArgs e)
		{
			tim.Enabled 	 = false;
			cmdStart.Enabled = true;
			cmdStop.Enabled  = false;
		}
		//----- タイマイベント -------------------------------------------------//
		private void tim_Tick(object sender, EventArgs e)
		{
			DateTime now = DateTime.Now;
			string s = now.Hour.ToString("D2") + "\n" + now.Minute.ToString("D2") + ":" + now.Second.ToString("D2");
			d1 += RndNum(); d1 = Math.Max(d1, 1.0); d1 = Math.Min(d1, 100.0);
			d2 += RndNum(); d2 = Math.Max(d2, 1.0); d2 = Math.Min(d2, 100.0);
			d3 += RndNum(); d3 = Math.Max(d3, 1.0); d3 = Math.Min(d3, 100.0);
			bar.PutData(s, d1, d2, d3);
			lin.PutData(s, d1, d2, d3);
		}
		//------ ランダムな加数生成 --------------------------------------------//
		private double RndNum()
		{
			double	a;
			a = rnd.NextDouble();
			a *= rnd.Next(30);
			if ((rnd.Next() & 1) != 0) a *= -1.0;
			return a;
		}
        //----- フォーム終了 --------------------------------------------------//
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            SAjrReg.SaveWndPos(this.Handle);
        }
	}
}
